/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.protocol;

import java.lang.reflect.Method;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.protocol.MultiplexingFactory;
import org.eclipse.osgi.framework.internal.protocol.MultiplexingURLStreamHandler;
import org.eclipse.osgi.framework.internal.protocol.ProtocolActivator;
import org.eclipse.osgi.framework.internal.protocol.URLStreamHandlerFactoryProxyFor15;
import org.eclipse.osgi.framework.internal.protocol.URLStreamHandlerProxy;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class StreamHandlerFactory
extends MultiplexingFactory
implements URLStreamHandlerFactory {
    static final SecureAction secureAction = (SecureAction)AccessController.doPrivileged(SecureAction.createSecureAction());
    private ServiceTracker handlerTracker;
    protected static final String URLSTREAMHANDLERCLASS = "org.osgi.service.url.URLStreamHandlerService";
    protected static final String PROTOCOL_HANDLER_PKGS = "java.protocol.handler.pkgs";
    protected static final String INTERNAL_PROTOCOL_HANDLER_PKG = "org.eclipse.osgi.framework.internal.protocol";
    private static final List ignoredClasses;
    private static final boolean useNetProxy;
    private Hashtable proxies = new Hashtable(15);
    private URLStreamHandlerFactory parentFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class[] classArray = new Class[3];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.internal.protocol.MultiplexingURLStreamHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.osgi.framework.internal.protocol.StreamHandlerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        ignoredClasses = Arrays.asList(classArray);
        Class<?> clazz4 = null;
        try {
            clazz4 = Class.forName("java.net.Proxy");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        useNetProxy = clazz4 != null;
    }

    public StreamHandlerFactory(BundleContext bundleContext, FrameworkAdaptor frameworkAdaptor) {
        super(bundleContext, frameworkAdaptor);
        this.handlerTracker = new ServiceTracker(bundleContext, URLSTREAMHANDLERCLASS, null);
        this.handlerTracker.open();
    }

    private Class getBuiltIn(String string, String string2, boolean bl) {
        if (string2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        while (stringTokenizer.hasMoreElements()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(stringTokenizer.nextToken());
            stringBuffer.append(".");
            stringBuffer.append(string);
            stringBuffer.append(".Handler");
            try {
                Class clazz = bl ? secureAction.forName(stringBuffer.toString()) : secureAction.loadSystemClass(stringBuffer.toString());
                if (clazz == null) continue;
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return null;
    }

    public URLStreamHandler createURLStreamHandler(String string) {
        String string2 = secureAction.getProperty(PROTOCOL_HANDLER_PKGS);
        Class clazz = this.getBuiltIn(string, string2, false);
        if (clazz != null) {
            return null;
        }
        URLStreamHandler uRLStreamHandler = null;
        if (this.isMultiplexing()) {
            if (this.findAuthorizedURLStreamHandler(string) != null) {
                uRLStreamHandler = new MultiplexingURLStreamHandler(string, this);
            }
        } else {
            uRLStreamHandler = this.createInternalURLStreamHandler(string);
        }
        if (uRLStreamHandler == null && this.parentFactory != null) {
            uRLStreamHandler = this.parentFactory.createURLStreamHandler(string);
        }
        return uRLStreamHandler;
    }

    public URLStreamHandler createInternalURLStreamHandler(String string) {
        String string2 = secureAction.getProperty("equinox.interal.handler.pkgs");
        string2 = string2 == null ? INTERNAL_PROTOCOL_HANDLER_PKG : String.valueOf(string2) + '|' + INTERNAL_PROTOCOL_HANDLER_PKG;
        Class clazz = this.getBuiltIn(string, string2, true);
        if (clazz == null) {
            URLStreamHandlerProxy uRLStreamHandlerProxy = (URLStreamHandlerProxy)this.proxies.get(string);
            if (uRLStreamHandlerProxy != null) {
                return uRLStreamHandlerProxy;
            }
            ServiceReference[] serviceReferenceArray = this.handlerTracker.getServiceReferences();
            if (serviceReferenceArray == null) {
                return null;
            }
            int n = 0;
            while (n < serviceReferenceArray.length) {
                Object object;
                String[] stringArray = serviceReferenceArray[n].getProperty("url.handler.protocol");
                if (stringArray instanceof String) {
                    stringArray = new String[]{(String)stringArray};
                }
                if (!(stringArray instanceof String[])) {
                    object = NLS.bind(Msg.URL_HANDLER_INCORRECT_TYPE, new Object[]{"url.handler.protocol", URLSTREAMHANDLERCLASS, serviceReferenceArray[n].getBundle()});
                    this.adaptor.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 2, 0, (String)object, 0, null, null));
                } else {
                    object = stringArray;
                    int n2 = 0;
                    while (n2 < ((String[])object).length) {
                        if (object[n2].equals(string)) {
                            uRLStreamHandlerProxy = useNetProxy ? new URLStreamHandlerFactoryProxyFor15(string, serviceReferenceArray[n], this.context) : new URLStreamHandlerProxy(string, serviceReferenceArray[n], this.context);
                            this.proxies.put(string, uRLStreamHandlerProxy);
                            return uRLStreamHandlerProxy;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            return null;
        }
        try {
            URLStreamHandler uRLStreamHandler = (URLStreamHandler)clazz.newInstance();
            if (uRLStreamHandler instanceof ProtocolActivator) {
                ((ProtocolActivator)((Object)uRLStreamHandler)).start(this.context, this.adaptor);
            }
            return uRLStreamHandler;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected URLStreamHandler findAuthorizedURLStreamHandler(String string) {
        Object object = this.findAuthorizedFactory(ignoredClasses);
        if (object == null) {
            return null;
        }
        if (object == this) {
            return this.createInternalURLStreamHandler(string);
        }
        try {
            Class<?> clazz = object.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Method method = clazz.getMethod("createInternalURLStreamHandler", classArray);
            return (URLStreamHandler)method.invoke(object, string);
        }
        catch (Exception exception) {
            FrameworkLog frameworkLog = this.adaptor.getFrameworkLog();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.osgi.framework.internal.protocol.StreamHandlerFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            frameworkLog.log(new FrameworkLogEntry(clazz.getName(), "findAuthorizedURLStreamHandler-loop", 4, exception, null));
            throw new RuntimeException(exception.getMessage());
        }
    }

    public Object getParentFactory() {
        return this.parentFactory;
    }

    public void setParentFactory(Object object) {
        if (this.parentFactory == null) {
            this.parentFactory = (URLStreamHandlerFactory)object;
        }
    }
}

