/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.composite;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.eclipse.osgi.internal.baseadaptor.BaseStorageHook;
import org.eclipse.osgi.internal.composite.CompositeImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.permissionadmin.PermissionInfo;

public class CompositeHelper {
    private static final PermissionInfo[] COMPOSITE_PERMISSIONS;
    private static final String COMPOSITE_POLICY = "org.eclipse.osgi.composite";
    private static String ELEMENT_SEPARATOR;
    private static final Object EQUALS_QUOTE;
    private static final String[] INVALID_COMPOSITE_HEADERS;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        PermissionInfo[] permissionInfoArray = new PermissionInfo[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.framework.PackagePermission");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        permissionInfoArray[0] = new PermissionInfo(clazz.getName(), "*", "export");
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.framework.ServicePermission");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        permissionInfoArray[1] = new PermissionInfo(clazz2.getName(), "*", "register,get");
        COMPOSITE_PERMISSIONS = permissionInfoArray;
        ELEMENT_SEPARATOR = "; ";
        EQUALS_QUOTE = "=\"";
        INVALID_COMPOSITE_HEADERS = new String[]{"DynamicImport-Package", "Fragment-Host", "Require-Bundle", "Bundle-NativeCode", "Bundle-ClassPath", "Bundle-Activator", "Bundle-Localization", "Bundle-ActivationPolicy"};
    }

    private static Manifest getCompositeManifest(Map map) {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        String string = (String)map.remove("Bundle-ManifestVersion");
        attributes.putValue("Bundle-ManifestVersion", string);
        map.remove(BaseStorageHook.COMPOSITE_HEADER);
        attributes.putValue(BaseStorageHook.COMPOSITE_HEADER, BaseStorageHook.COMPOSITE_BUNDLE);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            attributes.putValue((String)entry.getKey(), (String)entry.getValue());
        }
        return manifest;
    }

    private static Manifest getSurrogateManifest(Dictionary dictionary, BundleDescription bundleDescription, ExportPackageDescription[] exportPackageDescriptionArray) {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        attributes.putValue("Bundle-ManifestVersion", "2");
        attributes.putValue(BaseStorageHook.COMPOSITE_HEADER, BaseStorageHook.SURROGATE_BUNDLE);
        if (bundleDescription != null && exportPackageDescriptionArray != null) {
            CompositeHelper.addImports(attributes, bundleDescription, exportPackageDescriptionArray);
            CompositeHelper.addExports(attributes, exportPackageDescriptionArray);
        }
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if ("Bundle-ManifestVersion".equals(k) || BaseStorageHook.COMPOSITE_HEADER.equals(k) || "Import-Package".equals(k) || "Export-Package".equals(k) || !(k instanceof String) || !(dictionary.get(k) instanceof String)) continue;
            attributes.putValue((String)k, (String)dictionary.get(k));
        }
        return manifest;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static InputStream getCompositeInput(Map map, Map map2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Manifest manifest = CompositeHelper.getCompositeManifest(map2);
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)byteArrayOutputStream, manifest);
        try {
            Properties properties = new Properties();
            if (map != null) {
                properties.putAll((Map<?, ?>)map);
            }
            JarEntry jarEntry = new JarEntry(CompositeImpl.COMPOSITE_CONFIGURATION);
            jarOutputStream.putNextEntry(jarEntry);
            properties.store(jarOutputStream, null);
            jarOutputStream.closeEntry();
            jarOutputStream.flush();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                jarOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (IOException iOException) {}
        jarOutputStream.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    static InputStream getSurrogateInput(Dictionary dictionary, BundleDescription bundleDescription, ExportPackageDescription[] exportPackageDescriptionArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Manifest manifest = CompositeHelper.getSurrogateManifest(dictionary, bundleDescription, exportPackageDescriptionArray);
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)byteArrayOutputStream, manifest);
        jarOutputStream.flush();
        jarOutputStream.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private static void addImports(Attributes attributes, BundleDescription bundleDescription, ExportPackageDescription[] exportPackageDescriptionArray) {
        ExportPackageDescription[] exportPackageDescriptionArray2 = bundleDescription.getExportPackages();
        List list = CompositeHelper.getSystemExports(exportPackageDescriptionArray);
        if (exportPackageDescriptionArray2.length == 0 && list.size() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>(exportPackageDescriptionArray2.length);
        int n = 0;
        while (n < exportPackageDescriptionArray2.length) {
            if (n != 0) {
                stringBuffer.append(',');
            }
            arrayList.add(exportPackageDescriptionArray2[n].getName());
            CompositeHelper.getImportFrom(exportPackageDescriptionArray2[n], stringBuffer);
            ++n;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ExportPackageDescription exportPackageDescription = (ExportPackageDescription)iterator.next();
            if (arrayList.contains(exportPackageDescription.getName())) continue;
            if (n != 0) {
                stringBuffer.append(',');
            }
            ++n;
            stringBuffer.append(exportPackageDescription.getName()).append(ELEMENT_SEPARATOR).append("bundle-symbolic-name").append('=').append("system.bundle");
        }
        attributes.putValue("Import-Package", stringBuffer.toString());
    }

    private static List getSystemExports(ExportPackageDescription[] exportPackageDescriptionArray) {
        ArrayList<ExportPackageDescription> arrayList = null;
        int n = 0;
        while (n < exportPackageDescriptionArray.length) {
            if (exportPackageDescriptionArray[n].getExporter().getBundleId() == 0L) {
                if (arrayList == null) {
                    arrayList = new ArrayList<ExportPackageDescription>();
                }
                arrayList.add(exportPackageDescriptionArray[n]);
            }
            ++n;
        }
        return arrayList == null ? Collections.EMPTY_LIST : arrayList;
    }

    private static void getImportFrom(ExportPackageDescription exportPackageDescription, StringBuffer stringBuffer) {
        stringBuffer.append(exportPackageDescription.getName()).append(ELEMENT_SEPARATOR);
        Version version = exportPackageDescription.getVersion();
        stringBuffer.append("version").append(EQUALS_QUOTE).append('[').append(version).append(',').append(new Version(version.getMajor(), version.getMinor(), version.getMicro() + 1)).append(')').append('\"');
        CompositeHelper.addMap(stringBuffer, exportPackageDescription.getAttributes(), "=");
    }

    private static void addExports(Attributes attributes, ExportPackageDescription[] exportPackageDescriptionArray) {
        if (exportPackageDescriptionArray.length == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < exportPackageDescriptionArray.length) {
            if (n != 0) {
                stringBuffer.append(',');
            }
            CompositeHelper.getExportFrom(exportPackageDescriptionArray[n], stringBuffer);
            ++n;
        }
        attributes.putValue("Export-Package", stringBuffer.toString());
    }

    private static void getExportFrom(ExportPackageDescription exportPackageDescription, StringBuffer stringBuffer) {
        stringBuffer.append(exportPackageDescription.getName()).append(ELEMENT_SEPARATOR);
        stringBuffer.append("version").append(EQUALS_QUOTE).append(exportPackageDescription.getVersion()).append('\"');
        CompositeHelper.addMap(stringBuffer, exportPackageDescription.getDirectives(), ":=");
        CompositeHelper.addMap(stringBuffer, exportPackageDescription.getAttributes(), "=");
    }

    private static void addMap(StringBuffer stringBuffer, Map map, String string) {
        if (map == null) {
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(ELEMENT_SEPARATOR);
            Map.Entry entry = iterator.next();
            stringBuffer.append(entry.getKey()).append(string).append('\"');
            Object v = entry.getValue();
            if (v instanceof String[]) {
                String[] stringArray = (String[])v;
                int n = 0;
                while (n < stringArray.length) {
                    if (n != 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(stringArray[n]);
                    ++n;
                }
            } else {
                stringBuffer.append(v);
            }
            stringBuffer.append('\"');
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void setCompositePermissions(String string, BundleContext bundleContext) {
        ServiceReference serviceReference;
        PermissionAdmin permissionAdmin;
        Class<?> clazz = class$2;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.osgi.service.permissionadmin.PermissionAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$2 = clazz2;
        }
        if ((permissionAdmin = (PermissionAdmin)((serviceReference = bundleContext.getServiceReference(clazz.getName())) == null ? null : bundleContext.getService(serviceReference))) == null) {
            throw new RuntimeException("No Permission Admin service is available");
        }
        try {
            permissionAdmin.setPermissions(string, COMPOSITE_PERMISSIONS);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            bundleContext.ungetService(serviceReference);
            throw throwable;
        }
        {
            Object var4_6 = null;
            bundleContext.ungetService(serviceReference);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void setDisabled(boolean bl, Bundle bundle, BundleContext bundleContext) {
        ServiceReference serviceReference;
        PlatformAdmin platformAdmin;
        Class<?> clazz = class$3;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$3 = clazz2;
        }
        if ((platformAdmin = (PlatformAdmin)((serviceReference = bundleContext.getServiceReference(clazz.getName())) == null ? null : bundleContext.getService(serviceReference))) == null) {
            throw new RuntimeException("No Platform Admin service is available.");
        }
        try {
            State state = platformAdmin.getState(false);
            BundleDescription bundleDescription = state.getBundle(bundle.getBundleId());
            CompositeHelper.setDisabled(bl, bundleDescription);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            bundleContext.ungetService(serviceReference);
            throw throwable;
        }
        {
            Object var7_9 = null;
            bundleContext.ungetService(serviceReference);
        }
    }

    static void setDisabled(boolean bl, BundleDescription bundleDescription) {
        State state = bundleDescription.getContainingState();
        if (bl) {
            state.addDisabledInfo(new DisabledInfo(COMPOSITE_POLICY, "Composite companion bundle is not resolved.", bundleDescription));
        } else {
            DisabledInfo disabledInfo = state.getDisabledInfo(bundleDescription, COMPOSITE_POLICY);
            if (disabledInfo != null) {
                state.removeDisabledInfo(disabledInfo);
            }
        }
    }

    static void validateCompositeManifest(Map map) throws BundleException {
        if (map == null) {
            throw new BundleException("The composite manifest cannot be null.", 3);
        }
        if (map.get("Bundle-SymbolicName") == null) {
            throw new BundleException("The composite manifest must contain a Bundle-SymbolicName header.", 3);
        }
        int n = 0;
        while (n < INVALID_COMPOSITE_HEADERS.length) {
            if (map.get(INVALID_COMPOSITE_HEADERS[n]) != null) {
                throw new BundleException("The composite manifest must not contain the header " + INVALID_COMPOSITE_HEADERS[n], 3);
            }
            ++n;
        }
        String string = (String)map.get("Bundle-ManifestVersion");
        if (string == null) {
            map.put("Bundle-ManifestVersion", "2");
        } else {
            try {
                Integer n2 = Integer.valueOf(string);
                if (n2 > 2 || n2 < 2) {
                    throw new BundleException("Invalid Bundle-ManifestVersion: " + string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new BundleException("Invalid Bundle-ManifestVersion: " + string);
            }
        }
    }
}

