/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.composite;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.internal.composite.CompositeBase;
import org.eclipse.osgi.internal.composite.CompositeHelper;
import org.eclipse.osgi.internal.composite.CompositeServiceTracker;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.BundleLoaderProxy;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.service.internal.composite.CompositeModule;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.service.framework.CompositeBundle;
import org.osgi.service.framework.SurrogateBundle;

public class CompositeImpl
extends CompositeBase
implements CompositeBundle {
    private static String COMPOSITE_STORAGE = "store";
    public static String COMPOSITE_CONFIGURATION = "compositeConfig.properties";
    private final ServiceTrackerManager trackerManager = new ServiceTrackerManager();

    public CompositeImpl(BundleData bundleData, Framework framework) throws BundleException {
        super(bundleData, framework);
    }

    protected org.osgi.framework.launch.Framework findCompanionFramework(Framework framework, BundleData bundleData) throws BundleException {
        File file = bundleData.getDataFile(COMPOSITE_STORAGE);
        boolean bl = false;
        if (!file.exists()) {
            bl = true;
        }
        URL uRL = this.bundledata.getEntry(COMPOSITE_CONFIGURATION);
        Properties properties = new Properties();
        try {
            properties.load(uRL.openStream());
        }
        catch (IOException iOException) {
            throw new BundleException("Could not load child configuration", iOException);
        }
        properties.put("org.osgi.framework.storage", file.getAbsolutePath());
        properties.put(PROP_PARENTFRAMEWORK, framework.getSystemBundleContext().getBundle());
        properties.put(PROP_COMPOSITE, this);
        Equinox equinox = new Equinox(properties);
        if (!bl) {
            return equinox;
        }
        equinox.init();
        this.installSurrogate(equinox.getBundleContext(), bundleData);
        return equinox;
    }

    private void installSurrogate(BundleContext bundleContext, BundleData bundleData) throws BundleException {
        Bundle bundle;
        try {
            InputStream inputStream = CompositeHelper.getSurrogateInput(bundleData.getManifest(), null, null);
            bundle = bundleContext.installBundle(bundleData.getLocation(), inputStream);
        }
        catch (IOException iOException) {
            throw new BundleException("Error installing parent companion composite bundle", iOException);
        }
        CompositeHelper.setDisabled(true, bundle, bundleContext);
        CompositeHelper.setCompositePermissions(bundleData.getLocation(), bundleContext);
    }

    private boolean updateSurrogate(BundleData bundleData, BundleDescription bundleDescription, ExportPackageDescription[] exportPackageDescriptionArray) throws BundleException {
        InputStream inputStream;
        try {
            inputStream = CompositeHelper.getSurrogateInput(bundleData.getManifest(), bundleDescription, exportPackageDescriptionArray);
        }
        catch (IOException iOException) {
            throw new BundleException("Error updating surrogate bundle.", iOException);
        }
        CompositeModule compositeModule = (CompositeModule)((Object)this.getSurrogateBundle());
        compositeModule.updateContent(inputStream);
        boolean bl = exportPackageDescriptionArray == null;
        CompositeHelper.setDisabled(bl, this.getSurrogateBundle(), this.getCompositeFramework().getBundleContext());
        return bl ? false : compositeModule.resolveContent();
    }

    public org.osgi.framework.launch.Framework getCompositeFramework() {
        return this.companionFramework;
    }

    public SurrogateBundle getSurrogateBundle() {
        return (SurrogateBundle)this.getCompanionBundle();
    }

    protected Bundle getCompanionBundle() {
        if ((this.companionFramework.getState() & 6) != 0) {
            try {
                this.companionFramework.init();
            }
            catch (BundleException bundleException) {
                throw new RuntimeException("Cannot initialize child framework.", bundleException);
            }
        }
        return this.companionFramework.getBundleContext().getBundle(1L);
    }

    public void update(Map map) throws BundleException {
        Object object;
        CompositeHelper.validateCompositeManifest(map);
        if (this.isResolved() && (object = this.getBundleLoader()) != null) {
            ((BundleLoader)object).createClassLoader();
        }
        try {
            object = this.getFrameworkConfig();
            this.updateSurrogate(this.getBundleData(), null, null);
            this.updateContent(CompositeHelper.getCompositeInput((Map)object, map));
        }
        catch (IOException iOException) {
            throw new BundleException("Error updating composite.", iOException);
        }
    }

    private Map getFrameworkConfig() throws IOException {
        Properties properties = new Properties();
        URL uRL = this.getEntry(COMPOSITE_CONFIGURATION);
        properties.load(uRL.openStream());
        return properties;
    }

    public void uninstall() throws BundleException {
        this.checkClassLoader();
        this.stop(1);
        this.stopChildFramework();
        super.uninstall();
    }

    private void checkClassLoader() {
        BundleLoaderProxy bundleLoaderProxy = this.getLoaderProxy();
        if (bundleLoaderProxy != null && bundleLoaderProxy.inUse() && bundleLoaderProxy.getBundleLoader() != null) {
            BundleClassLoader bundleClassLoader = bundleLoaderProxy.getBundleLoader().createClassLoader();
            bundleClassLoader.getResource("dummy");
        }
    }

    protected void startHook() throws BundleException {
        this.companionFramework.start();
        this.trackerManager.startedComposite();
    }

    protected void stopHook() throws BundleException {
        this.trackerManager.stoppedComposite();
        if ((this.bundledata.getStatus() & 1) == 0) {
            this.stopChildFramework();
        }
    }

    public void started(CompositeModule compositeModule) {
        if (compositeModule == this.getSurrogateBundle()) {
            this.trackerManager.startedSurrogate();
        }
    }

    public void stopped(CompositeModule compositeModule) {
        if (compositeModule == this.getSurrogateBundle()) {
            this.trackerManager.stoppedSurrogate();
        }
    }

    private void stopChildFramework() throws BundleException {
        this.companionFramework.stop();
        try {
            FrameworkEvent frameworkEvent = this.companionFramework.waitForStop(30000L);
            switch (frameworkEvent.getType()) {
                case 2: {
                    throw new BundleException("Error stopping the child framework.", frameworkEvent.getThrowable());
                }
                case 512: {
                    throw new BundleException("Timed out waiting for the child framework to stop.");
                }
                case 64: {
                    return;
                }
            }
            throw new BundleException("Unexpected code returned when stopping the child framework:" + frameworkEvent.getType());
        }
        catch (InterruptedException interruptedException) {
            throw new BundleException("Error stopping child framework", interruptedException);
        }
    }

    public boolean giveExports(ExportPackageDescription[] exportPackageDescriptionArray) {
        if (exportPackageDescriptionArray == null) {
            SurrogateBundle surrogateBundle = this.getSurrogateBundle();
            CompositeHelper.setDisabled(true, this.getSurrogateBundle(), this.getCompositeFramework().getBundleContext());
            ((CompositeModule)((Object)surrogateBundle)).refreshContent();
            return true;
        }
        try {
            return this.updateSurrogate(this.getBundleData(), this.getBundleDescription(), exportPackageDescriptionArray);
        }
        catch (BundleException bundleException) {
            bundleException.printStackTrace();
            return false;
        }
    }

    class ServiceTrackerManager {
        static final int COMPOSITE_ACTIVE = 1;
        static final int SURROGATE_ACTIVE = 2;
        private int bundlesActive = 0;
        private CompositeServiceTracker shareToChildServices;
        private CompositeServiceTracker shareToParentServices;

        ServiceTrackerManager() {
        }

        void startedComposite() throws BundleException {
            this.open(1);
            CompositeImpl.this.getSurrogateBundle().start(1);
        }

        void startedSurrogate() {
            this.open(2);
        }

        void stoppedComposite() {
            try {
                CompositeImpl.this.getSurrogateBundle().stop(1);
            }
            catch (BundleException bundleException) {
            }
            catch (IllegalStateException illegalStateException) {}
            this.close(1);
        }

        void stoppedSurrogate() {
            this.close(2);
        }

        private synchronized void open(int n) {
            this.bundlesActive |= n;
            if ((this.bundlesActive & 3) != 3) {
                return;
            }
            this.shareToChildServices = new CompositeServiceTracker(CompositeImpl.this.getBundleContext(), CompositeImpl.this.getSurrogateBundle().getBundleContext(), (String)CompositeImpl.this.getBundleContext().getBundle().getHeaders("").get("CompositeServiceFilter-Import"));
            this.shareToChildServices.open();
            this.shareToParentServices = new CompositeServiceTracker(CompositeImpl.this.getSurrogateBundle().getBundleContext(), CompositeImpl.this.getBundleContext(), (String)CompositeImpl.this.getBundleContext().getBundle().getHeaders("").get("CompositeServiceFilter-Export"));
            this.shareToParentServices.open();
        }

        private synchronized void close(int n) {
            this.bundlesActive ^= n;
            if (this.shareToChildServices != null) {
                this.shareToChildServices.close();
            }
            if (this.shareToParentServices != null) {
                this.shareToParentServices.close();
            }
        }
    }
}

