/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.util.KeyedHashSet;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.composite.CompositeBase;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.FilteredSourcePackage;
import org.eclipse.osgi.internal.loader.PackageSource;
import org.eclipse.osgi.internal.loader.SingleSourcePackage;
import org.eclipse.osgi.internal.loader.SystemBundleLoader;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.RequiredBundle;

public class BundleLoaderProxy
implements RequiredBundle {
    static SecureAction secureAction = (SecureAction)AccessController.doPrivileged(SecureAction.createSecureAction());
    private BundleLoader loader;
    private final BundleHost bundle;
    private final BundleDescription description;
    private boolean stale = false;
    private final KeyedHashSet pkgSources;
    static /* synthetic */ Class class$0;

    public BundleLoaderProxy(BundleHost bundleHost, BundleDescription bundleDescription) {
        this.bundle = bundleHost;
        this.description = bundleDescription;
        this.pkgSources = new KeyedHashSet(false);
    }

    public BundleLoader getBundleLoader() {
        if (System.getSecurityManager() == null) {
            return this.getBundleLoader0();
        }
        return (BundleLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoaderProxy.this.getBundleLoader0();
            }
        });
    }

    synchronized BundleLoader getBundleLoader0() {
        if (this.loader != null) {
            return this.loader;
        }
        if (this.bundle.isResolved()) {
            try {
                this.loader = this.bundle.getBundleId() == 0L ? new SystemBundleLoader(this.bundle, this) : new BundleLoader(this.bundle, this);
            }
            catch (BundleException bundleException) {
                this.bundle.getFramework().publishFrameworkEvent(2, this.bundle, bundleException);
                return null;
            }
        }
        return this.loader;
    }

    public BundleLoader getBasicBundleLoader() {
        return this.loader;
    }

    public AbstractBundle getBundleHost() {
        return this.bundle;
    }

    void setStale() {
        this.stale = true;
    }

    public boolean isStale() {
        return this.stale;
    }

    public String toString() {
        String string = this.bundle.getSymbolicName();
        StringBuffer stringBuffer = new StringBuffer(string == null ? this.bundle.getBundleData().getLocation() : string);
        stringBuffer.append("; ").append("bundle-version");
        stringBuffer.append("=\"").append(this.description.getVersion().toString()).append("\"");
        return stringBuffer.toString();
    }

    public Bundle getBundle() {
        if (this.isStale()) {
            return null;
        }
        return this.bundle;
    }

    public Bundle[] getRequiringBundles() {
        if (this.isStale()) {
            return null;
        }
        BundleDescription[] bundleDescriptionArray = this.description.getDependents();
        if (bundleDescriptionArray == null || bundleDescriptionArray.length == 0) {
            return new Bundle[0];
        }
        ArrayList arrayList = new ArrayList(bundleDescriptionArray.length);
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            this.addRequirers(bundleDescriptionArray[n], arrayList);
            ++n;
        }
        return arrayList.toArray(new Bundle[arrayList.size()]);
    }

    void addRequirers(BundleDescription bundleDescription, ArrayList arrayList) {
        if (bundleDescription.getHost() != null) {
            return;
        }
        BundleLoaderProxy bundleLoaderProxy = this.getBundleLoader().getLoaderProxy(bundleDescription);
        if (bundleLoaderProxy == null) {
            return;
        }
        if (arrayList.contains(bundleLoaderProxy.bundle)) {
            return;
        }
        BundleLoader bundleLoader = bundleLoaderProxy.getBundleLoader();
        BundleLoaderProxy[] bundleLoaderProxyArray = bundleLoader.requiredBundles;
        int[] nArray = bundleLoader.reexportTable;
        if (bundleLoaderProxyArray == null) {
            return;
        }
        int n = nArray == null ? 0 : nArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < bundleLoaderProxyArray.length) {
            if (bundleLoaderProxyArray[n3] == this) {
                arrayList.add(bundleLoaderProxy.bundle);
                if (n2 < n && nArray[n2] == n3) {
                    ++n2;
                    BundleDescription[] bundleDescriptionArray = bundleDescription.getDependents();
                    if (bundleDescriptionArray == null) {
                        return;
                    }
                    int n4 = 0;
                    while (n4 < bundleDescriptionArray.length) {
                        bundleLoaderProxy.addRequirers(bundleDescriptionArray[n4], arrayList);
                        ++n4;
                    }
                }
                return;
            }
            ++n3;
        }
    }

    public String getSymbolicName() {
        return this.description.getSymbolicName();
    }

    public Version getVersion() {
        return this.description.getVersion();
    }

    public boolean isRemovalPending() {
        return this.description.isRemovalPending();
    }

    BundleDescription getBundleDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageSource getPackageSource(String string) {
        PackageSource packageSource = (PackageSource)this.pkgSources.getByKey(string);
        if (packageSource == null) {
            packageSource = new SingleSourcePackage(string, this);
            KeyedHashSet keyedHashSet = this.pkgSources;
            synchronized (keyedHashSet) {
                this.pkgSources.add(packageSource);
            }
        }
        return packageSource;
    }

    public boolean inUse() {
        return this.description.getDependents().length > 0 || this.bundle instanceof CompositeBase && this.description.getResolvedImports().length > 0;
    }

    boolean forceSourceCreation(ExportPackageDescription exportPackageDescription) {
        boolean bl = "strict".equals(secureAction.getProperty("osgi.resolverMode"));
        return exportPackageDescription.getDirective("include") != null || exportPackageDescription.getDirective("exclude") != null || bl && exportPackageDescription.getDirective("x-friends") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageSource createPackageSource(ExportPackageDescription exportPackageDescription, boolean bl) {
        boolean bl2;
        PackageSource packageSource = null;
        String string = (String)exportPackageDescription.getDirective("include");
        String string2 = (String)exportPackageDescription.getDirective("exclude");
        String[] stringArray = (String[])exportPackageDescription.getDirective("x-friends");
        if (stringArray != null && !(bl2 = "strict".equals(secureAction.getProperty("osgi.resolverMode")))) {
            stringArray = null;
        }
        if (string != null || string2 != null || stringArray != null) {
            packageSource = new FilteredSourcePackage(exportPackageDescription.getName(), this, string, string2, stringArray);
        }
        if (bl) {
            if (packageSource != null && this.pkgSources.getByKey(exportPackageDescription.getName()) == null) {
                KeyedHashSet keyedHashSet = this.pkgSources;
                synchronized (keyedHashSet) {
                    this.pkgSources.add(packageSource);
                }
            }
        } else if (packageSource == null) {
            packageSource = this.getPackageSource(exportPackageDescription.getName());
            Class<?> clazz = packageSource.getClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.osgi.internal.loader.SingleSourcePackage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                return new SingleSourcePackage(exportPackageDescription.getName(), this);
            }
        }
        return packageSource;
    }
}

