/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader.buddy;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.BundleLoaderProxy;
import org.eclipse.osgi.internal.loader.buddy.IBuddyPolicy;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class DependentPolicy
implements IBuddyPolicy {
    BundleLoader buddyRequester;
    int lastDependentOfAdded = -1;
    List allDependents = null;

    public DependentPolicy(BundleLoader bundleLoader) {
        this.buddyRequester = bundleLoader;
        this.allDependents = new ArrayList();
        this.basicAddImmediateDependents(this.buddyRequester.getBundle().getBundleDescription());
        if (this.allDependents.size() == 0) {
            this.allDependents = null;
        }
    }

    public Class loadClass(String string) {
        if (this.allDependents == null) {
            return null;
        }
        Class clazz = null;
        int n = 0;
        while (n < this.allDependents.size() && clazz == null) {
            block5: {
                BundleDescription bundleDescription = (BundleDescription)this.allDependents.get(n);
                try {
                    BundleLoaderProxy bundleLoaderProxy = this.buddyRequester.getLoaderProxy(bundleDescription);
                    if (bundleLoaderProxy != null) {
                        clazz = bundleLoaderProxy.getBundleLoader().findClass(string);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (clazz != null) break block5;
                    this.addDependent(n, bundleDescription);
                }
            }
            ++n;
        }
        return clazz;
    }

    private synchronized void addDependent(int n, BundleDescription bundleDescription) {
        if (n > this.lastDependentOfAdded) {
            this.lastDependentOfAdded = n;
            this.basicAddImmediateDependents(bundleDescription);
        }
    }

    public URL loadResource(String string) {
        if (this.allDependents == null) {
            return null;
        }
        URL uRL = null;
        int n = 0;
        while (n < this.allDependents.size() && uRL == null) {
            BundleDescription bundleDescription = (BundleDescription)this.allDependents.get(n);
            BundleLoaderProxy bundleLoaderProxy = this.buddyRequester.getLoaderProxy(bundleDescription);
            if (bundleLoaderProxy != null && (uRL = bundleLoaderProxy.getBundleLoader().findResource(string)) == null) {
                this.addDependent(n, bundleDescription);
            }
            ++n;
        }
        return uRL;
    }

    public Enumeration loadResources(String string) {
        if (this.allDependents == null) {
            return null;
        }
        Enumeration enumeration = null;
        int n = 0;
        while (n < this.allDependents.size()) {
            BundleDescription bundleDescription = (BundleDescription)this.allDependents.get(n);
            try {
                BundleLoaderProxy bundleLoaderProxy = this.buddyRequester.getLoaderProxy(bundleDescription);
                if (bundleLoaderProxy != null) {
                    enumeration = BundleLoader.compoundEnumerations(enumeration, bundleLoaderProxy.getBundleLoader().findResources(string));
                    this.addDependent(n, bundleDescription);
                }
            }
            catch (IOException iOException) {}
            ++n;
        }
        return enumeration;
    }

    private void basicAddImmediateDependents(BundleDescription bundleDescription) {
        BundleDescription[] bundleDescriptionArray = bundleDescription.getDependents();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            BundleDescription bundleDescription2 = bundleDescriptionArray[n];
            if (bundleDescription2.getHost() == null && !this.allDependents.contains(bundleDescription2)) {
                this.allDependents.add(bundleDescription2);
            }
            ++n;
        }
    }
}

