/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ComputeNodeOrder;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public final class StateHelperImpl
implements StateHelper {
    private static final StateHelper instance = new StateHelperImpl();

    public BundleDescription[] getDependentBundles(BundleDescription[] bundleDescriptionArray) {
        if (bundleDescriptionArray == null || bundleDescriptionArray.length == 0) {
            return new BundleDescription[0];
        }
        HashSet hashSet = new HashSet(bundleDescriptionArray.length);
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            if (bundleDescriptionArray[n].isResolved()) {
                this.addDependentBundles(bundleDescriptionArray[n], hashSet);
            }
            ++n;
        }
        return hashSet.toArray(new BundleDescription[hashSet.size()]);
    }

    private void addDependentBundles(BundleDescription bundleDescription, Set set) {
        if (set.contains(bundleDescription)) {
            return;
        }
        set.add(bundleDescription);
        BundleDescription[] bundleDescriptionArray = bundleDescription.getDependents();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            this.addDependentBundles(bundleDescriptionArray[n], set);
            ++n;
        }
    }

    public BundleDescription[] getPrerequisites(BundleDescription[] bundleDescriptionArray) {
        if (bundleDescriptionArray == null || bundleDescriptionArray.length == 0) {
            return new BundleDescription[0];
        }
        HashSet hashSet = new HashSet(bundleDescriptionArray.length);
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            this.addPrerequisites(bundleDescriptionArray[n], hashSet);
            ++n;
        }
        return hashSet.toArray(new BundleDescription[hashSet.size()]);
    }

    private void addPrerequisites(BundleDescription bundleDescription, Set set) {
        if (set.contains(bundleDescription)) {
            return;
        }
        set.add(bundleDescription);
        List list = ((BundleDescriptionImpl)bundleDescription).getBundleDependencies();
        BundleDescription[] bundleDescriptionArray = list.toArray(new BundleDescription[list.size()]);
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            this.addPrerequisites(bundleDescriptionArray[n], set);
            ++n;
        }
    }

    private Map getExportedPackageMap(State state) {
        HashMap<String, HashSet<ExportPackageDescription>> hashMap = new HashMap<String, HashSet<ExportPackageDescription>>(11);
        BundleDescription[] bundleDescriptionArray = state.getBundles();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            ExportPackageDescription[] exportPackageDescriptionArray = bundleDescriptionArray[n].getExportPackages();
            int n2 = 0;
            while (n2 < exportPackageDescriptionArray.length) {
                ExportPackageDescription exportPackageDescription = exportPackageDescriptionArray[n2];
                HashSet<ExportPackageDescription> hashSet = (HashSet<ExportPackageDescription>)hashMap.get(exportPackageDescription.getName());
                if (hashSet == null) {
                    hashSet = new HashSet<ExportPackageDescription>(1);
                    hashMap.put(exportPackageDescription.getName(), hashSet);
                }
                hashSet.add(exportPackageDescription);
                ++n2;
            }
            ++n;
        }
        return hashMap;
    }

    private Map getGenericsMap(State state, boolean bl) {
        HashMap<String, HashSet<GenericDescription>> hashMap = new HashMap<String, HashSet<GenericDescription>>(11);
        BundleDescription[] bundleDescriptionArray = state.getBundles();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            if (!bl || bundleDescriptionArray[n].isResolved()) {
                GenericDescription[] genericDescriptionArray = bundleDescriptionArray[n].getGenericCapabilities();
                int n2 = 0;
                while (n2 < genericDescriptionArray.length) {
                    GenericDescription genericDescription = genericDescriptionArray[n2];
                    HashSet<GenericDescription> hashSet = (HashSet<GenericDescription>)hashMap.get(genericDescription.getName());
                    if (hashSet == null) {
                        hashSet = new HashSet<GenericDescription>(1);
                        hashMap.put(genericDescription.getName(), hashSet);
                    }
                    hashSet.add(genericDescription);
                    ++n2;
                }
            }
            ++n;
        }
        return hashMap;
    }

    private VersionConstraint[] getUnsatisfiedLeaves(State state, BundleDescription[] bundleDescriptionArray) {
        Map map = this.getExportedPackageMap(state);
        Map map2 = this.getGenericsMap(state, false);
        HashSet<VersionConstraint> hashSet = new HashSet<VersionConstraint>(11);
        ArrayList<BundleDescription> arrayList = new ArrayList<BundleDescription>(bundleDescriptionArray.length);
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            arrayList.add(bundleDescriptionArray[n]);
            ++n;
        }
        n = 0;
        while (n < arrayList.size()) {
            BundleDescription bundleDescription = (BundleDescription)arrayList.get(n);
            VersionConstraint[] versionConstraintArray = this.getUnsatisfiedConstraints(bundleDescription);
            int n2 = 0;
            while (n2 < versionConstraintArray.length) {
                BaseDescription baseDescription;
                Object object;
                VersionConstraint versionConstraint = versionConstraintArray[n2];
                BaseDescription baseDescription2 = null;
                if (versionConstraint instanceof BundleSpecification || versionConstraint instanceof HostSpecification) {
                    object = state.getBundles(versionConstraint.getName());
                    int n3 = 0;
                    while (n3 < ((BundleDescription[])object).length && baseDescription2 == null) {
                        baseDescription2 = versionConstraint.isSatisfiedBy(object[n3]) ? object[n3] : null;
                        ++n3;
                    }
                } else if (versionConstraint instanceof ImportPackageSpecification) {
                    object = (Set)map.get(versionConstraint.getName());
                    if (object != null) {
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext() && baseDescription2 == null) {
                            baseDescription = (ExportPackageDescription)iterator.next();
                            BaseDescription baseDescription3 = baseDescription2 = versionConstraint.isSatisfiedBy(baseDescription) ? baseDescription : null;
                        }
                    }
                } else if (versionConstraint instanceof GenericSpecification && (object = (Set)map2.get(versionConstraint.getName())) != null) {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext() && baseDescription2 == null) {
                        baseDescription = (GenericDescription)iterator.next();
                        BaseDescription baseDescription4 = baseDescription2 = versionConstraint.isSatisfiedBy(baseDescription) ? baseDescription : null;
                    }
                }
                if (baseDescription2 == null) {
                    hashSet.add(versionConstraint);
                } else if (!baseDescription2.getSupplier().isResolved() && !arrayList.contains(baseDescription2.getSupplier())) {
                    arrayList.add(baseDescription2.getSupplier());
                }
                ++n2;
            }
            ++n;
        }
        return hashSet.toArray(new VersionConstraint[hashSet.size()]);
    }

    public VersionConstraint[] getUnsatisfiedLeaves(BundleDescription[] bundleDescriptionArray) {
        if (bundleDescriptionArray.length == 0) {
            return new VersionConstraint[0];
        }
        State state = bundleDescriptionArray[0].getContainingState();
        return this.getUnsatisfiedLeaves(state, bundleDescriptionArray);
    }

    public VersionConstraint[] getUnsatisfiedConstraints(BundleDescription bundleDescription) {
        State state = bundleDescription.getContainingState();
        if (state == null) {
            throw new IllegalStateException("Does not belong to a state");
        }
        ArrayList<VersionConstraint> arrayList = new ArrayList<VersionConstraint>();
        HostSpecification hostSpecification = bundleDescription.getHost();
        if (hostSpecification != null && !hostSpecification.isResolved() && !this.isResolvable(hostSpecification)) {
            arrayList.add(hostSpecification);
        }
        BundleSpecification[] bundleSpecificationArray = bundleDescription.getRequiredBundles();
        int n = 0;
        while (n < bundleSpecificationArray.length) {
            if (!bundleSpecificationArray[n].isResolved() && !this.isResolvable(bundleSpecificationArray[n])) {
                arrayList.add(bundleSpecificationArray[n]);
            }
            ++n;
        }
        ImportPackageSpecification[] importPackageSpecificationArray = bundleDescription.getImportPackages();
        int n2 = 0;
        while (n2 < importPackageSpecificationArray.length) {
            if (!importPackageSpecificationArray[n2].isResolved() && !this.isResolvable(importPackageSpecificationArray[n2])) {
                arrayList.add(importPackageSpecificationArray[n2]);
            }
            ++n2;
        }
        GenericSpecification[] genericSpecificationArray = bundleDescription.getGenericRequires();
        int n3 = 0;
        while (n3 < genericSpecificationArray.length) {
            if (!genericSpecificationArray[n3].isResolved() && !this.isResolvable(genericSpecificationArray[n3])) {
                arrayList.add(genericSpecificationArray[n3]);
            }
            ++n3;
        }
        NativeCodeSpecification nativeCodeSpecification = bundleDescription.getNativeCodeSpecification();
        if (nativeCodeSpecification != null && !nativeCodeSpecification.isResolved()) {
            arrayList.add(nativeCodeSpecification);
        }
        return arrayList.toArray(new VersionConstraint[arrayList.size()]);
    }

    public boolean isResolvable(ImportPackageSpecification importPackageSpecification) {
        ExportPackageDescription[] exportPackageDescriptionArray = importPackageSpecification.getBundle().getContainingState().getExportedPackages();
        int n = 0;
        while (n < exportPackageDescriptionArray.length) {
            if (importPackageSpecification.isSatisfiedBy(exportPackageDescriptionArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isResolvable(GenericSpecification genericSpecification) {
        Map map = this.getGenericsMap(genericSpecification.getBundle().getContainingState(), true);
        Set set = (Set)map.get(genericSpecification.getName());
        if (set == null) {
            return false;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!genericSpecification.isSatisfiedBy((GenericDescription)iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean isResolvable(BundleSpecification bundleSpecification) {
        return this.isBundleConstraintResolvable(bundleSpecification);
    }

    public boolean isResolvable(HostSpecification hostSpecification) {
        return this.isBundleConstraintResolvable(hostSpecification);
    }

    private boolean isBundleConstraintResolvable(VersionConstraint versionConstraint) {
        BundleDescription[] bundleDescriptionArray = versionConstraint.getBundle().getContainingState().getBundles(versionConstraint.getName());
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            if (bundleDescriptionArray[n].isResolved() && versionConstraint.isSatisfiedBy(bundleDescriptionArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Object[][] sortBundles(BundleDescription[] bundleDescriptionArray) {
        ArrayList arrayList = new ArrayList(bundleDescriptionArray.length);
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            if (bundleDescriptionArray[n].isResolved()) {
                this.buildReferences(bundleDescriptionArray[n], arrayList);
            }
            ++n;
        }
        Object[][] objectArray = ComputeNodeOrder.computeNodeOrder(bundleDescriptionArray, (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]));
        if (objectArray.length == 0) {
            return objectArray;
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            int n3 = 0;
            while (n3 < objectArray[n2].length) {
                BundleDescription bundleDescription;
                BundleDescription bundleDescription2 = (BundleDescription)objectArray[n2][n3];
                if (bundleDescription2.getHost() != null && (bundleDescription = (BundleDescription)bundleDescription2.getHost().getSupplier()) != null) {
                    this.fixFragmentOrder(bundleDescription, bundleDescription2, bundleDescriptionArray);
                }
                ++n3;
            }
            ++n2;
        }
        return objectArray;
    }

    private void fixFragmentOrder(BundleDescription bundleDescription, BundleDescription bundleDescription2, BundleDescription[] bundleDescriptionArray) {
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (n3 < bundleDescriptionArray.length && (n == -1 || n2 == -1)) {
            if (bundleDescriptionArray[n3] == bundleDescription) {
                n = n3;
            } else if (bundleDescriptionArray[n3] == bundleDescription2) {
                n2 = n3;
            }
            ++n3;
        }
        if (n2 > -1 && n2 < n) {
            n3 = n2;
            while (n3 < n) {
                bundleDescriptionArray[n3] = bundleDescriptionArray[n3 + 1];
                ++n3;
            }
            bundleDescriptionArray[n] = bundleDescription2;
        }
    }

    private void buildReferences(BundleDescription bundleDescription, List list) {
        HostSpecification hostSpecification = bundleDescription.getHost();
        if (hostSpecification != null) {
            if (hostSpecification.getHosts() != null) {
                BundleDescription[] bundleDescriptionArray = hostSpecification.getHosts();
                int n = 0;
                while (n < bundleDescriptionArray.length) {
                    if (bundleDescriptionArray[n] != bundleDescription) {
                        list.add(new Object[]{bundleDescription, bundleDescriptionArray[n]});
                    }
                    ++n;
                }
            }
        } else {
            this.buildReferences(bundleDescription, ((BundleDescriptionImpl)bundleDescription).getBundleDependencies(), list);
        }
    }

    private void buildReferences(BundleDescription bundleDescription, List list, List list2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addReference(bundleDescription, (BundleDescription)iterator.next(), list2);
        }
    }

    private void addReference(BundleDescription bundleDescription, BundleDescription bundleDescription2, List list) {
        if (bundleDescription == bundleDescription2 || bundleDescription2 == null) {
            return;
        }
        BundleDescription[] bundleDescriptionArray = bundleDescription2.getFragments();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            ExportPackageDescription[] exportPackageDescriptionArray;
            if (bundleDescriptionArray[n].isResolved() && (exportPackageDescriptionArray = bundleDescriptionArray[n].getExportPackages()).length > 0) {
                list.add(new Object[]{bundleDescription, bundleDescriptionArray[n]});
            }
            ++n;
        }
        list.add(new Object[]{bundleDescription, bundleDescription2});
    }

    public ExportPackageDescription[] getVisiblePackages(BundleDescription bundleDescription) {
        return this.getVisiblePackages(bundleDescription, 0);
    }

    public ExportPackageDescription[] getVisiblePackages(BundleDescription bundleDescription, int n) {
        Object object;
        Object object2;
        StateImpl stateImpl = (StateImpl)bundleDescription.getContainingState();
        boolean bl = false;
        if (stateImpl != null) {
            bl = stateImpl.inStrictMode();
        }
        BundleDescription bundleDescription2 = bundleDescription.getHost() == null ? bundleDescription : bundleDescription.getHost().getSupplier();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<String> hashSet2 = new HashSet<String>();
        ImportPackageSpecification[] importPackageSpecificationArray = bundleDescription.getImportPackages();
        int n2 = 0;
        while (n2 < importPackageSpecificationArray.length) {
            object2 = (ExportPackageDescription)importPackageSpecificationArray[n2].getSupplier();
            if (object2 != null && object2.getExporter() != bundleDescription2) {
                if (!this.isSystemExport((ExportPackageDescription)object2, n) && !hashSet.contains(object2)) {
                    arrayList.add(object2);
                    hashSet.add(object2);
                }
                BundleSpecification[] bundleSpecificationArray = object2.getExporter().getRequiredBundles();
                object = new HashSet();
                object.add(bundleDescription);
                HashSet<String> hashSet3 = new HashSet<String>(1);
                hashSet3.add(importPackageSpecificationArray[n2].getName());
                int n3 = 0;
                while (n3 < bundleSpecificationArray.length) {
                    BundleDescription bundleDescription3 = (BundleDescription)bundleSpecificationArray[n3].getSupplier();
                    if (bundleDescription3 != null) {
                        this.getPackages(bundleDescription3, bundleDescription.getSymbolicName(), hashSet2, arrayList, hashSet, (Set)object, bl, hashSet3, n);
                    }
                    ++n3;
                }
                hashSet2.add(importPackageSpecificationArray[n2].getName());
            }
            ++n2;
        }
        BundleSpecification[] bundleSpecificationArray = bundleDescription.getRequiredBundles();
        object2 = new HashSet(bundleSpecificationArray.length);
        object2.add(bundleDescription);
        int n4 = 0;
        while (n4 < bundleSpecificationArray.length) {
            object = (BundleDescription)bundleSpecificationArray[n4].getSupplier();
            if (object != null) {
                this.getPackages((BundleDescription)object, bundleDescription.getSymbolicName(), hashSet2, arrayList, hashSet, (Set)object2, bl, null, n);
            }
            ++n4;
        }
        return arrayList.toArray(new ExportPackageDescription[arrayList.size()]);
    }

    private void getPackages(BundleDescription bundleDescription, String string, Set set, ArrayList arrayList, Set set2, Set set3, boolean bl, Set set4, int n) {
        if (set3.contains(bundleDescription)) {
            return;
        }
        set3.add(bundleDescription);
        ExportPackageDescription[] exportPackageDescriptionArray = bundleDescription.getSubstitutedExports();
        ExportPackageDescription[] exportPackageDescriptionArray2 = bundleDescription.getResolvedImports();
        HashSet<String> hashSet = null;
        int n2 = 0;
        while (n2 < exportPackageDescriptionArray.length) {
            if (set4 == null || set4.contains(exportPackageDescriptionArray[n2].getName())) {
                int n3 = 0;
                while (n3 < exportPackageDescriptionArray2.length) {
                    if (exportPackageDescriptionArray[n2].getName().equals(exportPackageDescriptionArray2[n3].getName()) && !set2.contains(exportPackageDescriptionArray2[n3])) {
                        if (hashSet == null) {
                            hashSet = new HashSet<String>(1);
                        } else {
                            hashSet.clear();
                        }
                        hashSet.add(exportPackageDescriptionArray[n2].getName());
                        this.getPackages(exportPackageDescriptionArray2[n3].getSupplier(), string, set, arrayList, set2, new HashSet(0), bl, hashSet, n);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        set = exportPackageDescriptionArray.length == 0 ? set : new HashSet(set);
        n2 = 0;
        while (n2 < exportPackageDescriptionArray.length) {
            set.add(exportPackageDescriptionArray[n2].getName());
            ++n2;
        }
        ExportPackageDescription[] exportPackageDescriptionArray3 = bundleDescription.getSelectedExports();
        HashSet<String> hashSet2 = new HashSet<String>(exportPackageDescriptionArray3.length);
        int n4 = 0;
        while (n4 < exportPackageDescriptionArray3.length) {
            if (!(set4 != null && !set4.contains(exportPackageDescriptionArray3[n4].getName()) || this.isSystemExport(exportPackageDescriptionArray3[n4], n) || !this.isFriend(string, exportPackageDescriptionArray3[n4], bl) || set.contains(exportPackageDescriptionArray3[n4].getName()) || set2.contains(exportPackageDescriptionArray3[n4]) || hashSet2.contains(exportPackageDescriptionArray3[n4].getName()))) {
                arrayList.add(exportPackageDescriptionArray3[n4]);
                set2.add(exportPackageDescriptionArray3[n4]);
                hashSet2.add(exportPackageDescriptionArray3[n4].getName());
            }
            ++n4;
        }
        BundleSpecification[] bundleSpecificationArray = bundleDescription.getRequiredBundles();
        int n5 = 0;
        while (n5 < bundleSpecificationArray.length) {
            if (bundleSpecificationArray[n5].getSupplier() != null) {
                if (bundleSpecificationArray[n5].isExported()) {
                    this.getPackages((BundleDescription)bundleSpecificationArray[n5].getSupplier(), string, set, arrayList, set2, set3, bl, set4, n);
                } else if (hashSet2.size() > 0) {
                    HashSet hashSet3 = new HashSet();
                    this.getPackages((BundleDescription)bundleSpecificationArray[n5].getSupplier(), string, set, arrayList, set2, hashSet3, bl, hashSet2, n);
                }
            }
            ++n5;
        }
    }

    private boolean isSystemExport(ExportPackageDescription exportPackageDescription, int n) {
        if ((n & 1) != 0) {
            return false;
        }
        return (Integer)exportPackageDescription.getDirective("x-equinox-ee") >= 0;
    }

    private boolean isFriend(String string, ExportPackageDescription exportPackageDescription, boolean bl) {
        if (!bl) {
            return true;
        }
        String[] stringArray = (String[])exportPackageDescription.getDirective("x-friends");
        if (stringArray == null) {
            return true;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public int getAccessCode(BundleDescription bundleDescription, ExportPackageDescription exportPackageDescription) {
        if (((Boolean)exportPackageDescription.getDirective("x-internal")).booleanValue()) {
            return 2;
        }
        if (!this.isFriend(bundleDescription.getSymbolicName(), exportPackageDescription, true)) {
            return 2;
        }
        return 1;
    }

    public static StateHelper getInstance() {
        return instance;
    }
}

