/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import java.lang.reflect.Array;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.osgi.framework.util.Headers;

class ServiceProperties
extends Headers {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceProperties(int n, Dictionary dictionary) {
        super(n);
        if (dictionary == null) {
            return;
        }
        Dictionary dictionary2 = dictionary;
        synchronized (dictionary2) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                if (!(k instanceof String)) continue;
                String string = (String)k;
                this.setProperty(string, dictionary.get(string));
            }
        }
    }

    ServiceProperties(Dictionary dictionary) {
        this(dictionary == null ? 2 : dictionary.size() + 2, dictionary);
    }

    Object getProperty(String string) {
        return ServiceProperties.cloneValue(this.get(string));
    }

    synchronized String[] getPropertyKeys() {
        int n = this.size();
        String[] stringArray = new String[n];
        Enumeration enumeration = this.keys();
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)enumeration.nextElement();
            ++n2;
        }
        return stringArray;
    }

    synchronized Object setProperty(String string, Object object) {
        return this.set(string, ServiceProperties.cloneValue(object));
    }

    private static Object cloneValue(Object object) {
        block10: {
            if (object == null) {
                return null;
            }
            if (object instanceof String) {
                return object;
            }
            if (object instanceof Number) {
                return object;
            }
            if (object instanceof Character) {
                return object;
            }
            if (object instanceof Boolean) {
                return object;
            }
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                Class<?> clazz2 = clazz.getComponentType();
                int n = Array.getLength(object);
                Object object2 = Array.newInstance(clazz2, n);
                System.arraycopy(object, 0, object2, 0, n);
                return object2;
            }
            try {
                return clazz.getMethod("clone", null).invoke(object, null);
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                if (object instanceof Vector) {
                    return ((Vector)object).clone();
                }
                if (!(object instanceof Hashtable)) break block10;
                return ((Hashtable)object).clone();
            }
        }
        return object;
    }

    public synchronized String toString() {
        String[] stringArray = this.getPropertyKeys();
        int n = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer(20 * n);
        stringBuffer.append('{');
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String string = stringArray[n3];
            if (!string.equals("objectClass")) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string);
                stringBuffer.append('=');
                Object object = this.get(string);
                if (object.getClass().isArray()) {
                    stringBuffer.append('[');
                    int n4 = Array.getLength(object);
                    int n5 = 0;
                    while (n5 < n4) {
                        if (n5 > 0) {
                            stringBuffer.append(',');
                        }
                        stringBuffer.append(Array.get(object, n5));
                        ++n5;
                    }
                    stringBuffer.append(']');
                } else {
                    stringBuffer.append(object);
                }
                ++n2;
            }
            ++n3;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

