/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.launch;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.launch.EquinoxFWClassLoader;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.launch.Framework;

public class Equinox
implements Framework {
    private static final String implName = "org.eclipse.osgi.framework.internal.core.EquinoxLauncher";
    private Framework impl;
    private final boolean useSeparateCL;
    private final Map configuration;
    static /* synthetic */ Class class$0;

    public Equinox(Map map) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AllPermission());
        }
        this.useSeparateCL = FrameworkProperties.inUse();
        this.configuration = map;
    }

    private Framework createImpl() {
        if (System.getSecurityManager() == null) {
            return this.createImpl0();
        }
        return (Framework)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Equinox.this.createImpl0();
            }
        });
    }

    Framework createImpl0() {
        try {
            Class clazz = this.getImplClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.util.Map");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Constructor constructor = clazz.getConstructor(classArray);
            return (Framework)constructor.newInstance(this.configuration);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(implName);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getMessage());
        }
    }

    private Class getImplClass() throws ClassNotFoundException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (!this.useSeparateCL || !(classLoader instanceof URLClassLoader)) {
            return Class.forName(implName);
        }
        URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
        EquinoxFWClassLoader equinoxFWClassLoader = new EquinoxFWClassLoader(uRLArray, classLoader);
        return equinoxFWClassLoader.loadClass(implName);
    }

    private synchronized Framework getImpl() {
        if (this.impl == null) {
            this.impl = this.createImpl();
        }
        return this.impl;
    }

    public void init() throws BundleException {
        this.getImpl().init();
    }

    public FrameworkEvent waitForStop(long l) throws InterruptedException {
        return this.getImpl().waitForStop(l);
    }

    public Enumeration findEntries(String string, String string2, boolean bl) {
        return this.getImpl().findEntries(string, string2, bl);
    }

    public BundleContext getBundleContext() {
        return this.getImpl().getBundleContext();
    }

    public long getBundleId() {
        return this.getImpl().getBundleId();
    }

    public URL getEntry(String string) {
        return this.getImpl().getEntry(string);
    }

    public Enumeration getEntryPaths(String string) {
        return this.getImpl().getEntryPaths(string);
    }

    public Dictionary getHeaders() {
        return this.getImpl().getHeaders();
    }

    public Dictionary getHeaders(String string) {
        return this.getImpl().getHeaders(string);
    }

    public long getLastModified() {
        return this.getImpl().getLastModified();
    }

    public String getLocation() {
        return this.getImpl().getLocation();
    }

    public ServiceReference[] getRegisteredServices() {
        return this.getImpl().getRegisteredServices();
    }

    public URL getResource(String string) {
        return this.getImpl().getResource(string);
    }

    public Enumeration getResources(String string) throws IOException {
        return this.getImpl().getResources(string);
    }

    public ServiceReference[] getServicesInUse() {
        return this.getImpl().getServicesInUse();
    }

    public int getState() {
        return this.getImpl().getState();
    }

    public String getSymbolicName() {
        return this.getImpl().getSymbolicName();
    }

    public boolean hasPermission(Object object) {
        return this.getImpl().hasPermission(object);
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.getImpl().loadClass(string);
    }

    public void start(int n) throws BundleException {
        this.getImpl().start(n);
    }

    public void start() throws BundleException {
        this.getImpl().start();
    }

    public void stop(int n) throws BundleException {
        this.getImpl().stop(n);
    }

    public void stop() throws BundleException {
        this.getImpl().stop();
    }

    public void uninstall() throws BundleException {
        this.getImpl().uninstall();
    }

    public void update() throws BundleException {
        this.getImpl().update();
    }

    public void update(InputStream inputStream) throws BundleException {
        this.getImpl().update(inputStream);
    }

    public Map getSignerCertificates(int n) {
        return this.getImpl().getSignerCertificates(n);
    }

    public Version getVersion() {
        return this.getImpl().getVersion();
    }
}

