/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.AdminPermissionCollection;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.SignerProperty;

public final class AdminPermission
extends BasicPermission {
    static final long serialVersionUID = 307051004521261705L;
    public static final String CLASS = "class";
    public static final String EXECUTE = "execute";
    public static final String EXTENSIONLIFECYCLE = "extensionLifecycle";
    public static final String LIFECYCLE = "lifecycle";
    public static final String LISTENER = "listener";
    public static final String METADATA = "metadata";
    public static final String RESOLVE = "resolve";
    public static final String RESOURCE = "resource";
    public static final String STARTLEVEL = "startlevel";
    public static final String CONTEXT = "context";
    private static final int ACTION_CLASS = 1;
    private static final int ACTION_EXECUTE = 2;
    private static final int ACTION_LIFECYCLE = 4;
    private static final int ACTION_LISTENER = 8;
    private static final int ACTION_METADATA = 16;
    private static final int ACTION_RESOLVE = 64;
    private static final int ACTION_RESOURCE = 128;
    private static final int ACTION_STARTLEVEL = 256;
    private static final int ACTION_EXTENSIONLIFECYCLE = 512;
    private static final int ACTION_CONTEXT = 1024;
    private static final int ACTION_ALL = 2015;
    static final int ACTION_NONE = 0;
    private volatile String actions = null;
    transient int action_mask;
    transient Filter filter;
    final transient Bundle bundle;
    private volatile transient Dictionary properties;

    public AdminPermission() {
        this(null, 2015);
    }

    public AdminPermission(String string, String string2) {
        this(AdminPermission.parseFilter(string), AdminPermission.parseActions(string2));
    }

    public AdminPermission(Bundle bundle, String string) {
        super(AdminPermission.createName(bundle));
        this.setTransients(null, AdminPermission.parseActions(string));
        this.bundle = bundle;
    }

    private static String createName(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle must not be null");
        }
        StringBuffer stringBuffer = new StringBuffer("(id=");
        stringBuffer.append(bundle.getBundleId());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    AdminPermission(Filter filter, int n) {
        super(filter == null ? "*" : filter.toString());
        this.setTransients(filter, n);
        this.bundle = null;
    }

    private void setTransients(Filter filter, int n) {
        this.filter = filter;
        if (n == 0 || (n & 0x7DF) != n) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = n;
    }

    /*
     * Unable to fully structure code
     */
    private static int parseActions(String var0) {
        if (var0 == null || var0.equals("*")) {
            return 2015;
        }
        var1_1 = false;
        var2_2 = 0;
        if (var0 == null) {
            return var2_2;
        }
        var3_3 = var0.toCharArray();
        var4_4 = var3_3.length - 1;
        if (var4_4 >= 0) ** GOTO lbl71
        return var2_2;
        {
            --var4_4;
            do {
                if (var4_4 != -1 && ((var5_5 = var3_3[var4_4]) == ' ' || var5_5 == '\r' || var5_5 == '\n' || var5_5 == '\f' || var5_5 == '\t')) continue block4;
                if (!(var4_4 < 4 || var3_3[var4_4 - 4] != 'c' && var3_3[var4_4 - 4] != 'C' || var3_3[var4_4 - 3] != 'l' && var3_3[var4_4 - 3] != 'L' || var3_3[var4_4 - 2] != 'a' && var3_3[var4_4 - 2] != 'A' || var3_3[var4_4 - 1] != 's' && var3_3[var4_4 - 1] != 'S' || var3_3[var4_4] != 's' && var3_3[var4_4] != 'S')) {
                    var6_6 = 5;
                    var2_2 |= 65;
                } else if (!(var4_4 < 6 || var3_3[var4_4 - 6] != 'e' && var3_3[var4_4 - 6] != 'E' || var3_3[var4_4 - 5] != 'x' && var3_3[var4_4 - 5] != 'X' || var3_3[var4_4 - 4] != 'e' && var3_3[var4_4 - 4] != 'E' || var3_3[var4_4 - 3] != 'c' && var3_3[var4_4 - 3] != 'C' || var3_3[var4_4 - 2] != 'u' && var3_3[var4_4 - 2] != 'U' || var3_3[var4_4 - 1] != 't' && var3_3[var4_4 - 1] != 'T' || var3_3[var4_4] != 'e' && var3_3[var4_4] != 'E')) {
                    var6_6 = 7;
                    var2_2 |= 66;
                } else if (!(var4_4 < 17 || var3_3[var4_4 - 17] != 'e' && var3_3[var4_4 - 17] != 'E' || var3_3[var4_4 - 16] != 'x' && var3_3[var4_4 - 16] != 'X' || var3_3[var4_4 - 15] != 't' && var3_3[var4_4 - 15] != 'T' || var3_3[var4_4 - 14] != 'e' && var3_3[var4_4 - 14] != 'E' || var3_3[var4_4 - 13] != 'n' && var3_3[var4_4 - 13] != 'N' || var3_3[var4_4 - 12] != 's' && var3_3[var4_4 - 12] != 'S' || var3_3[var4_4 - 11] != 'i' && var3_3[var4_4 - 11] != 'I' || var3_3[var4_4 - 10] != 'o' && var3_3[var4_4 - 10] != 'O' || var3_3[var4_4 - 9] != 'n' && var3_3[var4_4 - 9] != 'N' || var3_3[var4_4 - 8] != 'l' && var3_3[var4_4 - 8] != 'L' || var3_3[var4_4 - 7] != 'i' && var3_3[var4_4 - 7] != 'I' || var3_3[var4_4 - 6] != 'f' && var3_3[var4_4 - 6] != 'F' || var3_3[var4_4 - 5] != 'e' && var3_3[var4_4 - 5] != 'E' || var3_3[var4_4 - 4] != 'c' && var3_3[var4_4 - 4] != 'C' || var3_3[var4_4 - 3] != 'y' && var3_3[var4_4 - 3] != 'Y' || var3_3[var4_4 - 2] != 'c' && var3_3[var4_4 - 2] != 'C' || var3_3[var4_4 - 1] != 'l' && var3_3[var4_4 - 1] != 'L' || var3_3[var4_4] != 'e' && var3_3[var4_4] != 'E')) {
                    var6_6 = 18;
                    var2_2 |= 512;
                } else if (!(var4_4 < 8 || var3_3[var4_4 - 8] != 'l' && var3_3[var4_4 - 8] != 'L' || var3_3[var4_4 - 7] != 'i' && var3_3[var4_4 - 7] != 'I' || var3_3[var4_4 - 6] != 'f' && var3_3[var4_4 - 6] != 'F' || var3_3[var4_4 - 5] != 'e' && var3_3[var4_4 - 5] != 'E' || var3_3[var4_4 - 4] != 'c' && var3_3[var4_4 - 4] != 'C' || var3_3[var4_4 - 3] != 'y' && var3_3[var4_4 - 3] != 'Y' || var3_3[var4_4 - 2] != 'c' && var3_3[var4_4 - 2] != 'C' || var3_3[var4_4 - 1] != 'l' && var3_3[var4_4 - 1] != 'L' || var3_3[var4_4] != 'e' && var3_3[var4_4] != 'E')) {
                    var6_6 = 9;
                    var2_2 |= 4;
                } else if (!(var4_4 < 7 || var3_3[var4_4 - 7] != 'l' && var3_3[var4_4 - 7] != 'L' || var3_3[var4_4 - 6] != 'i' && var3_3[var4_4 - 6] != 'I' || var3_3[var4_4 - 5] != 's' && var3_3[var4_4 - 5] != 'S' || var3_3[var4_4 - 4] != 't' && var3_3[var4_4 - 4] != 'T' || var3_3[var4_4 - 3] != 'e' && var3_3[var4_4 - 3] != 'E' || var3_3[var4_4 - 2] != 'n' && var3_3[var4_4 - 2] != 'N' || var3_3[var4_4 - 1] != 'e' && var3_3[var4_4 - 1] != 'E' || var3_3[var4_4] != 'r' && var3_3[var4_4] != 'R')) {
                    var6_6 = 8;
                    var2_2 |= 8;
                } else if (!(var4_4 < 7 || var3_3[var4_4 - 7] != 'm' && var3_3[var4_4 - 7] != 'M' || var3_3[var4_4 - 6] != 'e' && var3_3[var4_4 - 6] != 'E' || var3_3[var4_4 - 5] != 't' && var3_3[var4_4 - 5] != 'T' || var3_3[var4_4 - 4] != 'a' && var3_3[var4_4 - 4] != 'A' || var3_3[var4_4 - 3] != 'd' && var3_3[var4_4 - 3] != 'D' || var3_3[var4_4 - 2] != 'a' && var3_3[var4_4 - 2] != 'A' || var3_3[var4_4 - 1] != 't' && var3_3[var4_4 - 1] != 'T' || var3_3[var4_4] != 'a' && var3_3[var4_4] != 'A')) {
                    var6_6 = 8;
                    var2_2 |= 16;
                } else if (!(var4_4 < 6 || var3_3[var4_4 - 6] != 'r' && var3_3[var4_4 - 6] != 'R' || var3_3[var4_4 - 5] != 'e' && var3_3[var4_4 - 5] != 'E' || var3_3[var4_4 - 4] != 's' && var3_3[var4_4 - 4] != 'S' || var3_3[var4_4 - 3] != 'o' && var3_3[var4_4 - 3] != 'O' || var3_3[var4_4 - 2] != 'l' && var3_3[var4_4 - 2] != 'L' || var3_3[var4_4 - 1] != 'v' && var3_3[var4_4 - 1] != 'V' || var3_3[var4_4] != 'e' && var3_3[var4_4] != 'E')) {
                    var6_6 = 7;
                    var2_2 |= 64;
                } else if (!(var4_4 < 7 || var3_3[var4_4 - 7] != 'r' && var3_3[var4_4 - 7] != 'R' || var3_3[var4_4 - 6] != 'e' && var3_3[var4_4 - 6] != 'E' || var3_3[var4_4 - 5] != 's' && var3_3[var4_4 - 5] != 'S' || var3_3[var4_4 - 4] != 'o' && var3_3[var4_4 - 4] != 'O' || var3_3[var4_4 - 3] != 'u' && var3_3[var4_4 - 3] != 'U' || var3_3[var4_4 - 2] != 'r' && var3_3[var4_4 - 2] != 'R' || var3_3[var4_4 - 1] != 'c' && var3_3[var4_4 - 1] != 'C' || var3_3[var4_4] != 'e' && var3_3[var4_4] != 'E')) {
                    var6_6 = 8;
                    var2_2 |= 192;
                } else if (!(var4_4 < 9 || var3_3[var4_4 - 9] != 's' && var3_3[var4_4 - 9] != 'S' || var3_3[var4_4 - 8] != 't' && var3_3[var4_4 - 8] != 'T' || var3_3[var4_4 - 7] != 'a' && var3_3[var4_4 - 7] != 'A' || var3_3[var4_4 - 6] != 'r' && var3_3[var4_4 - 6] != 'R' || var3_3[var4_4 - 5] != 't' && var3_3[var4_4 - 5] != 'T' || var3_3[var4_4 - 4] != 'l' && var3_3[var4_4 - 4] != 'L' || var3_3[var4_4 - 3] != 'e' && var3_3[var4_4 - 3] != 'E' || var3_3[var4_4 - 2] != 'v' && var3_3[var4_4 - 2] != 'V' || var3_3[var4_4 - 1] != 'e' && var3_3[var4_4 - 1] != 'E' || var3_3[var4_4] != 'l' && var3_3[var4_4] != 'L')) {
                    var6_6 = 10;
                    var2_2 |= 256;
                } else if (!(var4_4 < 6 || var3_3[var4_4 - 6] != 'c' && var3_3[var4_4 - 6] != 'C' || var3_3[var4_4 - 5] != 'o' && var3_3[var4_4 - 5] != 'O' || var3_3[var4_4 - 4] != 'n' && var3_3[var4_4 - 4] != 'N' || var3_3[var4_4 - 3] != 't' && var3_3[var4_4 - 3] != 'T' || var3_3[var4_4 - 2] != 'e' && var3_3[var4_4 - 2] != 'E' || var3_3[var4_4 - 1] != 'x' && var3_3[var4_4 - 1] != 'X' || var3_3[var4_4] != 't' && var3_3[var4_4] != 'T')) {
                    var6_6 = 7;
                    var2_2 |= 1024;
                } else if (var4_4 >= 0 && var3_3[var4_4] == '*') {
                    var6_6 = 1;
                    var2_2 |= 2015;
                } else {
                    throw new IllegalArgumentException("invalid permission: " + var0);
                }
                var1_1 = false;
                while (var4_4 >= var6_6 && !var1_1) {
                    switch (var3_3[var4_4 - var6_6]) {
                        case ',': {
                            var1_1 = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission: " + var0);
                        }
                    }
                    --var4_4;
                }
                var4_4 -= var6_6;
lbl71:
                // 2 sources

            } while (var4_4 != -1);
        }
        if (var1_1) {
            throw new IllegalArgumentException("invalid permission: " + var0);
        }
        return var2_2;
    }

    private static Filter parseFilter(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).equals("*")) {
            return null;
        }
        try {
            return FrameworkUtil.createFilter(string);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid filter");
            illegalArgumentException.initCause(invalidSyntaxException);
            throw illegalArgumentException;
        }
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof AdminPermission)) {
            return false;
        }
        AdminPermission adminPermission = (AdminPermission)permission;
        if (this.bundle != null) {
            return false;
        }
        if (adminPermission.filter != null) {
            return false;
        }
        return this.implies0(adminPermission, 0);
    }

    boolean implies0(AdminPermission adminPermission, int n) {
        int n2 = adminPermission.action_mask;
        if (((n |= this.action_mask) & n2) != n2) {
            return false;
        }
        Filter filter = this.filter;
        if (filter == null) {
            return true;
        }
        if (adminPermission.bundle == null) {
            return false;
        }
        return filter.matchCase(adminPermission.getProperties());
    }

    public String getActions() {
        String string = this.actions;
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.action_mask;
            if ((n & 1) == 1) {
                stringBuffer.append(CLASS);
                stringBuffer.append(',');
            }
            if ((n & 2) == 2) {
                stringBuffer.append(EXECUTE);
                stringBuffer.append(',');
            }
            if ((n & 0x200) == 512) {
                stringBuffer.append(EXTENSIONLIFECYCLE);
                stringBuffer.append(',');
            }
            if ((n & 4) == 4) {
                stringBuffer.append(LIFECYCLE);
                stringBuffer.append(',');
            }
            if ((n & 8) == 8) {
                stringBuffer.append(LISTENER);
                stringBuffer.append(',');
            }
            if ((n & 0x10) == 16) {
                stringBuffer.append(METADATA);
                stringBuffer.append(',');
            }
            if ((n & 0x40) == 64) {
                stringBuffer.append(RESOLVE);
                stringBuffer.append(',');
            }
            if ((n & 0x80) == 128) {
                stringBuffer.append(RESOURCE);
                stringBuffer.append(',');
            }
            if ((n & 0x100) == 256) {
                stringBuffer.append(STARTLEVEL);
                stringBuffer.append(',');
            }
            if ((n & 0x400) == 1024) {
                stringBuffer.append(CONTEXT);
                stringBuffer.append(',');
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            this.actions = string = stringBuffer.toString();
        }
        return string;
    }

    public PermissionCollection newPermissionCollection() {
        return new AdminPermissionCollection();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AdminPermission)) {
            return false;
        }
        AdminPermission adminPermission = (AdminPermission)object;
        return this.action_mask == adminPermission.action_mask && (this.bundle == adminPermission.bundle || this.bundle != null && this.bundle.equals(adminPermission.bundle)) && (this.filter == null ? adminPermission.filter == null : this.filter.equals(adminPermission.filter));
    }

    public int hashCode() {
        int n = 527 + this.getName().hashCode();
        n = 31 * n + this.getActions().hashCode();
        if (this.bundle != null) {
            n = 31 * n + this.bundle.hashCode();
        }
        return n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.bundle != null) {
            throw new NotSerializableException("cannot serialize");
        }
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setTransients(AdminPermission.parseFilter(this.getName()), AdminPermission.parseActions(this.actions));
    }

    private Dictionary getProperties() {
        Dictionary dictionary = this.properties;
        if (dictionary != null) {
            return dictionary;
        }
        final Hashtable hashtable = new Hashtable(4);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SignerProperty signerProperty;
                hashtable.put("id", new Long(AdminPermission.this.bundle.getBundleId()));
                hashtable.put("location", AdminPermission.this.bundle.getLocation());
                String string = AdminPermission.this.bundle.getSymbolicName();
                if (string != null) {
                    hashtable.put("name", string);
                }
                if ((signerProperty = new SignerProperty(AdminPermission.this.bundle)).isBundleSigned()) {
                    hashtable.put("signer", signerProperty);
                }
                return null;
            }
        });
        this.properties = hashtable;
        return this.properties;
    }
}

