/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.Filter;
import org.osgi.framework.PackagePermission;

final class PackagePermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = -3350758995234427603L;
    private transient Map permissions = new HashMap();
    private boolean all_allowed = false;
    private Map filterPermissions;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[3];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Hashtable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[0] = new ObjectStreamField("permissions", clazz);
        objectStreamFieldArray[1] = new ObjectStreamField("all_allowed", Boolean.TYPE);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.util.HashMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[2] = new ObjectStreamField("filterPermissions", clazz2);
        serialPersistentFields = objectStreamFieldArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Permission permission) {
        if (!(permission instanceof PackagePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        PackagePermission packagePermission = (PackagePermission)permission;
        if (packagePermission.bundle != null) {
            throw new IllegalArgumentException("cannot add to collection: " + packagePermission);
        }
        String string = packagePermission.getName();
        Filter filter = packagePermission.filter;
        PackagePermissionCollection packagePermissionCollection = this;
        synchronized (packagePermissionCollection) {
            PackagePermission packagePermission2;
            HashMap<String, PackagePermission> hashMap;
            if (filter != null) {
                hashMap = this.filterPermissions;
                if (hashMap == null) {
                    this.filterPermissions = hashMap = new HashMap<String, PackagePermission>();
                }
            } else {
                hashMap = this.permissions;
            }
            if ((packagePermission2 = (PackagePermission)hashMap.get(string)) != null) {
                int n = packagePermission2.action_mask;
                int n2 = packagePermission.action_mask;
                if (n != n2) {
                    hashMap.put(string, new PackagePermission(string, n | n2));
                }
            } else {
                hashMap.put(string, packagePermission);
            }
            if (!this.all_allowed && string.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean implies(Permission permission) {
        Collection collection;
        if (!(permission instanceof PackagePermission)) {
            return false;
        }
        PackagePermission packagePermission = (PackagePermission)permission;
        if (packagePermission.filter != null) {
            return false;
        }
        String string = packagePermission.getName();
        int n = packagePermission.action_mask;
        int n2 = 0;
        Object object = this;
        synchronized (object) {
            PackagePermission packagePermission2;
            Map map = this.permissions;
            if (this.all_allowed && (packagePermission2 = (PackagePermission)map.get("*")) != null && ((n2 |= packagePermission2.action_mask) & n) == n) {
                return true;
            }
            packagePermission2 = (PackagePermission)map.get(string);
            if (packagePermission2 != null && ((n2 |= packagePermission2.action_mask) & n) == n) {
                return true;
            }
            int n3 = string.length() - 1;
            while (true) {
                int n4;
                if ((n4 = string.lastIndexOf(".", n3)) == -1) {
                    map = this.filterPermissions;
                    if (map != null) break;
                    return false;
                }
                packagePermission2 = (PackagePermission)map.get(string = String.valueOf(string.substring(0, n4 + 1)) + "*");
                if (packagePermission2 != null && ((n2 |= packagePermission2.action_mask) & n) == n) {
                    return true;
                }
                n3 = n4 - 1;
            }
            collection = map.values();
        }
        object = collection.iterator();
        while (object.hasNext()) {
            if (!((PackagePermission)object.next()).implies0(packagePermission, n2)) continue;
            return true;
        }
        return false;
    }

    public synchronized Enumeration elements() {
        ArrayList arrayList = new ArrayList(this.permissions.values());
        Map map = this.filterPermissions;
        if (map != null) {
            arrayList.addAll(map.values());
        }
        return Collections.enumeration(arrayList);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable hashtable = new Hashtable(this.permissions);
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("permissions", hashtable);
        putField.put("all_allowed", this.all_allowed);
        putField.put("filterPermissions", this.filterPermissions);
        objectOutputStream.writeFields();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Hashtable hashtable = (Hashtable)getField.get("permissions", null);
        this.permissions = new HashMap(hashtable);
        this.all_allowed = getField.get("all_allowed", false);
        this.filterPermissions = (HashMap)getField.get("filterPermissions", null);
    }
}

