/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.condpermadmin;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;

public class BundleLocationCondition {
    private static final String CONDITION_TYPE = "org.osgi.service.condpermadmin.BundleLocationCondition";

    public static Condition getCondition(final Bundle bundle, ConditionInfo conditionInfo) {
        if (!CONDITION_TYPE.equals(conditionInfo.getType())) {
            throw new IllegalArgumentException("ConditionInfo must be of type \"org.osgi.service.condpermadmin.BundleLocationCondition\"");
        }
        String[] stringArray = conditionInfo.getArgs();
        if (stringArray.length != 1 && stringArray.length != 2) {
            throw new IllegalArgumentException("Illegal number of args: " + stringArray.length);
        }
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return bundle.getLocation();
            }
        });
        Filter filter = null;
        try {
            filter = FrameworkUtil.createFilter("(location=" + BundleLocationCondition.escapeLocation(stringArray[0]) + ")");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new RuntimeException("Invalid filter: " + invalidSyntaxException.getFilter(), invalidSyntaxException);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>(2);
        hashtable.put("location", string);
        boolean bl = stringArray.length == 2 ? "!".equals(stringArray[1]) : false;
        return bl ^ filter.match(hashtable) ? Condition.TRUE : Condition.FALSE;
    }

    private BundleLocationCondition() {
    }

    private static String escapeLocation(String string) {
        boolean bl = false;
        int n = string.length();
        int n2 = n << 1;
        char[] cArray = new char[n2];
        string.getChars(0, n, cArray, n);
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            char c = cArray[n4];
            switch (c) {
                case '\\': {
                    if (n4 + 1 < n2 && cArray[n4 + 1] == '*') break;
                }
                case '(': 
                case ')': {
                    cArray[n3] = 92;
                    ++n3;
                    bl = true;
                }
            }
            cArray[n3] = c;
            ++n3;
            ++n4;
        }
        return bl ? new String(cArray, 0, n3) : string;
    }
}

