/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.tracker;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.util.tracker.AbstractTracked;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTracker
implements ServiceTrackerCustomizer {
    static final boolean DEBUG = false;
    protected final BundleContext context;
    protected final Filter filter;
    final ServiceTrackerCustomizer customizer;
    final String listenerFilter;
    private final String trackClass;
    private final ServiceReference trackReference;
    private volatile Tracked tracked;
    private volatile ServiceReference cachedReference;
    private volatile Object cachedService;
    private static final Version endMatchVersion = new Version(1, 5, 0);

    private Tracked tracked() {
        return this.tracked;
    }

    public ServiceTracker(BundleContext bundleContext, ServiceReference serviceReference, ServiceTrackerCustomizer serviceTrackerCustomizer) {
        this.context = bundleContext;
        this.trackReference = serviceReference;
        this.trackClass = null;
        this.customizer = serviceTrackerCustomizer == null ? this : serviceTrackerCustomizer;
        this.listenerFilter = "(service.id=" + serviceReference.getProperty("service.id").toString() + ")";
        try {
            this.filter = bundleContext.createFilter(this.listenerFilter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("unexpected InvalidSyntaxException: " + invalidSyntaxException.getMessage());
            illegalArgumentException.initCause(invalidSyntaxException);
            throw illegalArgumentException;
        }
    }

    public ServiceTracker(BundleContext bundleContext, String string, ServiceTrackerCustomizer serviceTrackerCustomizer) {
        this.context = bundleContext;
        this.trackReference = null;
        this.trackClass = string;
        this.customizer = serviceTrackerCustomizer == null ? this : serviceTrackerCustomizer;
        this.listenerFilter = "(objectClass=" + string.toString() + ")";
        try {
            this.filter = bundleContext.createFilter(this.listenerFilter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("unexpected InvalidSyntaxException: " + invalidSyntaxException.getMessage());
            illegalArgumentException.initCause(invalidSyntaxException);
            throw illegalArgumentException;
        }
    }

    public ServiceTracker(final BundleContext bundleContext, Filter filter, ServiceTrackerCustomizer serviceTrackerCustomizer) {
        this.context = bundleContext;
        this.trackReference = null;
        this.trackClass = null;
        Version version = (Version)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = bundleContext.getProperty("org.osgi.framework.version");
                return string == null ? Version.emptyVersion : new Version(string);
            }
        });
        boolean bl = version.compareTo(endMatchVersion) >= 0;
        this.listenerFilter = bl ? filter.toString() : null;
        this.filter = filter;
        ServiceTrackerCustomizer serviceTrackerCustomizer2 = this.customizer = serviceTrackerCustomizer == null ? this : serviceTrackerCustomizer;
        if (bundleContext == null || filter == null) {
            throw new NullPointerException();
        }
    }

    public void open() {
        this.open(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(boolean bl) {
        Tracked tracked;
        ServiceTracker serviceTracker = this;
        synchronized (serviceTracker) {
            if (this.tracked != null) {
                return;
            }
            Tracked tracked2 = tracked = bl ? new AllTracked() : new Tracked();
            synchronized (tracked2) {
                try {
                    this.context.addServiceListener(tracked, this.listenerFilter);
                    Object[] objectArray = null;
                    if (this.trackClass != null) {
                        objectArray = this.getInitialReferences(bl, this.trackClass, null);
                    } else if (this.trackReference != null) {
                        if (this.trackReference.getBundle() != null) {
                            objectArray = new ServiceReference[]{this.trackReference};
                        }
                    } else {
                        objectArray = this.getInitialReferences(bl, null, this.listenerFilter != null ? this.listenerFilter : this.filter.toString());
                    }
                    tracked.setInitial(objectArray);
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    throw new RuntimeException("unexpected InvalidSyntaxException: " + invalidSyntaxException.getMessage(), invalidSyntaxException);
                }
            }
            this.tracked = tracked;
        }
        tracked.trackInitial();
    }

    private ServiceReference[] getInitialReferences(boolean bl, String string, String string2) throws InvalidSyntaxException {
        if (bl) {
            return this.context.getAllServiceReferences(string, string2);
        }
        return this.context.getServiceReferences(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ServiceReference[] serviceReferenceArray;
        Tracked tracked;
        Object object = this;
        synchronized (object) {
            tracked = this.tracked;
            if (tracked == null) {
                return;
            }
            tracked.close();
            serviceReferenceArray = this.getServiceReferences();
            this.tracked = null;
            try {
                this.context.removeServiceListener(tracked);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        this.modified();
        object = tracked;
        synchronized (object) {
            tracked.notifyAll();
        }
        if (serviceReferenceArray != null) {
            int n = 0;
            while (n < serviceReferenceArray.length) {
                tracked.untrack(serviceReferenceArray[n], null);
                ++n;
            }
        }
    }

    public Object addingService(ServiceReference serviceReference) {
        return this.context.getService(serviceReference);
    }

    public void modifiedService(ServiceReference serviceReference, Object object) {
    }

    public void removedService(ServiceReference serviceReference, Object object) {
        this.context.ungetService(serviceReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitForService(long l) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        Object object = this.getService();
        while (object == null) {
            Tracked tracked = this.tracked();
            if (tracked == null) {
                return null;
            }
            Tracked tracked2 = tracked;
            synchronized (tracked2) {
                if (tracked.size() == 0) {
                    tracked.wait(l);
                }
            }
            object = this.getService();
            if (l <= 0L) continue;
            return object;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference[] getServiceReferences() {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int n;
            block5: {
                n = tracked.size();
                if (n != 0) break block5;
                return null;
            }
            return (ServiceReference[])tracked.getTracked(new ServiceReference[n]);
        }
    }

    public ServiceReference getServiceReference() {
        int n;
        ServiceReference serviceReference = this.cachedReference;
        if (serviceReference != null) {
            return serviceReference;
        }
        ServiceReference[] serviceReferenceArray = this.getServiceReferences();
        int n2 = n = serviceReferenceArray == null ? 0 : serviceReferenceArray.length;
        if (n == 0) {
            return null;
        }
        int n3 = 0;
        if (n > 1) {
            int n4;
            int[] nArray = new int[n];
            int n5 = 0;
            int n6 = Integer.MIN_VALUE;
            int n7 = 0;
            while (n7 < n) {
                Object object = serviceReferenceArray[n7].getProperty("service.ranking");
                nArray[n7] = n4 = object instanceof Integer ? (Integer)object : 0;
                if (n4 > n6) {
                    n3 = n7;
                    n6 = n4;
                    n5 = 1;
                } else if (n4 == n6) {
                    ++n5;
                }
                ++n7;
            }
            if (n5 > 1) {
                long l = Long.MAX_VALUE;
                n4 = 0;
                while (n4 < n) {
                    long l2;
                    if (nArray[n4] == n6 && (l2 = ((Long)serviceReferenceArray[n4].getProperty("service.id")).longValue()) < l) {
                        n3 = n4;
                        l = l2;
                    }
                    ++n4;
                }
            }
        }
        this.cachedReference = serviceReferenceArray[n3];
        return this.cachedReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(ServiceReference serviceReference) {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.getCustomizedObject(serviceReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getServices() {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int n;
            ServiceReference[] serviceReferenceArray;
            block6: {
                serviceReferenceArray = this.getServiceReferences();
                int n2 = n = serviceReferenceArray == null ? 0 : serviceReferenceArray.length;
                if (n != 0) break block6;
                return null;
            }
            Object[] objectArray = new Object[n];
            int n3 = 0;
            while (n3 < n) {
                objectArray[n3] = this.getService(serviceReferenceArray[n3]);
                ++n3;
            }
            return objectArray;
        }
    }

    public Object getService() {
        Object object = this.cachedService;
        if (object != null) {
            return object;
        }
        ServiceReference serviceReference = this.getServiceReference();
        if (serviceReference == null) {
            return null;
        }
        this.cachedService = this.getService(serviceReference);
        return this.cachedService;
    }

    public void remove(ServiceReference serviceReference) {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return;
        }
        tracked.untrack(serviceReference, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return 0;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTrackingCount() {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return -1;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.getTrackingCount();
        }
    }

    void modified() {
        this.cachedReference = null;
        this.cachedService = null;
    }

    class AllTracked
    extends Tracked
    implements AllServiceListener {
        AllTracked() {
        }
    }

    class Tracked
    extends AbstractTracked
    implements ServiceListener {
        Tracked() {
        }

        public void serviceChanged(ServiceEvent serviceEvent) {
            if (this.closed) {
                return;
            }
            ServiceReference serviceReference = serviceEvent.getServiceReference();
            switch (serviceEvent.getType()) {
                case 1: 
                case 2: {
                    if (ServiceTracker.this.listenerFilter != null) {
                        this.track(serviceReference, serviceEvent);
                        break;
                    }
                    if (ServiceTracker.this.filter.match(serviceReference)) {
                        this.track(serviceReference, serviceEvent);
                        break;
                    }
                    this.untrack(serviceReference, serviceEvent);
                    break;
                }
                case 4: 
                case 8: {
                    this.untrack(serviceReference, serviceEvent);
                }
            }
        }

        void modified() {
            super.modified();
            ServiceTracker.this.modified();
        }

        Object customizerAdding(Object object, Object object2) {
            return ServiceTracker.this.customizer.addingService((ServiceReference)object);
        }

        void customizerModified(Object object, Object object2, Object object3) {
            ServiceTracker.this.customizer.modifiedService((ServiceReference)object, object3);
        }

        void customizerRemoved(Object object, Object object2, Object object3) {
            ServiceTracker.this.customizer.removedService((ServiceReference)object, object3);
        }
    }
}

