/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Properties;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;

public class Preferences {
    public static final boolean BOOLEAN_DEFAULT_DEFAULT = false;
    public static final double DOUBLE_DEFAULT_DEFAULT = 0.0;
    public static final float FLOAT_DEFAULT_DEFAULT = 0.0f;
    public static final int INT_DEFAULT_DEFAULT = 0;
    public static final long LONG_DEFAULT_DEFAULT = 0L;
    public static final String STRING_DEFAULT_DEFAULT = "";
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String PT_PREFERENCES = "preferences";
    protected ListenerList listeners = new ListenerList();
    private Properties properties;
    private Properties defaultProperties = new Properties();
    protected boolean dirty = false;

    /*
     * Exception decompiling
     */
    public static void exportPreferences(IPath var0) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 167->171)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static void importPreferences(IPath var0) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 145->149)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static IStatus validatePreferenceVersions(IPath iPath) {
        PreferencesService preferencesService = PreferencesService.getDefault();
        return preferencesService.validateVersions(iPath);
    }

    public Preferences() {
        this.properties = new Properties(this.defaultProperties);
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.add((Object)iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.remove((Object)iPropertyChangeListener);
    }

    public boolean contains(String string) {
        return this.properties.containsKey(string) || this.defaultProperties.containsKey(string);
    }

    protected void firePropertyChangeEvent(String string, Object object, Object object2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Object[] objectArray = this.listeners.getListeners();
        if (objectArray.length == 0) {
            return;
        }
        final PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        int n = 0;
        while (n < objectArray.length) {
            final IPropertyChangeListener iPropertyChangeListener = (IPropertyChangeListener)objectArray[n];
            ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                }

                public void run() throws Exception {
                    iPropertyChangeListener.propertyChange(propertyChangeEvent);
                }
            };
            SafeRunner.run((ISafeRunnable)iSafeRunnable);
            ++n;
        }
    }

    public boolean getBoolean(String string) {
        String string2 = this.properties.getProperty(string);
        if (string2 == null) {
            return false;
        }
        return string2.equals(TRUE);
    }

    public void setValue(String string, boolean bl) {
        boolean bl2 = this.getDefaultBoolean(string);
        boolean bl3 = this.getBoolean(string);
        if (bl == bl2) {
            Object object = this.properties.remove(string);
            if (object != null) {
                this.dirty = true;
            }
        } else {
            this.properties.put(string, bl ? TRUE : FALSE);
        }
        if (bl3 != bl) {
            this.dirty = true;
            this.firePropertyChangeEvent(string, bl3 ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getDefaultBoolean(String string) {
        String string2 = this.defaultProperties.getProperty(string);
        if (string2 == null) {
            return false;
        }
        return string2.equals(TRUE);
    }

    public void setDefault(String string, boolean bl) {
        this.defaultProperties.put(string, bl ? TRUE : FALSE);
    }

    public double getDouble(String string) {
        return this.convertToDouble(this.properties.getProperty(string), 0.0);
    }

    public void setValue(String string, double d) {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException();
        }
        double d2 = this.getDefaultDouble(string);
        double d3 = this.getDouble(string);
        if (d == d2) {
            Object object = this.properties.remove(string);
            if (object != null) {
                this.dirty = true;
            }
        } else {
            this.properties.put(string, Double.toString(d));
        }
        if (d3 != d) {
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Double(d3), new Double(d));
        }
    }

    public double getDefaultDouble(String string) {
        return this.convertToDouble(this.defaultProperties.getProperty(string), 0.0);
    }

    public void setDefault(String string, double d) {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException();
        }
        this.defaultProperties.put(string, Double.toString(d));
    }

    private double convertToDouble(String string, double d) {
        double d2 = d;
        if (string != null) {
            try {
                d2 = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return d2;
    }

    public float getFloat(String string) {
        return this.convertToFloat(this.properties.getProperty(string), 0.0f);
    }

    public void setValue(String string, float f) {
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException();
        }
        float f2 = this.getDefaultFloat(string);
        float f3 = this.getFloat(string);
        if (f == f2) {
            Object object = this.properties.remove(string);
            if (object != null) {
                this.dirty = true;
            }
        } else {
            this.properties.put(string, Float.toString(f));
        }
        if (f3 != f) {
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Float(f3), new Float(f));
        }
    }

    public float getDefaultFloat(String string) {
        return this.convertToFloat(this.defaultProperties.getProperty(string), 0.0f);
    }

    public void setDefault(String string, float f) {
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException();
        }
        this.defaultProperties.put(string, Float.toString(f));
    }

    private float convertToFloat(String string, float f) {
        float f2 = f;
        if (string != null) {
            try {
                f2 = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return f2;
    }

    public int getInt(String string) {
        return this.convertToInt(this.properties.getProperty(string), 0);
    }

    public void setValue(String string, int n) {
        int n2 = this.getDefaultInt(string);
        int n3 = this.getInt(string);
        if (n == n2) {
            Object object = this.properties.remove(string);
            if (object != null) {
                this.dirty = true;
            }
        } else {
            this.properties.put(string, Integer.toString(n));
        }
        if (n3 != n) {
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Integer(n3), new Integer(n));
        }
    }

    public int getDefaultInt(String string) {
        return this.convertToInt(this.defaultProperties.getProperty(string), 0);
    }

    public void setDefault(String string, int n) {
        this.defaultProperties.put(string, Integer.toString(n));
    }

    private int convertToInt(String string, int n) {
        int n2 = n;
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n2;
    }

    public long getLong(String string) {
        return this.convertToLong(this.properties.getProperty(string), 0L);
    }

    public void setValue(String string, long l) {
        long l2 = this.getDefaultLong(string);
        long l3 = this.getLong(string);
        if (l == l2) {
            Object object = this.properties.remove(string);
            if (object != null) {
                this.dirty = true;
            }
        } else {
            this.properties.put(string, Long.toString(l));
        }
        if (l3 != l) {
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Long(l3), new Long(l));
        }
    }

    public long getDefaultLong(String string) {
        return this.convertToLong(this.defaultProperties.getProperty(string), 0L);
    }

    public void setDefault(String string, long l) {
        this.defaultProperties.put(string, Long.toString(l));
    }

    private long convertToLong(String string, long l) {
        long l2 = l;
        if (string != null) {
            try {
                l2 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return l2;
    }

    public String getString(String string) {
        String string2 = this.properties.getProperty(string);
        return string2 != null ? string2 : STRING_DEFAULT_DEFAULT;
    }

    public void setValue(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        String string3 = this.getDefaultString(string);
        String string4 = this.getString(string);
        if (string2.equals(string3)) {
            Object object = this.properties.remove(string);
            if (object != null) {
                this.dirty = true;
            }
        } else {
            this.properties.put(string, string2);
        }
        if (!string4.equals(string2)) {
            this.dirty = true;
            this.firePropertyChangeEvent(string, string4, string2);
        }
    }

    public String getDefaultString(String string) {
        String string2 = this.defaultProperties.getProperty(string);
        return string2 != null ? string2 : STRING_DEFAULT_DEFAULT;
    }

    public void setDefault(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        this.defaultProperties.put(string, string2);
    }

    public boolean isDefault(String string) {
        return !this.properties.containsKey(string);
    }

    public void setToDefault(String string) {
        Object object = this.properties.remove(string);
        if (object != null) {
            this.dirty = true;
        }
        String string2 = this.defaultProperties.getProperty(string, null);
        this.firePropertyChangeEvent(string, object, string2);
    }

    public String[] propertyNames() {
        return this.properties.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public String[] defaultPropertyNames() {
        return this.defaultProperties.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public boolean needsSaving() {
        return this.dirty;
    }

    public void store(OutputStream outputStream, String string) throws IOException {
        this.properties.store(outputStream, string);
        this.dirty = false;
    }

    public void load(InputStream inputStream) throws IOException {
        this.properties.load(inputStream);
        this.dirty = false;
    }

    public static interface IPropertyChangeListener
    extends EventListener {
        public void propertyChange(PropertyChangeEvent var1);
    }

    public static class PropertyChangeEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;
        private String propertyName;
        private Object oldValue;
        private Object newValue;

        protected PropertyChangeEvent(Object object, String string, Object object2, Object object3) {
            super(object);
            if (string == null) {
                throw new IllegalArgumentException();
            }
            this.propertyName = string;
            this.oldValue = object2;
            this.newValue = object3;
        }

        public String getProperty() {
            return this.propertyName;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        public Object getOldValue() {
            return this.oldValue;
        }
    }
}

