/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobMessages;
import org.eclipse.core.internal.jobs.WorkerPool;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class Worker
extends Thread {
    private static int nextWorkerNumber = 0;
    private volatile InternalJob currentJob;
    private final WorkerPool pool;

    public Worker(WorkerPool workerPool) {
        super("Worker-" + nextWorkerNumber++);
        this.pool = workerPool;
        this.setContextClassLoader(workerPool.defaultContextLoader);
    }

    public Job currentJob() {
        return (Job)this.currentJob;
    }

    private IStatus handleException(InternalJob internalJob, Throwable throwable) {
        String string = NLS.bind((String)JobMessages.jobs_internalError, (Object)internalJob.getName());
        return new Status(4, "org.eclipse.core.jobs", 2, string, throwable);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.setPriority(5);
        try {
            try {
                while ((this.currentJob = this.pool.startJob(this)) != null) {
                    Object var3_7;
                    this.currentJob.setThread(this);
                    IStatus iStatus = Status.OK_STATUS;
                    try {
                        try {
                            iStatus = this.currentJob.run(this.currentJob.getProgressMonitor());
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            iStatus = Status.CANCEL_STATUS;
                        }
                        catch (Exception exception) {
                            iStatus = this.handleException(this.currentJob, exception);
                        }
                        catch (ThreadDeath threadDeath) {
                            iStatus = this.handleException(this.currentJob, threadDeath);
                            throw threadDeath;
                        }
                        catch (Error error) {
                            iStatus = this.handleException(this.currentJob, error);
                        }
                    }
                    catch (Throwable throwable) {
                        var3_7 = null;
                        Thread.interrupted();
                        if (iStatus == null) {
                            iStatus = this.handleException(this.currentJob, new NullPointerException());
                        }
                        this.pool.endJob(this.currentJob, iStatus);
                        if ((iStatus.getSeverity() & 6) != 0) {
                            RuntimeLog.log((IStatus)iStatus);
                        }
                        this.currentJob = null;
                        this.setPriority(5);
                        throw throwable;
                    }
                    {
                        var3_7 = null;
                    }
                    Thread.interrupted();
                    if (iStatus == null) {
                        iStatus = this.handleException(this.currentJob, new NullPointerException());
                    }
                    this.pool.endJob(this.currentJob, iStatus);
                    if ((iStatus.getSeverity() & 6) != 0) {
                        RuntimeLog.log((IStatus)iStatus);
                    }
                    this.currentJob = null;
                    this.setPriority(5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            this.currentJob = null;
            this.pool.endWorker(this);
            throw throwable;
        }
        {
            Object var5_11 = null;
            this.currentJob = null;
            this.pool.endWorker(this);
            return;
        }
    }
}

