/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.TaskTip;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.ercp.update.UIImage;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.ercp.update.views.ScrolledText;
import org.eclipse.ercp.update.views.UpdateMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.InstallRegistry;
import org.eclipse.update.util.CategoryWrap;
import org.eclipse.update.util.FeatureWrap;
import org.eclipse.update.util.INode;
import org.eclipse.update.util.SiteWrap;
import org.osgi.framework.Bundle;

public class SelectFeaturesScreen
extends AbsScreen
implements TreeListener {
    private Tree featureList;
    private ScrolledText description;
    private Label requiredSpace;
    private Label freeSpace;
    private Command readDescription;
    private int checkedCount;
    private Vector taggedFeatures = new Vector();
    private UpdateMonitor downloadFeatureJarMonitor;
    private DownloadFeatureJarThread downloadFeatureJarThread;
    private boolean enableEnvFilter = true;
    private Image IMAGE_ICON_SITE = null;
    private Image IMAGE_ICON_CATEGORY = null;
    private Image IMAGE_ICON_FEATURE = null;
    private Image IMAGE_ICON_INCOMPATIBLE_FEATURE = null;
    private Image IMAGE_ICON_BROKEN_FEATURE = null;
    private Bundle[] runtime_bundles = null;

    public SelectFeaturesScreen(NormalView normalView) {
        super(normalView);
    }

    protected void createScreen() {
        this.init(UIMessages.SelectFeaturesToInstall);
        this.IMAGE_ICON_SITE = UIImage.createImage(UIImage.ICON_SITE);
        this.IMAGE_ICON_CATEGORY = UIImage.createImage(UIImage.ICON_CATEGORY);
        this.IMAGE_ICON_FEATURE = UIImage.createImage(UIImage.ICON_FEATURE);
        this.IMAGE_ICON_INCOMPATIBLE_FEATURE = UIImage.createImage(UIImage.ICON_INCOMPATIBLE_FEATURE);
        this.IMAGE_ICON_BROKEN_FEATURE = UIImage.createImage(UIImage.ICON_BROKEN_FEATURE);
        Composite composite = new Composite(this.screen, 0);
        composite.setLayout((Layout)new FormLayout());
        composite.setLayoutData((Object)new GridData(1808));
        FormData formData = new FormData();
        FormData formData2 = new FormData();
        if (this.view.parent.getClientArea().height * 2 < this.view.parent.getClientArea().width) {
            formData.top = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(100, 0);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(70, -2);
            formData2.top = new FormAttachment(0, 0);
            formData2.bottom = new FormAttachment(100, 0);
            formData2.left = new FormAttachment(70, 2);
            formData2.right = new FormAttachment(100, 0);
        } else {
            formData.top = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(70, -2);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData2.top = new FormAttachment(70, 2);
            formData2.bottom = new FormAttachment(100, 0);
            formData2.left = new FormAttachment(0, 0);
            formData2.right = new FormAttachment(100, 0);
        }
        this.featureList = new Tree(composite, 32);
        this.featureList.addSelectionListener((SelectionListener)this);
        this.featureList.addTreeListener((TreeListener)this);
        this.featureList.setLayoutData((Object)formData);
        this.description = new ScrolledText(composite, 0, 0, -1);
        this.description.setLayoutData(formData2);
        Composite composite2 = new Composite(this.screen, 0);
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setLayout((Layout)new FillLayout(256));
        this.requiredSpace = new Label(composite2, 0);
        this.freeSpace = new Label(composite2, 0);
        composite2.layout();
        this.setButtons(1, 2, 3);
        if (4097 == this.view.inputType) {
            this.readDescription = new Command((Control)this.screen, 1, 10);
            this.readDescription.setText(UIMessages.ReadDescription);
            this.readDescription.setLongLabel(UIMessages.ReadDescription);
            this.readDescription.addSelectionListener((SelectionListener)this);
        }
        if (3 == this.view.osType) {
            this.description.text.setFont(this.view.fontOnS60);
            this.requiredSpace.setFont(this.view.fontOnS60);
            this.freeSpace.setFont(this.view.fontOnS60);
        }
        this.screen.layout();
        if (Boolean.valueOf(System.getProperty("org.eclipse.ercp.update.disableEnvFilter")).booleanValue()) {
            this.enableEnvFilter = false;
        }
    }

    protected void refresh() {
        this.checkedCount = 0;
        this.featureList.removeAll();
        this.backButton.setEnabled(true);
        this.nextButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.description.setText("");
        int n = 0;
        while (n < this.view.viewedTree.size()) {
            SiteWrap siteWrap = (SiteWrap)this.view.viewedTree.elementAt(n);
            CategoryWrap[] categoryWrapArray = siteWrap.getChildren();
            if (categoryWrapArray.length != 0) {
                TreeItem treeItem = new TreeItem(this.featureList, 0);
                if (3 == this.view.osType) {
                    treeItem.setFont(this.view.fontOnS60);
                }
                treeItem.setText(siteWrap.getName());
                treeItem.setImage(this.IMAGE_ICON_SITE);
                siteWrap.setUiObject(treeItem);
                int n2 = 0;
                while (n2 < categoryWrapArray.length) {
                    CategoryWrap categoryWrap = categoryWrapArray[n2];
                    TreeItem treeItem2 = new TreeItem((TreeItem)siteWrap.getUiObject(), 0);
                    if (3 == this.view.osType) {
                        treeItem2.setFont(this.view.fontOnS60);
                    }
                    treeItem2.setText(categoryWrap.getLabel());
                    treeItem2.setImage(this.IMAGE_ICON_CATEGORY);
                    categoryWrap.setUiObject(treeItem2);
                    FeatureWrap[] featureWrapArray = categoryWrap.getChildren();
                    int n3 = 0;
                    while (n3 < featureWrapArray.length) {
                        FeatureWrap featureWrap = featureWrapArray[n3];
                        TreeItem treeItem3 = new TreeItem((TreeItem)categoryWrap.getUiObject(), 0);
                        if (3 == this.view.osType) {
                            treeItem3.setFont(this.view.fontOnS60);
                        }
                        treeItem3.setText(featureWrap.getShowedName());
                        treeItem3.setImage(this.IMAGE_ICON_FEATURE);
                        featureWrap.addUiObject(treeItem3);
                        ++n3;
                    }
                    ++n2;
                }
                if (categoryWrapArray.length == 0) {
                    treeItem.setGrayed(true);
                }
            }
            ++n;
        }
        this.updateSpaceIndicators();
        if (9 == this.view.runtimeType) {
            this.runtime_bundles = AppPlugin.getDefault().getBundle().getBundleContext().getBundles();
        }
    }

    protected void action() {
        this.setDefaultFocus();
        this.screen.pack();
    }

    protected void setDefaultFocus() {
        this.featureList.setFocus();
    }

    private boolean updateSpaceIndicators() {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = new Object[2];
        long l = 0L;
        this.checkedCount = 0;
        this.nextButton.setEnabled(false);
        int n = 0;
        while (n < this.view.availableFeatures.size()) {
            FeatureWrap featureWrap = (FeatureWrap)this.view.availableFeatures.elementAt(n);
            if (featureWrap.isSelected()) {
                ++this.checkedCount;
                l += featureWrap.getFeatureSize();
                this.nextButton.setEnabled(true);
            }
            ++n;
        }
        if (l > 1024L) {
            objectArray[0] = new Long(l >> 10).toString();
            objectArray[1] = UIMessages.MegaBytes;
            this.requiredSpace.setText(NLS.bind((String)UIMessages.RequiredSpace, (Object[])objectArray));
        } else {
            objectArray[0] = new Long(l).toString();
            objectArray[1] = UIMessages.KiloBytes;
            this.requiredSpace.setText(NLS.bind((String)UIMessages.RequiredSpace, (Object[])objectArray));
        }
        if ((3 == this.view.osType || 9 == this.view.runtimeType) && l > 10240L) {
            MessageBox messageBox = new MessageBox(this.screen.getShell(), 40);
            messageBox.setMessage(UIMessages.ExceedLimitedSize);
            if (messageBox.open() == 32) {
                return false;
            }
        }
        long l2 = -1L;
        try {
            l2 = Long.valueOf(System.getProperty("wed.eUpdate.availableSpace")) >> 10;
            if (l2 <= l) {
                this.nextButton.setEnabled(false);
            }
            if (l2 > 1024L) {
                objectArray2[0] = new Long(l2 >> 10).toString();
                objectArray2[1] = UIMessages.MegaBytes;
                this.freeSpace.setText(NLS.bind((String)UIMessages.FreeSpace, (Object[])objectArray2));
            } else {
                objectArray2[0] = new Long(l2).toString();
                objectArray2[1] = UIMessages.KiloBytes;
                this.freeSpace.setText(NLS.bind((String)UIMessages.FreeSpace, (Object[])objectArray2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.freeSpace.setText("");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.featureList) {
            if (this.downloadFeatureJarThread != null && this.downloadFeatureJarThread.getStatus() == 1) {
                return;
            }
            TreeItem treeItem = (TreeItem)selectionEvent.item;
            if (treeItem == null) {
                this.description.setText("");
                return;
            }
            INode iNode = null;
            int n = 0;
            while (n < this.view.viewedTree.size()) {
                iNode = ((INode)this.view.viewedTree.elementAt(n)).findByUiObject(treeItem);
                if (iNode != null) break;
                ++n;
            }
            if (selectionEvent.detail == 32) {
                this.taggedFeatures.removeAllElements();
                if (treeItem.getChecked()) {
                    this.rememberCurrentChecks();
                }
                if (iNode instanceof SiteWrap) {
                    this.checkSiteNode((SiteWrap)iNode, treeItem.getChecked());
                } else if (iNode instanceof CategoryWrap) {
                    this.checkCategoryNode((CategoryWrap)iNode, treeItem.getChecked());
                } else if (iNode instanceof FeatureWrap) {
                    if (treeItem.getGrayed()) {
                        this.description.setText(UIMessages.FeatureIsIncompatible);
                        this.description.setSelection(0, 0);
                        treeItem.setChecked(false);
                        return;
                    }
                    this.checkFeatureNode((FeatureWrap)iNode, treeItem.getChecked());
                }
                this.downloadNeededFeatureInfo();
            } else {
                this.description.setText(iNode.getDescription());
                this.screen.layout();
                this.description.setSelection(0, 0);
            }
            return;
        }
        if (selectionEvent.widget == this.backButton.widget) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(1, false);
        } else if (selectionEvent.widget == this.cancelButton.widget) {
            if (this.downloadFeatureJarMonitor != null) {
                this.downloadFeatureJarMonitor.setCanceled(true);
            }
        } else if (selectionEvent.widget == this.nextButton.widget) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(3, true);
        } else if (selectionEvent.widget == this.readDescription) {
            this.description.setFocus();
            this.description.setSelection(0, 0);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.featureList) {
            this.widgetSelected(selectionEvent);
        }
    }

    private boolean isIncompatibleFeature(FeatureWrap featureWrap) {
        if (this.enableEnvFilter) {
            IFeature iFeature = featureWrap.getFeature();
            if (iFeature.getOS() != null && this.isNotInSupportedList(iFeature.getOS(), Platform.getOS())) {
                return true;
            }
            if (iFeature.getWS() != null && this.isNotInSupportedList(iFeature.getWS(), Platform.getWS())) {
                return true;
            }
            if (iFeature.getOSArch() != null && this.isNotInSupportedList(iFeature.getOSArch(), Platform.getOSArch())) {
                return true;
            }
            if (iFeature.getNL() != null && this.isNotInSupportedLanguageList(iFeature.getNL(), Platform.getNL())) {
                return true;
            }
            if (9 == this.view.runtimeType && this.isThereDuplicatePlugins(featureWrap)) {
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isNotInSupportedList(String var1_1, String var2_2) {
        var3_3 = new StringTokenizer(var1_1.trim(), ",");
        if (var3_3.countTokens() != 0) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (!var2_2.equalsIgnoreCase(var3_3.nextToken().trim())) continue;
            return false;
lbl6:
            // 2 sources

            ** while (var3_3.hasMoreTokens())
        }
lbl7:
        // 1 sources

        return true;
    }

    private boolean isThereDuplicatePlugins(FeatureWrap featureWrap) {
        if (featureWrap.getFeatureUniquenessStatus() == 17) {
            IPluginEntry[] iPluginEntryArray = featureWrap.getFeature().getPluginEntries();
            int n = 0;
            while (n < iPluginEntryArray.length) {
                int n2 = 80;
                while (n2 < this.runtime_bundles.length) {
                    if (this.runtime_bundles[n2].getSymbolicName() != null && this.runtime_bundles[n2].getSymbolicName().startsWith(iPluginEntryArray[n].getVersionedIdentifier().getIdentifier()) && InstallRegistry.getInstance().get((Object)("plugin_" + iPluginEntryArray[n].getVersionedIdentifier())) == null) {
                        return true;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isNotInSupportedLanguageList(String var1_1, String var2_2) {
        var3_3 = new StringTokenizer(var1_1.trim(), ",");
        if (var3_3.countTokens() != 0) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            var4_4 = var3_3.nextToken().trim();
            if (!(var4_4.indexOf(95) > -1 ? var2_2.equals(var4_4) != false : var2_2.startsWith(var4_4) != false)) continue;
            return false;
lbl7:
            // 2 sources

            ** while (var3_3.hasMoreTokens())
        }
lbl8:
        // 1 sources

        return true;
    }

    private void checkSiteNode(SiteWrap siteWrap, boolean bl) {
        TreeItem treeItem = (TreeItem)siteWrap.getUiObject();
        treeItem.setChecked(bl);
        if (bl) {
            treeItem.setExpanded(true);
        }
        siteWrap.setSelected(bl);
        CategoryWrap[] categoryWrapArray = siteWrap.getChildren();
        int n = 0;
        while (n < categoryWrapArray.length) {
            this.checkCategoryNode(categoryWrapArray[n], bl);
            ++n;
        }
    }

    private void checkCategoryNode(CategoryWrap categoryWrap, boolean bl) {
        TreeItem treeItem = (TreeItem)categoryWrap.getUiObject();
        treeItem.setChecked(bl);
        if (bl) {
            treeItem.setExpanded(true);
        }
        categoryWrap.setSelected(bl);
        FeatureWrap[] featureWrapArray = categoryWrap.getChildren();
        int n = 0;
        while (n < featureWrapArray.length) {
            this.checkFeatureNode(featureWrapArray[n], bl);
            ++n;
        }
    }

    private void checkFeatureNode(FeatureWrap featureWrap, boolean bl) {
        if (bl && !featureWrap.isFeatureReady()) {
            this.taggedFeatures.add(featureWrap);
        }
        if (featureWrap.isFeatureReady() && this.isIncompatibleFeature(featureWrap)) {
            featureWrap.setSelected(false);
            return;
        }
        featureWrap.setSelected(bl);
        Vector vector = featureWrap.getUiObjects();
        int n = 0;
        while (n < vector.size()) {
            ((TreeItem)vector.elementAt(n)).setChecked(bl);
            ++n;
        }
    }

    private void finalizeAllCheckeds() {
        int n = 0;
        while (n < this.view.viewedTree.size()) {
            SiteWrap siteWrap = (SiteWrap)this.view.viewedTree.elementAt(n);
            boolean bl = false;
            CategoryWrap[] categoryWrapArray = siteWrap.getChildren();
            int n2 = 0;
            while (n2 < categoryWrapArray.length) {
                boolean bl2 = false;
                FeatureWrap[] featureWrapArray = categoryWrapArray[n2].getChildren();
                int n3 = 0;
                while (n3 < featureWrapArray.length) {
                    if (featureWrapArray[n3].isSelected()) {
                        bl2 = true;
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                categoryWrapArray[n2].setSelected(bl2);
                ((TreeItem)categoryWrapArray[n2].getUiObject()).setChecked(bl2);
                ++n2;
            }
            if (categoryWrapArray.length > 0) {
                siteWrap.setSelected(bl);
                ((TreeItem)siteWrap.getUiObject()).setChecked(bl);
            }
            ++n;
        }
    }

    private boolean isRequiredFeatureInstalled(VersionedIdentifier versionedIdentifier) {
        int n = 0;
        while (n < this.view.installedFeatures.size()) {
            block4: {
                VersionedIdentifier versionedIdentifier2;
                try {
                    versionedIdentifier2 = ((IFeatureReference)this.view.installedFeatures.get(n)).getVersionedIdentifier();
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                    break block4;
                }
                if (versionedIdentifier2.getIdentifier().equals(versionedIdentifier.getIdentifier()) && versionedIdentifier2.getVersion().isGreaterOrEqualTo(versionedIdentifier.getVersion())) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private boolean addRequiredFeatureInto(VersionedIdentifier versionedIdentifier) {
        int n = 0;
        while (n < this.view.availableFeatures.size()) {
            FeatureWrap featureWrap = (FeatureWrap)this.view.availableFeatures.elementAt(n);
            VersionedIdentifier versionedIdentifier2 = featureWrap.getVID();
            if (versionedIdentifier2.getIdentifier().equals(versionedIdentifier.getIdentifier()) && versionedIdentifier2.getVersion().isGreaterOrEqualTo(versionedIdentifier.getVersion())) {
                if (!featureWrap.isSelected()) {
                    if (!this.isIncompatibleFeature(featureWrap)) {
                        featureWrap.setSelected(true);
                        Vector vector = featureWrap.getUiObjects();
                        int n2 = 0;
                        while (n2 < vector.size()) {
                            ((TreeItem)vector.elementAt(n2)).setChecked(true);
                            ((TreeItem)vector.elementAt(n2)).setText(featureWrap.getShowedName());
                            ++n2;
                        }
                    }
                } else {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private void resolveDependency() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.view.availableFeatures.size()) {
            block10: {
                FeatureWrap featureWrap = (FeatureWrap)this.view.availableFeatures.elementAt(n);
                if (featureWrap.isSelected()) {
                    IIncludedFeatureReference[] iIncludedFeatureReferenceArray;
                    try {
                        iIncludedFeatureReferenceArray = featureWrap.getFeature().getIncludedFeatureReferences();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        break block10;
                    }
                    int n2 = 0;
                    while (n2 < iIncludedFeatureReferenceArray.length) {
                        try {
                            if (!this.isRequiredFeatureInstalled(iIncludedFeatureReferenceArray[n2].getVersionedIdentifier()) && !this.addRequiredFeatureInto(iIncludedFeatureReferenceArray[n2].getVersionedIdentifier())) {
                                Vector vector = featureWrap.getUiObjects();
                                int n3 = 0;
                                while (n3 < vector.size()) {
                                    ((TreeItem)vector.elementAt(n3)).setImage(this.IMAGE_ICON_BROKEN_FEATURE);
                                    ++n3;
                                }
                                stringBuffer.append(NLS.bind((String)UIMessages.NestedFeatureUnavailable, (Object[])new String[]{iIncludedFeatureReferenceArray[n2].getName()})).append("\n");
                            }
                        }
                        catch (CoreException coreException) {
                            coreException.printStackTrace();
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        if (stringBuffer.length() > 0) {
            this.description.setText(stringBuffer.toString());
            this.description.setSelection(0, 0);
        }
    }

    private void rememberCurrentChecks() {
        int n = 0;
        while (n < this.view.viewedTree.size()) {
            SiteWrap siteWrap = (SiteWrap)this.view.viewedTree.elementAt(n);
            siteWrap.setPreviousSelected(siteWrap.isSelected());
            CategoryWrap[] categoryWrapArray = siteWrap.getChildren();
            int n2 = 0;
            while (n2 < categoryWrapArray.length) {
                CategoryWrap categoryWrap = categoryWrapArray[n2];
                categoryWrap.setPreviousSelected(categoryWrap.isSelected());
                FeatureWrap[] featureWrapArray = categoryWrap.getChildren();
                int n3 = 0;
                while (n3 < featureWrapArray.length) {
                    FeatureWrap featureWrap = featureWrapArray[n3];
                    featureWrap.setPreviousSelected(featureWrap.isSelected());
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void recoverPreviousChecks() {
        int n = 0;
        while (n < this.view.viewedTree.size()) {
            SiteWrap siteWrap = (SiteWrap)this.view.viewedTree.elementAt(n);
            siteWrap.setSelected(siteWrap.isPreviousSelected());
            ((TreeItem)siteWrap.getUiObject()).setChecked(siteWrap.isPreviousSelected());
            CategoryWrap[] categoryWrapArray = siteWrap.getChildren();
            int n2 = 0;
            while (n2 < categoryWrapArray.length) {
                CategoryWrap categoryWrap = categoryWrapArray[n2];
                categoryWrap.setSelected(categoryWrap.isPreviousSelected());
                ((TreeItem)categoryWrap.getUiObject()).setChecked(categoryWrap.isPreviousSelected());
                ((TreeItem)categoryWrap.getUiObject()).setExpanded(false);
                FeatureWrap[] featureWrapArray = categoryWrap.getChildren();
                int n3 = 0;
                while (n3 < featureWrapArray.length) {
                    FeatureWrap featureWrap = featureWrapArray[n3];
                    featureWrap.setSelected(featureWrap.isPreviousSelected());
                    Vector vector = featureWrap.getUiObjects();
                    int n4 = 0;
                    while (n4 < vector.size()) {
                        ((TreeItem)vector.elementAt(n4)).setChecked(featureWrap.isPreviousSelected());
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void downloadNeededFeatureInfo() {
        final boolean bl = this.nextButton.getEnabled();
        if (this.taggedFeatures.size() < 1) {
            this.resolveDependency();
            this.finalizeAllCheckeds();
            if (!this.updateSpaceIndicators()) {
                this.recoverPreviousChecks();
                this.nextButton.setEnabled(bl);
                this.updateSpaceIndicators();
            }
            return;
        }
        this.featureList.setEnabled(false);
        this.backButton.setEnabled(false);
        this.cancelButton.setEnabled(true);
        this.nextButton.setEnabled(false);
        final TaskTip taskTip = new TaskTip(this.screen.getShell(), 2);
        taskTip.setText(UIMessages.DownloadFeatureInfo);
        taskTip.setVisible(true);
        if (this.view.inputType != 4097) {
            this.cancelButton.setFocus();
        } else {
            this.screen.setFocus();
        }
        this.downloadFeatureJarMonitor = new UpdateMonitor();
        this.downloadFeatureJarThread = new DownloadFeatureJarThread("", this.taggedFeatures, this.downloadFeatureJarMonitor);
        this.downloadFeatureJarThread.start();
        Display.getCurrent().timerExec(400, new Runnable(){

            public void run() {
                if (SelectFeaturesScreen.this.downloadFeatureJarThread.isAlive()) {
                    Display.getCurrent().timerExec(400, (Runnable)this);
                } else {
                    taskTip.setVisible(false);
                    taskTip.dispose();
                    if (SelectFeaturesScreen.this.downloadFeatureJarThread.getStatus() == 2) {
                        SelectFeaturesScreen.this.resolveDependency();
                        SelectFeaturesScreen.this.finalizeAllCheckeds();
                        if (!SelectFeaturesScreen.this.updateSpaceIndicators()) {
                            SelectFeaturesScreen.this.recoverPreviousChecks();
                            SelectFeaturesScreen.this.nextButton.setEnabled(bl);
                            SelectFeaturesScreen.this.updateSpaceIndicators();
                        }
                    } else {
                        SelectFeaturesScreen.this.recoverPreviousChecks();
                        SelectFeaturesScreen.this.nextButton.setEnabled(bl);
                    }
                    SelectFeaturesScreen.this.featureList.setEnabled(true);
                    SelectFeaturesScreen.this.backButton.setEnabled(true);
                    SelectFeaturesScreen.this.cancelButton.setEnabled(false);
                    SelectFeaturesScreen.this.downloadFeatureJarThread = null;
                    SelectFeaturesScreen.this.downloadFeatureJarMonitor = null;
                    boolean bl3 = false;
                    int n = 0;
                    while (n < SelectFeaturesScreen.this.taggedFeatures.size()) {
                        TreeItem treeItem;
                        int n2;
                        Vector vector;
                        FeatureWrap featureWrap = (FeatureWrap)SelectFeaturesScreen.this.taggedFeatures.elementAt(n);
                        if (featureWrap.isFeatureReady()) {
                            boolean bl2 = true;
                            if (SelectFeaturesScreen.this.isIncompatibleFeature(featureWrap)) {
                                bl2 = false;
                                featureWrap.setSelected(false);
                            }
                            vector = featureWrap.getUiObjects();
                            n2 = 0;
                            while (n2 < vector.size()) {
                                treeItem = (TreeItem)vector.elementAt(n2);
                                treeItem.setText(featureWrap.getShowedName());
                                if (!bl2) {
                                    treeItem.setChecked(false);
                                    treeItem.setGrayed(true);
                                    treeItem.setImage(SelectFeaturesScreen.this.IMAGE_ICON_INCOMPATIBLE_FEATURE);
                                    bl3 = true;
                                }
                                ++n2;
                            }
                        } else {
                            vector = featureWrap.getUiObjects();
                            n2 = 0;
                            while (n2 < vector.size()) {
                                treeItem = (TreeItem)vector.elementAt(n2);
                                treeItem.setChecked(false);
                                treeItem.setGrayed(true);
                                treeItem.setImage(SelectFeaturesScreen.this.IMAGE_ICON_BROKEN_FEATURE);
                                bl3 = true;
                                ++n2;
                            }
                        }
                        ++n;
                    }
                    if (bl3) {
                        SelectFeaturesScreen.this.finalizeAllCheckeds();
                        SelectFeaturesScreen.this.updateSpaceIndicators();
                    }
                    SelectFeaturesScreen.this.featureList.setFocus();
                }
            }
        });
    }

    public void treeCollapsed(TreeEvent treeEvent) {
    }

    public void treeExpanded(TreeEvent treeEvent) {
        final TreeItem treeItem = (TreeItem)treeEvent.item;
        if (treeItem == null) {
            return;
        }
        INode iNode = null;
        int n = 0;
        while (n < this.view.viewedTree.size()) {
            iNode = ((INode)this.view.viewedTree.elementAt(n)).findByUiObject(treeItem);
            if (iNode != null) break;
            ++n;
        }
        if (iNode instanceof CategoryWrap) {
            this.taggedFeatures.removeAllElements();
            FeatureWrap[] featureWrapArray = ((CategoryWrap)iNode).getChildren();
            final boolean bl = false;
            while (bl < featureWrapArray.length) {
                if (!featureWrapArray[bl].isFeatureReady()) {
                    this.taggedFeatures.add(featureWrapArray[bl]);
                }
                bl += 1;
            }
            if (this.taggedFeatures.size() < 1) {
                return;
            }
            if ("win32".equals(Platform.getOS()) && "x86".equals(Platform.getOSArch())) {
                this.featureList.setEnabled(false);
            } else {
                this.featureList.setVisible(false);
            }
            this.backButton.setEnabled(false);
            this.cancelButton.setEnabled(true);
            bl = this.nextButton.getEnabled();
            this.nextButton.setEnabled(false);
            final TaskTip taskTip = new TaskTip(this.screen.getShell(), 2);
            taskTip.setText(UIMessages.DownloadFeatureInfo);
            taskTip.setVisible(true);
            if (this.view.inputType != 4097) {
                this.cancelButton.setFocus();
            } else {
                this.screen.setFocus();
            }
            this.downloadFeatureJarMonitor = new UpdateMonitor();
            this.downloadFeatureJarThread = new DownloadFeatureJarThread("", this.taggedFeatures, this.downloadFeatureJarMonitor);
            this.downloadFeatureJarThread.start();
            Display.getCurrent().timerExec(400, new Runnable(){

                public void run() {
                    if (SelectFeaturesScreen.this.downloadFeatureJarThread.isAlive()) {
                        Display.getCurrent().timerExec(400, (Runnable)this);
                    } else {
                        taskTip.setVisible(false);
                        taskTip.dispose();
                        if (SelectFeaturesScreen.this.downloadFeatureJarThread.getStatus() != 2) {
                            treeItem.setExpanded(false);
                        }
                        if ("win32".equals(Platform.getOS()) && "x86".equals(Platform.getOSArch())) {
                            SelectFeaturesScreen.this.featureList.setEnabled(true);
                        } else {
                            SelectFeaturesScreen.this.featureList.setVisible(true);
                        }
                        SelectFeaturesScreen.this.backButton.setEnabled(true);
                        SelectFeaturesScreen.this.cancelButton.setEnabled(false);
                        SelectFeaturesScreen.this.nextButton.setEnabled(bl);
                        SelectFeaturesScreen.this.downloadFeatureJarThread = null;
                        SelectFeaturesScreen.this.downloadFeatureJarMonitor = null;
                        boolean bl2 = true;
                        int n = 0;
                        while (n < SelectFeaturesScreen.this.taggedFeatures.size()) {
                            FeatureWrap featureWrap = (FeatureWrap)SelectFeaturesScreen.this.taggedFeatures.elementAt(n);
                            if (featureWrap.isFeatureReady()) {
                                bl2 = true;
                                if (SelectFeaturesScreen.this.isIncompatibleFeature(featureWrap)) {
                                    bl2 = false;
                                    featureWrap.setSelected(false);
                                }
                                Vector vector = featureWrap.getUiObjects();
                                int n2 = 0;
                                while (n2 < vector.size()) {
                                    TreeItem treeItem2 = (TreeItem)vector.elementAt(n2);
                                    treeItem2.setText(featureWrap.getShowedName());
                                    if (!bl2) {
                                        treeItem2.setGrayed(true);
                                        treeItem2.setImage(SelectFeaturesScreen.this.IMAGE_ICON_INCOMPATIBLE_FEATURE);
                                        treeItem2.setChecked(false);
                                    }
                                    ++n2;
                                }
                            }
                            ++n;
                        }
                        SelectFeaturesScreen.this.featureList.setFocus();
                    }
                }
            });
        }
    }

    private class DownloadFeatureJarThread
    extends Thread {
        public static final int NONE = 0;
        public static final int RUNNING = 1;
        public static final int SUCCESS = 2;
        public static final int ENDED = 3;
        private Vector tags;
        private IProgressMonitor monitor;
        private int currentStatus;

        public DownloadFeatureJarThread(String string, Vector vector, IProgressMonitor iProgressMonitor) {
            super(string);
            this.tags = vector;
            this.monitor = iProgressMonitor;
            this.currentStatus = 0;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 119->123)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public int getStatus() {
            return this.currentStatus;
        }
    }
}

