/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.ManageScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.ercp.update.views.UpdateMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.DuplicateConflictsValidator;
import org.eclipse.update.internal.operations.IUnconfigureAndUninstallFeatureOperation;
import org.eclipse.update.internal.operations.OperationFactory;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IBatchOperation;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.IUpdateSearchResultCollector;
import org.eclipse.update.search.UpdateSearchRequest;

public class UpdatingScreen
extends AbsScreen {
    private static final int PROGRESS_UNIT = 10;
    private Composite pane;
    private Label updatingLabel;
    private Label updatingItem;
    private ProgressBar updateProgress;
    private Command cancelCommand;
    private UpdateSearchRequest searchRequest;
    private UpdateMonitor updateFeatureMonitor;
    private UpdateFeaturesThread updateFeaturesThread;
    private int totalSearchedFeaturesCount = 0;
    private boolean isSingleThread = true;
    private boolean isExisted = false;

    UpdatingScreen(NormalView normalView) {
        super(normalView);
    }

    protected void createScreen() {
        this.init(UIMessages.UpdateAllFeatures);
        this.pane = new Composite(this.screen, 0);
        this.pane.setLayoutData((Object)new GridData(768));
        this.pane.setLayout((Layout)new RowLayout(256));
        this.updatingLabel = new Label(this.pane, 0);
        this.updatingLabel.setText(UIMessages.Updating);
        this.updatingItem = new Label(this.pane, 0);
        this.updateProgress = new ProgressBar(this.screen, 65536);
        this.updateProgress.setLayoutData((Object)new GridData(768));
        this.fillSpace();
        if (65 == this.view.wmType) {
            this.cancelCommand = new Command((Control)this.screen, 1, 10);
            this.cancelCommand.setText(UIMessages.Cancel);
            this.cancelCommand.setLongLabel(UIMessages.Cancel);
            this.cancelCommand.addSelectionListener((SelectionListener)this);
        }
        this.setButtons(0, 2, 0);
        if (3 == this.view.osType) {
            this.updatingLabel.setFont(this.view.fontOnS60);
            this.updatingItem.setFont(this.view.fontOnS60);
        }
        this.screen.layout();
    }

    protected void refresh() {
        if (65 == this.view.wmType) {
            this.cancelCommand.setEnabled(true);
        }
        this.cancelButton.setEnabled(true);
        this.updatingItem.setText("");
        this.updateProgress.setSelection(0);
        this.pane.layout();
    }

    protected void action() {
        IFeature iFeature;
        if (this.view.availableFeatures.size() == 0) {
            this.isSingleThread = false;
            iFeature = new IFeature[this.view.installedFeatures.size()];
            int n = 0;
            while (n < this.view.installedFeatures.size()) {
                try {
                    iFeature[n] = ((IFeatureReference)this.view.installedFeatures.get(n)).getFeature(null);
                    if (UpdateCore.DEBUG) {
                        System.out.println("[ eUpdate debug ] Feature being assigned to search: " + iFeature[n].getLabel());
                    }
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
                ++n;
            }
            this.searchRequest = UpdateUtils.createNewUpdatesRequest((IFeature[])iFeature);
        } else {
            this.isSingleThread = true;
            iFeature = (IFeature)this.view.availableFeatures.elementAt(0);
            if (UpdateCore.DEBUG) {
                System.out.println("[ eUpdate debug ] Feature being assigned to search: " + iFeature.getLabel());
            }
            this.searchRequest = UpdateUtils.createNewUpdatesRequest((IFeature[])new IFeature[]{iFeature});
        }
        this.totalSearchedFeaturesCount = this.searchRequest.getCategory().getQueries().length;
        if (this.totalSearchedFeaturesCount == 0) {
            iFeature = new MessageBox(this.screen.getShell(), 34);
            iFeature.setText(UIMessages.UpdateStatus);
            iFeature.setMessage(UIMessages.NoUpdateAvailable);
            iFeature.open();
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(0, true);
            return;
        }
        this.updateFeatureMonitor = new UpdateMonitor();
        iFeature = OperationsManager.getValidator().validatePlatformConfigValid();
        if (iFeature != null) {
            System.out.println(iFeature.getMessage());
            return;
        }
        this.updateProgress.setMaximum((this.totalSearchedFeaturesCount + 1) * 10);
        this.updateFeaturesThread = new UpdateFeaturesThread("", this.searchRequest, this.view.installedFeatures, this.updateFeatureMonitor);
        this.updateFeaturesThread.start();
        this.setDefaultFocus();
        Display.getCurrent().timerExec(1000, new Runnable(){

            public void run() {
                if (UpdatingScreen.this.updateFeaturesThread.getStatus() == 0 && UpdatingScreen.this.updateFeaturesThread.isAlive()) {
                    Display.getCurrent().timerExec(400, (Runnable)this);
                    return;
                }
                if (UpdatingScreen.this.updateFeaturesThread.getStatus() == 1) {
                    UpdatingScreen.this.updatingItem.setText(UpdatingScreen.this.updateFeaturesThread.getUpdatingItem());
                    UpdatingScreen.this.pane.layout();
                    UpdatingScreen.this.updateProgress.setSelection((int)((double)UpdatingScreen.this.updateProgress.getMaximum() * (UpdatingScreen.this.updateFeatureMonitor.getDoneWorksCount() / (double)(UpdatingScreen.this.totalSearchedFeaturesCount + 1))));
                    Display.getCurrent().timerExec(400, (Runnable)this);
                } else {
                    if (UpdatingScreen.this.isExisted) {
                        return;
                    }
                    UpdatingScreen.this.isExisted = true;
                    if (UpdatingScreen.this.updateFeaturesThread.getStatus() == 2) {
                        UpdatingScreen.this.updatingItem.setText(NLS.bind((String)UIMessages.FeatureUpdated, (Object[])new Object[]{new Integer(UpdatingScreen.this.updateFeaturesThread.getTotalUpdatedFeaturesCount()).toString()}));
                        UpdatingScreen.this.pane.layout();
                        UpdatingScreen.this.updateProgress.setSelection(UpdatingScreen.this.updateProgress.getMaximum());
                        UpdatingScreen.this.view.enableRestartCommand = true;
                        MessageBox messageBox = new MessageBox(UpdatingScreen.this.screen.getShell(), 194);
                        if (UpdatingScreen.this.updateFeaturesThread.isJvmInUpdateList()) {
                            messageBox.setText(UIMessages.ConfirmRestart);
                            messageBox.setMessage(NLS.bind((String)UIMessages.NeedRestartManually, (Object[])UpdatingScreen.this.view.RuntimeName));
                            if (messageBox.open() == 64 && 9 != UpdatingScreen.this.view.runtimeType) {
                                System.getProperties().put("eworkbench.returnCode", new Integer(0));
                                PlatformUI.getWorkbench().close();
                            }
                        } else {
                            messageBox.setText(UIMessages.ConfirmRestart);
                            messageBox.setMessage(NLS.bind((String)UIMessages.RecommendToRestart, (Object[])UpdatingScreen.this.view.RuntimeName));
                            if (messageBox.open() == 64 && 9 != UpdatingScreen.this.view.runtimeType) {
                                System.getProperties().put("eworkbench.returnCode", new Integer(1));
                                PlatformUI.getWorkbench().close();
                            }
                        }
                    } else if (UpdatingScreen.this.updateFeaturesThread.getStatus() == 3) {
                        MessageBox messageBox = new MessageBox(UpdatingScreen.this.screen.getShell(), 34);
                        messageBox.setText(UIMessages.UpdateStatus);
                        messageBox.setMessage(UIMessages.NoUpdateAvailable);
                        messageBox.open();
                    } else {
                        MessageBox messageBox = new MessageBox(UpdatingScreen.this.screen.getShell(), 33);
                        messageBox.setText(UIMessages.UpdateStatus);
                        if (UpdatingScreen.this.isSingleThread) {
                            messageBox.setMessage(UIMessages.UpdateNotCompleted);
                        } else {
                            messageBox.setMessage(UIMessages.UpdateNotAllCompleted);
                        }
                        messageBox.open();
                    }
                    UpdatingScreen.this.isExisted = false;
                    if (65 == UpdatingScreen.this.view.wmType) {
                        UpdatingScreen.this.cancelCommand.setEnabled(false);
                    }
                    UpdatingScreen.this.cancelButton.setEnabled(false);
                    UpdatingScreen.this.updateFeaturesThread = null;
                    UpdatingScreen.this.setVisible(false);
                    NormalView normalView = UpdatingScreen.this.view;
                    ((Object)((Object)UpdatingScreen.this.view)).getClass();
                    ((Object)((Object)UpdatingScreen.this.view)).getClass();
                    normalView.showScreen(0, true);
                }
            }
        });
    }

    protected void setDefaultFocus() {
        if (this.view.inputType == 4097) {
            this.pane.setFocus();
        } else {
            this.cancelButton.setFocus();
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if ((selectionEvent.widget == this.cancelButton.widget || selectionEvent.widget == this.cancelCommand) && this.updateFeaturesThread != null && this.updateFeaturesThread.getStatus() == 1) {
            this.updateFeatureMonitor.setCanceled(true);
        }
    }

    public static final IInstallConfiguration getConfiguration() {
        IInstallConfiguration iInstallConfiguration = null;
        try {
            ILocalSite iLocalSite = SiteManager.getLocalSite();
            iInstallConfiguration = iLocalSite.getCurrentConfiguration();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return iInstallConfiguration;
    }

    private class UpdateFeaturesThread
    extends Thread {
        public static final int NONE = 0;
        public static final int RUNNING = 1;
        public static final int SUCCESS = 2;
        public static final int NO_UPDATE = 3;
        public static final int ENDED = 4;
        private UpdateSearchRequest request;
        private UpdateMonitor monitor;
        private UpdateSearchResultCollector collector;
        private Vector allFeatures;
        private int currentStatus;
        private int totalSearchedFeaturesCount = 0;
        private int totalUpdatedFeaturesCount = 0;
        private boolean isJvmInList = false;

        public UpdateFeaturesThread(String string, UpdateSearchRequest updateSearchRequest, Vector vector, UpdateMonitor updateMonitor) {
            super(string);
            this.request = updateSearchRequest;
            this.monitor = updateMonitor;
            this.currentStatus = 0;
            this.collector = new UpdateSearchResultCollector();
            this.totalSearchedFeaturesCount = updateSearchRequest.getCategory().getQueries().length;
            this.allFeatures = vector;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            IInstallFeatureOperation[] iInstallFeatureOperationArray;
            block16: {
                this.currentStatus = 1;
                UpdatingScreen.this.updateFeatureMonitor.beginTask(UIMessages.StartUpdating, this.totalSearchedFeaturesCount + 1);
                UpdatingScreen.this.updateFeatureMonitor.setTaskName(UIMessages.SearchingUpdates);
                this.isJvmInList = false;
                try {
                    this.request.performSearch((IUpdateSearchResultCollector)this.collector, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)this.monitor, 1));
                    if (UpdatingScreen.this.updateFeatureMonitor.isCanceled()) {
                        this.currentStatus = 4;
                        return;
                    }
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                    if (UpdatingScreen.this.searchRequest.getCategory().getQueries().length != coreException.getStatus().getChildren().length) break block16;
                    this.currentStatus = 4;
                    return;
                }
            }
            if ((iInstallFeatureOperationArray = this.collector.getOperations()) == null || iInstallFeatureOperationArray.length == 0) {
                this.currentStatus = 3;
                this.monitor.done();
                return;
            }
            this.totalUpdatedFeaturesCount = iInstallFeatureOperationArray.length;
            ArrayList arrayList = DuplicateConflictsValidator.computeDuplicateConflicts((IInstallFeatureOperation[])iInstallFeatureOperationArray, (IInstallConfiguration)UpdatingScreen.getConfiguration());
            if (arrayList != null) {
                this.currentStatus = 4;
                this.monitor.done();
                return;
            }
            int n = 0;
            while (n < iInstallFeatureOperationArray.length) {
                if (iInstallFeatureOperationArray[n].getFeature().getVersionedIdentifier().getIdentifier().startsWith(ManageScreen.JVM_LIB_FEATURE_NAME)) {
                    this.isJvmInList = true;
                    break;
                }
                ++n;
            }
            IBatchOperation iBatchOperation = OperationsManager.getOperationFactory().createBatchInstallOperation(iInstallFeatureOperationArray);
            try {
                try {
                    boolean bl = false;
                    if (!this.monitor.isCanceled()) {
                        bl = iBatchOperation.execute((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)this.monitor, this.monitor.getTotalWorksCount() - 1), null);
                    }
                    if (this.monitor.isCanceled() || !bl) {
                        this.removeOldVersion(iInstallFeatureOperationArray, true);
                        this.currentStatus = 4;
                        Object var5_9 = null;
                        this.monitor.done();
                        return;
                    }
                    this.removeOldVersion(iInstallFeatureOperationArray, false);
                    if (UpdateCore.DEBUG) {
                        System.out.println("Updating is finished successfully.");
                    }
                    this.currentStatus = 2;
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.currentStatus = 4;
                    invocationTargetException.printStackTrace();
                }
                catch (CoreException coreException) {
                    this.currentStatus = 4;
                    coreException.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                this.monitor.done();
                throw throwable;
            }
            {
                Object var5_11 = null;
                this.monitor.done();
                return;
            }
        }

        public String getUpdatingItem() {
            return this.monitor.getTaskName();
        }

        public int getStatus() {
            return this.currentStatus;
        }

        public boolean isJvmInUpdateList() {
            return this.isJvmInList;
        }

        public int getTotalUpdatedFeaturesCount() {
            return this.totalUpdatedFeaturesCount;
        }

        private void removeOldVersion(IInstallFeatureOperation[] iInstallFeatureOperationArray, boolean bl) {
            try {
                boolean bl2 = false;
                OperationFactory operationFactory = (OperationFactory)OperationsManager.getOperationFactory();
                IUnconfigureAndUninstallFeatureOperation iUnconfigureAndUninstallFeatureOperation = null;
                int n = 0;
                while (n < iInstallFeatureOperationArray.length) {
                    try {
                        if (bl) {
                            bl2 = false;
                            int n2 = 0;
                            while (n2 < this.allFeatures.size()) {
                                if (iInstallFeatureOperationArray[n].getFeature().getVersionedIdentifier().getIdentifier().equals(((IFeatureReference)this.allFeatures.get(n2)).getVersionedIdentifier().getIdentifier())) {
                                    bl2 = true;
                                    break;
                                }
                                ++n2;
                            }
                            if (!bl2) {
                                return;
                            }
                        }
                        iUnconfigureAndUninstallFeatureOperation = operationFactory.createUnconfigureAndUninstallFeatureOperation(iInstallFeatureOperationArray[n].getOldFeature().getSite().getCurrentConfiguredSite(), iInstallFeatureOperationArray[n].getOldFeature());
                        iUnconfigureAndUninstallFeatureOperation.execute(null, null);
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                    ++n;
                }
                SiteManager.getLocalSite().save();
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
                return;
            }
        }
    }

    class UpdateSearchResultCollector
    implements IUpdateSearchResultCollector {
        private ArrayList operations = new ArrayList();

        UpdateSearchResultCollector() {
        }

        public void accept(IFeature iFeature) {
            if (UpdateCore.DEBUG) {
                System.out.println("[ eUpdate debug ] searched and got this feature:");
                System.out.println("[ eUpdate debug ] \tLabel   is " + iFeature.getLabel());
                System.out.println("[ eUpdate debug ] \tID      is " + iFeature.getVersionedIdentifier().getIdentifier());
                System.out.println("[ eUpdate debug ] \tVersion is " + iFeature.getVersionedIdentifier().getVersion());
                System.out.println("[ eUpdate debug ] \tURL     is " + iFeature.getURL().toString());
            }
            IInstallFeatureOperation iInstallFeatureOperation = OperationsManager.getOperationFactory().createInstallOperation(null, iFeature, null, null, null);
            IConfiguredSite iConfiguredSite = UpdateUtils.getDefaultTargetSite((IInstallConfiguration)UpdatingScreen.getConfiguration(), (IInstallFeatureOperation)iInstallFeatureOperation);
            if (iConfiguredSite == null) {
                iConfiguredSite = UpdateUtils.getAffinitySite((IInstallConfiguration)UpdatingScreen.getConfiguration(), (IFeature)iFeature);
            }
            if (iConfiguredSite == null) {
                iConfiguredSite = UpdatingScreen.this.view.targetSite;
            }
            iInstallFeatureOperation.setTargetSite(iConfiguredSite);
            this.operations.add(iInstallFeatureOperation);
        }

        public IInstallFeatureOperation[] getOperations() {
            IInstallFeatureOperation[] iInstallFeatureOperationArray = new IInstallFeatureOperation[this.operations.size()];
            this.operations.toArray(iInstallFeatureOperationArray);
            return iInstallFeatureOperationArray;
        }
    }
}

