/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.bundlefile;

import java.io.IOException;
import java.util.Map;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;

public class MRUBundleFileList
implements EventDispatcher {
    private static final String PROP_FILE_LIMIT = "osgi.bundlefile.limit";
    private static final int MIN = 10;
    private static final int PROP_FILE_LIMIT_VALUE;
    private static final ThreadLocal closingBundleFile;
    private final BundleFile[] bundleFileList;
    private final long[] useStampList;
    private final int fileLimit;
    private final EventManager bundleFileCloserManager;
    private final Map bundleFileCloser;
    private int numOpen = 0;
    private long curUseStamp = 0L;
    private boolean firstDispatch = true;

    static {
        closingBundleFile = new ThreadLocal();
        int n = 100;
        try {
            String string = BundleFile.secureAction.getProperty(PROP_FILE_LIMIT);
            if (string != null) {
                n = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        PROP_FILE_LIMIT_VALUE = n;
    }

    public MRUBundleFileList() {
        this(PROP_FILE_LIMIT_VALUE);
    }

    public MRUBundleFileList(int n) {
        this.fileLimit = n;
        if (n >= 10) {
            this.bundleFileList = new BundleFile[n];
            this.useStampList = new long[n];
            this.bundleFileCloserManager = new EventManager("Bundle File Closer");
            this.bundleFileCloser = new CopyOnWriteIdentityMap();
            this.bundleFileCloser.put(this, this);
        } else {
            this.bundleFileList = null;
            this.useStampList = null;
            this.bundleFileCloserManager = null;
            this.bundleFileCloser = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BundleFile bundleFile) {
        if (this.fileLimit < 10) {
            return;
        }
        BundleFile bundleFile2 = null;
        MRUBundleFileList mRUBundleFileList = this;
        synchronized (mRUBundleFileList) {
            if (bundleFile.getMruIndex() >= 0) {
                return;
            }
            int n = 0;
            if (this.numOpen < this.fileLimit) {
                int n2 = 0;
                while (n2 < this.fileLimit) {
                    if (this.bundleFileList[n2] == null) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
            } else {
                n = 0;
                int n3 = 1;
                while (n3 < this.fileLimit) {
                    if (this.useStampList[n3] < this.useStampList[n]) {
                        n = n3;
                    }
                    ++n3;
                }
                bundleFile2 = this.bundleFileList[n];
                if (bundleFile2.getMruIndex() != n) {
                    throw new IllegalStateException("The BundleFile has the incorrect mru index: " + n + " != " + bundleFile2.getMruIndex());
                }
                this.removeInternal(bundleFile2);
            }
            this.bundleFileList[n] = bundleFile;
            bundleFile.setMruIndex(n);
            this.incUseStamp(n);
            ++this.numOpen;
        }
        this.closeBundleFile(bundleFile2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(BundleFile bundleFile) {
        if (this.fileLimit < 10) {
            return false;
        }
        MRUBundleFileList mRUBundleFileList = this;
        synchronized (mRUBundleFileList) {
            block5: {
                int n = bundleFile.getMruIndex();
                if (n < 0 || n >= this.fileLimit || this.bundleFileList[n] != bundleFile) break block5;
                this.removeInternal(bundleFile);
                return true;
            }
        }
        return false;
    }

    private void removeInternal(BundleFile bundleFile) {
        int n = bundleFile.getMruIndex();
        bundleFile.setMruIndex(-1);
        this.bundleFileList[n] = null;
        this.useStampList[n] = -1L;
        --this.numOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void use(BundleFile bundleFile) {
        if (this.fileLimit < 10) {
            return;
        }
        MRUBundleFileList mRUBundleFileList = this;
        synchronized (mRUBundleFileList) {
            int n = bundleFile.getMruIndex();
            if (n >= 0 && n < this.fileLimit && this.bundleFileList[n] == bundleFile) {
                this.incUseStamp(n);
            }
        }
    }

    private void incUseStamp(int n) {
        if (this.curUseStamp == Long.MAX_VALUE) {
            int n2 = 0;
            while (n2 < this.fileLimit) {
                this.useStampList[n2] = 0L;
                ++n2;
            }
            this.curUseStamp = 0L;
        }
        this.useStampList[n] = ++this.curUseStamp;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void dispatchEvent(Object object, Object object2, int n, Object object3) {
        if (this.firstDispatch) {
            Thread.currentThread().setContextClassLoader(null);
            this.firstDispatch = false;
        }
        try {
            try {
                closingBundleFile.set(object3);
                ((BundleFile)object3).close();
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            closingBundleFile.set(null);
            throw throwable;
        }
        {
            Object var5_7 = null;
            closingBundleFile.set(null);
            return;
        }
    }

    private void closeBundleFile(BundleFile bundleFile) {
        if (bundleFile == null) {
            return;
        }
        ListenerQueue listenerQueue = new ListenerQueue(this.bundleFileCloserManager);
        listenerQueue.queueListeners(this.bundleFileCloser.entrySet(), (EventDispatcher)this);
        listenerQueue.dispatchEventAsynchronous(0, bundleFile);
    }

    public void shutdown() {
        if (this.bundleFileCloserManager != null) {
            this.bundleFileCloserManager.close();
        }
    }

    public boolean isClosing(BundleFile bundleFile) {
        if (this.fileLimit < 10) {
            return false;
        }
        return closingBundleFile.get() == bundleFile;
    }

    public boolean isEnabled() {
        return this.fileLimit >= 10;
    }
}

