/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.debug;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.osgi.framework.debug.EclipseDebugTrace;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class FrameworkDebugOptions
implements DebugOptions,
ServiceTrackerCustomizer {
    private static final String OSGI_DEBUG = "osgi.debug";
    public static final String PROP_TRACEFILE = "osgi.tracefile";
    private Properties options = null;
    private static FrameworkDebugOptions singleton = null;
    private static final String OPTIONS = ".options";
    protected static final Map debugTraceCache = new HashMap();
    protected File outFile = null;
    private volatile BundleContext context;
    private volatile ServiceTracker listenerTracker;
    static /* synthetic */ Class class$0;

    private FrameworkDebugOptions() {
        this.loadOptions();
    }

    public void start(BundleContext bundleContext) {
        this.context = bundleContext;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.debug.DebugOptionsListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerTracker = new ServiceTracker(bundleContext, clazz.getName(), (ServiceTrackerCustomizer)this);
        this.listenerTracker.open();
    }

    public void stop(BundleContext bundleContext) {
        this.listenerTracker.close();
        this.listenerTracker = null;
        this.context = null;
    }

    public static FrameworkDebugOptions getDefault() {
        if (singleton == null) {
            singleton = new FrameworkDebugOptions();
        }
        return singleton;
    }

    private static URL buildURL(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        boolean bl2 = string.startsWith("file:");
        try {
            if (bl2) {
                return FrameworkDebugOptions.adjustTrailingSlash(new File(string.substring(5)).toURL(), bl);
            }
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            if (bl2) {
                return null;
            }
            try {
                return FrameworkDebugOptions.adjustTrailingSlash(new File(string).toURL(), bl);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    private static URL adjustTrailingSlash(URL uRL, boolean bl) throws MalformedURLException {
        String string = uRL.getFile();
        if (bl == string.endsWith("/")) {
            return uRL;
        }
        string = bl ? String.valueOf(string) + "/" : string.substring(0, string.length() - 1);
        return new URL(uRL.getProtocol(), uRL.getHost(), string);
    }

    public boolean getBooleanOption(String string, boolean bl) {
        String string2 = this.getOption(string);
        return string2 != null && string2.equalsIgnoreCase("true") || bl;
    }

    public String[] getOptionsForBundle(String string) {
        String[] stringArray;
        List<String> list = null;
        if (this.options != null) {
            list = new ArrayList();
            stringArray = this.options.entrySet().iterator();
            int n = 0;
            String string2 = null;
            while (stringArray.hasNext()) {
                int n2;
                Map.Entry entry = (Map.Entry)stringArray.next();
                string2 = (String)entry.getKey();
                if (!string2.substring(0, n2 = string2.indexOf("/")).equals(string)) continue;
                list.add(String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
                ++n;
            }
        }
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        stringArray = list.toArray(new String[list.size()]);
        return stringArray;
    }

    public String getOption(String string) {
        return this.options != null ? this.options.getProperty(string) : null;
    }

    public String getOption(String string, String string2) {
        return this.options != null ? this.options.getProperty(string, string2) : string2;
    }

    public int getIntegerOption(String string, int n) {
        String string2 = this.getOption(string);
        try {
            return string2 == null ? n : Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    String[] getAllOptions() {
        String[] stringArray = null;
        if (this.options != null) {
            stringArray = new String[this.options.size()];
            Iterator<Map.Entry<Object, Object>> iterator = this.options.entrySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                stringArray[n] = String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue();
                ++n;
            }
        }
        if (stringArray == null) {
            stringArray = new String[1];
        }
        return stringArray;
    }

    public void removeOption(String string) {
        if (string != null) {
            this.options.remove(string);
            int n = string.indexOf("/");
            String string2 = string.substring(0, n);
            this.optionsChanged(string2);
        }
    }

    public void setOption(String string, String string2) {
        if (this.options != null) {
            String string3 = this.options.getProperty(string);
            boolean bl = false;
            if (string3 != null) {
                if (!string3.equals(string2)) {
                    bl = true;
                }
            } else if (string2 != null) {
                bl = true;
            }
            if (bl) {
                this.options.put(string, string2.trim());
                int n = string.indexOf("/");
                String string4 = string.substring(0, n);
                this.optionsChanged(string4);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadOptions() {
        Object object;
        URL uRL;
        Object object2;
        String string = FrameworkProperties.getProperty(OSGI_DEBUG);
        if (string == null) {
            return;
        }
        this.options = new Properties();
        if (string.length() == 0) {
            object2 = FrameworkProperties.getProperty("user.dir").replace(File.separatorChar, '/');
            if (!((String)object2).endsWith("/")) {
                object2 = String.valueOf(object2) + "/";
            }
            string = new File((String)object2, OPTIONS).toString();
        }
        if ((uRL = FrameworkDebugOptions.buildURL(string, false)) == null) {
            System.out.println("Unable to construct URL for options file: " + string);
            return;
        }
        System.out.print("Debug options:\n    " + uRL.toExternalForm());
        try {
            object2 = uRL.openStream();
            try {
                this.options.load((InputStream)object2);
                System.out.println(" loaded");
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                ((InputStream)object2).close();
                throw throwable;
            }
            {
                object = null;
                ((InputStream)object2).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(" not found");
        }
        catch (IOException iOException) {
            System.out.println(" did not parse");
            iOException.printStackTrace(System.out);
        }
        object2 = this.options.keySet().iterator();
        while (true) {
            if (!object2.hasNext()) {
                if (this.options.size() == 0) {
                    this.options = null;
                }
                return;
            }
            object = object2.next();
            this.options.put(object, ((String)this.options.get(object)).trim());
        }
    }

    public boolean isDebugEnabled() {
        return FrameworkProperties.getProperty(OSGI_DEBUG) != null;
    }

    public void setDebugEnabled(boolean bl) {
        if (bl) {
            if (!this.isDebugEnabled()) {
                EclipseDebugTrace.newSession = true;
            }
            FrameworkProperties.setProperty(OSGI_DEBUG, "");
            if (this.options == null) {
                this.options = new Properties();
            }
        } else {
            FrameworkProperties.clearProperty(OSGI_DEBUG);
        }
    }

    public final DebugTrace newDebugTrace(String string) {
        return this.newDebugTrace(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DebugTrace newDebugTrace(String string, Class clazz) {
        DebugTrace debugTrace = null;
        Map map = debugTraceCache;
        synchronized (map) {
            debugTrace = (DebugTrace)debugTraceCache.get(string);
            if (debugTrace == null) {
                debugTrace = new EclipseDebugTrace(string, singleton, clazz);
                debugTraceCache.put(string, debugTrace);
            }
        }
        return debugTrace;
    }

    public final File getFile() {
        return this.outFile;
    }

    public synchronized void setFile(File file) {
        this.outFile = file;
        FrameworkProperties.setProperty(PROP_TRACEFILE, this.outFile.getAbsolutePath());
        EclipseDebugTrace.newSession = true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void optionsChanged(String string) {
        BundleContext bundleContext = this.context;
        if (bundleContext == null) {
            return;
        }
        ServiceReference[] serviceReferenceArray = null;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.osgi.service.debug.DebugOptionsListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            serviceReferenceArray = bundleContext.getServiceReferences(clazz.getName(), "(listener.symbolic.name=" + string + ")");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (serviceReferenceArray == null) {
            return;
        }
        int n = 0;
        while (n < serviceReferenceArray.length) {
            DebugOptionsListener debugOptionsListener = (DebugOptionsListener)bundleContext.getService(serviceReferenceArray[n]);
            if (debugOptionsListener != null) {
                Object var6_6;
                try {
                    try {
                        debugOptionsListener.optionsChanged(this);
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable throwable) {
                    var6_6 = null;
                    bundleContext.ungetService(serviceReferenceArray[n]);
                    throw throwable;
                }
                {
                    var6_6 = null;
                    bundleContext.ungetService(serviceReferenceArray[n]);
                }
            }
            ++n;
        }
        return;
    }

    public Object addingService(ServiceReference serviceReference) {
        DebugOptionsListener debugOptionsListener = (DebugOptionsListener)this.context.getService(serviceReference);
        debugOptionsListener.optionsChanged(this);
        return debugOptionsListener;
    }

    public void modifiedService(ServiceReference serviceReference, Object object) {
    }

    public void removedService(ServiceReference serviceReference, Object object) {
        this.context.ungetService(serviceReference);
    }
}

