/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;

public class EventManager {
    static final boolean DEBUG = false;
    private EventThread thread = null;
    private boolean closed = false;
    protected final String threadName;
    protected final ThreadGroup threadGroup;

    public EventManager() {
        this(null, null);
    }

    public EventManager(String string) {
        this(string, null);
    }

    public EventManager(String string, ThreadGroup threadGroup) {
        this.threadName = string;
        this.threadGroup = threadGroup;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        if (this.thread != null) {
            this.thread.close();
            this.thread = null;
        }
        this.closed = true;
    }

    synchronized EventThread getEventThread() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (this.thread == null) {
            this.thread = new EventThread(this.threadGroup, this.threadName);
            this.thread.start();
        }
        return this.thread;
    }

    static void dispatchEvent(Set set, EventDispatcher eventDispatcher, int n, Object object) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            try {
                eventDispatcher.dispatchEvent(k, v, n, object);
            }
            catch (Throwable throwable) {}
        }
    }

    static class EventThread
    extends Thread {
        private static int nextThreadNumber;
        private Queued head = null;
        private Queued tail = null;
        private volatile boolean running = true;

        EventThread(ThreadGroup threadGroup, String string) {
            super(threadGroup, string == null ? EventThread.getNextName() : string);
            this.setDaemon(true);
        }

        private static synchronized String getNextName() {
            return "EventManagerThread-" + nextThreadNumber++;
        }

        EventThread(String string) {
            this((ThreadGroup)null, string);
        }

        EventThread() {
            this((ThreadGroup)null, (String)null);
        }

        void close() {
            this.running = false;
            this.interrupt();
        }

        public void run() {
            try {
                while (true) {
                    Queued queued;
                    if ((queued = this.getNextEvent()) == null) {
                        return;
                    }
                    EventManager.dispatchEvent(queued.listeners, queued.dispatcher, queued.action, queued.object);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Error error) {
                throw error;
            }
        }

        synchronized void postEvent(Set set, EventDispatcher eventDispatcher, int n, Object object) {
            if (!this.isAlive()) {
                throw new IllegalStateException();
            }
            Queued queued = new Queued(set, eventDispatcher, n, object);
            if (this.head == null) {
                this.head = queued;
                this.tail = queued;
            } else {
                this.tail.next = queued;
                this.tail = queued;
            }
            this.notify();
        }

        private synchronized Queued getNextEvent() {
            while (this.running && this.head == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.running) {
                return null;
            }
            Queued queued = this.head;
            this.head = queued.next;
            if (this.head == null) {
                this.tail = null;
            }
            return queued;
        }

        private static class Queued {
            final Set listeners;
            final EventDispatcher dispatcher;
            final int action;
            final Object object;
            Queued next;

            Queued(Set set, EventDispatcher eventDispatcher, int n, Object object) {
                this.listeners = set;
                this.dispatcher = eventDispatcher;
                this.action = n;
                this.object = object;
                this.next = null;
            }
        }
    }
}

