/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;

public class ListenerQueue {
    protected final EventManager manager;
    private final Map queue;
    private boolean readOnly;

    public ListenerQueue(EventManager eventManager) {
        if (eventManager == null) {
            throw new IllegalArgumentException();
        }
        this.manager = eventManager;
        this.queue = new CopyOnWriteIdentityMap();
        this.readOnly = false;
    }

    public void queueListeners(EventListeners eventListeners, EventDispatcher eventDispatcher) {
        this.queueListeners(eventListeners.entrySet(), eventDispatcher);
    }

    public synchronized void queueListeners(Set set, EventDispatcher eventDispatcher) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        if (set.size() != 0) {
            this.queue.put(set, eventDispatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEventAsynchronous(int n, Object object) {
        Object object2 = this;
        synchronized (object2) {
            this.readOnly = true;
        }
        Object object3 = object2 = this.manager.getEventThread();
        synchronized (object3) {
            Iterator iterator = this.queue.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ((EventManager.EventThread)object2).postEvent((Set)entry.getKey(), (EventDispatcher)entry.getValue(), n, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEventSynchronous(int n, Object object) {
        Object object2 = this;
        synchronized (object2) {
            this.readOnly = true;
        }
        object2 = this.queue.entrySet().iterator();
        while (object2.hasNext()) {
            Map.Entry entry = (Map.Entry)object2.next();
            EventManager.dispatchEvent((Set)entry.getKey(), (EventDispatcher)entry.getValue(), n, object);
        }
    }
}

