/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.adaptor.StatusException;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.BundleLoaderProxy;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class BundleHost
extends AbstractBundle {
    private BundleLoaderProxy proxy;
    protected BundleContextImpl context = null;
    protected BundleFragment[] fragments = null;

    public BundleHost(BundleData bundleData, Framework framework) throws BundleException {
        super(bundleData, framework);
    }

    protected void load() {
        SecurityManager securityManager;
        if (Debug.DEBUG_GENERAL) {
            if ((this.state & 2) == 0) {
                Debug.println("Bundle.load called when state != INSTALLED: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            if (this.proxy != null) {
                Debug.println("Bundle.load called when proxy != null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
        }
        if (this.framework.isActive() && (securityManager = System.getSecurityManager()) != null && this.framework.securityAdmin != null) {
            this.domain = this.framework.securityAdmin.createProtectionDomain(this);
        }
        this.proxy = null;
    }

    protected boolean reload(AbstractBundle abstractBundle) {
        if (Debug.DEBUG_GENERAL && (this.state & 6) == 0) {
            Debug.println("Bundle.reload called when state != INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean bl = false;
        if (this.framework.isActive()) {
            if (this.state == 4) {
                BundleLoaderProxy bundleLoaderProxy = this.getLoaderProxy();
                bl = bundleLoaderProxy.inUse();
                if (bl) {
                    this.framework.packageAdmin.addRemovalPending(this.bundledata);
                    bundleLoaderProxy.getBundleLoader().createClassLoader();
                } else {
                    BundleLoader.closeBundleLoader(this.proxy);
                }
                this.state = 2;
                this.proxy = null;
                this.fragments = null;
            }
        } else {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        this.bundledata = abstractBundle.bundledata;
        this.bundledata.setBundle(this);
        if (this.framework.isActive() && System.getSecurityManager() != null && this.framework.securityAdmin != null) {
            this.domain = this.framework.securityAdmin.createProtectionDomain(this);
        }
        return bl;
    }

    protected void refresh() {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.reload called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.state == 4) {
            BundleLoader.closeBundleLoader(this.proxy);
            this.proxy = null;
            this.fragments = null;
            this.state = 2;
        }
        this.manifestLocalization = null;
    }

    protected boolean unload() {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.unload called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean bl = false;
        if (this.framework.isActive() && this.state == 4) {
            BundleLoaderProxy bundleLoaderProxy = this.getLoaderProxy();
            bl = bundleLoaderProxy.inUse();
            if (bl) {
                this.framework.packageAdmin.addRemovalPending(this.bundledata);
                bundleLoaderProxy.getBundleLoader().createClassLoader();
            } else {
                BundleLoader.closeBundleLoader(this.proxy);
            }
            this.state = 2;
            this.proxy = null;
            this.fragments = null;
            this.domain = null;
        }
        if (!bl) {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    private BundleLoader checkLoader() {
        BundleLoader bundleLoader;
        this.checkValid();
        if (!this.isResolved() && !this.framework.packageAdmin.resolveBundles(new Bundle[]{this})) {
            return null;
        }
        if (Debug.DEBUG_GENERAL && (this.state & 0x3C) == 0) {
            Debug.println("Bundle.checkLoader() called when state != STARTING | ACTIVE | STOPPING | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if ((bundleLoader = this.getBundleLoader()) == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle.checkLoader() called when loader == null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            return null;
        }
        return bundleLoader;
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        BundleLoader bundleLoader;
        if (bl) {
            try {
                this.framework.checkAdminPermission(this, "class");
            }
            catch (SecurityException securityException) {
                throw new ClassNotFoundException();
            }
        }
        if ((bundleLoader = this.checkLoader()) == null) {
            throw new ClassNotFoundException(NLS.bind(Msg.BUNDLE_CNFE_NOT_RESOLVED, string, this.getBundleData().getLocation()));
        }
        try {
            return bundleLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (!(classNotFoundException instanceof StatusException) && (this.bundledata.getStatus() & 2) != 0 && !this.testStateChanging(Thread.currentThread())) {
                try {
                    this.framework.secureAction.start(this, 1);
                }
                catch (BundleException bundleException) {
                    this.framework.adaptor.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 2, 0, bundleException.getMessage(), 0, bundleException, null));
                }
            }
            throw classNotFoundException;
        }
    }

    public URL getResource(String string) {
        BundleLoader bundleLoader = null;
        try {
            this.framework.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        bundleLoader = this.checkLoader();
        if (bundleLoader == null) {
            return null;
        }
        return bundleLoader.findResource(string);
    }

    public Enumeration getResources(String string) throws IOException {
        BundleLoader bundleLoader = null;
        try {
            this.framework.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        bundleLoader = this.checkLoader();
        if (bundleLoader == null) {
            return null;
        }
        Enumeration enumeration = bundleLoader.getResources(string);
        if (enumeration != null && enumeration.hasMoreElements()) {
            return enumeration;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void startWorker(int n) throws BundleException {
        block22: {
            if ((n & 1) == 0) {
                this.setStatus(1, true);
                this.setStatus(4, (n & 2) != 0);
                if (Debug.MONITOR_ACTIVATION) {
                    new Exception("A persistent start has been called on bundle: " + this.getBundleData()).printStackTrace();
                }
            }
            if (!this.framework.active || (this.state & 0x20) != 0) {
                return;
            }
            if (this.state == 2 && !this.framework.packageAdmin.resolveBundles(new Bundle[]{this})) {
                throw this.getResolutionFailureException();
            }
            if (this.getStartLevel() > this.framework.startLevelManager.getStartLevel()) {
                if ((n & 1) != 0) {
                    String string = NLS.bind(Msg.BUNDLE_TRANSIENT_START_ERROR, this);
                    throw new BundleException(string, 2, new AbstractBundle.BundleStatusException(string, 4, this));
                }
                return;
            }
            if ((n & 2) != 0 && (this.bundledata.getStatus() & 2) != 0) {
                if ((this.state & 4) != 0) {
                    this.state = 8;
                    this.completeStateChange();
                    this.framework.publishBundleEvent(512, this);
                }
                return;
            }
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle: Active sl = " + this.framework.startLevelManager.getStartLevel() + "; Bundle " + this.getBundleId() + " sl = " + this.getStartLevel());
            }
            this.state = 8;
            this.framework.publishBundleEvent(128, this);
            this.context = this.getContext();
            long l = 0L;
            BundleWatcher bundleWatcher = this.framework.adaptor.getBundleWatcher();
            if (bundleWatcher != null) {
                bundleWatcher.watchBundle(this, 4);
            }
            if (Debug.DEBUG_BUNDLE_TIME) {
                l = System.currentTimeMillis();
                System.out.println("Starting " + this.getSymbolicName());
            }
            try {
                try {
                    this.context.start();
                    this.startHook();
                    if (this.framework.active) {
                        this.state = 32;
                        if (Debug.DEBUG_GENERAL) {
                            Debug.println("->started " + this);
                        }
                        this.completeStateChange();
                        this.framework.publishBundleEvent(2, this);
                    }
                }
                catch (BundleException bundleException) {
                    this.state = 16;
                    this.framework.publishBundleEvent(256, this);
                    this.stopHook();
                    this.context.close();
                    this.context = null;
                    this.state = 4;
                    this.framework.publishBundleEvent(4, this);
                    throw bundleException;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                BundleWatcher bundleWatcher2 = this.framework.adaptor.getBundleWatcher();
                if (bundleWatcher2 != null) {
                    bundleWatcher2.watchBundle(this, 8);
                }
                if (Debug.DEBUG_BUNDLE_TIME) {
                    System.out.println("End starting " + this.getSymbolicName() + " " + (System.currentTimeMillis() - l));
                }
                throw throwable;
            }
            {
                Object var5_8 = null;
                BundleWatcher bundleWatcher3 = this.framework.adaptor.getBundleWatcher();
                if (bundleWatcher3 != null) {
                    bundleWatcher3.watchBundle(this, 8);
                }
                if (Debug.DEBUG_BUNDLE_TIME) {
                    System.out.println("End starting " + this.getSymbolicName() + " " + (System.currentTimeMillis() - l));
                }
                if (this.state != 1) break block22;
                this.context.close();
                this.context = null;
            }
            throw new BundleException(NLS.bind(Msg.BUNDLE_UNINSTALLED_EXCEPTION, this.getBundleData().getLocation()), 7);
        }
    }

    protected void startHook() throws BundleException {
    }

    protected boolean readyToResume() {
        if (this.getStartLevel() > this.framework.startLevelManager.getStartLevel()) {
            return false;
        }
        int n = this.bundledata.getStatus();
        if ((n & 1) == 0) {
            return false;
        }
        if ((n & 4) == 0 || (n & 2) == 0) {
            return true;
        }
        if (!this.isResolved()) {
            return false;
        }
        this.state = 8;
        this.completeStateChange();
        this.framework.publishBundleEvent(512, this);
        return false;
    }

    protected BundleContextImpl createContext() {
        return new BundleContextImpl(this);
    }

    protected synchronized BundleContextImpl getContext() {
        if (this.context == null && (this.state & 0x38) != 0) {
            this.context = this.createContext();
        }
        return this.context;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stopWorker(int n) throws BundleException {
        if ((n & 1) == 0) {
            this.setStatus(1, false);
            this.setStatus(4, false);
            if (Debug.MONITOR_ACTIVATION) {
                new Exception("A persistent start has been called on bundle: " + this.getBundleData()).printStackTrace();
            }
        }
        if (!this.framework.active) return;
        if ((this.state & 0x16) != 0) {
            return;
        }
        BundleWatcher bundleWatcher = this.framework.adaptor.getBundleWatcher();
        if (bundleWatcher != null) {
            bundleWatcher.watchBundle(this, 16);
        }
        this.state = 16;
        this.framework.publishBundleEvent(256, this);
        try {
            if (this.context != null) {
                this.context.stop();
            }
        }
        catch (Throwable throwable) {
            bundleWatcher = null;
            this.stopHook();
            if (this.context != null) {
                this.context.close();
                this.context = null;
            }
            this.checkValid();
            this.state = 4;
            if (Debug.DEBUG_GENERAL) {
                Debug.println("->stopped " + this);
            }
            this.framework.publishBundleEvent(4, this);
            BundleWatcher bundleWatcher2 = this.framework.adaptor.getBundleWatcher();
            if (bundleWatcher2 == null) throw throwable;
            bundleWatcher2.watchBundle(this, 32);
            throw throwable;
        }
        {
            bundleWatcher = null;
        }
        this.stopHook();
        if (this.context != null) {
            this.context.close();
            this.context = null;
        }
        this.checkValid();
        this.state = 4;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("->stopped " + this);
        }
        this.framework.publishBundleEvent(4, this);
        BundleWatcher bundleWatcher3 = this.framework.adaptor.getBundleWatcher();
        if (bundleWatcher3 == null) return;
        bundleWatcher3.watchBundle(this, 32);
    }

    protected void stopHook() throws BundleException {
    }

    public ServiceReference[] getRegisteredServices() {
        this.checkValid();
        if (this.context == null) {
            return null;
        }
        return this.context.getFramework().getServiceRegistry().getRegisteredServices(this.context);
    }

    public ServiceReference[] getServicesInUse() {
        this.checkValid();
        if (this.context == null) {
            return null;
        }
        return this.context.getFramework().getServiceRegistry().getServicesInUse(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleFragment[] getFragments() {
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            block4: {
                if (this.fragments != null) break block4;
                return null;
            }
            BundleFragment[] bundleFragmentArray = new BundleFragment[this.fragments.length];
            System.arraycopy(this.fragments, 0, bundleFragmentArray, 0, bundleFragmentArray.length);
            return bundleFragmentArray;
        }
    }

    protected void attachFragment(BundleFragment bundleFragment) throws BundleException {
        BundleLoader bundleLoader = this.getLoaderProxy().getBasicBundleLoader();
        if (bundleLoader != null) {
            bundleLoader.attachFragment(bundleFragment);
        }
        if (this.fragments == null) {
            this.fragments = new BundleFragment[]{bundleFragment};
        } else {
            boolean bl = false;
            BundleFragment[] bundleFragmentArray = new BundleFragment[this.fragments.length + 1];
            int n = 0;
            while (n < this.fragments.length) {
                if (bundleFragment == this.fragments[n]) {
                    return;
                }
                if (!bl && bundleFragment.getBundleId() < this.fragments[n].getBundleId()) {
                    if (bundleLoader != null) {
                        throw new BundleException(NLS.bind(Msg.BUNDLE_LOADER_ATTACHMENT_ERROR, this.fragments[n].getSymbolicName(), this.getSymbolicName()), 2);
                    }
                    bundleFragmentArray[n] = bundleFragment;
                    bl = true;
                }
                bundleFragmentArray[bl ? n + 1 : n] = this.fragments[n];
                ++n;
            }
            if (!bl) {
                bundleFragmentArray[bundleFragmentArray.length - 1] = bundleFragment;
            }
            this.fragments = bundleFragmentArray;
        }
        this.manifestLocalization = null;
    }

    protected BundleLoader getBundleLoader() {
        BundleLoaderProxy bundleLoaderProxy = this.getLoaderProxy();
        return bundleLoaderProxy == null ? null : bundleLoaderProxy.getBundleLoader();
    }

    public synchronized BundleLoaderProxy getLoaderProxy() {
        if (this.proxy != null) {
            return this.proxy;
        }
        BundleDescription bundleDescription = this.getBundleDescription();
        if (bundleDescription == null) {
            return null;
        }
        this.proxy = new BundleLoaderProxy(this, bundleDescription);
        bundleDescription.setUserObject(this.proxy);
        return this.proxy;
    }
}

