/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.framework.internal.core.ConsoleMsg;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkCommandInterpreter;
import org.eclipse.osgi.framework.internal.core.FrameworkCommandProvider;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class FrameworkConsole
implements Runnable {
    protected BufferedReader in;
    protected PrintWriter out;
    protected final BundleContext context;
    protected final String[] args;
    protected final CommandProvider osgicp;
    protected final ServiceTracker cptracker;
    static final String defaultEncoding = "iso8859-1";
    static final String encoding = FrameworkProperties.getProperty("osgi.console.encoding", FrameworkProperties.getProperty("file.encoding", "iso8859-1"));
    protected final boolean useSocketStream;
    protected boolean disconnect = false;
    protected final int port;
    protected ConsoleSocketGetter scsg = null;
    protected Socket s;
    boolean blockOnready = FrameworkProperties.getProperty("osgi.dev") != null || FrameworkProperties.getProperty("osgi.console.blockOnReady") != null;
    volatile boolean shutdown = false;
    static /* synthetic */ Class class$0;

    public FrameworkConsole(Framework framework, String[] stringArray) {
        this(framework, stringArray, 0, false);
    }

    public FrameworkConsole(Framework framework, int n, String[] stringArray) {
        this(framework, stringArray, n, true);
    }

    private FrameworkConsole(Framework framework, String[] stringArray, int n, boolean bl) {
        this.args = stringArray;
        this.useSocketStream = bl;
        this.port = n;
        this.context = framework.systemBundle.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.console.CommandProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.cptracker = new ServiceTracker(this.context, clazz.getName(), null);
        this.cptracker.open();
        this.osgicp = new FrameworkCommandProvider(framework).intialize();
    }

    private void getDefaultStreams() {
        FilterInputStream filterInputStream = new FilterInputStream(System.in){

            public void close() throws IOException {
            }
        };
        this.in = this.createBufferedReader(filterInputStream);
        FilterOutputStream filterOutputStream = new FilterOutputStream(System.out){

            public void close() throws IOException {
            }

            public void write(byte[] byArray, int n, int n2) throws IOException {
                this.out.write(byArray, n, n2);
            }
        };
        this.out = this.createPrintWriter(filterOutputStream);
        this.disconnect = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getSocketStream() {
        Object object;
        block11: {
            object = this;
            synchronized (object) {
                if (this.scsg == null) {
                    this.scsg = new ConsoleSocketGetter(new ServerSocket(this.port));
                }
                this.scsg.setAcceptConnections(true);
            }
            System.out.println(NLS.bind(ConsoleMsg.CONSOLE_LISTENING_ON_PORT, Integer.toString(this.scsg.getLocalPort())));
            object = this.scsg.getSocket();
            if (object != null) break block11;
            return false;
        }
        try {
            FrameworkConsole frameworkConsole = this;
            synchronized (frameworkConsole) {
                this.s = object;
                this.in = this.createBufferedReader(this.s.getInputStream());
                this.out = this.createPrintWriter(this.s.getOutputStream());
                this.disconnect = false;
            }
            return true;
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private BufferedReader createBufferedReader(InputStream inputStream) {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        }
        return bufferedReader;
    }

    PrintWriter createPrintWriter(OutputStream outputStream) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream, encoding)), true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream)), true);
        }
        return printWriter;
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public BufferedReader getReader() {
        return this.in;
    }

    public boolean getUseSocketStream() {
        return this.useSocketStream;
    }

    public void run() {
        this.getDefaultStreams();
        try {
            this.console(this.args);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.out);
        }
        while (!this.shutdown) {
            if (this.useSocketStream && !this.getSocketStream()) {
                return;
            }
            this.console();
        }
    }

    public void console(String[] stringArray) throws IOException {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.docommand(stringArray[n]);
                ++n;
            }
        }
    }

    protected void console() {
        BufferedReader bufferedReader = this.in;
        String string = "\r\n" + ConsoleMsg.CONSOLE_PROMPT;
        while (!this.disconnected()) {
            String string2;
            block9: {
                this.out.print(string);
                this.out.flush();
                string2 = null;
                try {
                    if (this.blockOnready && !this.useSocketStream) {
                        try {
                            while (!bufferedReader.ready()) {
                                Thread.sleep(300L);
                            }
                            string2 = bufferedReader.readLine();
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        string2 = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    if (this.shutdown) break block9;
                    iOException.printStackTrace(this.out);
                }
            }
            if (string2 == null) {
                if (this.useSocketStream) break;
                this.shutdown();
                break;
            }
            if (this.shutdown) continue;
            this.docommand(string2);
        }
    }

    protected void docommand(String string) {
        FrameworkCommandInterpreter frameworkCommandInterpreter;
        String string2;
        if (string != null && string.length() > 0 && (string2 = (frameworkCommandInterpreter = new FrameworkCommandInterpreter(string, this.getServices(), this)).nextArgument()) != null) {
            frameworkCommandInterpreter.execute(string2);
        }
    }

    public synchronized void disconnect() {
        if (!this.disconnect) {
            this.disconnect = true;
            if (this.useSocketStream) {
                if (this.s != null) {
                    try {
                        this.s.close();
                    }
                    catch (IOException iOException) {}
                }
                if (this.out != null) {
                    this.out.close();
                }
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private synchronized boolean disconnected() {
        return this.disconnect;
    }

    public String getInput() {
        String string;
        try {
            string = this.in.readLine();
            System.out.println("<" + string + ">");
        }
        catch (IOException iOException) {
            string = "";
        }
        return string;
    }

    public Object[] getServices() {
        Object[] objectArray = this.cptracker.getServiceReferences();
        if (objectArray == null) {
            return new Object[0];
        }
        Util.dsort(objectArray, 0, objectArray.length);
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            objectArray2[n] = this.context.getService((ServiceReference)objectArray[n]);
            ++n;
        }
        return objectArray2;
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.cptracker.close();
        this.disconnect();
        if (this.scsg != null) {
            try {
                this.scsg.shutdown();
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
        }
    }

    class ConsoleSocketGetter
    implements Runnable {
        private final ServerSocket server;
        private Socket socket;
        private boolean acceptConnections = true;
        private final Object lock = new Object();

        ConsoleSocketGetter(ServerSocket serverSocket) {
            Object object;
            this.server = serverSocket;
            try {
                object = serverSocket.getClass().getMethod("setReuseAddress", Boolean.TYPE);
                ((Method)object).invoke((Object)serverSocket, Boolean.TRUE);
            }
            catch (Exception exception) {}
            object = new Thread((Runnable)this, "ConsoleSocketGetter");
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
        }

        public int getLocalPort() {
            return this.server.getLocalPort();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!FrameworkConsole.this.shutdown) {
                try {
                    Object object;
                    this.socket = this.server.accept();
                    if (!this.acceptConnections) {
                        object = FrameworkConsole.this.createPrintWriter(this.socket.getOutputStream());
                        ((PrintWriter)object).println(ConsoleMsg.CONSOLE_TELNET_CONNECTION_REFUSED);
                        ((PrintWriter)object).println(ConsoleMsg.CONSOLE_TELNET_CURRENTLY_USED);
                        ((PrintWriter)object).println(ConsoleMsg.CONSOLE_TELNET_ONE_CLIENT_ONLY);
                        ((PrintWriter)object).close();
                        this.socket.close();
                        continue;
                    }
                    object = this.lock;
                    synchronized (object) {
                        this.lock.notify();
                    }
                }
                catch (Exception exception) {
                    if (FrameworkConsole.this.shutdown) continue;
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Socket getSocket() throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait();
            }
            this.setAcceptConnections(false);
            return FrameworkConsole.this.shutdown ? null : this.socket;
        }

        public void setAcceptConnections(boolean bl) {
            this.acceptConnections = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() throws IOException {
            this.server.close();
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
    }
}

