/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.protocol.reference;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.osgi.framework.adaptor.FilePath;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.ReferenceInputStream;

public class ReferenceURLConnection
extends URLConnection {
    protected URL reference;

    protected ReferenceURLConnection(URL uRL) {
        super(uRL);
    }

    public synchronized void connect() throws IOException {
        if (!this.connected) {
            String string;
            File file = new File(this.url.getPath().substring(5));
            if (!file.isAbsolute() && (string = this.getInstallPath()) != null) {
                file = ReferenceURLConnection.makeAbsolute(string, file);
            }
            URL uRL = file.toURL();
            if (!file.exists()) {
                throw new FileNotFoundException(file.toString());
            }
            this.reference = uRL;
        }
    }

    public boolean getDoInput() {
        return true;
    }

    public boolean getDoOutput() {
        return false;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return new ReferenceInputStream(this.reference);
    }

    private String getInstallPath() {
        String string = FrameworkProperties.getProperty("osgi.install.area");
        if (string == null) {
            return null;
        }
        if (!string.startsWith("file:")) {
            return null;
        }
        return string.substring(5);
    }

    private static File makeAbsolute(String string, File file) {
        if (file.isAbsolute()) {
            return file;
        }
        return new File(new FilePath(String.valueOf(string) + file.getPath()).toString());
    }
}

