/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.composite;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

class CompositeServiceTracker
implements ServiceTrackerCustomizer {
    final BundleContext sourceContext;
    final BundleContext targetContext;
    final ServiceTracker[] trackers;
    final String[] filters;
    final HashMap serviceComposites = new HashMap();

    public CompositeServiceTracker(BundleContext bundleContext, BundleContext bundleContext2, String string) {
        this.sourceContext = bundleContext;
        this.targetContext = bundleContext2;
        this.filters = ManifestElement.getArrayFromList(string, ",");
        this.trackers = new ServiceTracker[this.filters.length];
    }

    synchronized void open() {
        int n = 0;
        while (n < this.trackers.length) {
            try {
                this.trackers[n] = new ServiceTracker(this.sourceContext, this.sourceContext.createFilter(this.filters[n]), (ServiceTrackerCustomizer)this);
                this.trackers[n].open();
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            ++n;
        }
    }

    synchronized void close() {
        int n = 0;
        while (n < this.trackers.length) {
            if (this.trackers[n] != null) {
                this.trackers[n].close();
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference serviceReference) {
        int n;
        ServiceLink serviceLink;
        HashMap hashMap = this.serviceComposites;
        synchronized (hashMap) {
            serviceLink = (ServiceLink)this.serviceComposites.get(serviceReference);
            if (serviceLink == null) {
                serviceLink = new ServiceLink(serviceReference);
                this.serviceComposites.put(serviceReference, serviceLink);
            }
            n = serviceLink.incrementUse();
        }
        if (n == 1) {
            serviceLink.register();
        }
        return serviceLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifiedService(ServiceReference serviceReference, Object object) {
        ServiceLink serviceLink = (ServiceLink)object;
        Dictionary dictionary = null;
        HashMap hashMap = this.serviceComposites;
        synchronized (hashMap) {
            dictionary = serviceLink.getRefreshProperties();
        }
        if (dictionary != null) {
            ((ServiceLink)object).setServiceProperties(dictionary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference serviceReference, Object object) {
        int n;
        HashMap hashMap = this.serviceComposites;
        synchronized (hashMap) {
            n = ((ServiceLink)object).decrementUse();
            if (n == 0) {
                this.serviceComposites.remove(serviceReference);
            }
        }
        if (n == 0) {
            ((ServiceLink)object).unregister();
        }
    }

    class ServiceLink
    implements ServiceFactory {
        private final ServiceReference reference;
        private volatile ServiceRegistration registration;
        private Object service;
        private int useCount;

        ServiceLink(ServiceReference serviceReference) {
            this.reference = serviceReference;
        }

        Dictionary getRefreshProperties() {
            Dictionary dictionary = this.getServiceProperties();
            if (this.useCount <= 1) {
                return dictionary;
            }
            String[] stringArray = this.registration.getReference().getPropertyKeys();
            int n = 0;
            while (n < stringArray.length) {
                if (!"objectClass".equals(stringArray[n]) && !"service.id".equals(stringArray[n]) && this.registration.getReference().getProperty(stringArray[n]) != dictionary.get(stringArray[n])) {
                    return dictionary;
                }
                ++n;
            }
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if ("objectClass".equals(string) || "service.id".equals(string) || dictionary.get(string) == this.registration.getReference().getProperty(string)) continue;
                return dictionary;
            }
            return null;
        }

        int decrementUse() {
            return --this.useCount;
        }

        int incrementUse() {
            return ++this.useCount;
        }

        int getUse() {
            return this.useCount;
        }

        void setServiceProperties(Dictionary dictionary) {
            ServiceRegistration serviceRegistration = this.registration;
            if (serviceRegistration != null) {
                serviceRegistration.setProperties(dictionary);
            }
        }

        void register() {
            Dictionary dictionary = this.getServiceProperties();
            this.registration = CompositeServiceTracker.this.targetContext.registerService((String[])dictionary.get("objectClass"), (Object)this, dictionary);
        }

        void unregister() {
            ServiceRegistration serviceRegistration = this.registration;
            if (serviceRegistration != null) {
                serviceRegistration.unregister();
            }
        }

        private Dictionary getServiceProperties() {
            String[] stringArray = this.reference.getPropertyKeys();
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                hashtable.put(stringArray[n], this.reference.getProperty(stringArray[n]));
                ++n;
            }
            return hashtable;
        }

        public synchronized Object getService(Bundle bundle, ServiceRegistration serviceRegistration) {
            if (this.service == null) {
                this.service = CompositeServiceTracker.this.sourceContext.getService(this.reference);
            }
            return this.service;
        }

        public void ungetService(Bundle bundle, ServiceRegistration serviceRegistration, Object object) {
        }
    }
}

