/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.security.BasicPermission;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundlePermission;
import org.osgi.framework.PackagePermission;

public class PermissionChecker {
    private BundleContext context;
    private boolean checkPermissions = false;
    private ResolverImpl resolver;

    public PermissionChecker(BundleContext bundleContext, boolean bl, ResolverImpl resolverImpl) {
        this.context = bundleContext;
        this.checkPermissions = bl && bundleContext != null;
        this.resolver = resolverImpl;
    }

    public boolean checkPermission(VersionConstraint versionConstraint, BaseDescription baseDescription) {
        if (!this.checkPermissions) {
            return true;
        }
        boolean bl = false;
        BasicPermission basicPermission = null;
        BasicPermission basicPermission2 = null;
        Bundle bundle = null;
        Bundle bundle2 = null;
        int n = 0;
        if (versionConstraint instanceof ImportPackageSpecification) {
            n = 128;
            bundle = this.context.getBundle(((ExportPackageDescription)baseDescription).getExporter().getBundleId());
            basicPermission = new PackagePermission(baseDescription.getName(), "exportonly");
            basicPermission2 = new PackagePermission(versionConstraint.getName(), bundle, "import");
        } else {
            boolean bl2 = versionConstraint instanceof BundleSpecification;
            n = bl2 ? 512 : 4096;
            basicPermission = new BundlePermission(baseDescription.getName(), bl2 ? "provide" : "host");
            basicPermission2 = new BundlePermission(versionConstraint.getName(), bl2 ? "require" : "fragment");
            bundle = this.context.getBundle(((BundleDescription)baseDescription).getBundleId());
        }
        bundle2 = this.context.getBundle(versionConstraint.getBundle().getBundleId());
        if (bundle != null && (bundle.getState() & 1) == 0 && !(bl = bundle.hasPermission(basicPermission))) {
            switch (n) {
                case 128: {
                    n = 256;
                    break;
                }
                case 512: 
                case 4096: {
                    n = n == 512 ? 1024 : 2048;
                }
            }
            this.resolver.getState().addResolverError(versionConstraint.getBundle(), n, basicPermission.toString(), versionConstraint);
        }
        if (bl && bundle2 != null && (bundle2.getState() & 1) == 0 && !(bl = bundle2.hasPermission(basicPermission2))) {
            this.resolver.getState().addResolverError(versionConstraint.getBundle(), n, basicPermission2.toString(), versionConstraint);
        }
        return bl;
    }

    boolean checkPackagePermission(ExportPackageDescription exportPackageDescription) {
        if (!this.checkPermissions) {
            return true;
        }
        Bundle bundle = this.context.getBundle(exportPackageDescription.getExporter().getBundleId());
        return bundle == null ? false : bundle.hasPermission(new PackagePermission(exportPackageDescription.getName(), "exportonly"));
    }
}

