/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.permadmin;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.osgi.internal.permadmin.BundlePermissions;
import org.eclipse.osgi.internal.permadmin.PermissionInfoCollection;
import org.eclipse.osgi.internal.permadmin.SecurityAdmin;
import org.eclipse.osgi.internal.permadmin.SecurityRowSnapShot;
import org.osgi.framework.Bundle;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.permissionadmin.PermissionInfo;

public final class SecurityRow
implements ConditionalPermissionInfo {
    static final Class[] conditionMethodArgs;
    static Condition[] ABSTAIN_LIST;
    static Condition[] SATISFIED_LIST;
    static final Decision DECISION_ABSTAIN;
    static final Decision DECISION_GRANTED;
    static final Decision DECISION_DENIED;
    private final SecurityAdmin securityAdmin;
    private final String name;
    private final ConditionInfo[] conditionInfos;
    private final PermissionInfoCollection permissionInfoCollection;
    private final boolean deny;
    final HashMap bundleConditions;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.framework.Bundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.service.condpermadmin.ConditionInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        conditionMethodArgs = classArray;
        ABSTAIN_LIST = new Condition[0];
        SATISFIED_LIST = new Condition[0];
        DECISION_ABSTAIN = new Decision(4, null, null, null);
        DECISION_GRANTED = new Decision(1, null, null, null);
        DECISION_DENIED = new Decision(2, null, null, null);
    }

    public SecurityRow(SecurityAdmin securityAdmin, String string, ConditionInfo[] conditionInfoArray, PermissionInfo[] permissionInfoArray, String string2) {
        boolean bl;
        if (permissionInfoArray == null || permissionInfoArray.length == 0) {
            throw new IllegalArgumentException("It is invalid to have empty permissionInfos");
        }
        this.securityAdmin = securityAdmin;
        this.conditionInfos = conditionInfoArray == null ? new ConditionInfo[]{} : conditionInfoArray;
        boolean bl2 = "deny".equals(string2 = string2.toLowerCase());
        if (!(bl2 | (bl = "allow".equals(string2)))) {
            throw new IllegalArgumentException("Invalid decision: " + string2);
        }
        this.deny = bl2;
        this.name = string;
        this.permissionInfoCollection = new PermissionInfoCollection(permissionInfoArray);
        this.bundleConditions = conditionInfoArray == null || conditionInfoArray.length == 0 ? null : new HashMap();
    }

    static SecurityRowSnapShot createSecurityRowSnapShot(String string) {
        return (SecurityRowSnapShot)SecurityRow.createConditionalPermissionInfo(null, string);
    }

    static SecurityRow createSecurityRow(SecurityAdmin securityAdmin, String string) {
        return (SecurityRow)SecurityRow.createConditionalPermissionInfo(securityAdmin, string);
    }

    /*
     * Unable to fully structure code
     */
    private static ConditionalPermissionInfo createConditionalPermissionInfo(SecurityAdmin var0, String var1_1) {
        if ((var1_1 = var1_1.trim()).length() == 0) {
            throw new IllegalArgumentException("Empty encoded string is invalid");
        }
        var2_2 = var1_1.toCharArray();
        var4_4 = var2_2[var3_3 = var1_1.length() - 1];
        if (var4_4 != '}' && var4_4 != '\"') {
            throw new IllegalArgumentException(var1_1);
        }
        var5_5 = null;
        if (var4_4 == '\"') {
            if (var2_2.length < 2) {
                throw new IllegalArgumentException(var1_1);
            }
            var6_6 = var1_1.length() - 1;
            var7_7 = var6_6 - 1;
            while (var7_7 > 0) {
                if (var2_2[var7_7] == '\"') {
                    if (--var7_7 > 0 && var2_2[var7_7] == '\\') {
                        --var7_7;
                    } else {
                        ++var7_7;
                        break;
                    }
                }
                --var7_7;
            }
            if (var2_2[var7_7] != '\"') {
                throw new IllegalArgumentException(var1_1);
            }
            var5_5 = SecurityRow.unescapeString(var1_1.substring(var7_7 + 1, var6_6));
            var3_3 = var1_1.lastIndexOf(125, var7_7);
        }
        if ((var6_6 = var1_1.indexOf(123)) < 0 || var3_3 < var6_6) {
            throw new IllegalArgumentException(var1_1);
        }
        var7_8 = var1_1.substring(0, var6_6);
        if ((var7_8 = var7_8.trim()).length() == 0 || !"deny".equalsIgnoreCase(var7_8) && !"allow".equalsIgnoreCase(var7_8)) {
            throw new IllegalArgumentException(var1_1);
        }
        var8_9 = new ArrayList<ConditionInfo>();
        var9_10 = new ArrayList<PermissionInfo>();
        var10_11 = var6_6 + 1;
        ** GOTO lbl60
        {
            ++var10_11;
            do {
                if (var10_11 < var3_3 && var2_2[var10_11] != '[' && var2_2[var10_11] != '(') continue block1;
                if (var10_11 == var3_3) break block1;
                var11_12 = var10_11;
                var12_14 = var2_2[var11_12] == '[' ? ']' : ')';
                while (var10_11 < var3_3 && var2_2[var10_11] != var12_14) {
                    if (var2_2[var10_11] == '\"') {
                        ++var10_11;
                        while (var2_2[var10_11] != '\"') {
                            if (var2_2[var10_11] == '\\') {
                                ++var10_11;
                            }
                            ++var10_11;
                        }
                    }
                    ++var10_11;
                }
                var13_16 = var10_11;
                var14_17 = new String(var2_2, var11_12, var13_16 - var11_12 + 1);
                if (var12_14 == ']') {
                    var8_9.add(new ConditionInfo(var14_17));
                } else {
                    var9_10.add(new PermissionInfo(var14_17));
                }
                ++var10_11;
lbl60:
                // 2 sources

            } while (var10_11 < var3_3);
        }
        if (var9_10.size() == 0) {
            throw new IllegalArgumentException("No Permission infos: " + var1_1);
        }
        var11_13 = var8_9.toArray(new ConditionInfo[var8_9.size()]);
        var12_15 = var9_10.toArray(new PermissionInfo[var9_10.size()]);
        if (var0 == null) {
            return new SecurityRowSnapShot(var5_5, var11_13, var12_15, var7_8);
        }
        return new SecurityRow(var0, var5_5, var11_13, var12_15, var7_8);
    }

    static Object cloneArray(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Object object = Array.newInstance(objectArray.getClass().getComponentType(), objectArray.length);
        System.arraycopy(objectArray, 0, object, 0, objectArray.length);
        return object;
    }

    private static void escapeString(String string, StringBuffer stringBuffer) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\"': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
    }

    private static String unescapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.charAt(n2);
            if (n3 == 92 && ++n2 < n) {
                n3 = string.charAt(n2);
                switch (n3) {
                    case 34: 
                    case 92: {
                        break;
                    }
                    case 114: {
                        n3 = 13;
                        break;
                    }
                    case 110: {
                        n3 = 10;
                        break;
                    }
                    default: {
                        n3 = 92;
                        --n2;
                    }
                }
            }
            stringBuffer.append((char)n3);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public ConditionInfo[] getConditionInfos() {
        return (ConditionInfo[])SecurityRow.cloneArray(this.conditionInfos);
    }

    ConditionInfo[] internalGetConditionInfos() {
        return this.conditionInfos;
    }

    public String getAccessDecision() {
        return this.deny ? "deny" : "allow";
    }

    public PermissionInfo[] getPermissionInfos() {
        return (PermissionInfo[])SecurityRow.cloneArray(this.permissionInfoCollection.getPermissionInfos());
    }

    PermissionInfo[] internalGetPermissionInfos() {
        return this.permissionInfoCollection.getPermissionInfos();
    }

    public void delete() {
        this.securityAdmin.delete(this, true);
    }

    Condition[] getConditions(Bundle bundle) {
        Condition[] conditionArray = new Condition[this.conditionInfos.length];
        int n = 0;
        while (n < this.conditionInfos.length) {
            block11: {
                Class<?> clazz;
                try {
                    clazz = Class.forName(this.conditionInfos[n].getType());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
                Constructor<?> constructor = null;
                Method method = null;
                try {
                    method = clazz.getMethod("getCondition", conditionMethodArgs);
                    if ((method.getModifiers() & 8) == 0) {
                        method = null;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (method == null) {
                    try {
                        constructor = clazz.getConstructor(conditionMethodArgs);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        conditionArray[n] = Condition.FALSE;
                        break block11;
                    }
                }
                Object[] objectArray = new Object[]{bundle, this.conditionInfos[n]};
                try {
                    conditionArray[n] = method != null ? (Condition)method.invoke(null, objectArray) : (Condition)constructor.newInstance(objectArray);
                }
                catch (Throwable throwable) {
                    conditionArray[n] = Condition.FALSE;
                }
            }
            ++n;
        }
        return conditionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Decision evaluate(BundlePermissions bundlePermissions, Permission permission) {
        Condition[] conditionArray;
        if (this.bundleConditions == null) return this.evaluatePermission(permission);
        if (bundlePermissions == null) {
            return this.evaluatePermission(permission);
        }
        HashMap hashMap = this.bundleConditions;
        synchronized (hashMap) {
            conditionArray = (Condition[])this.bundleConditions.get(bundlePermissions);
            if (conditionArray == null) {
                conditionArray = this.getConditions(bundlePermissions.getBundle());
                this.bundleConditions.put(bundlePermissions, conditionArray);
            }
        }
        if (conditionArray == ABSTAIN_LIST) {
            return DECISION_ABSTAIN;
        }
        if (conditionArray == SATISFIED_LIST) {
            return this.evaluatePermission(permission);
        }
        boolean bl = true;
        ArrayList<Condition> arrayList = null;
        Decision decision = null;
        int n = 0;
        while (n < conditionArray.length) {
            block21: {
                block23: {
                    Condition condition;
                    block22: {
                        condition = conditionArray[n];
                        if (condition == null) break block21;
                        if (this.isPostponed(condition)) break block22;
                        boolean bl2 = condition.isMutable();
                        if (condition.isSatisfied()) {
                            if (!bl2) {
                                conditionArray[n] = null;
                            }
                            break block23;
                        } else {
                            if (bl2) return DECISION_ABSTAIN;
                            HashMap hashMap2 = this.bundleConditions;
                            synchronized (hashMap2) {
                                this.bundleConditions.put(bundlePermissions, ABSTAIN_LIST);
                                return DECISION_ABSTAIN;
                            }
                        }
                    }
                    if (decision == null) {
                        decision = this.evaluatePermission(permission);
                    }
                    if (decision == DECISION_ABSTAIN) {
                        return decision;
                    }
                    if (arrayList == null) {
                        arrayList = new ArrayList<Condition>(1);
                    }
                    arrayList.add(condition);
                }
                bl &= conditionArray[n] == null;
            }
            ++n;
        }
        if (bl) {
            HashMap hashMap3 = this.bundleConditions;
            synchronized (hashMap3) {
                this.bundleConditions.put(bundlePermissions, SATISFIED_LIST);
            }
        }
        if (decision == null) return this.evaluatePermission(permission);
        return new Decision(decision.decision | 8, arrayList.toArray(new Condition[arrayList.size()]), this, bundlePermissions);
    }

    private boolean isPostponed(Condition condition) {
        return condition.isPostponed() && this.securityAdmin.getSupportedSecurityManager() != null;
    }

    private Decision evaluatePermission(Permission permission) {
        return this.permissionInfoCollection.implies(permission) ? (this.deny ? DECISION_DENIED : DECISION_GRANTED) : DECISION_ABSTAIN;
    }

    public String toString() {
        return this.getEncoded();
    }

    public String getEncoded() {
        return SecurityRow.getEncoded(this.name, this.conditionInfos, this.internalGetPermissionInfos(), this.deny);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ConditionalPermissionInfo)) {
            return false;
        }
        return this.getEncoded().equals(((ConditionalPermissionInfo)object).getEncoded());
    }

    public int hashCode() {
        return SecurityRow.getHashCode(this.name, this.internalGetConditionInfos(), this.internalGetPermissionInfos(), this.getAccessDecision());
    }

    static int getHashCode(String string, ConditionInfo[] conditionInfoArray, PermissionInfo[] permissionInfoArray, String string2) {
        int n = 527 + string2.hashCode();
        int n2 = 0;
        while (n2 < conditionInfoArray.length) {
            n = 31 * n + conditionInfoArray[n2].hashCode();
            ++n2;
        }
        n2 = 0;
        while (n2 < permissionInfoArray.length) {
            n = 31 * n + permissionInfoArray[n2].hashCode();
            ++n2;
        }
        if (string != null) {
            n = 31 * n + string.hashCode();
        }
        return n;
    }

    static String getEncoded(String string, ConditionInfo[] conditionInfoArray, PermissionInfo[] permissionInfoArray, boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("deny");
        } else {
            stringBuffer.append("allow");
        }
        stringBuffer.append(" { ");
        if (conditionInfoArray != null) {
            n = 0;
            while (n < conditionInfoArray.length) {
                stringBuffer.append(conditionInfoArray[n].getEncoded()).append(' ');
                ++n;
            }
        }
        if (permissionInfoArray != null) {
            n = 0;
            while (n < permissionInfoArray.length) {
                stringBuffer.append(permissionInfoArray[n].getEncoded()).append(' ');
                ++n;
            }
        }
        stringBuffer.append('}');
        if (string != null) {
            stringBuffer.append(" \"");
            SecurityRow.escapeString(string, stringBuffer);
            stringBuffer.append('\"');
        }
        return stringBuffer.toString();
    }

    PermissionInfoCollection getPermissionInfoCollection() {
        return this.permissionInfoCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCaches() {
        this.permissionInfoCollection.clearPermissionCache();
        if (this.bundleConditions != null) {
            HashMap hashMap = this.bundleConditions;
            synchronized (hashMap) {
                this.bundleConditions.clear();
            }
        }
    }

    static class Decision {
        final int decision;
        final Condition[] postponed;
        private final SecurityRow row;
        private final BundlePermissions bundlePermissions;

        Decision(int n, Condition[] conditionArray, SecurityRow securityRow, BundlePermissions bundlePermissions) {
            this.decision = n;
            this.postponed = conditionArray;
            this.row = securityRow;
            this.bundlePermissions = bundlePermissions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleImmutable(Condition condition, boolean bl, boolean bl2) {
            if (bl2 || !condition.isPostponed()) {
                return;
            }
            if (bl) {
                HashMap hashMap = this.row.bundleConditions;
                synchronized (hashMap) {
                    Condition[] conditionArray = (Condition[])this.row.bundleConditions.get(this.bundlePermissions);
                    boolean bl3 = true;
                    int n = 0;
                    while (n < conditionArray.length) {
                        if (conditionArray[n] == condition && bl) {
                            conditionArray[n] = null;
                        }
                        bl3 &= conditionArray[n] == null;
                        ++n;
                    }
                    if (bl3) {
                        this.row.bundleConditions.put(this.bundlePermissions, SATISFIED_LIST);
                    }
                }
            }
            HashMap hashMap = this.row.bundleConditions;
            synchronized (hashMap) {
                this.row.bundleConditions.put(this.bundlePermissions, ABSTAIN_LIST);
            }
        }
    }
}

