/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Iterator;
import org.eclipse.osgi.framework.internal.core.AliasMapper;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Filter;
import org.osgi.framework.Version;

public class NativeCodeSpecificationImpl
extends VersionConstraintImpl
implements NativeCodeSpecification {
    private static final NativeCodeDescription[] EMPTY_NATIVECODEDESCRIPTIONS = new NativeCodeDescription[0];
    private static AliasMapper aliasMapper = new AliasMapper();
    private NativeCodeDescription[] possibleSuppliers;
    private boolean optional;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeCodeDescription[] getPossibleSuppliers() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.possibleSuppliers == null) {
                return EMPTY_NATIVECODEDESCRIPTIONS;
            }
            return this.possibleSuppliers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPossibleSuppliers(NativeCodeDescription[] nativeCodeDescriptionArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.possibleSuppliers = nativeCodeDescriptionArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOptional() {
        Object object = this.monitor;
        synchronized (object) {
            return this.optional;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOptional(boolean bl) {
        Object object = this.monitor;
        synchronized (object) {
            this.optional = bl;
        }
    }

    public boolean isSatisfiedBy(BaseDescription baseDescription) {
        if (!(baseDescription instanceof NativeCodeDescription)) {
            return false;
        }
        State state = this.getBundle().getContainingState();
        if (state == null) {
            return false;
        }
        Dictionary[] dictionaryArray = state.getPlatformProperties();
        NativeCodeDescription nativeCodeDescription = (NativeCodeDescription)baseDescription;
        Filter filter = nativeCodeDescription.getFilter();
        boolean bl = false;
        int n = 0;
        while (n < dictionaryArray.length && !bl) {
            if (filter == null || filter.matchCase(dictionaryArray[n])) {
                Object object;
                int n2;
                Object object2;
                Object object3;
                Object object4;
                String[] stringArray = nativeCodeDescription.getOSNames();
                if (stringArray.length == 0) {
                    bl = true;
                } else {
                    object4 = dictionaryArray[n].get("org.osgi.framework.os.name");
                    Object object5 = object3 = object4 == null || !(object4 instanceof String) ? object4 : aliasMapper.aliasOSName((String)object4);
                    if (object3 instanceof Collection) {
                        object2 = ((Collection)object3).toArray();
                    } else {
                        Object[] objectArray;
                        if (object3 == null) {
                            objectArray = new Object[]{};
                        } else {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = object3;
                        }
                        object2 = objectArray;
                    }
                    n2 = 0;
                    while (n2 < stringArray.length && !bl) {
                        object = aliasMapper.aliasOSName(stringArray[n2]);
                        int n3 = 0;
                        while (n3 < ((Object[])object2).length) {
                            if (object instanceof String) {
                                if (object2[n3].equals(object)) {
                                    bl = true;
                                }
                            } else {
                                Iterator iterator = ((Collection)object).iterator();
                                while (iterator.hasNext() && !bl) {
                                    if (!object2[n3].equals(iterator.next())) continue;
                                    bl = true;
                                }
                            }
                            ++n3;
                        }
                        ++n2;
                    }
                }
                if (bl) {
                    bl = false;
                    object4 = nativeCodeDescription.getProcessors();
                    if (((V)object4).length == 0) {
                        bl = true;
                    } else {
                        object3 = dictionaryArray[n].get("org.osgi.framework.processor");
                        Object object6 = object2 = object3 == null || !(object3 instanceof String) ? object3 : aliasMapper.aliasProcessor((String)object3);
                        if (object2 != null) {
                            n2 = 0;
                            while (n2 < ((V)object4).length && !bl) {
                                object = aliasMapper.aliasProcessor((String)object4[n2]);
                                if (object2.equals(object)) {
                                    bl = true;
                                }
                                ++n2;
                            }
                        }
                    }
                    if (!bl) {
                        return false;
                    }
                    bl = false;
                    object3 = nativeCodeDescription.getLanguages();
                    if (((V)object3).length == 0) {
                        bl = true;
                    } else {
                        object2 = dictionaryArray[n].get("org.osgi.framework.language");
                        if (object2 != null) {
                            n2 = 0;
                            while (n2 < ((V)object3).length && !bl) {
                                if (object2 instanceof String ? ((String)object2).equalsIgnoreCase((String)object3[n2]) : object2.equals(object3[n2])) {
                                    bl = true;
                                }
                                ++n2;
                            }
                        }
                    }
                    if (!bl) {
                        return false;
                    }
                    bl = false;
                    object2 = nativeCodeDescription.getOSVersions();
                    if (((Object[])object2).length == 0 || dictionaryArray[n].get("org.osgi.framework.os.version") == null) {
                        bl = true;
                    } else {
                        Version version;
                        try {
                            version = Version.parseVersion((String)dictionaryArray[n].get("org.osgi.framework.os.version"));
                        }
                        catch (Exception exception) {
                            version = Version.emptyVersion;
                        }
                        int n4 = 0;
                        while (n4 < ((Object)object2).length && !bl) {
                            if (((VersionRange)object2[n4]).isIncluded(version)) {
                                bl = true;
                            }
                            ++n4;
                        }
                    }
                }
            }
            ++n;
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        NativeCodeDescription[] nativeCodeDescriptionArray = this.getPossibleSuppliers();
        int n = 0;
        while (n < nativeCodeDescriptionArray.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(nativeCodeDescriptionArray[n].toString());
            ++n;
        }
        return stringBuffer.toString();
    }
}

