/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.hooks.service.ListenerHook;

class FilteredServiceListener
implements ServiceListener,
ListenerHook.ListenerInfo {
    private final FilterImpl filter;
    private final ServiceListener listener;
    private final BundleContextImpl context;
    private final boolean allservices;
    private final String objectClass;
    private boolean matched;
    private volatile boolean removed;

    FilteredServiceListener(BundleContextImpl bundleContextImpl, ServiceListener serviceListener, String string) throws InvalidSyntaxException {
        if (string == null) {
            this.filter = null;
            this.objectClass = null;
        } else {
            FilterImpl filterImpl = FilterImpl.newInstance(string);
            String string2 = filterImpl.getRequiredObjectClass();
            if (string2 == null) {
                this.objectClass = null;
                this.filter = filterImpl;
            } else {
                this.objectClass = string2.intern();
                this.filter = string.equals(FilteredServiceListener.getObjectClassFilterString(this.objectClass)) ? null : filterImpl;
            }
        }
        this.matched = false;
        this.removed = false;
        this.listener = serviceListener;
        this.context = bundleContextImpl;
        this.allservices = serviceListener instanceof AllServiceListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent serviceEvent) {
        ServiceReferenceImpl serviceReferenceImpl;
        block15: {
            Object object;
            block14: {
                serviceReferenceImpl = (ServiceReferenceImpl)serviceEvent.getServiceReference();
                if (this.objectClass != null) {
                    object = serviceReferenceImpl.getClasses();
                    int n = ((String[])object).length;
                    int n2 = 0;
                    while (n2 < n) {
                        if (object[n2] != this.objectClass) {
                            ++n2;
                            continue;
                        }
                        break block14;
                    }
                    return;
                }
            }
            if (!ServiceRegistry.hasListenServicePermission(serviceEvent, this.context)) {
                return;
            }
            if (Debug.DEBUG_EVENTS) {
                object = String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(this));
                Debug.println("filterServiceEvent(" + (String)object + ", \"" + this.getFilter() + "\", " + serviceReferenceImpl.getRegistration().getProperties() + ")");
            }
            if (this.filter != null) {
                boolean bl = this.filter.match(serviceReferenceImpl);
                FilteredServiceListener filteredServiceListener = this;
                synchronized (filteredServiceListener) {
                    if (bl) {
                        this.matched = true;
                        break block15;
                    }
                    if (this.matched) {
                        this.matched = false;
                        if (serviceEvent.getType() == 2) {
                            serviceEvent = new ServiceEvent(8, serviceReferenceImpl);
                            break block15;
                        }
                    }
                }
                return;
            }
        }
        if (this.allservices || ServiceRegistry.isAssignableTo(this.context, serviceReferenceImpl)) {
            if (Debug.DEBUG_EVENTS) {
                String string = String.valueOf(this.listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(this.listener));
                Debug.println("dispatchFilteredServiceEvent(" + string + ")");
            }
            this.listener.serviceChanged(serviceEvent);
        }
    }

    public String toString() {
        String string = this.getFilter();
        if (string == null) {
            string = "";
        }
        return String.valueOf(this.listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(this.listener)) + string;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public String getFilter() {
        if (this.filter != null) {
            return this.filter.toString();
        }
        return FilteredServiceListener.getObjectClassFilterString(this.objectClass);
    }

    public boolean isRemoved() {
        return this.removed;
    }

    void markRemoved() {
        this.removed = true;
    }

    private static String getObjectClassFilterString(String string) {
        if (string == null) {
            return null;
        }
        return "(objectClass=" + string + ")";
    }
}

