/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import java.util.Dictionary;
import java.util.List;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.internal.serviceregistry.ServiceProperties;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.eclipse.osgi.internal.serviceregistry.ServiceUse;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceRegistrationImpl
implements ServiceRegistration,
Comparable {
    private final Framework framework;
    private final ServiceRegistry registry;
    private final BundleContextImpl context;
    private final Bundle bundle;
    private final String[] clazzes;
    private final Object service;
    private ServiceReferenceImpl reference;
    private List contextsUsing;
    private ServiceProperties properties;
    private final long serviceid;
    private int serviceranking;
    private final Object registrationLock = new Object();
    private int state = 0;
    private static final int REGISTERED = 0;
    private static final int UNREGISTERING = 1;
    private static final int UNREGISTERED = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceRegistrationImpl(ServiceRegistry serviceRegistry, BundleContextImpl bundleContextImpl, String[] stringArray, Object object) {
        this.registry = serviceRegistry;
        this.context = bundleContextImpl;
        this.bundle = bundleContextImpl.getBundleImpl();
        this.framework = bundleContextImpl.getFramework();
        this.clazzes = stringArray;
        this.service = object;
        this.serviceid = serviceRegistry.getNextServiceId();
        Object object2 = this.registrationLock;
        synchronized (object2) {
            this.contextsUsing = null;
            this.reference = new ServiceReferenceImpl(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(Dictionary dictionary) {
        ServiceReferenceImpl serviceReferenceImpl;
        ServiceRegistry serviceRegistry = this.registry;
        synchronized (serviceRegistry) {
            this.context.checkValid();
            Object object = this.registrationLock;
            synchronized (object) {
                serviceReferenceImpl = this.reference;
                this.properties = this.createProperties(dictionary);
            }
            if (Debug.DEBUG_SERVICES) {
                Debug.println("registerService[" + this.bundle + "](" + this + ")");
            }
            this.registry.addServiceRegistration(this.context, this);
        }
        this.registry.publishServiceEvent(1, serviceReferenceImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Dictionary dictionary) {
        ServiceReferenceImpl serviceReferenceImpl;
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.state != 0) {
                throw new IllegalStateException(Msg.SERVICE_ALREADY_UNREGISTERED_EXCEPTION);
            }
            serviceReferenceImpl = this.reference;
            this.properties = this.createProperties(dictionary);
        }
        this.registry.publishServiceEvent(2, serviceReferenceImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        ServiceReferenceImpl serviceReferenceImpl;
        BundleContextImpl[] bundleContextImplArray;
        ServiceRegistry serviceRegistry = this.registry;
        synchronized (serviceRegistry) {
            bundleContextImplArray = this.registrationLock;
            synchronized (this.registrationLock) {
                if (this.state != 0) {
                    throw new IllegalStateException(Msg.SERVICE_ALREADY_UNREGISTERED_EXCEPTION);
                }
                if (Debug.DEBUG_SERVICES) {
                    Debug.println("unregisterService[" + this.bundle + "](" + this + ")");
                }
                this.registry.removeServiceRegistration(this.context, this);
                this.state = 1;
                serviceReferenceImpl = this.reference;
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        {
            this.registry.publishServiceEvent(4, serviceReferenceImpl);
            int n = 0;
            bundleContextImplArray = null;
            Object object = this.registrationLock;
            synchronized (object) {
                this.state = 2;
                if (this.contextsUsing != null && (n = this.contextsUsing.size()) > 0) {
                    if (Debug.DEBUG_SERVICES) {
                        Debug.println("unregisterService: releasing users");
                    }
                    bundleContextImplArray = this.contextsUsing.toArray(new BundleContextImpl[n]);
                }
            }
            int n2 = 0;
            while (n2 < n) {
                this.releaseService(bundleContextImplArray[n2]);
                ++n2;
            }
            Object object2 = this.registrationLock;
            synchronized (object2) {
                this.contextsUsing = null;
                this.reference = null;
            }
            return;
        }
    }

    public ServiceReference getReference() {
        return this.getReferenceImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceReferenceImpl getReferenceImpl() {
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.reference == null) {
                throw new IllegalStateException(Msg.SERVICE_ALREADY_UNREGISTERED_EXCEPTION);
            }
            return this.reference;
        }
    }

    private ServiceProperties createProperties(Dictionary dictionary) {
        ServiceProperties serviceProperties = new ServiceProperties(dictionary);
        serviceProperties.set("objectClass", this.clazzes, true);
        serviceProperties.set("service.id", new Long(this.serviceid), true);
        serviceProperties.setReadOnly();
        Object object = serviceProperties.getProperty("service.ranking");
        this.serviceranking = object instanceof Integer ? (Integer)object : 0;
        return serviceProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceProperties getProperties() {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.properties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getProperty(String string) {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.properties.getProperty(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getPropertyKeys() {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.properties.getPropertyKeys();
        }
    }

    long getId() {
        return this.serviceid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getRanking() {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.serviceranking;
        }
    }

    String[] getClasses() {
        return this.clazzes;
    }

    Object getServiceObject() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bundle getBundle() {
        Object object = this.registrationLock;
        synchronized (object) {
            block4: {
                if (this.reference != null) break block4;
                return null;
            }
            return this.bundle;
        }
    }

    /*
     * Exception decompiling
     */
    Object getService(BundleContextImpl var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[UNCONDITIONALDOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean ungetService(BundleContextImpl bundleContextImpl) {
        ServiceUse serviceUse;
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.state == 2) {
                return false;
            }
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println("ungetService[" + bundleContextImpl.getBundleImpl() + "](" + this + ")");
        }
        if ((object = bundleContextImpl.getServicesInUseMap()) == null) {
            return false;
        }
        Object object2 = object;
        synchronized (object2) {
            serviceUse = (ServiceUse)object.get(this);
            if (serviceUse == null) {
                return false;
            }
        }
        object2 = serviceUse;
        synchronized (object2) {
            if (!serviceUse.ungetService()) return true;
            Object object3 = object;
            synchronized (object3) {
                Object object4 = this.registrationLock;
                synchronized (object4) {
                    object.remove(this);
                    this.contextsUsing.remove(bundleContextImpl);
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseService(BundleContextImpl bundleContextImpl) {
        ServiceUse serviceUse;
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.reference == null) {
                return;
            }
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println("releaseService[" + bundleContextImpl.getBundleImpl() + "](" + this + ")");
        }
        if ((object = bundleContextImpl.getServicesInUseMap()) == null) {
            return;
        }
        Object object2 = object;
        synchronized (object2) {
            Object object3 = this.registrationLock;
            synchronized (object3) {
                serviceUse = (ServiceUse)object.remove(this);
                if (serviceUse == null) {
                    return;
                }
                if (this.contextsUsing != null) {
                    this.contextsUsing.remove(bundleContextImpl);
                }
            }
        }
        object2 = serviceUse;
        synchronized (object2) {
            serviceUse.releaseService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bundle[] getUsingBundles() {
        Object object = this.registrationLock;
        synchronized (object) {
            int n;
            block9: {
                block8: {
                    block7: {
                        if (this.state != 2) break block7;
                        return null;
                    }
                    if (this.contextsUsing != null) break block8;
                    return null;
                }
                n = this.contextsUsing.size();
                if (n != 0) break block9;
                return null;
            }
            Bundle[] bundleArray = new Bundle[n];
            int n2 = 0;
            while (n2 < n) {
                bundleArray[n2] = ((BundleContextImpl)this.contextsUsing.get(n2)).getBundleImpl();
                ++n2;
            }
            return bundleArray;
        }
    }

    boolean isAssignableTo(Bundle bundle, String string) {
        return this.framework.isServiceAssignableTo(this.bundle, bundle, string, this.service.getClass());
    }

    public String toString() {
        int n = this.clazzes.length;
        StringBuffer stringBuffer = new StringBuffer(50 * n);
        stringBuffer.append('{');
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.clazzes[n2]);
            ++n2;
        }
        stringBuffer.append("}=");
        stringBuffer.append(this.getProperties().toString());
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        long l;
        int n;
        ServiceRegistrationImpl serviceRegistrationImpl = (ServiceRegistrationImpl)object;
        int n2 = this.getRanking();
        if (n2 != (n = serviceRegistrationImpl.getRanking())) {
            if (n2 < n) {
                return 1;
            }
            return -1;
        }
        long l2 = this.getId();
        if (l2 == (l = serviceRegistrationImpl.getId())) {
            return 0;
        }
        if (l2 < l) {
            return -1;
        }
        return 1;
    }
}

