/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.internal.serviceregistry.FilteredServiceListener;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistrationImpl;
import org.eclipse.osgi.internal.serviceregistry.ShrinkableCollection;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;

public class ServiceRegistry {
    public static final int SERVICEEVENT = 3;
    private static final String findHookName;
    private static final String eventHookName;
    private static final String listenerHookName;
    private final Map publishedServicesByClass;
    private final List allPublishedServices;
    private final Map publishedServicesByContext;
    private long serviceid;
    private final Map serviceEventListeners;
    private static final int initialCapacity = 50;
    private static final int initialSubCapacity = 10;
    private final Framework framework;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.framework.hooks.service.FindHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        findHookName = clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.framework.hooks.service.EventHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        eventHookName = clazz2.getName();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.osgi.framework.hooks.service.ListenerHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        listenerHookName = clazz3.getName();
    }

    public ServiceRegistry(Framework framework) {
        this.framework = framework;
        this.serviceid = 1L;
        this.publishedServicesByClass = new HashMap(50);
        this.publishedServicesByContext = new HashMap(50);
        this.allPublishedServices = new ArrayList(50);
        this.serviceEventListeners = new HashMap(50);
    }

    public ServiceRegistrationImpl registerService(BundleContextImpl bundleContextImpl, String[] stringArray, Object object, Dictionary dictionary) {
        String string;
        if (object == null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Service object is null");
            }
            throw new IllegalArgumentException(Msg.SERVICE_ARGUMENT_NULL_EXCEPTION);
        }
        int n = stringArray.length;
        if (n == 0) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Classes array is empty");
            }
            throw new IllegalArgumentException(Msg.SERVICE_EMPTY_CLASS_LIST_EXCEPTION);
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2].intern();
            if (!arrayList.contains(string2)) {
                arrayList.add(string2);
            }
            ++n2;
        }
        n = arrayList.size();
        stringArray = arrayList.toArray(new String[n]);
        ServiceRegistry.checkRegisterServicePermission(stringArray);
        if (!(object instanceof ServiceFactory) && (string = ServiceRegistry.checkServiceClass(stringArray, object)) != null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Service object is not an instanceof " + string);
            }
            throw new IllegalArgumentException(NLS.bind(Msg.SERVICE_NOT_INSTANCEOF_CLASS_EXCEPTION, string));
        }
        ServiceRegistrationImpl serviceRegistrationImpl = new ServiceRegistrationImpl(this, bundleContextImpl, stringArray, object);
        serviceRegistrationImpl.register(dictionary);
        if (arrayList.contains(listenerHookName)) {
            this.notifyNewListenerHook(serviceRegistrationImpl);
        }
        return serviceRegistrationImpl;
    }

    public ServiceReferenceImpl[] getServiceReferences(BundleContextImpl bundleContextImpl, String string, String string2, boolean bl) throws InvalidSyntaxException {
        if (Debug.DEBUG_SERVICES) {
            Debug.println(String.valueOf(bl ? "getAllServiceReferences(" : "getServiceReferences(") + string + ", \"" + string2 + "\")");
        }
        Filter filter = string2 == null ? null : bundleContextImpl.createFilter(string2);
        List list = ServiceRegistry.changeRegistrationsToReferences(this.lookupServiceRegistrations(string, filter));
        Object object = list.iterator();
        while (object.hasNext()) {
            ServiceReferenceImpl serviceReferenceImpl = (ServiceReferenceImpl)object.next();
            if (bl || ServiceRegistry.isAssignableTo(bundleContextImpl, serviceReferenceImpl)) {
                try {
                    ServiceRegistry.checkGetServicePermission(serviceReferenceImpl);
                }
                catch (SecurityException securityException) {
                    object.remove();
                }
                continue;
            }
            object.remove();
        }
        object = new ShrinkableCollection(list);
        this.notifyFindHooks(bundleContextImpl, string, string2, bl, (Collection)object);
        int n = list.size();
        if (n == 0) {
            return null;
        }
        return list.toArray(new ServiceReferenceImpl[n]);
    }

    public ServiceReferenceImpl getServiceReference(BundleContextImpl bundleContextImpl, String string) {
        block4: {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("getServiceReference(" + string + ")");
            }
            try {
                ServiceReferenceImpl[] serviceReferenceImplArray = this.getServiceReferences(bundleContextImpl, string, null, false);
                if (serviceReferenceImplArray != null) {
                    return serviceReferenceImplArray[0];
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                if (!Debug.DEBUG_GENERAL) break block4;
                Debug.println("InvalidSyntaxException w/ null filter" + invalidSyntaxException.getMessage());
                Debug.printStackTrace(invalidSyntaxException);
            }
        }
        return null;
    }

    public Object getService(BundleContextImpl bundleContextImpl, ServiceReferenceImpl serviceReferenceImpl) {
        ServiceRegistry.checkGetServicePermission(serviceReferenceImpl);
        return serviceReferenceImpl.getRegistration().getService(bundleContextImpl);
    }

    public boolean ungetService(BundleContextImpl bundleContextImpl, ServiceReferenceImpl serviceReferenceImpl) {
        ServiceRegistrationImpl serviceRegistrationImpl = serviceReferenceImpl.getRegistration();
        return serviceRegistrationImpl.ungetService(bundleContextImpl);
    }

    public ServiceReferenceImpl[] getRegisteredServices(BundleContextImpl bundleContextImpl) {
        List list = ServiceRegistry.changeRegistrationsToReferences(this.lookupServiceRegistrations(bundleContextImpl));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ServiceReferenceImpl serviceReferenceImpl = (ServiceReferenceImpl)iterator.next();
            try {
                ServiceRegistry.checkGetServicePermission(serviceReferenceImpl);
            }
            catch (SecurityException securityException) {
                iterator.remove();
            }
        }
        int n = list.size();
        if (n == 0) {
            return null;
        }
        return list.toArray(new ServiceReferenceImpl[n]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReferenceImpl[] getServicesInUse(BundleContextImpl bundleContextImpl) {
        List list;
        Map map = bundleContextImpl.getServicesInUseMap();
        if (map == null) {
            return null;
        }
        Object object = map;
        synchronized (object) {
            block9: {
                if (map.size() != 0) break block9;
                return null;
            }
            list = ServiceRegistry.changeRegistrationsToReferences(new ArrayList(map.keySet()));
        }
        object = list.iterator();
        while (object.hasNext()) {
            ServiceReferenceImpl serviceReferenceImpl = (ServiceReferenceImpl)object.next();
            try {
                ServiceRegistry.checkGetServicePermission(serviceReferenceImpl);
            }
            catch (SecurityException securityException) {
                object.remove();
            }
        }
        int n = list.size();
        if (n == 0) {
            return null;
        }
        return list.toArray(new ServiceReferenceImpl[n]);
    }

    public void unregisterServices(BundleContextImpl bundleContextImpl) {
        List list = this.lookupServiceRegistrations(bundleContextImpl);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ServiceRegistrationImpl serviceRegistrationImpl = (ServiceRegistrationImpl)iterator.next();
            try {
                serviceRegistrationImpl.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseServicesInUse(BundleContextImpl bundleContextImpl) {
        ArrayList arrayList;
        Map map = bundleContextImpl.getServicesInUseMap();
        if (map == null) {
            return;
        }
        Object object = map;
        synchronized (object) {
            if (map.size() == 0) {
                return;
            }
            arrayList = new ArrayList(map.keySet());
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println("Releasing services");
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            ServiceRegistrationImpl serviceRegistrationImpl = (ServiceRegistrationImpl)object.next();
            serviceRegistrationImpl.releaseService(bundleContextImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceListener(BundleContextImpl bundleContextImpl, ServiceListener serviceListener, String string) throws InvalidSyntaxException {
        FilteredServiceListener filteredServiceListener;
        Object object;
        if (Debug.DEBUG_EVENTS) {
            object = String.valueOf(serviceListener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(serviceListener));
            Debug.println("addServiceListener[" + bundleContextImpl.getBundleImpl() + "](" + (String)object + ", \"" + string + "\")");
        }
        object = new FilteredServiceListener(bundleContextImpl, serviceListener, string);
        List<FilteredServiceListener> list = this.serviceEventListeners;
        synchronized (list) {
            Map map = (Map)this.serviceEventListeners.get(bundleContextImpl);
            if (map == null) {
                map = new CopyOnWriteIdentityMap();
                this.serviceEventListeners.put(bundleContextImpl, map);
            }
            filteredServiceListener = (FilteredServiceListener)map.put(serviceListener, object);
        }
        if (filteredServiceListener != null) {
            filteredServiceListener.markRemoved();
            list = Collections.singletonList(filteredServiceListener);
            this.notifyListenerHooks(list, false);
        }
        list = Collections.singletonList(object);
        this.notifyListenerHooks(list, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(BundleContextImpl bundleContextImpl, ServiceListener serviceListener) {
        Object object;
        if (Debug.DEBUG_EVENTS) {
            object = String.valueOf(serviceListener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(serviceListener));
            Debug.println("removeServiceListener[" + bundleContextImpl.getBundleImpl() + "](" + (String)object + ")");
        }
        Object object2 = this.serviceEventListeners;
        synchronized (object2) {
            Map map = (Map)this.serviceEventListeners.get(bundleContextImpl);
            if (map == null) {
                return;
            }
            object = (FilteredServiceListener)map.remove(serviceListener);
        }
        if (object == null) {
            return;
        }
        ((FilteredServiceListener)object).markRemoved();
        object2 = Collections.singletonList(object);
        this.notifyListenerHooks((Collection)object2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllServiceListeners(BundleContextImpl bundleContextImpl) {
        Map map;
        Object object = this.serviceEventListeners;
        synchronized (object) {
            map = (Map)this.serviceEventListeners.remove(bundleContextImpl);
        }
        if (map == null || map.size() == 0) {
            return;
        }
        object = map.values();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            FilteredServiceListener filteredServiceListener = (FilteredServiceListener)iterator.next();
            filteredServiceListener.markRemoved();
        }
        this.notifyListenerHooks((Collection)object, false);
    }

    void publishServiceEvent(int n, ServiceReferenceImpl serviceReferenceImpl) {
        final ServiceEvent serviceEvent = new ServiceEvent(n, serviceReferenceImpl);
        if (System.getSecurityManager() == null) {
            this.publishServiceEventPrivileged(serviceEvent);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServiceRegistry.this.publishServiceEventPrivileged(serviceEvent);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishServiceEventPrivileged(ServiceEvent serviceEvent) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        HashMap hashMap;
        Object object5 = this.serviceEventListeners;
        synchronized (object5) {
            hashMap = new HashMap(this.serviceEventListeners.size());
            object4 = this.serviceEventListeners.entrySet().iterator();
            while (object4.hasNext()) {
                object3 = object4.next();
                object2 = (BundleContextImpl)object3.getKey();
                object = (Map)object3.getValue();
                if (object.isEmpty()) continue;
                hashMap.put((BundleContextImpl)object2, object.entrySet());
            }
        }
        object5 = hashMap.keySet();
        this.notifyEventHooksPrivileged(serviceEvent, (Collection)object5);
        if (hashMap.isEmpty()) {
            return;
        }
        object4 = this.framework.newListenerQueue();
        object3 = hashMap.entrySet().iterator();
        while (object3.hasNext()) {
            object2 = (Map.Entry)object3.next();
            object = (BundleContextImpl)object2.getKey();
            Set set = (Set)object2.getValue();
            ((ListenerQueue)object4).queueListeners(set, (EventDispatcher)object);
        }
        ((ListenerQueue)object4).dispatchEventSynchronous(3, serviceEvent);
    }

    synchronized long getNextServiceId() {
        long l = this.serviceid++;
        return l;
    }

    void addServiceRegistration(BundleContextImpl bundleContextImpl, ServiceRegistrationImpl serviceRegistrationImpl) {
        int n;
        ArrayList<ServiceRegistrationImpl> arrayList = (ArrayList<ServiceRegistrationImpl>)this.publishedServicesByContext.get(bundleContextImpl);
        if (arrayList == null) {
            arrayList = new ArrayList<ServiceRegistrationImpl>(10);
            this.publishedServicesByContext.put(bundleContextImpl, arrayList);
        }
        arrayList.add(serviceRegistrationImpl);
        String[] stringArray = serviceRegistrationImpl.getClasses();
        int n2 = 0;
        int n3 = stringArray.length;
        while (n2 < n3) {
            String string = stringArray[n2];
            ArrayList<ServiceRegistrationImpl> arrayList2 = (ArrayList<ServiceRegistrationImpl>)this.publishedServicesByClass.get(string);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<ServiceRegistrationImpl>(10);
                this.publishedServicesByClass.put(string, arrayList2);
            }
            n = -Collections.binarySearch(arrayList2, serviceRegistrationImpl) - 1;
            arrayList2.add(n, serviceRegistrationImpl);
            ++n2;
        }
        n = -Collections.binarySearch(this.allPublishedServices, serviceRegistrationImpl) - 1;
        this.allPublishedServices.add(n, serviceRegistrationImpl);
    }

    void removeServiceRegistration(BundleContextImpl bundleContextImpl, ServiceRegistrationImpl serviceRegistrationImpl) {
        List list = (List)this.publishedServicesByContext.get(bundleContextImpl);
        if (list != null) {
            list.remove(serviceRegistrationImpl);
        }
        String[] stringArray = serviceRegistrationImpl.getClasses();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String string = stringArray[n];
            List list2 = (List)this.publishedServicesByClass.get(string);
            list2.remove(serviceRegistrationImpl);
            ++n;
        }
        this.allPublishedServices.remove(serviceRegistrationImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List lookupServiceRegistrations(String string, Filter filter) {
        List list;
        Object object = this;
        synchronized (object) {
            list = string == null ? this.allPublishedServices : (List)this.publishedServicesByClass.get(string);
            if (list == null || list.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            list = new ArrayList(list);
        }
        if (filter == null) {
            return list;
        }
        object = list.iterator();
        while (object.hasNext()) {
            ServiceRegistrationImpl serviceRegistrationImpl = (ServiceRegistrationImpl)object.next();
            if (filter.match(serviceRegistrationImpl.getReferenceImpl())) continue;
            object.remove();
        }
        return list;
    }

    private synchronized List lookupServiceRegistrations(BundleContextImpl bundleContextImpl) {
        List list = (List)this.publishedServicesByContext.get(bundleContextImpl);
        if (list == null || list.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(list);
    }

    private static List changeRegistrationsToReferences(List list) {
        ListIterator<ServiceReferenceImpl> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            ServiceRegistrationImpl serviceRegistrationImpl = (ServiceRegistrationImpl)listIterator.next();
            listIterator.set(serviceRegistrationImpl.getReferenceImpl());
        }
        return list;
    }

    private static void checkRegisterServicePermission(String[] stringArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            securityManager.checkPermission(new ServicePermission(stringArray[n], "register"));
            ++n;
        }
    }

    private static void checkGetServicePermission(ServiceReference serviceReference) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        securityManager.checkPermission(new ServicePermission(serviceReference, "get"));
    }

    static boolean hasListenServicePermission(ServiceEvent serviceEvent, BundleContextImpl bundleContextImpl) {
        BundleProtectionDomain bundleProtectionDomain = bundleContextImpl.getBundleImpl().getProtectionDomain();
        if (bundleProtectionDomain == null) {
            return true;
        }
        return bundleProtectionDomain.implies(new ServicePermission(serviceEvent.getServiceReference(), "get"));
    }

    static String checkServiceClass(String[] stringArray, final Object object) {
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return object.getClass().getClassLoader();
            }
        });
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            block4: {
                try {
                    Class<?> clazz;
                    Class<?> clazz2 = clazz = classLoader == null ? Class.forName(stringArray[n]) : classLoader.loadClass(stringArray[n]);
                    if (!clazz.isInstance(object)) {
                        return stringArray[n];
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!ServiceRegistry.extensiveCheckServiceClass(stringArray[n], object.getClass())) break block4;
                    return stringArray[n];
                }
            }
            ++n;
        }
        return null;
    }

    private static boolean extensiveCheckServiceClass(String string, Class clazz) {
        if (string.equals(clazz.getName())) {
            return false;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            if (!ServiceRegistry.extensiveCheckServiceClass(string, classArray[n])) {
                return false;
            }
            ++n;
        }
        Class clazz2 = clazz.getSuperclass();
        return clazz2 == null || ServiceRegistry.extensiveCheckServiceClass(string, clazz2);
    }

    static boolean isAssignableTo(BundleContextImpl bundleContextImpl, ServiceReferenceImpl serviceReferenceImpl) {
        AbstractBundle abstractBundle = bundleContextImpl.getBundleImpl();
        String[] stringArray = serviceReferenceImpl.getClasses();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            if (!serviceReferenceImpl.isAssignableTo(abstractBundle, stringArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void notifyFindHooks(final BundleContextImpl bundleContextImpl, final String string, final String string2, final boolean bl, final Collection collection) {
        if (System.getSecurityManager() == null) {
            this.notifyFindHooksPrivileged(bundleContextImpl, string, string2, bl, collection);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServiceRegistry.this.notifyFindHooksPrivileged(bundleContextImpl, string, string2, bl, collection);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void notifyFindHooksPrivileged(BundleContextImpl bundleContextImpl, String string, String string2, boolean bl, Collection collection) {
        BundleContextImpl bundleContextImpl2 = this.framework.getSystemBundleContext();
        if (bundleContextImpl2 == null) {
            return;
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println("notifyFindHooks(" + bundleContextImpl.getBundleImpl() + "," + string + "," + string2 + "," + bl + "," + collection + ")");
        }
        List list = this.lookupServiceRegistrations(findHookName, null);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object var13_13;
            ServiceRegistrationImpl serviceRegistrationImpl = (ServiceRegistrationImpl)iterator.next();
            Object object = serviceRegistrationImpl.getService(bundleContextImpl2);
            if (object == null) continue;
            try {
                try {
                    if (object instanceof FindHook) {
                        ((FindHook)object).find(bundleContextImpl, string, string2, bl, collection);
                    }
                }
                catch (Throwable throwable) {
                    if (Debug.DEBUG_SERVICES) {
                        Debug.println(object + ".find() exception: " + throwable.getMessage());
                        Debug.printStackTrace(throwable);
                    }
                    this.framework.getAdaptor().handleRuntimeError(throwable);
                    ServiceException serviceException = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, object.getClass().getName(), "find"), throwable);
                    this.framework.publishFrameworkEvent(2, serviceRegistrationImpl.getBundle(), serviceException);
                }
            }
            catch (Throwable throwable) {
                var13_13 = null;
                serviceRegistrationImpl.ungetService(bundleContextImpl2);
                throw throwable;
            }
            {
                var13_13 = null;
                serviceRegistrationImpl.ungetService(bundleContextImpl2);
            }
        }
        return;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifyEventHooksPrivileged(ServiceEvent serviceEvent, Collection collection) {
        BundleContextImpl bundleContextImpl = this.framework.getSystemBundleContext();
        if (bundleContextImpl == null) {
            return;
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println("notifyEventHooks(" + serviceEvent.getType() + ":" + serviceEvent.getServiceReference() + "," + collection + ")");
        }
        List list = this.lookupServiceRegistrations(eventHookName, null);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object var10_10;
            ServiceRegistrationImpl serviceRegistrationImpl = (ServiceRegistrationImpl)iterator.next();
            Object object = serviceRegistrationImpl.getService(bundleContextImpl);
            if (object == null) continue;
            try {
                try {
                    if (object instanceof EventHook) {
                        ((EventHook)object).event(serviceEvent, collection);
                    }
                }
                catch (Throwable throwable) {
                    if (Debug.DEBUG_SERVICES) {
                        Debug.println(object + ".event() exception: " + throwable.getMessage());
                        Debug.printStackTrace(throwable);
                    }
                    this.framework.getAdaptor().handleRuntimeError(throwable);
                    ServiceException serviceException = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, object.getClass().getName(), "event"), throwable);
                    this.framework.publishFrameworkEvent(2, serviceRegistrationImpl.getBundle(), serviceException);
                }
            }
            catch (Throwable throwable) {
                var10_10 = null;
                serviceRegistrationImpl.ungetService(bundleContextImpl);
                throw throwable;
            }
            {
                var10_10 = null;
                serviceRegistrationImpl.ungetService(bundleContextImpl);
            }
        }
        return;
    }

    private void notifyNewListenerHook(final ServiceRegistrationImpl serviceRegistrationImpl) {
        if (System.getSecurityManager() == null) {
            this.notifyNewListenerHookPrivileged(serviceRegistrationImpl);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServiceRegistry.this.notifyNewListenerHookPrivileged(serviceRegistrationImpl);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void notifyNewListenerHookPrivileged(ServiceRegistrationImpl serviceRegistrationImpl) {
        Object object;
        BundleContextImpl bundleContextImpl = this.framework.getSystemBundleContext();
        if (bundleContextImpl == null) {
            return;
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println("notifyNewListenerHook(" + serviceRegistrationImpl + ")");
        }
        Collection collection = new ArrayList(50);
        Object object2 = this.serviceEventListeners;
        synchronized (object2) {
            Iterator iterator = this.serviceEventListeners.values().iterator();
            while (iterator.hasNext()) {
                object = (Map)iterator.next();
                if (object.isEmpty()) continue;
                collection.addAll(object.values());
            }
        }
        collection = Collections.unmodifiableCollection(collection);
        object2 = serviceRegistrationImpl.getService(bundleContextImpl);
        if (object2 == null) {
            return;
        }
        try {
            try {
                if (object2 instanceof ListenerHook) {
                    ((ListenerHook)object2).added(collection);
                }
            }
            catch (Throwable throwable) {
                if (Debug.DEBUG_SERVICES) {
                    Debug.println(object2 + ".added() exception: " + throwable.getMessage());
                    Debug.printStackTrace(throwable);
                }
                this.framework.getAdaptor().handleRuntimeError(throwable);
                object = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, object2.getClass().getName(), "event"), throwable);
                this.framework.publishFrameworkEvent(2, serviceRegistrationImpl.getBundle(), (Throwable)object);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            serviceRegistrationImpl.ungetService(bundleContextImpl);
            throw throwable;
        }
        {
            Object var7_10 = null;
            serviceRegistrationImpl.ungetService(bundleContextImpl);
        }
    }

    private void notifyListenerHooks(final Collection collection, final boolean bl) {
        if (System.getSecurityManager() == null) {
            this.notifyListenerHooksPrivileged(collection, bl);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServiceRegistry.this.notifyListenerHooksPrivileged(collection, bl);
                    return null;
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void notifyListenerHooksPrivileged(Collection collection, boolean bl) {
        BundleContextImpl bundleContextImpl = this.framework.getSystemBundleContext();
        if (bundleContextImpl == null) {
            return;
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println("notifyListenerHooks(" + collection + "," + (bl ? "added" : "removed") + ")");
        }
        List list = this.lookupServiceRegistrations(listenerHookName, null);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object var10_10;
            ServiceRegistrationImpl serviceRegistrationImpl = (ServiceRegistrationImpl)iterator.next();
            Object object = serviceRegistrationImpl.getService(bundleContextImpl);
            if (object == null) continue;
            try {
                block10: {
                    try {
                        if (!(object instanceof ListenerHook)) break block10;
                        if (bl) {
                            ((ListenerHook)object).added(collection);
                            break block10;
                        }
                        ((ListenerHook)object).removed(collection);
                    }
                    catch (Throwable throwable) {
                        if (Debug.DEBUG_SERVICES) {
                            Debug.println(object + "." + (bl ? "added" : "removed") + "() exception: " + throwable.getMessage());
                            Debug.printStackTrace(throwable);
                        }
                        this.framework.getAdaptor().handleRuntimeError(throwable);
                        ServiceException serviceException = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, object.getClass().getName(), "event"), throwable);
                        this.framework.publishFrameworkEvent(2, serviceRegistrationImpl.getBundle(), serviceException);
                    }
                }
                var10_10 = null;
                serviceRegistrationImpl.ungetService(bundleContextImpl);
            }
            catch (Throwable throwable) {
                var10_10 = null;
                serviceRegistrationImpl.ungetService(bundleContextImpl);
                throw throwable;
            }
        }
    }
}

