/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.osgi.internal.provisional.verifier.CertificateChain;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifier;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifierFactory;
import org.eclipse.osgi.signedcontent.InvalidContentException;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentEntry;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.osgi.framework.Bundle;

public class LegacyVerifierFactory
implements CertificateVerifierFactory {
    private final SignedContentFactory signedContentFactory;

    public LegacyVerifierFactory(SignedContentFactory signedContentFactory) {
        this.signedContentFactory = signedContentFactory;
    }

    public CertificateVerifier getVerifier(File file) throws IOException {
        try {
            return new LegacyVerifier(this.signedContentFactory.getSignedContent(file));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (IOException)new IOException(generalSecurityException.getMessage()).initCause(generalSecurityException);
        }
    }

    public CertificateVerifier getVerifier(Bundle bundle) throws IOException {
        try {
            return new LegacyVerifier(this.signedContentFactory.getSignedContent(bundle));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (IOException)new IOException(generalSecurityException.getMessage()).initCause(generalSecurityException);
        }
    }

    static class LegacyChain
    implements CertificateChain {
        private final SignerInfo signerInfo;
        private final SignedContent content;

        public LegacyChain(SignerInfo signerInfo, SignedContent signedContent) {
            this.signerInfo = signerInfo;
            this.content = signedContent;
        }

        public Certificate[] getCertificates() {
            return this.signerInfo.getCertificateChain();
        }

        public String getChain() {
            StringBuffer stringBuffer = new StringBuffer();
            Certificate[] certificateArray = this.getCertificates();
            int n = 0;
            while (n < certificateArray.length) {
                X509Certificate x509Certificate = (X509Certificate)certificateArray[n];
                stringBuffer.append(x509Certificate.getSubjectDN().getName());
                stringBuffer.append("; ");
                ++n;
            }
            return stringBuffer.toString();
        }

        public Certificate getRoot() {
            Certificate[] certificateArray = this.getCertificates();
            return certificateArray.length > 0 ? certificateArray[certificateArray.length - 1] : null;
        }

        public Certificate getSigner() {
            Certificate[] certificateArray = this.getCertificates();
            return certificateArray.length > 0 ? certificateArray[0] : null;
        }

        public Date getSigningTime() {
            return this.content.getSigningTime(this.signerInfo);
        }

        public boolean isTrusted() {
            return this.signerInfo.isTrusted();
        }
    }

    static class LegacyVerifier
    implements CertificateVerifier {
        private final SignedContent signedContent;

        public LegacyVerifier(SignedContent signedContent) {
            this.signedContent = signedContent;
        }

        public void checkContent() throws CertificateException, CertificateExpiredException {
            SignedContentEntry[] signedContentEntryArray = this.signedContent.getSignedEntries();
            int n = 0;
            while (n < signedContentEntryArray.length) {
                try {
                    signedContentEntryArray[n].verify();
                }
                catch (InvalidContentException invalidContentException) {
                    throw new SecurityException(invalidContentException.getMessage());
                }
                catch (IOException iOException) {
                    throw new SecurityException(iOException.getMessage());
                }
                ++n;
            }
            SignerInfo[] signerInfoArray = this.signedContent.getSignerInfos();
            int n2 = 0;
            while (n2 < signerInfoArray.length) {
                this.signedContent.checkValidity(signerInfoArray[n2]);
                ++n2;
            }
        }

        public CertificateChain[] getChains() {
            SignerInfo[] signerInfoArray = this.signedContent.getSignerInfos();
            CertificateChain[] certificateChainArray = new CertificateChain[signerInfoArray.length];
            int n = 0;
            while (n < certificateChainArray.length) {
                certificateChainArray[n] = new LegacyChain(signerInfoArray[n], this.signedContent);
                ++n;
            }
            return certificateChainArray;
        }

        public boolean isSigned() {
            return this.signedContent.isSigned();
        }

        public String[] verifyContent() {
            ArrayList<String> arrayList = new ArrayList<String>(0);
            SignedContentEntry[] signedContentEntryArray = this.signedContent.getSignedEntries();
            int n = 0;
            while (n < signedContentEntryArray.length) {
                try {
                    signedContentEntryArray[n].verify();
                }
                catch (InvalidContentException invalidContentException) {
                    arrayList.add(signedContentEntryArray[n].getName());
                }
                catch (IOException iOException) {
                    arrayList.add(signedContentEntryArray[n].getName());
                }
                ++n;
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
    }
}

