/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.AdminPermission;

final class AdminPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 3906372644575328048L;
    private transient Map permissions = new HashMap();
    private boolean all_allowed;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$0;

    static {
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Hashtable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[0] = new ObjectStreamField("permissions", clazz);
        objectStreamFieldArray[1] = new ObjectStreamField("all_allowed", Boolean.TYPE);
        serialPersistentFields = objectStreamFieldArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Permission permission) {
        if (!(permission instanceof AdminPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        AdminPermission adminPermission = (AdminPermission)permission;
        if (adminPermission.bundle != null) {
            throw new IllegalArgumentException("cannot add to collection: " + adminPermission);
        }
        String string = adminPermission.getName();
        AdminPermissionCollection adminPermissionCollection = this;
        synchronized (adminPermissionCollection) {
            Map map = this.permissions;
            AdminPermission adminPermission2 = (AdminPermission)map.get(string);
            if (adminPermission2 != null) {
                int n = adminPermission2.action_mask;
                int n2 = adminPermission.action_mask;
                if (n != n2) {
                    map.put(string, new AdminPermission(adminPermission2.filter, n | n2));
                }
            } else {
                map.put(string, adminPermission);
            }
            if (!this.all_allowed && string.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(Permission permission) {
        Collection collection;
        if (!(permission instanceof AdminPermission)) {
            return false;
        }
        AdminPermission adminPermission = (AdminPermission)permission;
        if (adminPermission.filter != null) {
            return false;
        }
        int n = 0;
        Object object = this;
        synchronized (object) {
            Map map;
            block7: {
                int n2;
                AdminPermission adminPermission2;
                map = this.permissions;
                if (!this.all_allowed || (adminPermission2 = (AdminPermission)map.get("*")) == null || ((n |= adminPermission2.action_mask) & (n2 = adminPermission.action_mask)) != n2) break block7;
                return true;
            }
            collection = map.values();
        }
        object = collection.iterator();
        while (object.hasNext()) {
            if (!((AdminPermission)object.next()).implies0(adminPermission, n)) continue;
            return true;
        }
        return false;
    }

    public synchronized Enumeration elements() {
        return Collections.enumeration(this.permissions.values());
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable hashtable = new Hashtable(this.permissions);
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("permissions", hashtable);
        putField.put("all_allowed", this.all_allowed);
        objectOutputStream.writeFields();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Hashtable hashtable = (Hashtable)getField.get("permissions", null);
        this.permissions = new HashMap(hashtable);
        this.all_allowed = getField.get("all_allowed", false);
    }
}

