/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServicePermissionCollection;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SignerProperty;

public final class ServicePermission
extends BasicPermission {
    static final long serialVersionUID = -7662148639076511574L;
    public static final String GET = "get";
    public static final String REGISTER = "register";
    private static final int ACTION_GET = 1;
    private static final int ACTION_REGISTER = 2;
    private static final int ACTION_ALL = 3;
    static final int ACTION_NONE = 0;
    transient int action_mask;
    private volatile String actions = null;
    final transient ServiceReference service;
    final transient String[] objectClass;
    transient Filter filter;
    private volatile transient Dictionary properties;
    private transient boolean wildcard;
    private transient String prefix;

    public ServicePermission(String string, String string2) {
        this(string, ServicePermission.parseActions(string2));
        if (this.filter != null && (this.action_mask & 3) != 1) {
            throw new IllegalArgumentException("invalid action string for filter expression");
        }
    }

    public ServicePermission(ServiceReference serviceReference, String string) {
        super(ServicePermission.createName(serviceReference));
        this.setTransients(null, ServicePermission.parseActions(string));
        this.service = serviceReference;
        this.objectClass = (String[])serviceReference.getProperty("objectClass");
        if ((this.action_mask & 3) != 1) {
            throw new IllegalArgumentException("invalid action string");
        }
    }

    private static String createName(ServiceReference serviceReference) {
        if (serviceReference == null) {
            throw new IllegalArgumentException("reference must not be null");
        }
        StringBuffer stringBuffer = new StringBuffer("(service.id=");
        stringBuffer.append(serviceReference.getProperty("service.id"));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    ServicePermission(String string, int n) {
        super(string);
        this.setTransients(ServicePermission.parseFilter(string), n);
        this.service = null;
        this.objectClass = null;
    }

    private void setTransients(Filter filter, int n) {
        if (n == 0 || (n & 3) != n) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = n;
        this.filter = filter;
        if (filter == null) {
            int n2;
            String string = this.getName();
            boolean bl = this.wildcard = string.charAt((n2 = string.length()) - 1) == '*' && (n2 == 1 || string.charAt(n2 - 2) == '.');
            if (this.wildcard && n2 > 1) {
                this.prefix = string.substring(0, n2 - 1);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int parseActions(String var0) {
        var1_1 = false;
        var2_2 = 0;
        if (var0 == null) {
            return var2_2;
        }
        var3_3 = var0.toCharArray();
        var4_4 = var3_3.length - 1;
        if (var4_4 >= 0) ** GOTO lbl33
        return var2_2;
        {
            --var4_4;
            do {
                if (var4_4 != -1 && ((var5_5 = var3_3[var4_4]) == ' ' || var5_5 == '\r' || var5_5 == '\n' || var5_5 == '\f' || var5_5 == '\t')) continue block4;
                if (!(var4_4 < 2 || var3_3[var4_4 - 2] != 'g' && var3_3[var4_4 - 2] != 'G' || var3_3[var4_4 - 1] != 'e' && var3_3[var4_4 - 1] != 'E' || var3_3[var4_4] != 't' && var3_3[var4_4] != 'T')) {
                    var6_6 = 3;
                    var2_2 |= 1;
                } else if (!(var4_4 < 7 || var3_3[var4_4 - 7] != 'r' && var3_3[var4_4 - 7] != 'R' || var3_3[var4_4 - 6] != 'e' && var3_3[var4_4 - 6] != 'E' || var3_3[var4_4 - 5] != 'g' && var3_3[var4_4 - 5] != 'G' || var3_3[var4_4 - 4] != 'i' && var3_3[var4_4 - 4] != 'I' || var3_3[var4_4 - 3] != 's' && var3_3[var4_4 - 3] != 'S' || var3_3[var4_4 - 2] != 't' && var3_3[var4_4 - 2] != 'T' || var3_3[var4_4 - 1] != 'e' && var3_3[var4_4 - 1] != 'E' || var3_3[var4_4] != 'r' && var3_3[var4_4] != 'R')) {
                    var6_6 = 8;
                    var2_2 |= 2;
                } else {
                    throw new IllegalArgumentException("invalid permission: " + var0);
                }
                var1_1 = false;
                while (var4_4 >= var6_6 && !var1_1) {
                    switch (var3_3[var4_4 - var6_6]) {
                        case ',': {
                            var1_1 = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission: " + var0);
                        }
                    }
                    --var4_4;
                }
                var4_4 -= var6_6;
lbl33:
                // 2 sources

            } while (var4_4 != -1);
        }
        if (var1_1) {
            throw new IllegalArgumentException("invalid permission: " + var0);
        }
        return var2_2;
    }

    private static Filter parseFilter(String string) {
        if ((string = string.trim()).charAt(0) != '(') {
            return null;
        }
        try {
            return FrameworkUtil.createFilter(string);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid filter");
            illegalArgumentException.initCause(invalidSyntaxException);
            throw illegalArgumentException;
        }
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission = (ServicePermission)permission;
        if (this.service != null) {
            return false;
        }
        if (servicePermission.filter != null) {
            return false;
        }
        return this.implies0(servicePermission, 0);
    }

    boolean implies0(ServicePermission servicePermission, int n) {
        int n2 = servicePermission.action_mask;
        if (((n |= this.action_mask) & n2) != n2) {
            return false;
        }
        if (this.wildcard && this.prefix == null) {
            return true;
        }
        Filter filter = this.filter;
        if (filter != null) {
            return filter.matchCase(servicePermission.getProperties());
        }
        String[] stringArray = servicePermission.objectClass;
        if (stringArray == null) {
            return super.implies(servicePermission);
        }
        if (this.wildcard) {
            int n3 = this.prefix.length();
            int n4 = 0;
            int n5 = stringArray.length;
            while (n4 < n5) {
                String string = stringArray[n4];
                if (string.length() > n3 && string.startsWith(this.prefix)) {
                    return true;
                }
                ++n4;
            }
        } else {
            String string = this.getName();
            int n6 = 0;
            int n7 = stringArray.length;
            while (n6 < n7) {
                if (stringArray[n6].equals(string)) {
                    return true;
                }
                ++n6;
            }
        }
        return false;
    }

    public String getActions() {
        String string = this.actions;
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            int n = this.action_mask;
            if ((n & 1) == 1) {
                stringBuffer.append(GET);
                bl = true;
            }
            if ((n & 2) == 2) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(REGISTER);
            }
            this.actions = string = stringBuffer.toString();
        }
        return string;
    }

    public PermissionCollection newPermissionCollection() {
        return new ServicePermissionCollection();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission = (ServicePermission)object;
        return this.action_mask == servicePermission.action_mask && this.getName().equals(servicePermission.getName()) && (this.service == servicePermission.service || this.service != null && this.service.compareTo(servicePermission.service) == 0);
    }

    public int hashCode() {
        int n = 527 + this.getName().hashCode();
        n = 31 * n + this.getActions().hashCode();
        if (this.service != null) {
            n = 31 * n + this.service.hashCode();
        }
        return n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.service != null) {
            throw new NotSerializableException("cannot serialize");
        }
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setTransients(ServicePermission.parseFilter(this.getName()), ServicePermission.parseActions(this.actions));
    }

    private Dictionary getProperties() {
        Hashtable<String, String[]> hashtable = this.properties;
        if (hashtable != null) {
            return hashtable;
        }
        if (this.service == null) {
            hashtable = new Hashtable<String, String[]>(1);
            if (this.filter == null) {
                ((Dictionary)hashtable).put("objectClass", new String[]{this.getName()});
            }
            this.properties = hashtable;
            return this.properties;
        }
        final HashMap hashMap = new HashMap(4);
        final Bundle bundle = this.service.getBundle();
        if (bundle != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    SignerProperty signerProperty;
                    hashMap.put("id", new Long(bundle.getBundleId()));
                    hashMap.put("location", bundle.getLocation());
                    String string = bundle.getSymbolicName();
                    if (string != null) {
                        hashMap.put("name", string);
                    }
                    if ((signerProperty = new SignerProperty(bundle)).isBundleSigned()) {
                        hashMap.put("signer", signerProperty);
                    }
                    return null;
                }
            });
        }
        this.properties = new Properties(hashMap, this.service);
        return this.properties;
    }

    private static class Properties
    extends Dictionary {
        private final Map properties;
        private final ServiceReference service;

        Properties(Map map, ServiceReference serviceReference) {
            this.properties = map;
            this.service = serviceReference;
        }

        public Object get(Object object) {
            if (!(object instanceof String)) {
                return null;
            }
            String string = (String)object;
            if (string.charAt(0) == '@') {
                return this.service.getProperty(string.substring(1));
            }
            Object v = this.properties.get(string);
            if (v != null) {
                return v;
            }
            return this.service.getProperty(string);
        }

        public int size() {
            return this.properties.size() + this.service.getPropertyKeys().length;
        }

        public boolean isEmpty() {
            return false;
        }

        public Enumeration keys() {
            Set set = this.properties.keySet();
            String[] stringArray = this.service.getPropertyKeys();
            ArrayList<Object> arrayList = new ArrayList<Object>(set.size() + stringArray.length);
            arrayList.addAll(set);
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                block3: {
                    String string = stringArray[n];
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        if (!string.equalsIgnoreCase((String)iterator.next())) {
                            continue;
                        }
                        break block3;
                    }
                    arrayList.add(string);
                }
                ++n;
            }
            return Collections.enumeration(arrayList);
        }

        public Enumeration elements() {
            Set set = this.properties.keySet();
            String[] stringArray = this.service.getPropertyKeys();
            ArrayList<Object> arrayList = new ArrayList<Object>(set.size() + stringArray.length);
            arrayList.addAll(this.properties.values());
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                block3: {
                    String string = stringArray[n];
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        if (!string.equalsIgnoreCase((String)iterator.next())) {
                            continue;
                        }
                        break block3;
                    }
                    arrayList.add(this.service.getProperty(string));
                }
                ++n;
            }
            return Collections.enumeration(arrayList);
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }
    }
}

