/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class PlatformURLPluginConnection
extends PlatformURLConnection {
    private Bundle target = null;
    private static boolean isRegistered = false;
    public static final String PLUGIN = "plugin";
    static /* synthetic */ Class class$0;

    public PlatformURLPluginConnection(URL uRL) {
        super(uRL);
    }

    protected boolean allowCaching() {
        return true;
    }

    public static Object[] parse(String string, URL uRL) throws IOException {
        Object[] objectArray = new Object[2];
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (!string.startsWith(PLUGIN)) {
            throw new IOException(NLS.bind((String)CommonMessages.url_badVariant, (Object)uRL));
        }
        int n = string.indexOf("/", PLUGIN.length() + 1);
        String string2 = n == -1 ? string.substring(PLUGIN.length() + 1) : string.substring(PLUGIN.length() + 1, n);
        String string3 = PlatformURLPluginConnection.getId(string2);
        Activator activator = Activator.getDefault();
        if (activator == null) {
            throw new IOException(CommonMessages.activator_not_available);
        }
        Bundle bundle = activator.getBundle(string3);
        if (bundle == null) {
            throw new IOException(NLS.bind((String)CommonMessages.url_resolvePlugin, (Object)uRL));
        }
        objectArray[0] = bundle;
        objectArray[1] = n == -1 || n + 1 >= string.length() ? "/" : string.substring(n + 1);
        return objectArray;
    }

    protected URL resolve() throws IOException {
        String string;
        String string2 = this.url.getFile().trim();
        Object[] objectArray = PlatformURLPluginConnection.parse(string2, this.url);
        Bundle bundle = (Bundle)objectArray[0];
        URL uRL = bundle.getEntry(string = (String)objectArray[1]);
        if (uRL != null || "/".equals(string)) {
            return uRL;
        }
        return new URL(bundle.getEntry("/"), string);
    }

    public static void startup() {
        if (isRegistered) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.runtime.PlatformURLPluginConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformURLHandler.register(PLUGIN, clazz);
        isRegistered = true;
    }

    public URL[] getAuxillaryURLs() throws IOException {
        Object object;
        int n;
        Object object2;
        if (this.target == null) {
            object2 = this.url.getFile().trim();
            if (((String)object2).startsWith("/")) {
                object2 = ((String)object2).substring(1);
            }
            if (!((String)object2).startsWith(PLUGIN)) {
                throw new IOException(NLS.bind((String)CommonMessages.url_badVariant, (Object)this.url));
            }
            n = ((String)object2).indexOf("/", PLUGIN.length() + 1);
            object = n == -1 ? ((String)object2).substring(PLUGIN.length() + 1) : ((String)object2).substring(PLUGIN.length() + 1, n);
            String string = PlatformURLPluginConnection.getId((String)object);
            Activator activator = Activator.getDefault();
            if (activator == null) {
                throw new IOException(CommonMessages.activator_not_available);
            }
            this.target = activator.getBundle(string);
            if (this.target == null) {
                throw new IOException(NLS.bind((String)CommonMessages.url_resolvePlugin, (Object)this.url));
            }
        }
        int n2 = n = (object2 = Activator.getDefault().getFragments(this.target)) == null ? 0 : ((Bundle[])object2).length;
        if (n == 0) {
            return null;
        }
        object = new URL[n];
        int n3 = 0;
        while (n3 < n) {
            object[n3] = object2[n3].getEntry("/");
            ++n3;
        }
        return object;
    }
}

