/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Calendar;

import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarDataBase;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarMonthWidgetListener;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class CalendarMonthWidget
extends Canvas
implements PaintListener,
KeyListener,
FocusListener,
DisposeListener,
MouseListener {
    Date selecteddate;
    Composite parent;
    String[] firstRow = new String[]{Messages.getString("CalendarMonthWidget.week"), Messages.getString("CalendarMonthWidget.sunday"), Messages.getString("CalendarMonthWidget.monday"), Messages.getString("CalendarMonthWidget.tuesday"), Messages.getString("CalendarMonthWidget.wednesday"), Messages.getString("CalendarMonthWidget.thursday"), Messages.getString("CalendarMonthWidget.friday"), Messages.getString("CalendarMonthWidget.saturday")};
    Image backbufferImage;
    Image pictureOfTheMonth;
    Image pictureWeekSelected;
    Image pictureWeekSelected_nonFocusing;
    Image pictureDayOfWeekSelected;
    Image pictureDayOfWeekSelected_nonFocusing;
    Image pictureDayOfMonthSelected;
    Image pictureDayOfMonthSelected_nonFocusing;
    Color foregroundColor;
    GC backbufferGC;
    GC pictureOfTheMonthGC;
    Rectangle area;
    int cellwidth;
    int cellheight;
    CalendarMonthWidgetListener listener;
    static int NONE = -1;
    static int PICTUREWEEKSELECTED = 0;
    static int PICTUREWEEKSELECTED_NONFOCUSING = 1;
    static int PICTUREDAYOFWEEKSELECTED = 2;
    static int PICTUREDAYOFWEEKSELECTED_NONFOCUSING = 3;
    static int PICTUREDAYOFMONTHSELECTED = 4;
    static int PICTUREDAYOFMONTHSELECTED_NONFOCUSING = 5;
    CalendarDataBase calendardatabase;

    CalendarMonthWidget(Composite composite, CalendarDataBase calendarDataBase) {
        super(composite, 262144);
        this.calendardatabase = calendarDataBase;
        this.selecteddate = new Date();
        this.foregroundColor = new Color((Device)this.getDisplay(), 80, 180, 80);
        this.parent = composite;
        this.addPaintListener(this);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.computeArea();
        this.buildDoubleBufferingGC();
        this.redrawAllMonth();
        this.setSelectedDate(this.selecteddate);
        this.addFocusListener(this);
        composite.addDisposeListener((DisposeListener)this);
    }

    public void addCalendarMonthWidgetListener(CalendarMonthWidgetListener calendarMonthWidgetListener) {
        this.listener = calendarMonthWidgetListener;
    }

    public void paintControl(PaintEvent paintEvent) {
        paintEvent.gc.drawImage(this.backbufferImage, 0, 0);
    }

    public Date getSelecteddate() {
        return this.selecteddate;
    }

    private void drawCell(String string, int n, int n2, GC gC, Rectangle rectangle, int n3, boolean bl) {
        Point point = gC.textExtent(string);
        Point point2 = new Point((this.cellwidth - point.x) / 2, (this.cellheight - point.y) / 2);
        if (n3 == PICTUREWEEKSELECTED) {
            if (this.isFocusControl()) {
                gC.drawImage(this.pictureWeekSelected, rectangle.x + n * this.cellwidth, rectangle.y + n2 * this.cellheight);
            } else {
                gC.drawImage(this.pictureWeekSelected_nonFocusing, rectangle.x + n * this.cellwidth, rectangle.y + n2 * this.cellheight);
            }
        } else if (n3 == PICTUREDAYOFWEEKSELECTED) {
            if (this.isFocusControl()) {
                gC.drawImage(this.pictureDayOfWeekSelected, rectangle.x + n * this.cellwidth, rectangle.y + n2 * this.cellheight);
            } else {
                gC.drawImage(this.pictureDayOfWeekSelected_nonFocusing, rectangle.x + n * this.cellwidth, rectangle.y + n2 * this.cellheight);
            }
        } else if (n3 == PICTUREDAYOFMONTHSELECTED) {
            if (this.isFocusControl()) {
                gC.drawImage(this.pictureDayOfMonthSelected, rectangle.x + n * this.cellwidth, rectangle.y + n2 * this.cellheight);
            } else {
                gC.drawImage(this.pictureDayOfMonthSelected_nonFocusing, rectangle.x + n * this.cellwidth, rectangle.y + n2 * this.cellheight);
            }
        }
        if (bl) {
            gC.setForeground(this.foregroundColor);
        } else {
            gC.setForeground(new Color((Device)this.getDisplay(), 0, 0, 0));
        }
        gC.drawText(string, rectangle.x + n * this.cellwidth + point2.x, rectangle.y + n2 * this.cellheight + point2.y, 1);
    }

    private void drawCellBackground(GC gC, int n) {
        if (n == PICTUREWEEKSELECTED || n == PICTUREDAYOFWEEKSELECTED || n == PICTUREDAYOFMONTHSELECTED) {
            gC.setBackground(this.getDisplay().getSystemColor(26));
        } else if (n == PICTUREWEEKSELECTED_NONFOCUSING || n == PICTUREDAYOFWEEKSELECTED_NONFOCUSING || n == PICTUREDAYOFMONTHSELECTED_NONFOCUSING) {
            gC.setBackground(this.getDisplay().getSystemColor(22));
        }
        Rectangle rectangle = gC.getClipping();
        gC.fillRectangle(rectangle);
        Point point = new Point(0, 0);
        Point point2 = new Point(rectangle.width - 1, rectangle.height - 1);
        gC.setLineStyle(1);
        gC.setForeground(this.getDisplay().getSystemColor(18));
        gC.drawLine(point2.x, point.y, point2.x, point2.y);
        gC.drawLine(point.x, point2.y, point2.x, point2.y);
        gC.setForeground(this.getDisplay().getSystemColor(19));
        gC.drawLine(point.x, point.y, point.x, point.y + this.cellheight - 2);
        gC.drawLine(point.x, point.y, point.x + this.cellwidth - 2, point.y);
        if (n == PICTUREDAYOFMONTHSELECTED || n == PICTUREDAYOFMONTHSELECTED_NONFOCUSING) {
            gC.setLineStyle(1);
            gC.setForeground(new Color((Device)this.getDisplay(), 0, 255, 255));
            gC.drawRectangle(point.x, point.y, point2.x - 1, point2.y - 1);
        }
    }

    public void setSelectedDate(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setFirstDayOfWeek(1);
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(2);
        int n2 = gregorianCalendar.get(1);
        gregorianCalendar.setTime(this.selecteddate);
        int n3 = gregorianCalendar.get(2);
        int n4 = gregorianCalendar.get(1);
        this.selecteddate = date;
        if (n4 != n2 || n3 != n) {
            this.redrawAllMonth();
        }
        this.backbufferGC.drawImage(this.pictureOfTheMonth, 0, 0);
        this.drawDaySelection(this.selecteddate);
        if (this.listener != null) {
            this.listener.newDateSelected(date);
        }
        this.redraw();
    }

    public void keyPressed(KeyEvent keyEvent) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setFirstDayOfWeek(1);
        gregorianCalendar.setTime(this.selecteddate);
        if (keyEvent.keyCode == 0x1000004) {
            gregorianCalendar.add(6, 1);
            Date date = gregorianCalendar.getTime();
            this.setSelectedDate(date);
        } else if (keyEvent.keyCode == 0x1000003) {
            gregorianCalendar.add(6, -1);
            Date date = gregorianCalendar.getTime();
            this.setSelectedDate(date);
        } else if (keyEvent.keyCode == 0x1000002) {
            gregorianCalendar.add(4, 1);
            Date date = gregorianCalendar.getTime();
            this.setSelectedDate(date);
        } else if (keyEvent.keyCode == 0x1000001) {
            gregorianCalendar.add(4, -1);
            Date date = gregorianCalendar.getTime();
            this.setSelectedDate(date);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
        int n = mouseEvent.x / this.cellwidth;
        int n2 = mouseEvent.y / this.cellheight;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setFirstDayOfWeek(1);
        gregorianCalendar.setTime(this.selecteddate);
        int n3 = 1;
        while (n3 <= gregorianCalendar.getActualMaximum(5)) {
            gregorianCalendar.setTime(this.selecteddate);
            gregorianCalendar.set(5, n3);
            if (n == gregorianCalendar.get(7) && n2 == gregorianCalendar.get(4)) {
                this.setSelectedDate(gregorianCalendar.getTime());
                break;
            }
            ++n3;
        }
    }

    public void mouseUp(MouseEvent mouseEvent) {
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    private void buildDoubleBufferingGC() {
        if (this.backbufferImage != null) {
            this.backbufferImage.dispose();
        }
        if (this.backbufferGC != null) {
            this.backbufferGC.dispose();
        }
        this.backbufferImage = new Image((Device)this.parent.getDisplay(), this.parent.getClientArea());
        this.backbufferGC = new GC((Drawable)this.backbufferImage);
        this.pictureOfTheMonth = new Image((Device)this.parent.getDisplay(), this.parent.getClientArea());
        this.pictureOfTheMonthGC = new GC((Drawable)this.pictureOfTheMonth);
        this.pictureWeekSelected = new Image((Device)this.parent.getDisplay(), this.cellwidth, this.cellheight);
        GC gC = new GC((Drawable)this.pictureWeekSelected);
        this.drawCellBackground(gC, PICTUREWEEKSELECTED);
        gC.dispose();
        this.pictureWeekSelected_nonFocusing = new Image((Device)this.parent.getDisplay(), this.cellwidth, this.cellheight);
        gC = new GC((Drawable)this.pictureWeekSelected_nonFocusing);
        this.drawCellBackground(gC, PICTUREWEEKSELECTED_NONFOCUSING);
        gC.dispose();
        this.pictureDayOfWeekSelected = new Image((Device)this.parent.getDisplay(), this.cellwidth, this.cellheight);
        gC = new GC((Drawable)this.pictureDayOfWeekSelected);
        this.drawCellBackground(gC, PICTUREDAYOFWEEKSELECTED);
        gC.dispose();
        this.pictureDayOfWeekSelected_nonFocusing = new Image((Device)this.parent.getDisplay(), this.cellwidth, this.cellheight);
        gC = new GC((Drawable)this.pictureDayOfWeekSelected_nonFocusing);
        this.drawCellBackground(gC, PICTUREDAYOFWEEKSELECTED_NONFOCUSING);
        gC.dispose();
        this.pictureDayOfMonthSelected = new Image((Device)this.parent.getDisplay(), this.cellwidth, this.cellheight);
        gC = new GC((Drawable)this.pictureDayOfMonthSelected);
        this.drawCellBackground(gC, PICTUREDAYOFMONTHSELECTED);
        gC.dispose();
        this.pictureDayOfMonthSelected_nonFocusing = new Image((Device)this.parent.getDisplay(), this.cellwidth, this.cellheight);
        gC = new GC((Drawable)this.pictureDayOfMonthSelected_nonFocusing);
        this.drawCellBackground(gC, PICTUREDAYOFMONTHSELECTED_NONFOCUSING);
        gC.dispose();
    }

    private void drawDaySelection(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setFirstDayOfWeek(1);
        gregorianCalendar.setTime(date);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setFirstDayOfWeek(1);
        gregorianCalendar2.setTime(date);
        gregorianCalendar2.setTime(date);
        Integer n = new Integer(gregorianCalendar2.get(3));
        int n2 = gregorianCalendar2.get(4);
        this.drawCell(n.toString(), 0, n2, this.backbufferGC, this.area, PICTUREWEEKSELECTED, false);
        int n3 = gregorianCalendar2.get(7);
        this.drawCell(this.firstRow[n3], n3, 0, this.backbufferGC, this.area, PICTUREDAYOFWEEKSELECTED, false);
        this.drawCell(new Integer(gregorianCalendar2.get(5)).toString(), n3, n2, this.backbufferGC, this.area, PICTUREDAYOFMONTHSELECTED, this.calendardatabase.meetingThisDay(this.selecteddate));
    }

    public void redrawAllMonth() {
        this.pictureOfTheMonthGC.setBackground(this.getDisplay().getSystemColor(22));
        this.pictureOfTheMonthGC.setForeground(this.getDisplay().getSystemColor(22));
        this.pictureOfTheMonthGC.fillRectangle(this.area);
        if (this.parent.isFocusControl()) {
            this.pictureOfTheMonthGC.setLineWidth(2);
        } else {
            this.pictureOfTheMonthGC.setLineWidth(1);
        }
        this.pictureOfTheMonthGC.setForeground(this.getDisplay().getSystemColor(21));
        this.pictureOfTheMonthGC.setLineWidth(1);
        int n = 1;
        while (n < 7) {
            this.pictureOfTheMonthGC.drawLine(this.area.x + this.cellwidth, this.area.y + n * this.cellheight, this.area.x + this.area.width, this.area.y + n * this.cellheight);
            ++n;
        }
        this.pictureOfTheMonthGC.drawLine(this.area.x + this.cellwidth, this.area.y + this.cellheight, this.area.x + this.cellwidth, this.area.y + this.area.height);
        n = 0;
        while (n < 8) {
            this.drawCell(this.firstRow[n], n, 0, this.pictureOfTheMonthGC, this.area, NONE, false);
            ++n;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setFirstDayOfWeek(1);
        gregorianCalendar.setTime(this.selecteddate);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setFirstDayOfWeek(1);
        gregorianCalendar2.setTime(this.selecteddate);
        int n2 = 1;
        while (n2 <= gregorianCalendar2.getActualMaximum(4)) {
            gregorianCalendar2.setTime(this.selecteddate);
            gregorianCalendar2.set(4, n2);
            Integer n3 = new Integer(gregorianCalendar2.get(3));
            this.drawCell(n3.toString(), 0, n2, this.pictureOfTheMonthGC, this.area, NONE, false);
            ++n2;
        }
        gregorianCalendar2.setTime(this.selecteddate);
        n2 = 1;
        while (n2 <= gregorianCalendar2.getActualMaximum(5)) {
            gregorianCalendar2.setTime(this.selecteddate);
            gregorianCalendar2.set(5, n2);
            int n4 = gregorianCalendar2.get(7);
            int n5 = gregorianCalendar2.get(4);
            Integer n6 = new Integer(n2);
            this.drawCell(n6.toString(), n4, n5, this.pictureOfTheMonthGC, this.area, NONE, this.calendardatabase.meetingThisDay(gregorianCalendar2.getTime()));
            ++n2;
        }
        this.drawDaySelection(this.selecteddate);
    }

    private void computeArea() {
        this.area = this.parent.getClientArea();
        this.area.width -= this.area.width % 8;
        this.area.height -= this.area.height % 7;
        this.cellwidth = this.area.width / 8;
        this.cellheight = this.area.height / 7;
        this.area.width = this.cellwidth * 8;
        this.area.height = this.cellheight * 7;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.drawDaySelection(this.selecteddate);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.drawDaySelection(this.selecteddate);
    }

    void releaseRessource() {
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        if (this.backbufferImage != null) {
            this.backbufferImage.dispose();
        }
        if (this.pictureOfTheMonth != null) {
            this.pictureOfTheMonth.dispose();
        }
        if (this.pictureWeekSelected != null) {
            this.pictureWeekSelected.dispose();
        }
        if (this.pictureWeekSelected_nonFocusing != null) {
            this.pictureWeekSelected_nonFocusing.dispose();
        }
        if (this.pictureDayOfWeekSelected != null) {
            this.pictureDayOfWeekSelected.dispose();
        }
        if (this.pictureDayOfWeekSelected_nonFocusing != null) {
            this.pictureDayOfWeekSelected_nonFocusing.dispose();
        }
        if (this.pictureDayOfMonthSelected != null) {
            this.pictureDayOfMonthSelected.dispose();
        }
        if (this.pictureDayOfMonthSelected_nonFocusing != null) {
            this.pictureDayOfMonthSelected_nonFocusing.dispose();
        }
        if (this.backbufferGC != null) {
            this.backbufferGC.dispose();
        }
        if (this.pictureOfTheMonthGC != null) {
            this.pictureOfTheMonthGC.dispose();
        }
        if (this.foregroundColor != null) {
            this.foregroundColor.dispose();
        }
    }
}

