/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Tree;

import java.util.Vector;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.QueryDialog;
import org.eclipse.ercp.swt.mobile.TimedMessageBox;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeShowCase
extends ShowCase
implements KeyListener,
SelectionListener {
    static final int ROOT = 0;
    static final int NODE = 1;
    static final int LEAVE = 2;
    static final int TREE = 3;
    static final String[] itemText = new String[]{Messages.getString("TreeShowCase.0"), Messages.getString("TreeShowCase.1"), Messages.getString("TreeShowCase.2")};
    private Vector itemType;
    private Vector itemsInTree;
    private boolean overlapped = false;
    private Shell shell;
    private Display display;
    private Tree tree;
    private Command commandExit;
    private Command commandRemove;
    private Command commandAdd;
    private Command commandLabel;
    private Image imageRoot;
    private Image imageNode;
    private Image imageLeave;
    private ImageData rootImageData;
    private ImageData nodeImageData;
    private ImageData leaveImageData;

    public String getName() {
        return Messages.getString("TreeShowCase.3");
    }

    private void quit() {
        this.shell.dispose();
        this.imageRoot.dispose();
        this.imageNode.dispose();
        this.imageLeave.dispose();
        super.dispose();
    }

    protected void show() {
        this.shell = new Shell(this.getComposite().getShell(), 2080);
        this.shell.setBounds(this.getComposite().getShell().getBounds());
        this.shell.setText(Messages.getString("TreeShowCase.4"));
        this.display = this.getComposite().getShell().getDisplay();
        this.commandLabel = new Command((Control)this.shell, 1, 1);
        this.commandLabel.setText(Messages.getString("TreeShowCase.5"));
        this.commandLabel.addSelectionListener((SelectionListener)this);
        this.commandAdd = new Command((Control)this.shell, 1, 1);
        this.commandAdd.setText(Messages.getString("TreeShowCase.6"));
        this.commandAdd.addSelectionListener((SelectionListener)this);
        this.commandRemove = new Command((Control)this.shell, 1, 1);
        this.commandRemove.setText(Messages.getString("TreeShowCase.7"));
        this.commandRemove.addSelectionListener((SelectionListener)this);
        this.commandExit = new Command((Control)this.shell, 7, 1);
        this.commandExit.setText(Messages.getString("TreeShowCase.8"));
        this.commandExit.setLongLabel(Messages.getString("TreeShowCase.9"));
        this.commandExit.addSelectionListener((SelectionListener)this);
        this.tree = new Tree((Composite)this.shell, 2820);
        this.rootImageData = new ImageData(this.getClass().getResourceAsStream("/res/folderRoot.png"));
        this.nodeImageData = new ImageData(this.getClass().getResourceAsStream("/res/folder.png"));
        this.leaveImageData = new ImageData(this.getClass().getResourceAsStream("/res/file.png"));
        if (this.display.getDPI().equals((Object)new Point(192, 192))) {
            this.rootImageData = this.rootImageData.scaledTo(32, 32);
            this.nodeImageData = this.nodeImageData.scaledTo(32, 32);
            this.leaveImageData = this.leaveImageData.scaledTo(32, 32);
        }
        this.imageRoot = new Image((Device)this.display, this.rootImageData);
        this.imageNode = new Image((Device)this.display, this.nodeImageData);
        this.imageLeave = new Image((Device)this.display, this.leaveImageData);
        this.resetTree();
        this.tree.addKeyListener((KeyListener)this);
        this.tree.addSelectionListener((SelectionListener)this);
        this.shell.setText(Messages.getString("TreeShowCase.13"));
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.open();
        this.shell.layout();
    }

    private void changeCommands() {
        if (!this.overlapped) {
            this.commandExit.setText(Messages.getString("TreeShowCase.14"));
            this.commandExit.setLongLabel(Messages.getString("TreeShowCase.15"));
            this.commandAdd.setText(Messages.getString("TreeShowCase.16"));
            this.commandRemove.setText(Messages.getString("TreeShowCase.17"));
            this.commandLabel.setText(Messages.getString("TreeShowCase.18"));
        } else {
            this.commandExit.setText(Messages.getString("TreeShowCase.19"));
            this.commandExit.setLongLabel(Messages.getString("TreeShowCase.20"));
            this.commandAdd.setText(Messages.getString("TreeShowCase.29"));
            this.commandRemove.setText(Messages.getString("TreeShowCase.22"));
            this.commandLabel.setText(Messages.getString("TreeShowCase.23"));
        }
    }

    private void ShowResult(String string) {
        TimedMessageBox timedMessageBox = new TimedMessageBox(this.shell);
        timedMessageBox.setText(string);
        timedMessageBox.open();
    }

    private void displayError(String string) {
        MessageBox messageBox = new MessageBox(this.shell, 33);
        messageBox.setMessage(string);
        messageBox.open();
    }

    private void SetTreeInVectors() {
        if (this.itemsInTree == null) {
            this.itemsInTree = new Vector();
        }
        if (this.itemType == null) {
            this.itemType = new Vector();
        }
        this.itemsInTree.add(0, this.tree);
        this.itemType.add(0, new Integer(3));
    }

    private void removeAndClear() {
        if (this.tree != null) {
            this.tree.removeAll();
        }
        if (this.itemsInTree != null) {
            this.itemsInTree.clear();
        }
        if (this.itemType != null) {
            this.itemType.clear();
        }
    }

    private void resetTree() {
        this.removeAndClear();
        this.SetTreeInVectors();
        TreeItem treeItem = (TreeItem)this.insertItem(this.tree, 0, 1);
        TreeItem treeItem2 = (TreeItem)this.insertItem(treeItem, 1, 2);
        TreeItem cfr_ignored_0 = (TreeItem)this.insertItem(treeItem2, 2, 3);
        TreeItem cfr_ignored_1 = (TreeItem)this.insertItem(treeItem2, 2, 4);
        TreeItem cfr_ignored_2 = (TreeItem)this.insertItem(treeItem2, 2, 5);
        treeItem = (TreeItem)this.insertItem(this.tree, 0, 6);
        treeItem2 = (TreeItem)this.insertItem(treeItem, 1, 7);
        treeItem2 = (TreeItem)this.insertItem(treeItem, 2, 8);
        treeItem = (TreeItem)this.insertItem(this.tree, 0, 9);
        treeItem2 = (TreeItem)this.insertItem(treeItem, 1, 10);
        treeItem2 = (TreeItem)this.insertItem(treeItem, 1, 11);
        treeItem2 = (TreeItem)this.insertItem(treeItem2, 1, 12);
        treeItem2 = (TreeItem)this.insertItem(treeItem2, 1, 13);
        TreeItem cfr_ignored_3 = (TreeItem)this.insertItem(treeItem2, 2, 14);
    }

    private int findIndexOfItem(Object object) {
        if (this.itemsInTree == null) {
            return -1;
        }
        return this.itemsInTree.indexOf(object);
    }

    private void removeAllItemsFrom(TreeItem treeItem, int n) {
        int n2 = n + 1;
        block0 : switch ((Integer)this.itemType.get(n)) {
            case 0: {
                TreeItem treeItem2;
                n2 = n + 1;
                while (n2 < this.itemsInTree.size()) {
                    treeItem2 = ((TreeItem)this.itemsInTree.get(n2)).getParentItem();
                    if (treeItem2 == null) break block0;
                    ++n2;
                }
                break;
            }
            case 1: {
                TreeItem treeItem2 = ((TreeItem)this.itemsInTree.get(n)).getParentItem();
                n2 = n + 1;
                while (n2 < this.itemsInTree.size()) {
                    TreeItem treeItem3 = ((TreeItem)this.itemsInTree.get(n2)).getParentItem();
                    if (treeItem2.equals(treeItem3) || treeItem3 == null) break block0;
                    ++n2;
                }
                break;
            }
            default: {
                SWT.error((int)6);
            }
        }
        treeItem.dispose();
        int n3 = 0;
        while (n3 < n2 - n) {
            this.itemType.removeElementAt(n);
            this.itemsInTree.removeElementAt(n);
            ++n3;
        }
    }

    void removeItem() {
        if (this.tree == null) {
            return;
        }
        TreeItem[] treeItemArray = this.tree.getSelection();
        if (treeItemArray.length == 0) {
            this.displayError(Messages.getString("TreeShowCase.24"));
            return;
        }
        int n = this.itemsInTree.indexOf(treeItemArray[0]);
        switch ((Integer)this.itemType.get(n)) {
            case 2: {
                treeItemArray[0].dispose();
                this.itemType.removeElementAt(n);
                this.itemsInTree.removeElementAt(n);
                break;
            }
            case 0: {
                this.removeAllItemsFrom(treeItemArray[0], n);
                break;
            }
            case 1: {
                this.removeAllItemsFrom(treeItemArray[0], n);
            }
        }
        if (this.tree.getItemCount() != 0) {
            TreeItem[] treeItemArray2 = n != 1 ? new TreeItem[]{(TreeItem)this.itemsInTree.get(n - 1)} : new TreeItem[]{(TreeItem)this.itemsInTree.get(1)};
            this.tree.setSelection(treeItemArray2);
            this.tree.showSelection();
        }
    }

    private void add(int n) {
        if (this.tree == null) {
            return;
        }
        TreeItem[] treeItemArray = this.tree.getSelection();
        if (treeItemArray.length == 0 && this.tree.getItemCount() != 0) {
            this.displayError(Messages.getString("TreeShowCase.25"));
            return;
        }
        int n2 = 0;
        if (this.tree.getItemCount() != 0) {
            n2 = this.itemsInTree.indexOf(treeItemArray[0]);
            int n3 = (Integer)this.itemType.get(n2);
            if (n3 == 2 && n == 2 || n3 == 2 && n == 1 || n3 == 1 && n == 0) {
                this.displayError(Messages.getString("TreeShowCase.26"));
                return;
            }
        } else if (n != 0) {
            this.displayError(Messages.getString("TreeShowCase.27"));
            return;
        }
        TreeItem treeItem = null;
        switch (n) {
            case 0: {
                int n4 = 0;
                int n5 = 1;
                String string = this.changeLabel(itemText[0]);
                if (string == null) break;
                if (this.tree.getItemCount() == 0) {
                    treeItem = new TreeItem(this.tree, 2048);
                } else {
                    n4 = this.rankUnderRoot(n2);
                    n5 = this.findIndexOfNextItemUnderRoot(n2);
                    treeItem = new TreeItem(this.tree, 2048, n4);
                }
                treeItem.setImage(this.imageRoot);
                treeItem.setText(string);
                this.itemsInTree.insertElementAt(treeItem, n5);
                this.itemType.insertElementAt(new Integer(0), n5);
                break;
            }
            case 1: {
                Object e = this.itemsInTree.get(n2);
                String string = this.changeLabel(itemText[1]);
                if (string == null) break;
                treeItem = new TreeItem((TreeItem)e, 2048, 0);
                treeItem.setImage(this.imageNode);
                treeItem.setText(string);
                this.itemsInTree.insertElementAt(treeItem, n2 + 1);
                this.itemType.insertElementAt(new Integer(1), n2 + 1);
                break;
            }
            case 2: {
                Object e = this.itemsInTree.get(n2);
                String string = this.changeLabel(itemText[2]);
                if (string == null) break;
                treeItem = new TreeItem((TreeItem)e, 2048, 0);
                treeItem.setImage(this.imageLeave);
                treeItem.setText(string);
                this.itemsInTree.insertElementAt(treeItem, n2 + 1);
                this.itemType.insertElementAt(new Integer(2), n2 + 1);
            }
        }
        this.tree.setSelection(new TreeItem[]{treeItem});
        this.tree.showSelection();
    }

    private int findRootOfItemIndex(int n) {
        if ((Integer)this.itemType.get(n) == 0) {
            return n;
        }
        int n2 = n - 1;
        while (n2 > 0) {
            if ((Integer)this.itemType.get(n) == 0) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    int findIndexOfNextItemUnderRoot(int n) {
        int n2 = n + 1;
        while (n2 < this.itemType.size()) {
            if (((TreeItem)this.itemsInTree.get(n)).getParentItem() == null) break;
            ++n;
        }
        return n2;
    }

    private void changeLabel() {
        TreeItem[] treeItemArray = this.tree.getSelection();
        if (treeItemArray.length == 0) {
            return;
        }
        String string = this.changeLabel(treeItemArray[0].getText());
        if (string != null) {
            treeItemArray[0].setText(string);
        }
    }

    private String changeLabel(String string) {
        QueryDialog queryDialog = new QueryDialog(this.shell, 65536);
        queryDialog.setMaximum(15);
        queryDialog.setPromptText(Messages.getString("TreeShowCase.28"), string);
        String string2 = queryDialog.open();
        return string2;
    }

    private int rankUnderRoot(int n) {
        int n2 = 0;
        int n3 = n;
        while (n3 > 0) {
            if (((TreeItem)this.itemsInTree.get(n3)).getParentItem() == null) {
                ++n2;
            }
            --n3;
        }
        return n2;
    }

    private int nodeRank(int n) {
        int n2 = 0;
        TreeItem treeItem = ((TreeItem)this.itemsInTree.get(n)).getParentItem();
        int n3 = n;
        while (n3 > 0) {
            if (treeItem.equals((TreeItem)this.itemsInTree.get(n3))) break;
            ++n2;
            --n3;
        }
        return n2;
    }

    private int leaveRank(int n) {
        int n2 = 1;
        if (((TreeItem)this.itemsInTree.get(n)).getParentItem() == null) {
            return this.rankUnderRoot(n);
        }
        int n3 = n - 1;
        while (n3 > 0) {
            int n4 = (Integer)this.itemType.get(n3);
            if (n4 == 0 || n4 == 1) break;
            if ((Integer)this.itemType.get(n3) == 1) {
                ++n2;
            }
            --n3;
        }
        return n2;
    }

    private Object insertItem(Object object, int n, int n2) {
        TreeItem treeItem = object.equals(this.tree) ? new TreeItem((Tree)object, 2048) : new TreeItem((TreeItem)object, 2048);
        switch (n) {
            case 0: {
                treeItem.setImage(this.imageRoot);
                treeItem.setText(itemText[0]);
                break;
            }
            case 1: {
                treeItem.setImage(this.imageNode);
                treeItem.setText(itemText[1]);
                break;
            }
            case 2: {
                treeItem.setImage(this.imageLeave);
                treeItem.setText(itemText[2]);
                break;
            }
            default: {
                treeItem.setImage(this.imageLeave);
                treeItem.setText(itemText[2]);
                n = 2;
            }
        }
        this.itemsInTree.add(n2, treeItem);
        this.itemType.add(n2, new Integer(n));
        return treeItem;
    }

    private void cancel() {
        this.overlapped = false;
        this.changeCommands();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        try {
            if (selectionEvent.widget != this.tree) {
                if (selectionEvent.widget == this.commandLabel) {
                    if (this.overlapped) {
                        this.add(0);
                    } else {
                        this.changeLabel();
                    }
                } else if (selectionEvent.widget == this.commandAdd) {
                    if (this.overlapped) {
                        this.add(1);
                    } else {
                        this.overlapped = true;
                        this.changeCommands();
                    }
                } else if (selectionEvent.widget == this.commandRemove) {
                    if (this.overlapped) {
                        this.add(2);
                    } else {
                        this.removeItem();
                    }
                } else if (selectionEvent.widget == this.commandExit) {
                    if (this.overlapped) {
                        this.cancel();
                    } else {
                        this.quit();
                    }
                }
            }
        }
        catch (Exception exception) {}
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }
}

