/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.PreferencesOSGiUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class ConfigurationPreferences
extends EclipsePreferences {
    private int segmentCount;
    private String qualifier;
    private IPath location;
    private IEclipsePreferences loadLevel;
    private static Set loadedNodes = new HashSet();
    private static boolean initialized = false;
    private static IPath baseLocation;

    static {
        URL uRL = PreferencesOSGiUtils.getDefault().getConfigurationLocation().getURL();
        if (uRL != null) {
            baseLocation = new Path(uRL.getFile());
        }
    }

    public ConfigurationPreferences() {
        this(null, null);
    }

    private ConfigurationPreferences(EclipsePreferences eclipsePreferences, String string) {
        super(eclipsePreferences, string);
        this.initializeChildren();
        String string2 = this.absolutePath();
        this.segmentCount = ConfigurationPreferences.getSegmentCount(string2);
        if (this.segmentCount < 2) {
            return;
        }
        this.qualifier = ConfigurationPreferences.getSegment(string2, 1);
        if (this.qualifier == null) {
            return;
        }
        if (baseLocation != null) {
            this.location = this.computeLocation(baseLocation, this.qualifier);
        }
    }

    protected IPath getLocation() {
        return this.location;
    }

    protected synchronized boolean isAlreadyLoaded(IEclipsePreferences iEclipsePreferences) {
        return loadedNodes.contains(iEclipsePreferences.name());
    }

    protected synchronized void loaded() {
        loadedNodes.add(this.name());
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            EclipsePreferences eclipsePreferences = this;
            int n = 2;
            while (n < this.segmentCount) {
                eclipsePreferences = (EclipsePreferences)eclipsePreferences.parent();
                ++n;
            }
            this.loadLevel = eclipsePreferences;
        }
        return this.loadLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void initializeChildren() {
        if (initialized) return;
        if (this.parent == null) {
            return;
        }
        try {
            block10: {
                ConfigurationPreferences configurationPreferences = this;
                // MONITORENTER : configurationPreferences
                if (baseLocation != null) break block10;
                // MONITOREXIT : configurationPreferences
                Object var4_2 = null;
                initialized = true;
                return;
            }
            String[] stringArray = this.computeChildren(baseLocation);
            int n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    // MONITOREXIT : configurationPreferences
                    break;
                }
                this.addChild(stringArray[n], null);
                ++n;
            }
            Object var4_4 = null;
            initialized = true;
            return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            initialized = true;
            throw throwable;
        }
    }

    protected EclipsePreferences internalCreate(EclipsePreferences eclipsePreferences, String string, Object object) {
        return new ConfigurationPreferences(eclipsePreferences, string);
    }
}

