/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.CompatibleWorkbenchPage;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PageSelectionService;
import org.eclipse.ui.internal.PartListenerList;
import org.eclipse.ui.internal.PartListenerList2;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.PerspectiveHelper;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.misc.ShowMessage;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.UIExtensionTracker;

public class WorkbenchPage
extends CompatibleWorkbenchPage
implements IWorkbenchPage {
    private WorkbenchWindow window;
    private IAdaptable input;
    private Composite composite;
    private IWorkbenchPart activePart;
    private ActivationList activationList = new ActivationList();
    private PartListenerList partListeners = new PartListenerList();
    private PartListenerList2 partListeners2 = new PartListenerList2();
    private ListenerList propertyChangeListeners = new ListenerList();
    private PageSelectionService selectionService = new PageSelectionService(this);
    private ViewFactory viewFactory;
    private PerspectiveList perspList = new PerspectiveList();
    private PerspectiveDescriptor deferredActivePersp;
    private HashMap stateMap = new HashMap();
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getProperty();
            if (!"PROP_VISIBILITY".equals(string)) return;
            WorkbenchPartReference workbenchPartReference = (WorkbenchPartReference)((PartPane)propertyChangeEvent.getSource()).getPartReference();
            IWorkbenchPart iWorkbenchPart = workbenchPartReference.getPart(Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
            if (workbenchPartReference == null) {
                return;
            }
            if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                String string2 = null;
                if (UIStats.isDebugging(9)) {
                    string2 = "visible::" + workbenchPartReference.getTitle();
                }
                try {
                    UIStats.start(9, string2);
                    WorkbenchPage.this.partListeners2.firePartVisible(workbenchPartReference);
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    UIStats.end(9, iWorkbenchPart, string2);
                    throw throwable;
                }
                {
                    Object var6_10 = null;
                    UIStats.end(9, iWorkbenchPart, string2);
                    return;
                }
            }
            String string3 = null;
            if (UIStats.isDebugging(9)) {
                string3 = "hidden::" + workbenchPartReference.getTitle();
            }
            try {
                UIStats.start(9, string3);
                WorkbenchPage.this.partListeners2.firePartHidden(workbenchPartReference);
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                UIStats.end(9, iWorkbenchPart, string3);
                throw throwable;
            }
            {
                Object var6_12 = null;
            }
            UIStats.end(9, iWorkbenchPart, string3);
        }
    };
    private ActionSwitcher actionSwitcher = new ActionSwitcher();
    private IExtensionTracker tracker;
    private IExtensionChangeHandler perspectiveChangeHandler = new IExtensionChangeHandler(){

        public void removeExtension(IExtension iExtension, Object[] objectArray) {
        }

        public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
            if (WorkbenchPage.this != WorkbenchPage.this.getWorkbenchWindow().getActivePage()) {
                return;
            }
        }
    };

    private IExtensionPoint getPerspectiveExtensionPoint() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "perspectiveExtensions");
    }

    public WorkbenchPage(WorkbenchWindow workbenchWindow, String string, IAdaptable iAdaptable) throws WorkbenchException {
        if (string == null) {
            throw new WorkbenchException(WorkbenchMessages.WorkbenchPage_UndefinedPerspective);
        }
        this.init(workbenchWindow, string, iAdaptable);
    }

    public WorkbenchPage(WorkbenchWindow workbenchWindow, IAdaptable iAdaptable) throws WorkbenchException {
        this.init(workbenchWindow, null, iAdaptable);
    }

    public void activate(IWorkbenchPart iWorkbenchPart) {
        if (!this.certifyPart(iWorkbenchPart)) {
            return;
        }
        if (this.window.isClosing()) {
            return;
        }
        this.zoomOutIfNecessary(iWorkbenchPart);
        if (this.window.getActivePage() == this) {
            this.bringToTop(iWorkbenchPart);
            this.setActivePart(iWorkbenchPart);
        } else {
            this.activationList.setActive(iWorkbenchPart);
            this.activePart = iWorkbenchPart;
        }
    }

    private void activatePart(final IWorkbenchPart iWorkbenchPart) {
        Platform.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.WorkbenchPage_ErrorActivatingView){

            public void run() {
                if (iWorkbenchPart != null) {
                    iWorkbenchPart.setFocus();
                    PartSite partSite = (PartSite)iWorkbenchPart.getSite();
                    partSite.getPane().showFocus(true);
                    WorkbenchPage.this.updateTabList(iWorkbenchPart);
                }
            }
        });
    }

    public void addFastView(IViewReference iViewReference) {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return;
        }
        if (perspective.isFastView(iViewReference)) {
            return;
        }
        perspective.addFastView(iViewReference);
        if (iViewReference.getPart(false) == this.activePart) {
            this.activate(this.activationList.getActive());
        }
        this.window.firePerspectiveChanged(this, this.getPerspective(), iViewReference, "fastViewAdd");
        this.window.firePerspectiveChanged(this, this.getPerspective(), "fastViewAdd");
    }

    public void addPartListener(IPartListener iPartListener) {
        this.partListeners.addPartListener(iPartListener);
    }

    public void addPartListener(IPartListener2 iPartListener2) {
        this.partListeners2.addPartListener(iPartListener2);
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.propertyChangeListeners.add((Object)iPropertyChangeListener);
    }

    public void addSelectionListener(ISelectionListener iSelectionListener) {
        this.selectionService.addSelectionListener(iSelectionListener);
    }

    public void addSelectionListener(String string, ISelectionListener iSelectionListener) {
        this.selectionService.addSelectionListener(string, iSelectionListener);
    }

    public void addPostSelectionListener(ISelectionListener iSelectionListener) {
        this.selectionService.addPostSelectionListener(iSelectionListener);
    }

    public void addPostSelectionListener(String string, ISelectionListener iSelectionListener) {
        this.selectionService.addPostSelectionListener(string, iSelectionListener);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void bringToTop(IWorkbenchPart iWorkbenchPart) {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) return;
        if (!this.certifyPart(iWorkbenchPart)) {
            return;
        }
        if (this.isZoomed() && this.partChangeAffectsZoom(this.getReference(iWorkbenchPart))) {
            return;
        }
        String string = null;
        if (UIStats.isDebugging(8)) {
            string = iWorkbenchPart != null ? iWorkbenchPart.getTitle() : "none";
        }
        boolean bl = false;
        try {
            UIStats.start(8, string);
            if (iWorkbenchPart instanceof IViewPart) {
                IViewReference iViewReference = (IViewReference)this.getReference(iWorkbenchPart);
                bl = perspective.bringToTop(iViewReference);
            }
            if (bl) {
                this.activationList.setActive(iWorkbenchPart);
                this.firePartBroughtToTop(iWorkbenchPart);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            UIStats.end(8, iWorkbenchPart, string);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        UIStats.end(8, iWorkbenchPart, string);
    }

    private void busyResetPerspective() {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        Perspective perspective = this.getActivePerspective();
        IPerspectiveRegistry iPerspectiveRegistry = WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        PerspectiveDescriptor perspectiveDescriptor = (PerspectiveDescriptor)iPerspectiveRegistry.findPerspectiveWithId(perspective.getDesc().getId());
        if (perspectiveDescriptor == null) {
            perspectiveDescriptor = (PerspectiveDescriptor)iPerspectiveRegistry.findPerspectiveWithId(((PerspectiveDescriptor)perspective.getDesc()).getOriginalId());
        }
        if (perspectiveDescriptor == null) {
            return;
        }
        this.window.firePerspectiveChanged(this, perspectiveDescriptor, "reset");
        Perspective perspective2 = this.createPerspective(perspectiveDescriptor);
        if (perspective2 == null) {
            this.window.firePerspectiveChanged(this, perspectiveDescriptor, "resetComplete");
            return;
        }
        this.perspList.swap(perspective, perspective2);
        this.setPerspective(perspective2);
        this.disposePerspective(perspective);
        this.window.firePerspectiveChanged(this, perspectiveDescriptor, "resetComplete");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void busySetPerspective(IPerspectiveDescriptor iPerspectiveDescriptor) {
        String string;
        block5: {
            block4: {
                string = iPerspectiveDescriptor.getId();
                Perspective perspective = null;
                try {
                    UIStats.start(10, string);
                    PerspectiveDescriptor perspectiveDescriptor = (PerspectiveDescriptor)iPerspectiveDescriptor;
                    perspective = this.findPerspective(perspectiveDescriptor);
                    if (perspective == null && (perspective = this.createPerspective(perspectiveDescriptor)) == null) {
                        Object var5_5 = null;
                        break block4;
                    }
                    this.setPerspective(perspective);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    UIStats.end(10, iPerspectiveDescriptor.getId(), string);
                    throw throwable;
                }
            }
            UIStats.end(10, iPerspectiveDescriptor.getId(), string);
            return;
        }
        Object var5_7 = null;
        UIStats.end(10, iPerspectiveDescriptor.getId(), string);
    }

    private IViewPart busyShowView(String string, String string2, int n) throws PartInitException {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return null;
        }
        IViewReference iViewReference = perspective.findView(string, string2);
        IViewPart iViewPart = null;
        if (iViewReference != null) {
            iViewPart = iViewReference.getView(true);
        }
        if (iViewPart != null) {
            this.busyShowView(iViewPart, n);
            return iViewPart;
        }
        iViewPart = perspective.showView(string, string2);
        if (iViewPart != null) {
            this.busyShowView(iViewPart, n);
            this.window.firePerspectiveChanged(this, this.getPerspective(), this.getReference(iViewPart), "viewShow");
            this.window.firePerspectiveChanged(this, this.getPerspective(), "viewShow");
        }
        return iViewPart;
    }

    private void busyShowView(IViewPart iViewPart, int n) {
        if (n == 1) {
            this.activate(iViewPart);
        } else if (n == 2) {
            IWorkbenchPartReference iWorkbenchPartReference = this.getActivePartReference();
            if (iWorkbenchPartReference == null || !(iWorkbenchPartReference instanceof IViewReference)) {
                this.bringToTop(iViewPart);
            } else {
                IViewReference iViewReference = (IViewReference)iWorkbenchPartReference;
                IViewReference[] iViewReferenceArray = this.getViewReferenceStack(iViewPart);
                int n2 = 0;
                while (n2 < iViewReferenceArray.length) {
                    if (iViewReferenceArray[n2].equals(iViewReference)) {
                        return;
                    }
                    ++n2;
                }
                this.bringToTop(iViewPart);
            }
        }
    }

    private boolean certifyPart(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart != null && !(iWorkbenchPart.getSite() instanceof PartSite)) {
            return false;
        }
        if (iWorkbenchPart instanceof IViewPart) {
            Perspective perspective = this.getActivePerspective();
            return perspective != null && perspective.containsView((IViewPart)iWorkbenchPart);
        }
        return false;
    }

    public boolean close() {
        boolean[] blArray = new boolean[]{this.window.closePage(this, true)};
        if (blArray[0] && this.tracker != null) {
            this.tracker.close();
        }
        return blArray[0];
    }

    public void closePerspective(IPerspectiveDescriptor iPerspectiveDescriptor, boolean bl, boolean bl2) {
        Perspective perspective = this.findPerspective(iPerspectiveDescriptor);
        if (perspective != null) {
            this.closePerspective(perspective, bl, bl2);
        }
    }

    void closePerspective(Perspective perspective, boolean bl, boolean bl2) {
        boolean bl3;
        if (this.isZoomed()) {
            this.zoomOut();
        }
        boolean bl4 = bl3 = this.perspList.getActive() == perspective;
        if (bl3) {
            this.setPerspective(this.perspList.getNextActive());
        }
        this.disposePerspective(perspective);
        if (bl2 && this.perspList.size() == 0) {
            this.close();
        }
    }

    public void closeAllPerspectives(boolean bl, boolean bl2) {
        if (this.perspList.isEmpty()) {
            return;
        }
        if (this.isZoomed()) {
            this.zoomOut();
        }
        this.setPerspective((Perspective)null);
        PerspectiveList perspectiveList = this.perspList;
        this.perspList = new PerspectiveList();
        Iterator iterator = perspectiveList.iterator();
        while (iterator.hasNext()) {
            this.closePerspective((Perspective)iterator.next(), false, false);
        }
        if (bl2) {
            this.close();
        }
    }

    private void createClientComposite() {
        Composite composite = this.window.getPageComposite();
        this.composite = new Composite(composite, 524288);
        this.composite.setVisible(false);
        composite.layout();
    }

    private Perspective createPerspective(PerspectiveDescriptor perspectiveDescriptor) {
        Perspective perspective;
        String string = perspectiveDescriptor.getId();
        try {
            UIStats.start(3, string);
            Perspective perspective2 = new Perspective(perspectiveDescriptor, this);
            this.perspList.add(perspective2);
            this.window.firePerspectiveOpened(this, perspectiveDescriptor);
            IViewReference[] iViewReferenceArray = perspective2.getViewReferences();
            int n = 0;
            while (n < iViewReferenceArray.length) {
                IViewReference iViewReference = iViewReferenceArray[n];
                if (iViewReference != null) {
                    this.addPart(iViewReference);
                }
                ++n;
            }
            perspective = perspective2;
            Object var7_8 = null;
        }
        catch (WorkbenchException workbenchException) {
            try {
                if (!((Workbench)this.window.getWorkbench()).isStarting()) {
                    ShowMessage.openError(this.window.getShell(), WorkbenchMessages.Error, NLS.bind((String)WorkbenchMessages.Workbench_showPerspectiveError, (Object)perspectiveDescriptor.getId()));
                }
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                UIStats.end(3, perspectiveDescriptor.getId(), string);
                throw throwable;
            }
            UIStats.end(3, perspectiveDescriptor.getId(), string);
            return null;
        }
        UIStats.end(3, perspectiveDescriptor.getId(), string);
        return perspective;
    }

    protected void addPart(IWorkbenchPartReference iWorkbenchPartReference) {
        this.activationList.add(iWorkbenchPartReference);
    }

    protected void removePart(IWorkbenchPartReference iWorkbenchPartReference) {
        this.activationList.remove(iWorkbenchPartReference);
    }

    private void deactivatePart(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart != null) {
            PartSite partSite = (PartSite)iWorkbenchPart.getSite();
            partSite.getPane().showFocus(false);
        }
    }

    public void detachView(IViewReference iViewReference) {
        Perspective perspective = this.getActivePerspective();
        PerspectiveHelper perspectiveHelper = perspective.getPresentation();
        if (perspective == null) {
            return;
        }
        perspectiveHelper.detachPart(iViewReference);
    }

    public void attachView(IViewReference iViewReference) {
        PerspectiveHelper perspectiveHelper = this.getPerspectivePresentation();
        perspectiveHelper.attachPart(iViewReference);
    }

    private void disposePart(IWorkbenchPartReference iWorkbenchPartReference) {
        final WorkbenchPartReference workbenchPartReference = (WorkbenchPartReference)iWorkbenchPartReference;
        Platform.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                workbenchPartReference.dispose();
            }

            public void handleException(Throwable throwable) {
            }
        });
    }

    public void dispose() {
        Object object;
        if (this.isZoomed()) {
            this.zoomOut();
        }
        IViewReference[] iViewReferenceArray = this.viewFactory.getViews();
        Iterator iterator = this.perspList.iterator();
        while (iterator.hasNext()) {
            object = (Perspective)iterator.next();
            this.window.firePerspectiveClosed(this, ((Perspective)object).getDesc());
            ((Perspective)object).dispose();
        }
        this.perspList = new PerspectiveList();
        object = new int[1];
        int n = 0;
        while (n < iViewReferenceArray.length) {
            final WorkbenchPartReference workbenchPartReference = (WorkbenchPartReference)((Object)iViewReferenceArray[n]);
            this.firePartClosed(iViewReferenceArray[n]);
            SafeRunner.run((ISafeRunnable)new SafeRunnable((int[])object){
                private final /* synthetic */ int[] val$errors;
                {
                    this.val$errors = nArray;
                }

                public void run() {
                    workbenchPartReference.dispose();
                }

                public void handleException(Throwable throwable) {
                    this.val$errors[0] = this.val$errors[0] + 1;
                }
            });
            ++n;
        }
        this.activePart = null;
        this.activationList = new ActivationList();
        this.composite.dispose();
        if (this.tracker != null) {
            this.tracker.close();
        }
    }

    private void disposePerspective(Perspective perspective) {
        IViewReference[] iViewReferenceArray = perspective.getViewReferences();
        this.perspList.remove(perspective);
        this.window.firePerspectiveClosed(this, perspective.getDesc());
        perspective.dispose();
        int n = 0;
        while (n < iViewReferenceArray.length) {
            IViewReference iViewReference = iViewReferenceArray[n];
            boolean bl = this.viewFactory.hasView(iViewReference);
            if (!bl) {
                this.firePartClosed(iViewReference);
                this.activationList.remove(iViewReference);
                this.disposePart(iViewReference);
            }
            ++n;
        }
    }

    public Perspective findPerspective(IPerspectiveDescriptor iPerspectiveDescriptor) {
        Iterator iterator = this.perspList.iterator();
        while (iterator.hasNext()) {
            Perspective perspective = (Perspective)iterator.next();
            if (!iPerspectiveDescriptor.getId().equals(perspective.getDesc().getId())) continue;
            return perspective;
        }
        return null;
    }

    public IViewPart findView(String string) {
        IViewReference iViewReference = this.findViewReference(string);
        if (iViewReference == null) {
            return null;
        }
        return iViewReference.getView(true);
    }

    public IViewReference findViewReference(String string) {
        return this.findViewReference(string, null);
    }

    public IViewReference findViewReference(String string, String string2) {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return null;
        }
        return perspective.findView(string, string2);
    }

    private void firePartActivated(IWorkbenchPart iWorkbenchPart) {
        this.partListeners.firePartActivated(iWorkbenchPart);
        this.partListeners2.firePartActivated(this.getReference(iWorkbenchPart));
        this.selectionService.partActivated(iWorkbenchPart);
    }

    private void firePartBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        this.partListeners.firePartBroughtToTop(iWorkbenchPart);
        this.partListeners2.firePartBroughtToTop(this.getReference(iWorkbenchPart));
        this.selectionService.partBroughtToTop(iWorkbenchPart);
    }

    private void firePartClosed(IWorkbenchPartReference iWorkbenchPartReference) {
        IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
        if (iWorkbenchPart != null) {
            this.partListeners.firePartClosed(iWorkbenchPart);
            this.selectionService.partClosed(iWorkbenchPart);
        }
        this.partListeners2.firePartClosed(iWorkbenchPartReference);
    }

    private void firePartDeactivated(IWorkbenchPart iWorkbenchPart) {
        this.partListeners.firePartDeactivated(iWorkbenchPart);
        this.partListeners2.firePartDeactivated(this.getReference(iWorkbenchPart));
        this.selectionService.partDeactivated(iWorkbenchPart);
    }

    public void firePartOpened(IWorkbenchPart iWorkbenchPart) {
        this.partListeners.firePartOpened(iWorkbenchPart);
        this.partListeners2.firePartOpened(this.getReference(iWorkbenchPart));
        this.selectionService.partOpened(iWorkbenchPart);
    }

    private void firePartInputChanged(IWorkbenchPart iWorkbenchPart) {
        this.partListeners2.firePartInputChanged(this.getReference(iWorkbenchPart));
        this.selectionService.partInputChanged(iWorkbenchPart);
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        Object[] objectArray = this.propertyChangeListeners.getListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, object, object2);
        int n = 0;
        while (n < objectArray.length) {
            ((IPropertyChangeListener)objectArray[n]).propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    public IWorkbenchPart getActivePart() {
        return this.activePart;
    }

    public IWorkbenchPartReference getActivePartReference() {
        return this.getReference(this.activePart);
    }

    public Perspective getActivePerspective() {
        return this.perspList.getActive();
    }

    public Composite getClientComposite() {
        return this.composite;
    }

    public PerspectiveHelper getPerspectivePresentation() {
        if (this.getActivePerspective() != null) {
            return this.getActivePerspective().getPresentation();
        }
        return null;
    }

    public IViewReference[] getFastViews() {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            return perspective.getFastViews();
        }
        return new IViewReference[0];
    }

    public IAdaptable getInput() {
        return this.input;
    }

    public String getLabel() {
        String string = WorkbenchMessages.WorkbenchPage_UnknownLabel;
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            string = NLS.bind((String)WorkbenchMessages.WorkbenchPage_PerspectiveFormat, (Object)string, (Object)perspective.getDesc().getLabel());
        } else if (this.deferredActivePersp != null) {
            string = NLS.bind((String)WorkbenchMessages.WorkbenchPage_PerspectiveFormat, (Object)string, (Object)this.deferredActivePersp.getLabel());
        }
        return string;
    }

    public IPerspectiveDescriptor getPerspective() {
        if (this.deferredActivePersp != null) {
            return this.deferredActivePersp;
        }
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            return perspective.getDesc();
        }
        return null;
    }

    public ISelection getSelection() {
        return this.selectionService.getSelection();
    }

    public ISelection getSelection(String string) {
        return this.selectionService.getSelection(string);
    }

    public ArrayList getShowInPartIds() {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            return perspective.getShowInPartIds();
        }
        return new ArrayList();
    }

    public void performedShowIn(String string) {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            perspective.performedShowIn(string);
        }
    }

    public void sortShowInPartIds(ArrayList arrayList) {
        final Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    long l;
                    long l2 = perspective.getShowInTime((String)object);
                    return l2 == (l = perspective.getShowInTime((String)object2)) ? 0 : (l2 > l ? -1 : 1);
                }
            });
        }
    }

    protected WorkbenchWindow getUnprotectedWindow() {
        return this.window;
    }

    public ViewFactory getViewFactory() {
        if (this.viewFactory == null) {
            this.viewFactory = new ViewFactory(this, WorkbenchPlugin.getDefault().getViewRegistry());
        }
        return this.viewFactory;
    }

    public IViewReference[] getViewReferences() {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            return perspective.getViewReferences();
        }
        return new IViewReference[0];
    }

    public IViewPart[] getViews() {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            IViewReference[] iViewReferenceArray = perspective.getViewReferences();
            ArrayList<IWorkbenchPart> arrayList = new ArrayList<IWorkbenchPart>(iViewReferenceArray.length);
            int n = 0;
            while (n < iViewReferenceArray.length) {
                IWorkbenchPart iWorkbenchPart = iViewReferenceArray[n].getPart(true);
                if (iWorkbenchPart != null) {
                    arrayList.add(iWorkbenchPart);
                }
                ++n;
            }
            IViewPart[] iViewPartArray = new IViewPart[arrayList.size()];
            return arrayList.toArray(iViewPartArray);
        }
        return new IViewPart[0];
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.window;
    }

    public void hideActionSet(String string) {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            perspective.hideActionSet(string);
            this.window.firePerspectiveChanged(this, this.getPerspective(), "actionSetHide");
        }
    }

    public void hideView(IViewReference iViewReference) {
        if (iViewReference == null) {
            return;
        }
        IWorkbenchPart iWorkbenchPart = iViewReference.getPart(false);
        if (iWorkbenchPart != null) {
            this.hideView((IViewPart)iWorkbenchPart);
        } else {
            this.hideView(this.getActivePerspective(), iViewReference);
        }
    }

    void refreshActiveView() {
        IWorkbenchPart iWorkbenchPart = this.activationList.getActive();
        if (iWorkbenchPart != this.activePart) {
            if (iWorkbenchPart != null) {
                this.activate(iWorkbenchPart);
            } else {
                this.setActivePart(null);
            }
        }
    }

    public void hideView(IViewPart iViewPart) {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null || !this.certifyPart(iViewPart)) {
            return;
        }
        IViewReference iViewReference = (IViewReference)this.getReference(iViewPart);
        if (iViewPart == this.activePart) {
            IWorkbenchPart iWorkbenchPart = this.activationList.getPreviouslyActive();
            if (iWorkbenchPart != null) {
                this.activate(iWorkbenchPart);
            } else {
                this.setActivePart(null);
            }
        }
        this.hideView(perspective, iViewReference);
    }

    private void hideView(Perspective perspective, IViewReference iViewReference) {
        this.window.firePerspectiveChanged(this, perspective.getDesc(), iViewReference, "viewHide");
        perspective.hideView(iViewReference);
        boolean bl = this.viewFactory.hasView(iViewReference);
        if (!bl) {
            this.firePartClosed(iViewReference);
            this.disposePart(iViewReference);
            this.activationList.remove(iViewReference);
            this.activePart = this.activationList.getActive();
        }
        this.window.firePerspectiveChanged(this, this.getPerspective(), "viewHide");
    }

    private void init(WorkbenchWindow workbenchWindow, String string, IAdaptable iAdaptable) throws WorkbenchException {
        this.window = workbenchWindow;
        this.input = iAdaptable;
        this.createClientComposite();
        if (string != null) {
            PerspectiveDescriptor perspectiveDescriptor = (PerspectiveDescriptor)WorkbenchPlugin.getDefault().getPerspectiveRegistry().findPerspectiveWithId(string);
            if (perspectiveDescriptor == null) {
                throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.WorkbenchPage_ErrorCreatingPerspective, (Object)string));
            }
            Perspective perspective = this.createPerspective(perspectiveDescriptor);
            if (perspective == null) {
                return;
            }
            this.perspList.setActive(perspective);
            this.window.firePerspectiveActivated(this, perspectiveDescriptor);
        }
        this.getExtensionTracker().registerHandler(this.perspectiveChangeHandler, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getPerspectiveExtensionPoint()));
    }

    public boolean isPartVisible(IWorkbenchPart iWorkbenchPart) {
        return ((PartSite)iWorkbenchPart.getSite()).getPane().isVisible();
    }

    public boolean isEditorAreaVisible() {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return false;
        }
        return perspective.isEditorAreaVisible();
    }

    public boolean isFastView(IViewReference iViewReference) {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            return perspective.isFastView(iViewReference);
        }
        return false;
    }

    public boolean isFixedLayout() {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            return perspective.isFixedLayout();
        }
        return false;
    }

    public IViewReference getActiveFastView() {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            return perspective.getActiveFastView();
        }
        return null;
    }

    public boolean isZoomed() {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return false;
        }
        if (perspective.getPresentation() == null) {
            return false;
        }
        return perspective.getPresentation().isZoomed();
    }

    protected void onActivate() {
        this.composite.setVisible(true);
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            perspective.onActivate();
            this.updateVisibility(null, perspective);
        }
        if (this.activePart == null && perspective != null) {
            IViewReference[] iViewReferenceArray = perspective.getViewReferences();
            int n = 0;
            while (n < iViewReferenceArray.length) {
                IViewReference iViewReference = iViewReferenceArray[n];
                if (iViewReference != null) {
                    this.activePart = iViewReference.getPart(false);
                    if (this.activePart != null) break;
                }
                ++n;
            }
        }
        if (this.activePart != null) {
            this.activationList.setActive(this.activePart);
            this.activatePart(this.activePart);
            this.actionSwitcher.updateActivePart(this.activePart);
            this.firePartActivated(this.activePart);
        } else {
            this.composite.setFocus();
        }
    }

    protected void onDeactivate() {
        if (this.activePart != null) {
            this.deactivatePart(this.activePart);
            this.actionSwitcher.updateActivePart(null);
            this.firePartDeactivated(this.activePart);
        }
        if (this.getActivePerspective() != null) {
            this.getActivePerspective().onDeactivate();
        }
        this.composite.setVisible(false);
    }

    private boolean partChangeAffectsZoom(IWorkbenchPartReference iWorkbenchPartReference) {
        PartPane partPane = ((WorkbenchPartReference)iWorkbenchPartReference).getPane();
        return this.getActivePerspective().getPresentation().partChangeAffectsZoom(partPane);
    }

    public void removeFastView(IViewReference iViewReference) {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return;
        }
        if (!perspective.isFastView(iViewReference)) {
            return;
        }
        this.window.firePerspectiveChanged(this, this.getPerspective(), iViewReference, "fastViewRemove");
        this.window.firePerspectiveChanged(this, this.getPerspective(), "fastViewRemove");
    }

    public void removePartListener(IPartListener iPartListener) {
        this.partListeners.removePartListener(iPartListener);
    }

    public void removePartListener(IPartListener2 iPartListener2) {
        this.partListeners2.removePartListener(iPartListener2);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.propertyChangeListeners.remove((Object)iPropertyChangeListener);
    }

    public void removeSelectionListener(ISelectionListener iSelectionListener) {
        this.selectionService.removeSelectionListener(iSelectionListener);
    }

    public void removeSelectionListener(String string, ISelectionListener iSelectionListener) {
        this.selectionService.removeSelectionListener(string, iSelectionListener);
    }

    public void removePostSelectionListener(ISelectionListener iSelectionListener) {
        this.selectionService.removePostSelectionListener(iSelectionListener);
    }

    public void removePostSelectionListener(String string, ISelectionListener iSelectionListener) {
        this.selectionService.removePostSelectionListener(string, iSelectionListener);
    }

    public void requestActivation(IWorkbenchPart iWorkbenchPart) {
        if (!this.certifyPart(iWorkbenchPart)) {
            return;
        }
        this.setActivePart(iWorkbenchPart);
    }

    public void resetPerspective() {
        new Runnable(){

            public void run() {
                WorkbenchPage.this.busyResetPerspective();
            }
        };
        this.busyResetPerspective();
    }

    public IStatus restoreState(IMemento iMemento, IPerspectiveDescriptor iPerspectiveDescriptor) {
        String string;
        MultiStatus multiStatus;
        String string2 = iMemento.getString("label");
        String string3 = null;
        if (UIStats.isDebugging(4)) {
            string3 = string2 == null ? "" : "::" + string2;
        }
        try {
            Object object;
            Object object2;
            UIStats.start(4, "WorkbenchPage" + string3);
            if (string2 == null) {
                string2 = "";
            }
            MultiStatus multiStatus2 = new MultiStatus("org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.WorkbenchPage_unableToRestorePerspective, (Object)string2), null);
            iMemento.getString("workingSet");
            IMemento iMemento2 = iMemento.getChild("views");
            if (iMemento2 != null) {
                multiStatus2.merge(this.getViewFactory().restoreState(iMemento2));
            }
            iMemento2 = iMemento.getChild("perspectives");
            String string4 = iMemento2.getString("activePart");
            String string5 = null;
            if (string4 != null && (string5 = ViewFactory.extractSecondaryId(string4)) != null) {
                string4 = ViewFactory.extractPrimaryId(string4);
            }
            String string6 = iMemento2.getString("activePerspective");
            IMemento[] iMementoArray = iMemento2.getChildren("perspective");
            Perspective perspective = null;
            int n = 0;
            while (n < iMementoArray.length) {
                try {
                    object2 = new Perspective(null, this);
                    multiStatus2.merge(((Perspective)object2).restoreState(iMementoArray[n]));
                    object = ((Perspective)object2).getDesc();
                    if (object.equals(iPerspectiveDescriptor)) {
                        perspective = object2;
                    } else if (perspective == null && object.getId().equals(string6)) {
                        perspective = object2;
                    }
                    this.perspList.add((Perspective)object2);
                    this.window.firePerspectiveOpened(this, (IPerspectiveDescriptor)object);
                }
                catch (WorkbenchException workbenchException) {}
                ++n;
            }
            n = 0;
            if (iPerspectiveDescriptor == null) {
                n = 1;
            } else if (perspective != null && perspective.getDesc().equals(iPerspectiveDescriptor)) {
                n = 1;
            } else {
                n = 0;
                perspective = this.createPerspective((PerspectiveDescriptor)iPerspectiveDescriptor);
                if (perspective == null) {
                    multiStatus2.merge((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.Workbench_showPerspectiveError, (Object)iPerspectiveDescriptor.getId()), null));
                }
            }
            this.perspList.setActive(perspective);
            perspective = this.perspList.getActive();
            if (perspective == null) {
                perspective = this.perspList.getNextActive();
                this.perspList.setActive(perspective);
                multiStatus2.merge(perspective.restoreState());
            }
            if (perspective != null && n != 0) {
                multiStatus2.merge(perspective.restoreState());
            }
            if (perspective != null) {
                this.window.firePerspectiveActivated(this, perspective.getDesc());
                if (string4 != null) {
                    object2 = perspective.findView(string4, string5);
                    object = null;
                    if (object2 != null) {
                        object = object2.getView(true);
                    }
                    if (object != null) {
                        this.activePart = object;
                    }
                }
            }
            multiStatus = multiStatus2;
            Object var15_16 = null;
            string = iPerspectiveDescriptor == null ? string2 : iPerspectiveDescriptor.getId();
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            String string7 = iPerspectiveDescriptor == null ? string2 : iPerspectiveDescriptor.getId();
            UIStats.end(4, string7, "WorkbenchPage" + string3);
            throw throwable;
        }
        UIStats.end(4, string, "WorkbenchPage" + string3);
        return multiStatus;
    }

    public boolean saveAllEditors(boolean bl) {
        return true;
    }

    public void savePerspective() {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return;
        }
        if (this.isZoomed()) {
            this.zoomOut();
        }
        perspective.saveDesc();
    }

    public void savePerspectiveAs(IPerspectiveDescriptor iPerspectiveDescriptor) {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return;
        }
        IPerspectiveDescriptor iPerspectiveDescriptor2 = perspective.getDesc();
        if (this.isZoomed()) {
            this.zoomOut();
        }
        perspective.saveDescAs(iPerspectiveDescriptor);
        this.window.firePerspectiveSavedAs(this, iPerspectiveDescriptor2, iPerspectiveDescriptor);
    }

    public IStatus saveState(IMemento iMemento) {
        Object object;
        if (this.isZoomed()) {
            this.zoomOut();
        }
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.WorkbenchPage_unableToSavePerspective, (Object)this.getLabel()), null);
        IMemento iMemento2 = iMemento.createChild("views");
        multiStatus.merge(this.getViewFactory().saveState(iMemento2));
        iMemento2 = iMemento.createChild("perspectives");
        if (this.getPerspective() != null) {
            iMemento2.putString("activePerspective", this.getPerspective().getId());
        }
        if (this.getActivePart() != null) {
            if (this.getActivePart() instanceof IViewPart) {
                object = (IViewReference)this.getReference(this.getActivePart());
                if (object != null) {
                    iMemento2.putString("activePart", ViewFactory.getKey((IViewReference)object));
                }
            } else {
                iMemento2.putString("activePart", this.getActivePart().getSite().getId());
            }
        }
        object = this.perspList.iterator();
        while (object.hasNext()) {
            Perspective perspective = (Perspective)object.next();
            IMemento iMemento3 = iMemento2.createChild("perspective");
            multiStatus.merge(perspective.saveState(iMemento3));
        }
        return multiStatus;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setActivePart(IWorkbenchPart iWorkbenchPart) {
        Object object;
        if (this.activePart == iWorkbenchPart) {
            return;
        }
        String string = null;
        if (UIStats.isDebugging(7)) {
            string = iWorkbenchPart != null ? iWorkbenchPart.getTitle() : "none";
        }
        try {
            IWorkbenchPart iWorkbenchPart2;
            UIStats.start(7, string);
            Perspective perspective = this.getActivePerspective();
            if (perspective != null) {
                perspective.partActivated(iWorkbenchPart);
            }
            if ((iWorkbenchPart2 = this.activePart) != null) {
                this.deactivatePart(iWorkbenchPart2);
            }
            this.activePart = iWorkbenchPart;
            if (iWorkbenchPart != null) {
                this.activationList.setActive(iWorkbenchPart);
            }
            this.activatePart(this.activePart);
            if (iWorkbenchPart2 != null) {
                this.firePartDeactivated(iWorkbenchPart2);
            }
            this.actionSwitcher.updateActivePart(iWorkbenchPart);
            if (iWorkbenchPart != null) {
                this.firePartActivated(iWorkbenchPart);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            Object object2 = iWorkbenchPart == null ? this : iWorkbenchPart;
            UIStats.end(7, object2, string);
            throw throwable;
        }
        {
            Object var5_7 = null;
            object = iWorkbenchPart == null ? this : iWorkbenchPart;
        }
        UIStats.end(7, object, string);
    }

    public void setEditorAreaVisible(boolean bl) {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return;
        }
        if (bl == perspective.isEditorAreaVisible()) {
            return;
        }
        if (this.isZoomed()) {
            this.zoomOut();
        }
        if (bl) {
            perspective.showEditorArea();
            this.window.firePerspectiveChanged(this, this.getPerspective(), "editorAreaShow");
        } else {
            perspective.hideEditorArea();
            this.window.firePerspectiveChanged(this, this.getPerspective(), "editorAreaHide");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setPerspective(Perspective perspective) {
        Perspective perspective2 = this.getActivePerspective();
        if (perspective2 == perspective) {
            return;
        }
        this.window.largeUpdateStart();
        try {
            block17: {
                block18: {
                    String string;
                    Object object;
                    if (perspective != null && (object = perspective.restoreState()).getSeverity() != 0) {
                        string = WorkbenchMessages.WorkbenchPage_errorReadingState;
                        ShowMessage.printError(string, (IStatus)object);
                    }
                    object = this.activePart;
                    this.setActivePart(null);
                    if (perspective2 != null) {
                        perspective2.onDeactivate();
                        this.window.firePerspectiveDeactivated(this, perspective2.getDesc());
                    }
                    this.perspList.setActive(perspective);
                    if (perspective != null) {
                        perspective.onActivate();
                        this.window.firePerspectiveActivated(this, perspective.getDesc());
                    } else {
                        object = null;
                    }
                    this.updateVisibility(perspective2, perspective);
                    if (object == null) break block18;
                    perspective2.setOldPartRef(this.getReference((IWorkbenchPart)object));
                    if (object instanceof IViewPart) {
                        String string2;
                        string = object.getSite().getId();
                        if (perspective.findView(string, string2 = ((IViewPart)object).getViewSite().getSecondaryId()) != null) {
                            this.activate((IWorkbenchPart)object);
                            break block17;
                        } else {
                            this.activateOldPart(perspective);
                        }
                        break block17;
                    } else {
                        this.activateOldPart(perspective);
                    }
                    break block17;
                }
                this.activateOldPart(perspective);
            }
            if (this.getActivePart() == null && this.activationList.getActive() != null) {
                this.activate(this.activationList.getActive());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.window.largeUpdateEnd();
            if (perspective == null) {
                return;
            }
            IPerspectiveDescriptor iPerspectiveDescriptor = perspective.getDesc();
            if (iPerspectiveDescriptor == null) {
                return;
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.window.largeUpdateEnd();
            if (perspective == null) {
                return;
            }
            IPerspectiveDescriptor iPerspectiveDescriptor = perspective.getDesc();
            if (iPerspectiveDescriptor == null) {
                return;
            }
            return;
        }
    }

    private void updateVisibility(Perspective perspective, Perspective perspective2) {
        Object object;
        int n;
        IViewReference[] iViewReferenceArray;
        HashSet<Object> hashSet = new HashSet<Object>();
        if (perspective != null) {
            iViewReferenceArray = perspective.getViewReferences();
            n = 0;
            while (n < iViewReferenceArray.length) {
                object = ((WorkbenchPartReference)((Object)iViewReferenceArray[n])).getPane();
                if (object != null) {
                    hashSet.add(object);
                }
                ++n;
            }
        }
        if (perspective2 != null) {
            iViewReferenceArray = perspective2.getViewReferences();
            n = 0;
            while (n < iViewReferenceArray.length) {
                object = ((WorkbenchPartReference)((Object)iViewReferenceArray[n])).getPane();
                if (object != null) {
                    hashSet.add(object);
                }
                ++n;
            }
            PerspectiveHelper perspectiveHelper = perspective2.getPresentation();
            object = hashSet.iterator();
            while (object.hasNext()) {
                PartPane partPane = (PartPane)object.next();
                IWorkbenchPartReference iWorkbenchPartReference = partPane.getPartReference();
                partPane.setVisible(perspectiveHelper.isPartVisible(iWorkbenchPartReference));
            }
        } else {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object = (PartPane)iterator.next();
                ((PartPane)object).setVisible(false);
            }
        }
    }

    private void activateOldPart(Perspective perspective) {
        if (this.window.isClosing()) {
            return;
        }
        if (perspective != null) {
            IWorkbenchPartReference iWorkbenchPartReference = perspective.getOldPartRef();
            IWorkbenchPart iWorkbenchPart = null;
            if (iWorkbenchPartReference != null) {
                iWorkbenchPart = iWorkbenchPartReference.getPart(false);
            }
            if (iWorkbenchPart != null) {
                this.activate(iWorkbenchPart);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPerspective(final IPerspectiveDescriptor iPerspectiveDescriptor) {
        try {
            this.getClientComposite().setRedraw(false);
            new Runnable(){

                public void run() {
                    WorkbenchPage.this.busySetPerspective(iPerspectiveDescriptor);
                }
            };
            this.busySetPerspective(iPerspectiveDescriptor);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.getClientComposite().setRedraw(true);
            IWorkbenchPart iWorkbenchPart = this.getActivePart();
            if (iWorkbenchPart == null) throw throwable;
            iWorkbenchPart.setFocus();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.getClientComposite().setRedraw(true);
        IWorkbenchPart iWorkbenchPart = this.getActivePart();
        if (iWorkbenchPart == null) return;
        iWorkbenchPart.setFocus();
    }

    public void showActionSet(String string) {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            this.window.firePerspectiveChanged(this, this.getPerspective(), "actionSetShow");
        }
    }

    public IViewPart showView(String string) throws PartInitException {
        return this.showView(string, null, 1);
    }

    public IViewPart showView(String string, String string2, int n) throws PartInitException {
        if (string2 != null && (string2.length() == 0 || string2.indexOf(":") != -1)) {
            throw new IllegalArgumentException(WorkbenchMessages.WorkbenchPage_IllegalSecondaryId);
        }
        if (!this.certifyMode(n)) {
            throw new IllegalArgumentException(WorkbenchMessages.WorkbenchPage_IllegalViewMode);
        }
        Object[] objectArray = new Object[1];
        try {
            objectArray[0] = this.busyShowView(string, string2, n);
        }
        catch (PartInitException partInitException) {
            objectArray[0] = partInitException;
        }
        if (objectArray[0] instanceof IViewPart) {
            return (IViewPart)objectArray[0];
        }
        if (objectArray[0] instanceof PartInitException) {
            throw (PartInitException)((Object)objectArray[0]);
        }
        throw new PartInitException(WorkbenchMessages.WorkbenchPage_AbnormalWorkbenchCondition);
    }

    private boolean certifyMode(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public void setState(IWorkbenchPartReference iWorkbenchPartReference, int n) {
        boolean bl;
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return;
        }
        PartPane partPane = ((WorkbenchPartReference)iWorkbenchPartReference).getPane();
        if (!partPane.isDocked()) {
            partPane.setZoomed(n == 1);
            return;
        }
        boolean bl2 = this.isZoomed();
        boolean bl3 = bl = n == 1;
        if (bl2 && !bl) {
            this.zoomOut();
        } else if (!bl2 && bl) {
            perspective.getPresentation().zoomIn(iWorkbenchPartReference);
            this.activate(iWorkbenchPartReference.getPart(true));
        }
        PartStack partStack = (PartStack)partPane.getContainer();
        if (partStack != null) {
            partStack.setMinimized(n == 0);
        }
    }

    int getState(IWorkbenchPartReference iWorkbenchPartReference) {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return 2;
        }
        PartPane partPane = ((WorkbenchPartReference)iWorkbenchPartReference).getPane();
        PartStack partStack = (PartStack)partPane.getContainer();
        if (partStack != null) {
            return partStack.getState();
        }
        return 2;
    }

    public void toggleZoom(IWorkbenchPartReference iWorkbenchPartReference) {
        int n = this.getState(iWorkbenchPartReference);
        boolean bl = n != 1;
        int n2 = bl ? 1 : 2;
        this.setState(iWorkbenchPartReference, n2);
    }

    public void updateActionBars() {
        this.window.updateActionBars();
    }

    private void updateTabList(IWorkbenchPart iWorkbenchPart) {
        PartSite partSite = (PartSite)iWorkbenchPart.getSite();
        PartPane partPane = partSite.getPane();
        if (partPane instanceof ViewPane) {
            ViewPane viewPane = (ViewPane)partPane;
            Control[] controlArray = viewPane.getTabList();
            if (!partPane.isDocked()) {
                viewPane.getControl().getShell().setTabList(controlArray);
            } else {
                this.getClientComposite().setTabList(controlArray);
            }
        }
    }

    public void updateTitle(IViewReference iViewReference) {
    }

    void zoomOut() {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            perspective.getPresentation().zoomOut();
        }
    }

    private void zoomOutIfNecessary(IWorkbenchPart iWorkbenchPart) {
        if (this.isZoomed() && this.partChangeAffectsZoom(((PartSite)iWorkbenchPart.getSite()).getPartReference())) {
            this.zoomOut();
        }
    }

    public int getEditorReuseThreshold() {
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getInt("REUSE_OPEN_EDITORS");
    }

    public void setEditorReuseThreshold(int n) {
    }

    public IPerspectiveDescriptor[] getOpenPerspectives() {
        Perspective[] perspectiveArray = this.perspList.getOpenedPerspectives();
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = new IPerspectiveDescriptor[perspectiveArray.length];
        int n = 0;
        while (n < iPerspectiveDescriptorArray.length) {
            iPerspectiveDescriptorArray[n] = perspectiveArray[n].getDesc();
            ++n;
        }
        return iPerspectiveDescriptorArray;
    }

    public IPerspectiveDescriptor[] getSortedPerspectives() {
        Perspective[] perspectiveArray = this.perspList.getSortedPerspectives();
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = new IPerspectiveDescriptor[perspectiveArray.length];
        int n = 0;
        while (n < iPerspectiveDescriptorArray.length) {
            iPerspectiveDescriptorArray[n] = perspectiveArray[n].getDesc();
            ++n;
        }
        return iPerspectiveDescriptorArray;
    }

    public IWorkbenchPartReference[] getSortedParts() {
        return this.activationList.getParts();
    }

    public IWorkbenchPartReference getReference(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == null) {
            return null;
        }
        PartPane partPane = ((PartSite)iWorkbenchPart.getSite()).getPane();
        if (partPane == null) {
            IViewReference[] iViewReferenceArray = this.getViewReferences();
            int n = 0;
            while (n < iViewReferenceArray.length) {
                if (iViewReferenceArray[n].getPart(false) == iWorkbenchPart) {
                    return iViewReferenceArray[n];
                }
                ++n;
            }
            return null;
        }
        return partPane.getPartReference();
    }

    protected HashMap getStateMap() {
        return this.stateMap;
    }

    protected void addPerspective(Perspective perspective) {
        this.perspList.add(perspective);
        this.window.firePerspectiveOpened(this, perspective.getDesc());
    }

    private IViewReference[] getViewReferenceStack(IViewPart iViewPart) {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null || !this.certifyPart(iViewPart)) {
            return null;
        }
        ILayoutContainer iLayoutContainer = ((PartSite)iViewPart.getSite()).getPane().getContainer();
        if (iLayoutContainer instanceof ViewStack) {
            ViewStack viewStack = (ViewStack)iLayoutContainer;
            ArrayList<IViewReference> arrayList = new ArrayList<IViewReference>(viewStack.getChildren().length);
            int n = 0;
            while (n < viewStack.getChildren().length) {
                IViewReference iViewReference;
                LayoutPart layoutPart = viewStack.getChildren()[n];
                if (layoutPart instanceof ViewPane && (iViewReference = ((ViewPane)layoutPart).getViewReference()) != null) {
                    arrayList.add(iViewReference);
                }
                ++n;
            }
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    int n = -1 * WorkbenchPage.this.activationList.indexOf((IWorkbenchPartReference)object);
                    int n2 = -1 * WorkbenchPage.this.activationList.indexOf((IWorkbenchPartReference)object2);
                    return n - n2;
                }
            });
            return arrayList.toArray(new IViewReference[arrayList.size()]);
        }
        return new IViewReference[]{(IViewReference)this.getReference(iViewPart)};
    }

    public IViewPart[] getViewStack(IViewPart iViewPart) {
        IViewReference[] iViewReferenceArray = this.getViewReferenceStack(iViewPart);
        if (iViewReferenceArray == null) {
            return null;
        }
        IViewPart[] iViewPartArray = new IViewPart[iViewReferenceArray.length];
        int n = 0;
        while (n < iViewReferenceArray.length) {
            iViewPartArray[n] = iViewReferenceArray[n].getView(true);
            ++n;
        }
        return iViewPartArray;
    }

    IWorkbenchPartReference[] getAllParts() {
        IViewReference[] iViewReferenceArray = this.viewFactory.getViews();
        IWorkbenchPartReference[] iWorkbenchPartReferenceArray = new IWorkbenchPartReference[iViewReferenceArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < iViewReferenceArray.length) {
            iWorkbenchPartReferenceArray[n++] = iViewReferenceArray[n2];
            ++n2;
        }
        return iWorkbenchPartReferenceArray;
    }

    IWorkbenchPartReference[] getOpenParts() {
        IWorkbenchPartReference[] iWorkbenchPartReferenceArray = this.getAllParts();
        ArrayList<IWorkbenchPartReference> arrayList = new ArrayList<IWorkbenchPartReference>();
        int n = 0;
        while (n < iWorkbenchPartReferenceArray.length) {
            IWorkbenchPartReference iWorkbenchPartReference = iWorkbenchPartReferenceArray[n];
            IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
            if (iWorkbenchPart != null) {
                arrayList.add(iWorkbenchPartReference);
            }
            ++n;
        }
        return arrayList.toArray(new IWorkbenchPartReference[arrayList.size()]);
    }

    public void testInvariants() {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            perspective.testInvariants();
        }
    }

    public IExtensionTracker getExtensionTracker() {
        if (this.tracker == null) {
            this.tracker = new UIExtensionTracker(this.getWorkbenchWindow().getWorkbench().getDisplay());
        }
        return this.tracker;
    }

    public String[] getNewWizardShortcuts() {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return new String[0];
        }
        return perspective.getNewWizardShortcuts();
    }

    public String[] getPerspectiveShortcuts() {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return new String[0];
        }
        return perspective.getPerspectiveShortcuts();
    }

    public String[] getShowViewShortcuts() {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return new String[0];
        }
        return perspective.getShowViewShortcuts();
    }

    private class ActionSwitcher {
        private IWorkbenchPart activePart;

        private ActionSwitcher() {
        }

        public void updateActivePart(IWorkbenchPart iWorkbenchPart) {
            if (this.activePart == iWorkbenchPart) {
                return;
            }
            this.activePart = iWorkbenchPart;
        }
    }

    private class ActivationList {
        List parts = new ArrayList();

        private ActivationList() {
        }

        void setActive(IWorkbenchPart iWorkbenchPart) {
            if (this.parts.size() <= 0) {
                return;
            }
            PartPane partPane = ((PartSite)iWorkbenchPart.getSite()).getPane();
            IWorkbenchPartReference iWorkbenchPartReference = WorkbenchPage.this.getReference(iWorkbenchPart);
            if (iWorkbenchPartReference == this.parts.get(this.parts.size() - 1)) {
                return;
            }
            this.parts.remove(iWorkbenchPartReference);
            this.parts.add(iWorkbenchPartReference);
            partPane.addPropertyChangeListener(WorkbenchPage.this.propertyChangeListener);
        }

        void setActive(IWorkbenchPartReference iWorkbenchPartReference) {
            this.setActive(iWorkbenchPartReference.getPart(true));
        }

        void add(IWorkbenchPartReference iWorkbenchPartReference) {
            if (this.parts.indexOf(iWorkbenchPartReference) >= 0) {
                return;
            }
            PartPane partPane = ((WorkbenchPartReference)iWorkbenchPartReference).getPane();
            if (partPane != null) {
                partPane.addPropertyChangeListener(WorkbenchPage.this.propertyChangeListener);
            }
            this.parts.add(0, iWorkbenchPartReference);
        }

        IWorkbenchPart getActive() {
            if (this.parts.isEmpty()) {
                return null;
            }
            return this.getActive(this.parts.size() - 1);
        }

        IWorkbenchPart getPreviouslyActive() {
            if (this.parts.size() < 2) {
                return null;
            }
            return this.getActive(this.parts.size() - 2);
        }

        private IWorkbenchPart getActive(int n) {
            IWorkbenchPartReference iWorkbenchPartReference = this.getActiveReference(n, false);
            if (iWorkbenchPartReference == null) {
                return null;
            }
            return iWorkbenchPartReference.getPart(true);
        }

        private IWorkbenchPartReference getActiveReference(int n, boolean bl) {
            IWorkbenchPartReference iWorkbenchPartReference = this.getActiveReference(n, bl, true);
            if (iWorkbenchPartReference != null) {
                return iWorkbenchPartReference;
            }
            return this.getActiveReference(n, bl, false);
        }

        private IWorkbenchPartReference getActiveReference(int n, boolean bl, boolean bl2) {
            IViewReference[] iViewReferenceArray = WorkbenchPage.this.getViewReferences();
            int n2 = n;
            while (n2 >= 0) {
                ILayoutContainer iLayoutContainer;
                WorkbenchPartReference workbenchPartReference = (WorkbenchPartReference)this.parts.get(n2);
                PartPane partPane = workbenchPartReference.getPane();
                if (!(partPane != null && ((iLayoutContainer = partPane.getContainer()) != null && !iLayoutContainer.allowsAutoFocus() || bl2 && partPane.isObscuredByZoom()))) {
                    if (workbenchPartReference instanceof IViewReference) {
                        if (!((IViewReference)((Object)workbenchPartReference)).isFastView()) {
                            int n3 = 0;
                            while (n3 < iViewReferenceArray.length) {
                                if (iViewReferenceArray[n3] == workbenchPartReference) {
                                    return workbenchPartReference;
                                }
                                ++n3;
                            }
                        }
                    } else {
                        return workbenchPartReference;
                    }
                }
                --n2;
            }
            return null;
        }

        int indexOf(IWorkbenchPart iWorkbenchPart) {
            return this.parts.indexOf(WorkbenchPage.this.getReference(iWorkbenchPart));
        }

        int indexOf(IWorkbenchPartReference iWorkbenchPartReference) {
            return this.parts.indexOf(iWorkbenchPartReference);
        }

        boolean remove(IWorkbenchPartReference iWorkbenchPartReference) {
            PartPane partPane = ((WorkbenchPartReference)iWorkbenchPartReference).getPane();
            if (partPane != null) {
                partPane.removePropertyChangeListener(WorkbenchPage.this.propertyChangeListener);
            }
            return this.parts.remove(iWorkbenchPartReference);
        }

        private IWorkbenchPartReference[] getParts() {
            IViewReference[] iViewReferenceArray = WorkbenchPage.this.getViewReferences();
            ArrayList<IWorkbenchPartReference> arrayList = new ArrayList<IWorkbenchPartReference>(this.parts.size());
            IWorkbenchPartReference[] iWorkbenchPartReferenceArray = this.parts.iterator();
            block0: while (iWorkbenchPartReferenceArray.hasNext()) {
                IWorkbenchPartReference iWorkbenchPartReference = (IWorkbenchPartReference)iWorkbenchPartReferenceArray.next();
                if (iWorkbenchPartReference instanceof IViewReference) {
                    int n = 0;
                    while (n < iViewReferenceArray.length) {
                        if (iViewReferenceArray[n] == iWorkbenchPartReference) {
                            arrayList.add(iWorkbenchPartReference);
                            continue block0;
                        }
                        ++n;
                    }
                    continue;
                }
                arrayList.add(iWorkbenchPartReference);
            }
            iWorkbenchPartReferenceArray = new IWorkbenchPartReference[arrayList.size()];
            return arrayList.toArray(iWorkbenchPartReferenceArray);
        }
    }

    private class PerspectiveList {
        private List openedList = new ArrayList(15);
        private List usedList = new ArrayList(15);
        private Perspective active;

        public Perspective[] getSortedPerspectives() {
            Perspective[] perspectiveArray = new Perspective[this.usedList.size()];
            return this.usedList.toArray(perspectiveArray);
        }

        public boolean add(Perspective perspective) {
            this.openedList.add(perspective);
            this.usedList.add(0, perspective);
            return true;
        }

        public Iterator iterator() {
            return this.openedList.iterator();
        }

        public Perspective[] getOpenedPerspectives() {
            Perspective[] perspectiveArray = new Perspective[this.openedList.size()];
            return this.openedList.toArray(perspectiveArray);
        }

        public boolean remove(Perspective perspective) {
            if (this.active == perspective) {
                this.active = null;
            }
            this.usedList.remove(perspective);
            return this.openedList.remove(perspective);
        }

        public void swap(Perspective perspective, Perspective perspective2) {
            int n = this.openedList.indexOf(perspective);
            int n2 = this.openedList.indexOf(perspective2);
            if (n < 0 || n2 < 0) {
                return;
            }
            this.openedList.set(n, perspective2);
            this.openedList.set(n2, perspective);
        }

        public boolean isEmpty() {
            return this.openedList.isEmpty();
        }

        public Perspective getActive() {
            return this.active;
        }

        public Perspective getNextActive() {
            if (this.active == null) {
                if (this.usedList.isEmpty()) {
                    return null;
                }
                return (Perspective)this.usedList.get(this.usedList.size() - 1);
            }
            if (this.usedList.size() < 2) {
                return null;
            }
            return (Perspective)this.usedList.get(this.usedList.size() - 2);
        }

        public int size() {
            return this.openedList.size();
        }

        public void setActive(Perspective perspective) {
            if (perspective == this.active) {
                return;
            }
            this.active = perspective;
            if (perspective != null) {
                this.usedList.remove(perspective);
                this.usedList.add(perspective);
            }
        }
    }
}

