/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ercp.swt.mobile.MobileShell;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.IShellProvider;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PerspectiveListenerList;
import org.eclipse.ui.internal.SameShellProvider;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindowConfigurer;
import org.eclipse.ui.internal.layout.TrimLayout;
import org.eclipse.ui.internal.layout.TrimLayoutData;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.registry.UIExtensionTracker;

public class WorkbenchWindow
implements IWorkbenchWindow {
    private boolean operationInProgress = false;
    private static int orientation = 0;
    private Control contents;
    private int returnCode = 0;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private IShellProvider parentShell;
    private static IShellProvider defaultModalParent = new IShellProvider(){

        public Shell getShell() {
            Display display = Display.getCurrent();
            if (display == null) {
                return null;
            }
            Shell shell = display.getActiveShell();
            if (shell == null) {
                shell = WorkbenchWindow.getModalChild(Display.getCurrent().getShells());
            } else {
                Shell shell2 = WorkbenchWindow.getModalChild(shell.getShells());
                if (shell2 != null) {
                    shell = shell2;
                }
            }
            return shell;
        }
    };
    private WorkbenchWindowAdvisor windowAdvisor;
    private PageList pageList = new PageList();
    private PerspectiveListenerList perspectiveListeners = new PerspectiveListenerList();
    private boolean updateDisabled = true;
    private boolean closing = false;
    private boolean shellActivated = false;
    private TrimLayout defaultLayout;
    private boolean emptyWindowContentsCreated = false;
    private Control emptyWindowContents;
    private Rectangle normalBounds;
    private boolean asMaximizedState = false;
    private Composite pageComposite;
    private int submenus = 0;
    private WorkbenchWindowConfigurer windowConfigurer = null;
    private int shellStyle;
    static final String GRP_PAGES = "pages";
    static final String GRP_PERSPECTIVES = "perspectives";
    static final String GRP_FAST_VIEWS = "fastViews";
    static final int VGAP = 0;
    static final int CLIENT_INSET = 3;
    static final int BAR_SIZE = 23;
    public static final int SHOW_VIEW_SUBMENU = 1;
    public static final int OPEN_PERSPECTIVE_SUBMENU = 2;
    public static final int NEW_WIZARD_SUBMENU = 4;
    private boolean perspectiveBarVisible = true;
    private boolean statusLineVisible = true;
    private Map actionSetHandlersByCommandId = new HashMap();
    private Map globalActionHandlersByCommandId = new HashMap();
    private List handlerActivations = new ArrayList();
    private int largeUpdates = 0;
    private IExtensionTracker tracker;
    private Shell shell;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void addSubmenu(int n) {
        this.submenus |= n;
    }

    public boolean containsSubmenu(int n) {
        return (this.submenus & n) != 0;
    }

    public WorkbenchWindow() {
        PlatformUI.getWorkbench();
        this.fireWindowOpening();
        this.setShellStyle(this.getWindowConfigurer().getShellStyle());
        Shell shell = this.getWorkbench().getDisplay().getActiveShell();
        this.setParentShell(shell);
    }

    protected void setShellStyle(int n) {
        this.shellStyle = n;
    }

    protected void setParentShell(Shell shell) {
        Assert.isTrue(this.shell == null, "There must not be an existing shell.");
        this.parentShell = new SameShellProvider((Control)shell);
    }

    protected int perspectiveBarStyle() {
        return 8520000;
    }

    void submitActionSetAndGlobalHandlers() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IHandlerService iHandlerService = (IHandlerService)iWorkbench.getAdapter(clazz);
        HashMap hashMap = new HashMap();
        hashMap.putAll(this.actionSetHandlersByCommandId);
        hashMap.putAll(this.globalActionHandlersByCommandId);
        ArrayList<IHandlerActivation> arrayList = new ArrayList<IHandlerActivation>(hashMap.size());
        Iterator iterator = this.handlerActivations.iterator();
        while (iterator.hasNext()) {
            IHandlerActivation iHandlerActivation = (IHandlerActivation)iterator.next();
            String string = iHandlerActivation.getCommandId();
            Object v = hashMap.get(string);
            if (v == iHandlerActivation.getHandler()) {
                hashMap.remove(string);
                arrayList.add(iHandlerActivation);
                continue;
            }
            iHandlerService.deactivateHandler(iHandlerActivation);
        }
        this.handlerActivations = arrayList;
    }

    public void addPageListener(IPageListener iPageListener) {
    }

    public void addPerspectiveListener(IPerspectiveListener iPerspectiveListener) {
        this.perspectiveListeners.addPerspectiveListener(iPerspectiveListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean busyClose() {
        boolean bl;
        block8: {
            bl = false;
            this.closing = true;
            this.updateDisabled = true;
            try {
                Workbench workbench = this.getWorkbenchImpl();
                int n = workbench.getWorkbenchWindowCount();
                if (!workbench.isStarting() && !workbench.isClosing() && n <= 1 && workbench.getWorkbenchConfigurer().getExitOnLastWindowClose()) {
                    bl = workbench.close();
                } else if (this.okToClose()) {
                    bl = this.hardClose();
                }
                Object var4_6 = null;
                if (!bl) {
                    this.closing = false;
                    this.updateDisabled = false;
                }
                if (!bl || this.tracker == null) break block8;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (!bl) {
                    this.closing = false;
                    this.updateDisabled = false;
                }
                throw throwable;
            }
            this.tracker.close();
        }
        return bl;
    }

    protected IWorkbenchPage busyOpenPage(String string, IAdaptable iAdaptable) throws WorkbenchException {
        IWorkbenchPage iWorkbenchPage = null;
        if (this.pageList.isEmpty()) {
            iWorkbenchPage = new WorkbenchPage(this, string, iAdaptable);
            this.pageList.add(iWorkbenchPage);
            this.firePageOpened(iWorkbenchPage);
            this.setActivePage(iWorkbenchPage);
        } else {
            IWorkbenchWindow iWorkbenchWindow = this.getWorkbench().openWorkbenchWindow(string, iAdaptable);
            iWorkbenchPage = iWorkbenchWindow.getActivePage();
        }
        return iWorkbenchPage;
    }

    public int open() {
        if (this.getPages().length == 0) {
            this.showEmptyWindowContents();
        }
        this.fireWindowCreated();
        this.getWindowAdvisor().openIntro();
        int n = this.windowOpen();
        this.fireWindowOpened();
        return n;
    }

    public int windowOpen() {
        if (this.shell == null || this.shell.isDisposed()) {
            this.shell = null;
            this.create();
        }
        this.constrainShellSize();
        if (((Workbench)this.getWorkbench()).isOpenShellEnabled()) {
            this.shell.open();
        }
        return this.returnCode;
    }

    protected void constrainShellSize() {
        Rectangle rectangle;
        Rectangle rectangle2 = this.shell.getBounds();
        if (!rectangle2.equals((Object)(rectangle = this.getConstrainedShellBounds(rectangle2)))) {
            this.shell.setBounds(rectangle);
        }
    }

    public void create() {
        this.shell = this.createShell();
        this.contents = this.createContents((Composite)this.shell);
        this.initializeBounds();
    }

    protected final Shell createShell() {
        Shell shell = this.getParentShell();
        if (shell != null && shell.isDisposed()) {
            this.parentShell = new SameShellProvider(null);
            shell = this.getParentShell();
        }
        MobileShell mobileShell = new MobileShell(Display.getCurrent(), this.getShellStyle());
        mobileShell.setData((Object)this);
        mobileShell.addShellListener(this.getShellListener());
        this.configureShell((Shell)mobileShell);
        return mobileShell;
    }

    protected Shell getParentShell() {
        Shell shell = this.parentShell.getShell();
        int n = 229376;
        if ((this.getShellStyle() & n) != 0 && shell == null) {
            shell = defaultModalParent.getShell();
        }
        return shell;
    }

    private static Shell getModalChild(Shell[] shellArray) {
        int n = 229376;
        int n2 = shellArray.length - 1;
        while (n2 >= 0) {
            Shell shell = shellArray[n2];
            Shell[] shellArray2 = shell.getShells();
            Shell shell2 = WorkbenchWindow.getModalChild(shellArray2);
            if (shell2 != null) {
                return shell2;
            }
            if (shell.isVisible() && (shell.getStyle() & n) != 0) {
                return shell;
            }
            --n2;
        }
        return null;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    protected ShellListener getShellListener() {
        return new ShellListener(){

            public void shellClosed(ShellEvent shellEvent) {
                shellEvent.doit = false;
                if (WorkbenchWindow.this.canHandleShellCloseEvent()) {
                    WorkbenchWindow.this.handleShellCloseEvent();
                }
            }

            public void shellActivated(ShellEvent shellEvent) {
            }

            public void shellDeactivated(ShellEvent shellEvent) {
            }

            public void shellDeiconified(ShellEvent shellEvent) {
            }

            public void shellIconified(ShellEvent shellEvent) {
            }
        };
    }

    protected int getShellStyle() {
        return this.shellStyle;
    }

    protected void handleShellCloseEvent() {
        this.setReturnCode(1);
        this.close();
    }

    protected void setReturnCode(int n) {
        this.returnCode = n;
    }

    protected boolean canHandleShellCloseEvent() {
        if (this.operationInProgress) {
            return false;
        }
        return this.fireWindowShellClosing();
    }

    public boolean close() {
        boolean[] blArray = new boolean[]{this.busyClose()};
        return blArray[0];
    }

    protected boolean isClosing() {
        return this.closing || this.getWorkbenchImpl().isClosing();
    }

    private void closeAllPages() {
        this.setActivePage(null);
        PageList pageList = this.pageList;
        this.pageList = new PageList();
        Iterator iterator = pageList.iterator();
        while (iterator.hasNext()) {
            WorkbenchPage workbenchPage = (WorkbenchPage)iterator.next();
            this.firePageClosed(workbenchPage);
            workbenchPage.dispose();
        }
        if (!this.closing) {
            this.showEmptyWindowContents();
        }
    }

    public void closeAllPages(boolean bl) {
        boolean bl2;
        if (bl && !(bl2 = this.saveAllPages(true))) {
            return;
        }
        this.closeAllPages();
    }

    protected boolean closePage(IWorkbenchPage iWorkbenchPage, boolean bl) {
        WorkbenchPage workbenchPage;
        boolean bl2;
        if (!this.pageList.contains(iWorkbenchPage)) {
            return false;
        }
        WorkbenchPage workbenchPage2 = (WorkbenchPage)iWorkbenchPage;
        boolean bl3 = bl2 = workbenchPage2 == this.getActiveWorkbenchPage();
        if (bl2) {
            this.setActivePage(null);
        }
        this.pageList.remove(workbenchPage2);
        workbenchPage2.dispose();
        if (bl2 && (workbenchPage = this.pageList.getNextActive()) != null) {
            this.setActivePage(workbenchPage);
        }
        if (!this.closing && this.pageList.isEmpty()) {
            this.showEmptyWindowContents();
        }
        return true;
    }

    private void showEmptyWindowContents() {
        if (!this.emptyWindowContentsCreated) {
            Composite composite = this.getPageComposite();
            this.emptyWindowContentsCreated = true;
            composite.layout();
        }
    }

    private void hideEmptyWindowContents() {
        if (this.emptyWindowContentsCreated) {
            if (this.emptyWindowContents != null) {
                this.emptyWindowContents.dispose();
                this.emptyWindowContents = null;
                this.getPageComposite().layout();
            }
            this.emptyWindowContentsCreated = false;
        }
    }

    protected void configureShell(Shell shell) {
        String string;
        Layout layout = this.getLayout();
        if (layout != null) {
            shell.setLayout(layout);
        }
        if ((string = this.getWindowConfigurer().basicGetTitle()) != null) {
            shell.setText(string);
        }
        this.trackShellActivation(shell);
        this.trackShellResize(shell);
    }

    public static int getDefaultOrientation() {
        return orientation;
    }

    public static void setDefaultOrientation(int n) {
        orientation = n;
    }

    protected void createTrimWidgets(Shell shell) {
    }

    protected Composite createPageComposite(Composite composite) {
        this.pageComposite = new Composite(composite, 524288);
        this.pageComposite.setLayout((Layout)new FillLayout());
        return this.pageComposite;
    }

    protected Control createContents(Composite composite) {
        this.getWindowAdvisor().createWindowContents((Shell)composite);
        Assert.isNotNull(this.pageComposite, "createWindowContents must call configurer.createPageComposite");
        return this.pageComposite;
    }

    protected void createDefaultContents(Shell shell) {
        this.defaultLayout = new TrimLayout();
        this.defaultLayout.setSpacing(5, 5, 2, 2);
        shell.setLayout((Layout)this.defaultLayout);
        this.createPageComposite((Composite)shell);
        this.setLayoutDataForContents();
    }

    private void fireWindowOpening() {
        this.getWindowAdvisor().preWindowOpen();
    }

    void fireWindowRestored() throws WorkbenchException {
        this.getWindowAdvisor().postWindowRestore();
    }

    private void fireWindowCreated() {
        this.getWindowAdvisor().postWindowCreate();
    }

    private void fireWindowOpened() {
        this.getWorkbenchImpl().fireWindowOpened(this);
        this.getWindowAdvisor().postWindowOpen();
    }

    private boolean fireWindowShellClosing() {
        return this.getWindowAdvisor().preWindowShellClose();
    }

    private void fireWindowClosed() {
        this.getWindowAdvisor().postWindowClose();
        this.getWorkbenchImpl().fireWindowClosed(this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void firePageActivated(IWorkbenchPage iWorkbenchPage) {
        String string = null;
        if (UIStats.isDebugging(11)) {
            string = "activated " + iWorkbenchPage.getLabel();
        }
        try {
            UIStats.start(11, string);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            UIStats.end(11, iWorkbenchPage.getLabel(), string);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        UIStats.end(11, iWorkbenchPage.getLabel(), string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void firePageClosed(IWorkbenchPage iWorkbenchPage) {
        String string = null;
        if (UIStats.isDebugging(11)) {
            string = "closed " + iWorkbenchPage.getLabel();
        }
        try {
            UIStats.start(11, string);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            UIStats.end(11, iWorkbenchPage.getLabel(), string);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        UIStats.end(11, iWorkbenchPage.getLabel(), string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void firePageOpened(IWorkbenchPage iWorkbenchPage) {
        String string = null;
        if (UIStats.isDebugging(11)) {
            string = "opened " + iWorkbenchPage.getLabel();
        }
        try {
            UIStats.start(11, string);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            UIStats.end(11, iWorkbenchPage.getLabel(), string);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        UIStats.end(11, iWorkbenchPage.getLabel(), string);
    }

    void firePerspectiveActivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
        this.perspectiveListeners.firePerspectiveActivated(iWorkbenchPage, iPerspectiveDescriptor);
    }

    void firePerspectiveDeactivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
        this.perspectiveListeners.firePerspectiveDeactivated(iWorkbenchPage, iPerspectiveDescriptor);
    }

    void firePerspectiveChanged(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, String string) {
        if (iPerspectiveDescriptor != null) {
            this.perspectiveListeners.firePerspectiveChanged(iWorkbenchPage, iPerspectiveDescriptor, string);
        }
    }

    void firePerspectiveChanged(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, IWorkbenchPartReference iWorkbenchPartReference, String string) {
        if (iPerspectiveDescriptor != null) {
            this.perspectiveListeners.firePerspectiveChanged(iWorkbenchPage, iPerspectiveDescriptor, iWorkbenchPartReference, string);
        }
    }

    void firePerspectiveClosed(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
        this.perspectiveListeners.firePerspectiveClosed(iWorkbenchPage, iPerspectiveDescriptor);
    }

    void firePerspectiveOpened(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
        this.perspectiveListeners.firePerspectiveOpened(iWorkbenchPage, iPerspectiveDescriptor);
    }

    void firePerspectiveSavedAs(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, IPerspectiveDescriptor iPerspectiveDescriptor2) {
        this.perspectiveListeners.firePerspectiveSavedAs(iWorkbenchPage, iPerspectiveDescriptor, iPerspectiveDescriptor2);
    }

    public IWorkbenchPage getActivePage() {
        return this.pageList.getActive();
    }

    WorkbenchPage getActiveWorkbenchPage() {
        return this.pageList.getActive();
    }

    protected Composite getPageComposite() {
        return this.pageComposite;
    }

    public IWorkbenchPage[] getPages() {
        return this.pageList.getPages();
    }

    public IPartService getPartService() {
        System.out.println("WorkbenchWindow:getPartService: might need to restore this");
        return null;
    }

    protected Layout getLayout() {
        return null;
    }

    public ISelectionService getSelectionService() {
        System.out.println("WorkbenchWindow:getSelectionService: might need to restore this");
        return null;
    }

    public boolean getShellActivated() {
        return this.shellActivated;
    }

    public StatusLineManager getStatusLineManager2() {
        return null;
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hardClose() {
        try {
            IWorkbench iWorkbench = this.getWorkbench();
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            IHandlerService iHandlerService = (IHandlerService)iWorkbench.getAdapter(clazz);
            iHandlerService.deactivateHandlers(this.handlerActivations);
            Iterator iterator = this.handlerActivations.iterator();
            while (true) {
                block7: {
                    if (iterator.hasNext()) break block7;
                    this.handlerActivations.clear();
                    this.actionSetHandlersByCommandId.clear();
                    this.globalActionHandlersByCommandId.clear();
                    this.closeAllPages();
                    this.fireWindowClosed();
                    this.getWindowAdvisor().dispose();
                    break;
                }
                IHandlerActivation iHandlerActivation = (IHandlerActivation)iterator.next();
                iHandlerActivation.getHandler().dispose();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            boolean bl = this.appWindowClose();
            throw throwable;
        }
        {
            Object var6_7 = null;
            return this.appWindowClose();
        }
    }

    public boolean appWindowClose() {
        if (this.operationInProgress) {
            return false;
        }
        return this.windowClose();
    }

    public boolean windowClose() {
        if (this.shell == null || this.shell.isDisposed()) {
            return true;
        }
        this.shell.dispose();
        this.shell = null;
        this.contents = null;
        return true;
    }

    public boolean isApplicationMenu(String string) {
        return false;
    }

    public boolean okToClose() {
        return this.getWorkbenchImpl().isClosing() || this.saveAllPages(true);
    }

    public IWorkbenchPage openPage(String string, IAdaptable iAdaptable) throws WorkbenchException {
        Assert.isNotNull(string);
        Object[] objectArray = new Object[1];
        try {
            objectArray[0] = this.busyOpenPage(string, iAdaptable);
        }
        catch (WorkbenchException workbenchException) {
            objectArray[0] = workbenchException;
        }
        if (objectArray[0] instanceof IWorkbenchPage) {
            return (IWorkbenchPage)objectArray[0];
        }
        if (objectArray[0] instanceof WorkbenchException) {
            throw (WorkbenchException)((Object)objectArray[0]);
        }
        throw new WorkbenchException(WorkbenchMessages.WorkbenchWindow_exceptionMessage);
    }

    public IWorkbenchPage openPage(IAdaptable iAdaptable) throws WorkbenchException {
        String string = this.getWorkbenchImpl().getPerspectiveRegistry().getDefaultPerspective();
        return this.openPage(string, iAdaptable);
    }

    public void removePageListener(IPageListener iPageListener) {
    }

    public void removePerspectiveListener(IPerspectiveListener iPerspectiveListener) {
        this.perspectiveListeners.removePerspectiveListener(iPerspectiveListener);
    }

    private IStatus unableToRestorePage(IMemento iMemento) {
        String string = iMemento.getString("label");
        if (string == null) {
            string = "";
        }
        return new Status(4, "org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.WorkbenchWindow_unableToRestorePerspective, (Object)string), null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus restoreState(IMemento iMemento, IPerspectiveDescriptor iPerspectiveDescriptor) {
        Object object;
        Object object2;
        Assert.isNotNull(this.getShell());
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.WorkbenchWindow_problemsRestoringWindow, null);
        Rectangle rectangle = this.getShell().getDisplay().getBounds();
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Integer n = iMemento.getInteger("x");
        rectangle2.x = n == null ? 0 : n;
        n = iMemento.getInteger("y");
        rectangle2.y = n == null ? 0 : n;
        n = iMemento.getInteger("width");
        rectangle2.width = n == null ? 0 : n;
        n = iMemento.getInteger("height");
        int n2 = rectangle2.height = n == null ? 0 : n;
        if (!rectangle2.isEmpty()) {
            if (!rectangle2.intersects(rectangle)) {
                object2 = this.getShell().getDisplay().getClientArea();
                rectangle2.x = object2.x;
                rectangle2.y = object2.y;
            }
            this.getShell().setBounds(rectangle2);
        }
        if ("true".equals(iMemento.getString("maximized"))) {
            this.getShell().setMaximized(true);
        }
        "true".equals(iMemento.getString("minimized"));
        object2 = null;
        IMemento[] iMementoArray = iMemento.getChildren("page");
        int n3 = 0;
        while (n3 < iMementoArray.length) {
            block17: {
                Object object3;
                IAdaptable iAdaptable;
                String string;
                block18: {
                    Object var16_19;
                    IMemento iMemento2;
                    block19: {
                        object = iMementoArray[n3];
                        string = object.getString("focus");
                        if (string == null || string.length() == 0) break block17;
                        iAdaptable = null;
                        iMemento2 = object.getChild("input");
                        if (iMemento2 == null) break block18;
                        object3 = iMemento2.getString("factoryID");
                        if (object3 != null) break block19;
                        WorkbenchPlugin.log("Unable to restore page - no input factory ID.");
                        multiStatus.add(this.unableToRestorePage((IMemento)object));
                        break block17;
                    }
                    try {
                        block22: {
                            block21: {
                                IElementFactory iElementFactory;
                                block20: {
                                    UIStats.start(4, "WorkbenchPageFactory");
                                    iElementFactory = PlatformUI.getWorkbench().getElementFactory((String)object3);
                                    if (iElementFactory != null) break block20;
                                    WorkbenchPlugin.log("Unable to restore page - cannot instantiate input factory: " + (String)object3);
                                    multiStatus.add(this.unableToRestorePage((IMemento)object));
                                    break block21;
                                }
                                iAdaptable = iElementFactory.createElement(iMemento2);
                                if (iAdaptable != null) break block22;
                                WorkbenchPlugin.log("Unable to restore page - cannot instantiate input element: " + (String)object3);
                                multiStatus.add(this.unableToRestorePage((IMemento)object));
                            }
                            var16_19 = null;
                            UIStats.end(4, object3, "WorkbenchPageFactory");
                            break block17;
                        }
                        var16_19 = null;
                    }
                    catch (Throwable throwable) {
                        var16_19 = null;
                        UIStats.end(4, object3, "WorkbenchPageFactory");
                        throw throwable;
                    }
                    UIStats.end(4, object3, "WorkbenchPageFactory");
                }
                object3 = null;
                try {
                    object3 = new WorkbenchPage(this, iAdaptable);
                    multiStatus.add(((WorkbenchPage)object3).restoreState((IMemento)object, iPerspectiveDescriptor));
                    this.pageList.add(object3);
                    this.firePageOpened((IWorkbenchPage)object3);
                }
                catch (WorkbenchException workbenchException) {
                    WorkbenchPlugin.log("Unable to restore perspective - constructor failed.", (Throwable)((Object)workbenchException));
                    multiStatus.add(workbenchException.getStatus());
                    break block17;
                }
                if (string != null && string.length() > 0) {
                    object2 = object3;
                }
            }
            ++n3;
        }
        if (this.pageList.isEmpty()) {
            try {
                String string = this.getWorkbenchImpl().getPerspectiveRegistry().getDefaultPerspective();
                if (string != null) {
                    object = new WorkbenchPage(this, string, this.getDefaultPageInput());
                    this.pageList.add(object);
                    this.firePageOpened((IWorkbenchPage)object);
                }
            }
            catch (WorkbenchException workbenchException) {
                WorkbenchPlugin.log("Unable to create default perspective - constructor failed.", (Throwable)((Object)workbenchException));
                multiStatus.add(workbenchException.getStatus());
            }
        }
        if (object2 == null) {
            object2 = this.pageList.getNextActive();
        }
        this.setActivePage((IWorkbenchPage)object2);
        return multiStatus;
    }

    public void run(boolean bl, boolean bl2, IRunnableWithProgress iRunnableWithProgress) throws InvocationTargetException, InterruptedException {
        this.appWindowRun(bl, bl2, iRunnableWithProgress);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void appWindowRun(boolean var1_1, boolean var2_2, IRunnableWithProgress var3_3) throws InvocationTargetException, InterruptedException {
        try {
            this.operationInProgress = true;
            var3_3.run((IProgressMonitor)new NullProgressMonitor());
            var4_4 = this.getContents();
            var5_5 = var4_4.getDisplay();
            var6_6 = this.getShell();
            var7_7 = var4_4.getEnabled();
            var8_8 = var5_5.getShells();
            var9_9 = new boolean[var8_8.length];
            var10_10 = 0;
            while (true) {
                if (var10_10 >= var8_8.length) {
                    var10_11 = var5_5.getFocusControl();
                    ** try [egrp 1[TRYBLOCK] [2 : 128->216)] { 
lbl15:
                    // 1 sources

                    break;
                }
                var11_12 = var8_8[var10_10];
                if (var11_12 != var6_6 && var11_12 != null && !var11_12.isDisposed()) {
                    var9_9[var10_10] = var11_12.getEnabled();
                    var11_12.setEnabled(false);
                }
                ++var10_10;
            }
            {
                var4_4.setEnabled(false);
                var11_12 = new Exception[1];
                try {
                    ModalContext.run((IRunnableWithProgress)var3_3, (boolean)var1_1, (IProgressMonitor)this.getProgressMonitor(), (Display)var5_5);
                }
                catch (InvocationTargetException var12_13) {
                    var11_12[0] = var12_13;
                }
                catch (InterruptedException var12_14) {
                    var11_12[0] = var12_14;
                }
                if (var11_12[0] != null) {
                    if (var11_12[0] instanceof InvocationTargetException) {
                        throw (InvocationTargetException)var11_12[0];
                    }
                    if (var11_12[0] instanceof InterruptedException) {
                        throw (InterruptedException)var11_12[0];
                    }
                }
                ** GOTO lbl-1000
            }
lbl38:
            // 1 sources

            catch (Throwable var14_16) {
                var13_17 = null;
                this.operationInProgress = false;
                var15_19 = 0;
            }
            while (true) {
                if (var15_19 >= var8_8.length) {
                    if (!var4_4.isDisposed()) {
                        var4_4.setEnabled(var7_7);
                    }
                    if (var10_11 == null) throw var14_16;
                    if (var10_11.isDisposed() != false) throw var14_16;
                    var10_11.forceFocus();
                    throw var14_16;
                }
                var16_21 = var8_8[var15_19];
                if (var16_21 != var6_6 && var16_21 != null && !var16_21.isDisposed()) {
                    var16_21.setEnabled(var9_9[var15_19]);
                }
                ++var15_19;
            }
lbl-1000:
            // 1 sources

            {
                var13_18 = null;
                this.operationInProgress = false;
                var15_20 = 0;
                while (true) {
                    if (var15_20 >= var8_8.length) {
                        if (!var4_4.isDisposed()) {
                            var4_4.setEnabled(var7_7);
                        }
                        if (var10_11 == null || var10_11.isDisposed()) break;
                        var10_11.forceFocus();
                        break;
                    }
                    var16_22 = var8_8[var15_20];
                    if (var16_22 != var6_6 && var16_22 != null && !var16_22.isDisposed()) {
                        var16_22.setEnabled(var9_9[var15_20]);
                    }
                    ++var15_20;
                }
            }
        }
        catch (Throwable var18_23) {
            var17_24 = null;
            this.operationInProgress = false;
            throw var18_23;
        }
        {
            var17_25 = null;
            this.operationInProgress = false;
            return;
        }
    }

    public IProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }

    protected Control getContents() {
        return this.contents;
    }

    private boolean saveAllPages(boolean bl) {
        boolean bl2 = true;
        Iterator iterator = this.pageList.iterator();
        while (bl2 && iterator.hasNext()) {
            WorkbenchPage workbenchPage = (WorkbenchPage)iterator.next();
            bl2 = workbenchPage.saveAllEditors(bl);
        }
        return bl2;
    }

    public IStatus saveState(IMemento iMemento) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.WorkbenchWindow_problemsSavingWindow, null);
        if (this.getShell().getMaximized() || this.asMaximizedState) {
            iMemento.putString("maximized", "true");
        }
        if (this.getShell().getMinimized()) {
            iMemento.putString("minimized", "true");
        }
        if (this.normalBounds == null) {
            this.normalBounds = this.getShell().getBounds();
        }
        iMemento.putInteger("x", this.normalBounds.x);
        iMemento.putInteger("y", this.normalBounds.y);
        iMemento.putInteger("width", this.normalBounds.width);
        iMemento.putInteger("height", this.normalBounds.height);
        Iterator iterator = this.pageList.iterator();
        while (iterator.hasNext()) {
            IPersistableElement iPersistableElement;
            IAdaptable iAdaptable;
            WorkbenchPage workbenchPage = (WorkbenchPage)iterator.next();
            IMemento iMemento2 = iMemento.createChild("page");
            iMemento2.putString("label", workbenchPage.getLabel());
            multiStatus.add(workbenchPage.saveState(iMemento2));
            if (workbenchPage == this.getActiveWorkbenchPage()) {
                iMemento2.putString("focus", "true");
            }
            if ((iAdaptable = workbenchPage.getInput()) == null) continue;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ui.IPersistableElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iPersistableElement = (IPersistableElement)iAdaptable.getAdapter((Class)clazz)) == null) {
                WorkbenchPlugin.log("Unable to save page input: " + iAdaptable + ", because it does not adapt to IPersistableElement");
                continue;
            }
            IMemento iMemento3 = iMemento2.createChild("input");
            iMemento3.putString("factoryID", iPersistableElement.getFactoryId());
            iPersistableElement.saveState(iMemento3);
        }
        return multiStatus;
    }

    public void setActivePage(IWorkbenchPage iWorkbenchPage) {
        WorkbenchPage workbenchPage;
        if (this.getActiveWorkbenchPage() == iWorkbenchPage) {
            return;
        }
        WorkbenchPage workbenchPage2 = this.getActiveWorkbenchPage();
        if (workbenchPage2 != null) {
            workbenchPage2.onDeactivate();
        }
        if (iWorkbenchPage == null || this.pageList.contains(iWorkbenchPage)) {
            this.pageList.setActive(iWorkbenchPage);
        }
        if ((workbenchPage = this.pageList.getActive()) != null) {
            this.hideEmptyWindowContents();
            workbenchPage.onActivate();
            this.firePageActivated(workbenchPage);
            if (workbenchPage.getPerspective() != null) {
                this.firePerspectiveActivated(workbenchPage, workbenchPage.getPerspective());
            }
        }
        if (this.isClosing()) {
            return;
        }
        this.updateDisabled = false;
    }

    private void trackShellActivation(Shell shell) {
        shell.addShellListener(new ShellListener(){

            public void shellActivated(ShellEvent shellEvent) {
                WorkbenchWindow.this.shellActivated = true;
                WorkbenchWindow.this.getWorkbenchImpl().setActivatedWindow(WorkbenchWindow.this);
                WorkbenchPage workbenchPage = WorkbenchWindow.this.getActiveWorkbenchPage();
                if (workbenchPage != null) {
                    IWorkbenchPart iWorkbenchPart = workbenchPage.getActivePart();
                    if (iWorkbenchPart != null) {
                        PartSite partSite = (PartSite)iWorkbenchPart.getSite();
                        partSite.getPane().shellActivated();
                    }
                    WorkbenchWindow.this.getWorkbenchImpl().fireWindowActivated(WorkbenchWindow.this);
                }
            }

            public void shellDeactivated(ShellEvent shellEvent) {
                WorkbenchWindow.this.shellActivated = false;
                WorkbenchPage workbenchPage = WorkbenchWindow.this.getActiveWorkbenchPage();
                if (workbenchPage != null) {
                    IWorkbenchPart iWorkbenchPart = workbenchPage.getActivePart();
                    if (iWorkbenchPart != null) {
                        PartSite partSite = (PartSite)iWorkbenchPart.getSite();
                        partSite.getPane().shellDeactivated();
                    }
                    WorkbenchWindow.this.getWorkbenchImpl().fireWindowDeactivated(WorkbenchWindow.this);
                }
            }

            public void shellClosed(ShellEvent shellEvent) {
            }

            public void shellDeiconified(ShellEvent shellEvent) {
            }

            public void shellIconified(ShellEvent shellEvent) {
            }
        });
    }

    private void trackShellResize(Shell shell) {
        shell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
                this.saveBounds();
            }

            public void controlResized(ControlEvent controlEvent) {
                this.saveBounds();
            }

            private void saveBounds() {
                Shell shell = WorkbenchWindow.this.getShell();
                if (shell == null) {
                    return;
                }
                if (shell.isDisposed()) {
                    return;
                }
                if (shell.getMinimized()) {
                    return;
                }
                if (shell.getMaximized()) {
                    WorkbenchWindow.this.asMaximizedState = true;
                    return;
                }
                WorkbenchWindow.this.asMaximizedState = false;
                WorkbenchWindow.this.normalBounds = shell.getBounds();
            }
        });
    }

    public void updateActionBars() {
        if (this.updateDisabled || this.updatesDeferred()) {
            return;
        }
    }

    private boolean updatesDeferred() {
        return this.largeUpdates > 0;
    }

    public final void largeUpdateStart() {
        ++this.largeUpdates;
    }

    public final void largeUpdateEnd() {
        if (--this.largeUpdates == 0) {
            this.updateActionBars();
        }
    }

    WorkbenchWindowConfigurer getWindowConfigurer() {
        if (this.windowConfigurer == null) {
            this.windowConfigurer = new WorkbenchWindowConfigurer(this);
        }
        return this.windowConfigurer;
    }

    private WorkbenchAdvisor getAdvisor() {
        return this.getWorkbenchImpl().getAdvisor();
    }

    private WorkbenchWindowAdvisor getWindowAdvisor() {
        if (this.windowAdvisor == null) {
            this.windowAdvisor = this.getAdvisor().createWorkbenchWindowAdvisor(this.getWindowConfigurer());
            Assert.isNotNull(this.windowAdvisor);
        }
        return this.windowAdvisor;
    }

    private Workbench getWorkbenchImpl() {
        return Workbench.getInstance();
    }

    protected void initializeBounds() {
        Point point = this.getInitialSize();
        Point point2 = this.getInitialLocation(point);
        this.getShell().setBounds(this.getConstrainedShellBounds(new Rectangle(point2.x, point2.y, point.x, point.y)));
    }

    protected Rectangle getConstrainedShellBounds(Rectangle rectangle) {
        return rectangle;
    }

    protected Point getInitialLocation(Point point) {
        Shell shell = this.getShell();
        if (shell != null) {
            return shell.getLocation();
        }
        return this.getInitialLocation(point);
    }

    protected Point getInitialSize() {
        return this.getWindowConfigurer().getInitialSize();
    }

    public void setPerspectiveBarVisible(boolean bl) {
        boolean bl2 = this.perspectiveBarVisible;
        this.perspectiveBarVisible = bl;
        if (bl2 != this.perspectiveBarVisible) {
            this.updateLayoutDataForContents();
        }
    }

    public boolean getPerspectiveBarVisible() {
        return this.perspectiveBarVisible;
    }

    public void setStatusLineVisible(boolean bl) {
        boolean bl2 = this.statusLineVisible;
        this.statusLineVisible = bl;
        if (bl2 != this.statusLineVisible) {
            this.updateLayoutDataForContents();
        }
    }

    public boolean getStatusLineVisible() {
        return this.statusLineVisible;
    }

    private void updateLayoutDataForContents() {
        if (this.defaultLayout == null) {
            return;
        }
        this.defaultLayout.setCenterControl((Control)this.getPageComposite());
    }

    public boolean getShowFastViewBars() {
        return this.getWindowConfigurer().getShowFastViewBars();
    }

    private void setLayoutDataForContents() {
        this.updateLayoutDataForContents();
    }

    protected boolean showTopSeperator() {
        return false;
    }

    public void addToTrim(Control control, int n) {
        Control control2 = null;
        control.setLayoutData((Object)new TrimLayoutData(false, -1, -1));
        this.defaultLayout.addTrim(control, n, control2);
    }

    public IExtensionTracker getExtensionTracker() {
        if (this.tracker == null) {
            this.tracker = new UIExtensionTracker(this.getWorkbench().getDisplay());
        }
        return this.tracker;
    }

    IAdaptable getDefaultPageInput() {
        return this.getWorkbenchImpl().getDefaultPageInput();
    }

    public Shell getShell() {
        return this.shell;
    }

    class PageList {
        private List pagesInCreationOrder = new ArrayList(4);
        private List pageInActivationOrder = new ArrayList(4);
        private Object active;

        public boolean add(Object object) {
            this.pagesInCreationOrder.add(object);
            this.pageInActivationOrder.add(0, object);
            return true;
        }

        public Iterator iterator() {
            return this.pagesInCreationOrder.iterator();
        }

        public boolean contains(Object object) {
            return this.pagesInCreationOrder.contains(object);
        }

        public boolean remove(Object object) {
            if (this.active == object) {
                this.active = null;
            }
            this.pageInActivationOrder.remove(object);
            return this.pagesInCreationOrder.remove(object);
        }

        public boolean isEmpty() {
            return this.pagesInCreationOrder.isEmpty();
        }

        public IWorkbenchPage[] getPages() {
            int n = this.pagesInCreationOrder.size();
            IWorkbenchPage[] iWorkbenchPageArray = new IWorkbenchPage[n];
            this.pagesInCreationOrder.toArray(iWorkbenchPageArray);
            return iWorkbenchPageArray;
        }

        public void setActive(Object object) {
            if (this.active == object) {
                return;
            }
            this.active = object;
            if (object != null) {
                this.pageInActivationOrder.remove(object);
                this.pageInActivationOrder.add(object);
            }
        }

        public WorkbenchPage getActive() {
            return (WorkbenchPage)this.active;
        }

        public WorkbenchPage getNextActive() {
            if (this.active == null) {
                if (this.pageInActivationOrder.isEmpty()) {
                    return null;
                }
                return (WorkbenchPage)this.pageInActivationOrder.get(this.pageInActivationOrder.size() - 1);
            }
            if (this.pageInActivationOrder.size() < 2) {
                return null;
            }
            return (WorkbenchPage)this.pageInActivationOrder.get(this.pageInActivationOrder.size() - 2);
        }
    }
}

