/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import org.eclipse.ercp.swt.mobile.IndexData;
import org.eclipse.ercp.swt.mobile.IndexLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class CaptionedControl
extends Composite {
    Label captionLabel = null;
    Label trailingLabel = null;
    Label iconImage = null;
    IndexData rd;
    int orientationStyle = 0;
    int headingIndex = 0;
    int imgIndex = 0;
    int trailingIndex = 0;
    int innerLabelCount = 0;
    private Listener focusInListener;
    private Listener focusOutListener;

    public CaptionedControl(Composite parent, int style) {
        super(parent, 0);
        if (parent instanceof CaptionedControl) {
            SWT.error(43);
            return;
        }
        this.orientationStyle = style;
        IndexLayout rl = new IndexLayout();
        rl.wrap = false;
        rl.pack = true;
        this.setLayout(rl);
        final Display display = this.getDisplay();
        final CaptionedControl thisControl = this;
        this.focusInListener = new Listener(){

            public void handleEvent(Event event) {
                Control c = (Control)event.widget;
                Composite parent = c.getParent();
                if (!(parent != thisControl && c != thisControl || thisControl.isDisposed())) {
                    if (CaptionedControl.this.captionLabel != null && !CaptionedControl.this.captionLabel.isDisposed()) {
                        CaptionedControl.this.captionLabel.setBackground(new Color(display, 255, 200, 120));
                    }
                    if (CaptionedControl.this.trailingLabel != null && !CaptionedControl.this.trailingLabel.isDisposed()) {
                        CaptionedControl.this.trailingLabel.setBackground(new Color(display, 255, 200, 120));
                    }
                }
                if (c == thisControl && !thisControl.isDisposed()) {
                    Control[] children = ((Composite)thisControl).getChildren();
                    for (int i = 0; i < children.length; ++i) {
                        if (children[i] instanceof Label) continue;
                        children[i].forceFocus();
                        break;
                    }
                }
            }
        };
        this.focusOutListener = new Listener(){

            public void handleEvent(Event event) {
                Control c;
                for (c = (Control)event.widget; c != thisControl && !(c.getParent() instanceof Shell); c = c.getParent()) {
                }
                if (c == thisControl) {
                    if (CaptionedControl.this.captionLabel != null) {
                        CaptionedControl.this.captionLabel.setBackground(null);
                    }
                    if (CaptionedControl.this.trailingLabel != null) {
                        CaptionedControl.this.trailingLabel.setBackground(null);
                    }
                }
            }
        };
        display.addFilter(15, this.focusInListener);
        display.addFilter(16, this.focusOutListener);
        this.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (CaptionedControl.this.getControl() != null) {
                    CaptionedControl.this.getControl().setFocus();
                }
            }
        });
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
            return;
        }
        if (null == this.captionLabel) {
            this.captionLabel = new Label(this, 0);
            this.captionLabel.addListener(3, new Listener(){

                public void handleEvent(Event event) {
                    if (CaptionedControl.this.getControl() != null) {
                        CaptionedControl.this.getControl().setFocus();
                    }
                }
            });
            ++this.innerLabelCount;
            this.headingIndex = this.innerLabelCount;
        }
        this.captionLabel.setText(string);
        Point p = this.captionLabel.computeSize(-1, -1);
        this.rd = new IndexData(p.x, p.y);
        this.captionLabel.setLayoutData(this.rd);
        this.layout();
    }

    protected void releaseWidget() {
        if (this.captionLabel != null) {
            if (!this.captionLabel.isDisposed()) {
                this.captionLabel.dispose();
            }
            this.captionLabel = null;
        }
        if (this.trailingLabel != null) {
            if (!this.trailingLabel.isDisposed()) {
                this.trailingLabel.dispose();
            }
            this.trailingLabel = null;
        }
        if (this.iconImage != null) {
            if (!this.iconImage.isDisposed()) {
                this.iconImage.dispose();
            }
            this.iconImage = null;
        }
        if (this.rd != null) {
            this.rd = null;
        }
        super.releaseWidget();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Control[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isDisposed()) continue;
            children[i].setEnabled(enabled);
        }
    }

    public void setTrailingText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
            return;
        }
        if (this.trailingLabel == null) {
            this.trailingLabel = new Label(this, 0);
            this.trailingLabel.addListener(3, new Listener(){

                public void handleEvent(Event event) {
                    if (CaptionedControl.this.getControl() != null) {
                        CaptionedControl.this.getControl().setFocus();
                    }
                }
            });
            ++this.innerLabelCount;
            this.trailingIndex = this.innerLabelCount;
        }
        this.trailingLabel.setText(string);
        Point p = this.trailingLabel.computeSize(-1, -1);
        this.rd = new IndexData(p.x, p.y);
        this.trailingLabel.setLayoutData(this.rd);
        this.layout();
    }

    public String getText() {
        this.checkWidget();
        if (this.captionLabel == null) {
            return new String("");
        }
        return this.captionLabel.getText();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        if (layout instanceof IndexLayout) {
            super.setLayout(layout);
        } else {
            super.setLayout(null);
            Control[] children = this.getChildren();
            for (int i = 0; i < children.length; ++i) {
                children[i].setLayoutData(null);
            }
            super.setLayout(layout);
        }
    }

    public String getTrailingText() {
        this.checkWidget();
        if (this.trailingLabel == null) {
            return new String("");
        }
        return this.trailingLabel.getText();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image == null) {
            if (this.iconImage != null) {
                this.iconImage.dispose();
                this.iconImage = null;
                if (this.headingIndex > this.imgIndex) {
                    --this.headingIndex;
                }
                if (this.trailingIndex > this.imgIndex) {
                    --this.trailingIndex;
                }
                this.imgIndex = 0;
                --this.innerLabelCount;
            }
            return;
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        if (null == this.iconImage) {
            this.iconImage = new Label(this, 0);
            this.iconImage.addListener(3, new Listener(){

                public void handleEvent(Event event) {
                    if (CaptionedControl.this.getControl() != null) {
                        CaptionedControl.this.getControl().setFocus();
                    }
                }
            });
            ++this.innerLabelCount;
            this.imgIndex = this.innerLabelCount;
        }
        this.iconImage.setImage(image);
    }

    public Image getImage() {
        this.checkWidget();
        if (this.iconImage == null) {
            return null;
        }
        return this.iconImage.getImage();
    }

    Control getControl() {
        Control[] controlList = new Control[4];
        controlList = this.getTabList();
        for (int i = 0; i < controlList.length; ++i) {
            if (controlList[i] instanceof Label) continue;
            return controlList[i];
        }
        return null;
    }

    public Control[] getChildren() {
        Control[] children = super.getChildren();
        CaptionedControl captionedControl = this;
        if (children.length == 2) {
            Control tmp;
            if (children[0] instanceof Label && children[1] instanceof Label) {
                if (captionedControl.headingIndex > captionedControl.imgIndex || captionedControl.imgIndex > captionedControl.trailingIndex || captionedControl.headingIndex > captionedControl.trailingIndex) {
                    tmp = children[1];
                    children[1] = children[0];
                    children[0] = tmp;
                }
            } else if (children[0] instanceof Label) {
                if (captionedControl.trailingIndex == 1) {
                    tmp = children[1];
                    children[1] = children[0];
                    children[0] = tmp;
                }
            } else if (children[1] instanceof Label && (captionedControl.headingIndex == 1 || captionedControl.imgIndex == 1)) {
                tmp = children[1];
                children[1] = children[0];
                children[0] = tmp;
            }
            if (this.orientationStyle == 0x4000000) {
                tmp = children[1];
                children[1] = children[0];
                children[0] = tmp;
            }
        } else if (children.length == 3) {
            Control[] tempChildren;
            if (children[0] instanceof Label && children[1] instanceof Label && children[2] instanceof Label) {
                tempChildren = new Control[]{children[captionedControl.headingIndex], children[captionedControl.imgIndex], children[captionedControl.trailingIndex]};
                children = tempChildren;
            } else if (captionedControl.headingIndex == 0) {
                tempChildren = new Control[3];
                for (int i = 0; i < 3; ++i) {
                    if (children[i] == captionedControl.iconImage) {
                        tempChildren[0] = children[i];
                        continue;
                    }
                    if (children[i] == captionedControl.trailingLabel) {
                        tempChildren[2] = children[i];
                        continue;
                    }
                    tempChildren[1] = children[i];
                }
                children = tempChildren;
            } else if (captionedControl.imgIndex == 0) {
                tempChildren = new Control[3];
                for (int i = 0; i < 3; ++i) {
                    if (children[i] == captionedControl.captionLabel) {
                        tempChildren[0] = children[i];
                        continue;
                    }
                    if (children[i] == captionedControl.trailingLabel) {
                        tempChildren[2] = children[i];
                        continue;
                    }
                    tempChildren[1] = children[i];
                }
                children = tempChildren;
            } else if (captionedControl.trailingIndex == 0) {
                tempChildren = new Control[3];
                for (int i = 0; i < 3; ++i) {
                    if (children[i] == captionedControl.captionLabel) {
                        tempChildren[0] = children[i];
                        continue;
                    }
                    if (children[i] == captionedControl.iconImage) {
                        tempChildren[1] = children[i];
                        continue;
                    }
                    tempChildren[2] = children[i];
                }
                children = tempChildren;
            }
            if (this.orientationStyle == 0x4000000) {
                Control temp = children[2];
                children[2] = children[0];
                children[0] = temp;
            }
        } else if (children.length == 4) {
            Control[] tempChildren = new Control[4];
            for (int i = 0; i < 4; ++i) {
                if (children[i] == captionedControl.captionLabel) {
                    tempChildren[0] = children[i];
                    continue;
                }
                if (children[i] == captionedControl.iconImage) {
                    tempChildren[1] = children[i];
                    continue;
                }
                if (children[i] == captionedControl.trailingLabel) {
                    tempChildren[3] = children[i];
                    continue;
                }
                tempChildren[2] = children[i];
            }
            children = tempChildren;
            if (this.orientationStyle == 0x4000000) {
                Control temp = children[3];
                children[3] = children[0];
                children[0] = temp;
                temp = children[2];
                children[2] = children[1];
                children[1] = temp;
            }
        }
        return children;
    }

    protected void removeInternalFilter() {
        if (this.focusInListener != null) {
            this.getDisplay().removeFilter(15, this.focusInListener);
        }
        this.focusInListener = null;
        if (this.focusOutListener != null) {
            this.getDisplay().removeFilter(16, this.focusOutListener);
        }
        this.focusOutListener = null;
    }
}

