/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.ManageScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.ercp.update.views.UpdateMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.IUnconfigureAndUninstallFeatureOperation;
import org.eclipse.update.internal.operations.OperationFactory;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.util.FeatureWrap;

public class InstallingScreen
extends AbsScreen {
    public static final int PROGRESS_MAX_VALUE = 10;
    public Label featureLabel;
    public Label featureName;
    public ProgressBar featureProgress;
    public ProgressBar overallProgress;
    private int totalInstallFeaturesCount = 0;
    private UpdateMonitor installFeatureMonitor;
    private InstallFeatureThread installFeaturesThread;
    private Composite pane;
    private Command cancelCommand;
    private StringBuffer installLog;
    private boolean isExisted = false;

    InstallingScreen(NormalView normalView) {
        super(normalView);
    }

    protected void createScreen() {
        this.init(null);
        this.pane = new Composite(this.screen, 0);
        this.pane.setLayoutData((Object)new GridData(768));
        this.pane.setLayout((Layout)new GridLayout(1, false));
        this.featureLabel = new Label(this.pane, 0);
        this.featureLabel.setText(UIMessages.Installing);
        this.featureName = new Label(this.pane, 0);
        this.featureName.setLayoutData((Object)new GridData(768));
        this.featureProgress = new ProgressBar(this.screen, 65536);
        this.featureProgress.setMaximum(10);
        this.featureProgress.setLayoutData((Object)new GridData(768));
        Label label = new Label(this.screen, 0);
        label.setText(UIMessages.OverallProgress);
        this.overallProgress = new ProgressBar(this.screen, 65536);
        this.overallProgress.setLayoutData((Object)new GridData(768));
        this.fillSpace();
        this.setButtons(0, 2, 0);
        if (3 == this.view.osType) {
            this.featureLabel.setFont(this.view.fontOnS60);
            this.featureName.setFont(this.view.fontOnS60);
        }
        this.screen.layout();
    }

    protected void refresh() {
        this.cancelButton.setEnabled(true);
        this.featureName.setText("");
        this.featureProgress.setSelection(0);
        this.overallProgress.setSelection(0);
        this.screen.layout();
    }

    protected void action() {
        try {
            if (this.view.targetSite == null) {
                this.view.targetSite = SiteManager.getLocalSite().getCurrentConfiguration().getConfiguredSites()[0];
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        if (this.view.targetSite == null) {
            System.out.println("Error: error to get local site for installation.");
            return;
        }
        this.totalInstallFeaturesCount = 0;
        int n = 0;
        while (n < this.view.availableFeatures.size()) {
            if (((FeatureWrap)this.view.availableFeatures.elementAt(n)).isSelected()) {
                ++this.totalInstallFeaturesCount;
            }
            ++n;
        }
        this.overallProgress.setMaximum(this.totalInstallFeaturesCount);
        this.installFeatureMonitor = new UpdateMonitor();
        this.installLog = new StringBuffer();
        this.installFeaturesThread = new InstallFeatureThread("", this.view.targetSite, this.view.availableFeatures, this.view.installedFeatures, this.installLog, this.installFeatureMonitor);
        this.installFeaturesThread.start();
        this.setDefaultFocus();
        Display.getCurrent().timerExec(400, new Runnable(){

            public void run() {
                if (InstallingScreen.this.installFeaturesThread.isFinished()) {
                    if (InstallingScreen.this.isExisted) {
                        return;
                    }
                    InstallingScreen.this.isExisted = true;
                    if (InstallingScreen.this.installFeaturesThread.getDoneWorksCount() == InstallingScreen.this.totalInstallFeaturesCount) {
                        InstallingScreen.this.featureName.setText(NLS.bind((String)UIMessages.FeaturesInstalled, (Object[])new Object[]{new Integer(InstallingScreen.this.totalInstallFeaturesCount).toString()}));
                        InstallingScreen.this.screen.layout();
                        InstallingScreen.this.featureProgress.setSelection(10);
                        InstallingScreen.this.overallProgress.setSelection(InstallingScreen.this.totalInstallFeaturesCount);
                        InstallingScreen.this.view.enableRestartCommand = true;
                        if (InstallingScreen.this.installFeaturesThread.isJvmInUpdateList()) {
                            MessageBox messageBox = new MessageBox(InstallingScreen.this.screen.getShell(), 194);
                            messageBox.setText(UIMessages.ConfirmRestart);
                            messageBox.setMessage(NLS.bind((String)UIMessages.NeedRestartManually, (Object[])InstallingScreen.this.view.RuntimeName));
                            if (messageBox.open() == 64 && 9 != InstallingScreen.this.view.runtimeType) {
                                System.getProperties().put("eworkbench.returnCode", new Integer(0));
                                PlatformUI.getWorkbench().close();
                                return;
                            }
                        } else if (InstallingScreen.this.installFeaturesThread.isOldVersionReplaced()) {
                            MessageBox messageBox = new MessageBox(InstallingScreen.this.screen.getShell(), 194);
                            messageBox.setText(UIMessages.ConfirmRestart);
                            messageBox.setMessage(NLS.bind((String)UIMessages.RecommendToRestart, (Object[])InstallingScreen.this.view.RuntimeName));
                            if (messageBox.open() == 64 && 9 != InstallingScreen.this.view.runtimeType) {
                                System.getProperties().put("eworkbench.returnCode", new Integer(1));
                                PlatformUI.getWorkbench().close();
                                return;
                            }
                        } else {
                            MessageBox messageBox = new MessageBox(InstallingScreen.this.screen.getShell(), 34);
                            messageBox.setText(UIMessages.InstallStatus);
                            messageBox.setMessage(NLS.bind((String)UIMessages.InstallCompleted, (Object[])InstallingScreen.this.view.RuntimeName));
                            messageBox.open();
                        }
                    } else {
                        InstallingScreen.this.featureProgress.setSelection((int)(10.0 * InstallingScreen.this.installFeatureMonitor.getDoneWorksCount() / (double)InstallingScreen.this.installFeatureMonitor.getTotalWorksCount()));
                        InstallingScreen.this.overallProgress.setSelection(InstallingScreen.this.installFeaturesThread.getDoneWorksCount());
                        UpdateCore.log((String)UIMessages.InstallNotCompleted, null);
                        UpdateCore.log((String)InstallingScreen.this.installLog.toString(), null);
                        MessageBox messageBox = new MessageBox(InstallingScreen.this.screen.getShell(), 33);
                        messageBox.setText(UIMessages.InstallStatus);
                        messageBox.setMessage(UIMessages.InstallNotCompleted);
                        messageBox.open();
                    }
                    InstallingScreen.this.isExisted = false;
                    InstallingScreen.this.cancelButton.setEnabled(false);
                    InstallingScreen.this.installFeaturesThread = null;
                    InstallingScreen.this.setVisible(false);
                    NormalView normalView = InstallingScreen.this.view;
                    ((Object)((Object)InstallingScreen.this.view)).getClass();
                    ((Object)((Object)InstallingScreen.this.view)).getClass();
                    normalView.showScreen(0, true);
                } else {
                    if (InstallingScreen.this.installFeaturesThread.isAlive()) {
                        InstallingScreen.this.featureName.setText(InstallingScreen.this.installFeaturesThread.getCurrentFeatureName());
                        InstallingScreen.this.screen.layout();
                        InstallingScreen.this.featureProgress.setSelection((int)(10.0 * InstallingScreen.this.installFeatureMonitor.getDoneWorksCount() / (double)InstallingScreen.this.installFeatureMonitor.getTotalWorksCount()));
                        InstallingScreen.this.overallProgress.setSelection(InstallingScreen.this.installFeaturesThread.getDoneWorksCount());
                    }
                    Display.getCurrent().timerExec(300, (Runnable)this);
                }
            }
        });
    }

    protected void setDefaultFocus() {
        if (this.view.inputType == 4097) {
            this.pane.setFocus();
        } else {
            this.cancelButton.setFocus();
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (!(selectionEvent.widget != this.cancelButton.widget && selectionEvent.widget != this.cancelCommand || this.installFeaturesThread == null || this.installFeaturesThread.isFinished())) {
            this.installFeatureMonitor.setCanceled(true);
        }
    }

    private class InstallFeatureThread
    extends Thread {
        private IConfiguredSite site;
        private Vector features;
        private Vector allEarlierFeatures;
        private Vector beSuccessfullyInstalleds;
        private StringBuffer log;
        private IProgressMonitor monitor;
        private int count;
        private String currentFeatureName = "";
        private boolean isThreadFinished = false;
        private boolean isJvmInList = false;
        private boolean isAnythingReplaced = false;

        public InstallFeatureThread(String string, IConfiguredSite iConfiguredSite, Vector vector, Vector vector2, StringBuffer stringBuffer, IProgressMonitor iProgressMonitor) {
            super(string);
            this.site = iConfiguredSite;
            this.features = vector;
            this.allEarlierFeatures = vector2;
            this.log = stringBuffer;
            this.monitor = iProgressMonitor;
            this.count = 0;
            this.beSuccessfullyInstalleds = new Vector();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block33: {
                block32: {
                    block30: {
                        block31: {
                            this.isThreadFinished = false;
                            this.isJvmInList = false;
                            this.isAnythingReplaced = false;
                            var1_1 = 0;
                            try {
                                try {
                                    var2_2 = null;
                                    var3_4 = (OperationFactory)OperationsManager.getOperationFactory();
                                    var1_1 = 0;
                                    while (var1_1 < this.features.size()) {
                                        block29: {
                                            var2_2 = (FeatureWrap)this.features.elementAt(var1_1);
                                            if (var2_2.isSelected()) {
                                                try {
                                                    if (!this.monitor.isCanceled()) {
                                                        this.currentFeatureName = var2_2.getShowedName();
                                                        var3_4.createInstallOperation(this.site, var2_2.getFeature(), null, null, null).execute(this.monitor, null);
                                                        if (!this.isJvmInList && var2_2.getVID().getIdentifier().startsWith(ManageScreen.JVM_LIB_FEATURE_NAME)) {
                                                            this.isJvmInList = true;
                                                        }
                                                        var2_2.releaseFeature();
                                                        try {
                                                            if (this.features.size() >= 10) {
                                                                InstallFeatureThread.sleep(500L);
                                                            } else {
                                                                InstallFeatureThread.sleep(100L);
                                                            }
                                                        }
                                                        catch (InterruptedException v0) {}
                                                        ++this.count;
                                                        this.beSuccessfullyInstalleds.add(var2_2.getVID());
                                                        break block29;
                                                    }
                                                    this.isThreadFinished = true;
                                                }
                                                catch (CoreException var4_5) {
                                                    if (!(var4_5 instanceof InstallAbortedException)) {
                                                        this.log.append(var2_2.getShowedName()).append("\n");
                                                        var4_5.printStackTrace();
                                                        break block29;
                                                    }
                                                    this.isThreadFinished = true;
                                                }
                                                var5_6 = null;
                                                if (this.beSuccessfullyInstalleds.size() <= 0) break block30;
                                                this.removeOldVersion(this.beSuccessfullyInstalleds);
                                                break block31;
                                            }
                                        }
                                        ++var1_1;
                                    }
                                    ** GOTO lbl-1000
                                }
                                catch (Exception var2_3) {
                                    var2_3.printStackTrace();
                                    ** GOTO lbl-1000
                                }
                            }
                            catch (Throwable var6_15) {
                                var5_7 = null;
                                if (this.beSuccessfullyInstalleds.size() > 0) {
                                    this.removeOldVersion(this.beSuccessfullyInstalleds);
                                    ConfiguratorUtils.getCurrentPlatformConfiguration().refresh();
                                    if (!this.isAnythingReplaced) {
                                        OperationsManager.applyChangesNow();
                                    }
                                }
                                var7_10 = var1_1;
                                break block32;
                            }
                        }
                        ConfiguratorUtils.getCurrentPlatformConfiguration().refresh();
                        if (!this.isAnythingReplaced) {
                            OperationsManager.applyChangesNow();
                        }
                    }
                    var7_9 = var1_1;
                    while (true) {
                        if (var7_9 >= this.features.size()) break;
                        var8_12 = (FeatureWrap)this.features.elementAt(var7_9);
                        if (var8_12.isSelected()) {
                            this.log.append(var8_12.getShowedName()).append("\n");
                        }
                        ++var7_9;
                    }
                    this.isThreadFinished = true;
                    return;
                }
                while (true) {
                    if (var7_10 >= this.features.size()) {
                        this.isThreadFinished = true;
                        throw var6_15;
                    }
                    var8_13 = (FeatureWrap)this.features.elementAt(var7_10);
                    if (var8_13.isSelected()) {
                        this.log.append(var8_13.getShowedName()).append("\n");
                    }
                    ++var7_10;
                }
lbl-1000:
                // 2 sources

                {
                    var5_8 = null;
                    if (this.beSuccessfullyInstalleds.size() <= 0) break block33;
                    this.removeOldVersion(this.beSuccessfullyInstalleds);
                }
                ConfiguratorUtils.getCurrentPlatformConfiguration().refresh();
                if (!this.isAnythingReplaced) {
                    OperationsManager.applyChangesNow();
                }
            }
            var7_11 = var1_1;
            while (true) {
                if (var7_11 >= this.features.size()) {
                    this.isThreadFinished = true;
                    return;
                }
                var8_14 = (FeatureWrap)this.features.elementAt(var7_11);
                if (var8_14.isSelected()) {
                    this.log.append(var8_14.getShowedName()).append("\n");
                }
                ++var7_11;
            }
        }

        private void removeOldVersion(Vector vector) {
            try {
                Object[] objectArray = this.allEarlierFeatures.toArray();
                OperationFactory operationFactory = (OperationFactory)OperationsManager.getOperationFactory();
                IUnconfigureAndUninstallFeatureOperation iUnconfigureAndUninstallFeatureOperation = null;
                int n = 0;
                while (n < vector.size()) {
                    VersionedIdentifier versionedIdentifier = (VersionedIdentifier)vector.elementAt(n);
                    try {
                        int n2 = 0;
                        while (n2 < objectArray.length) {
                            IFeatureReference iFeatureReference = (IFeatureReference)objectArray[n2];
                            if (iFeatureReference != null && versionedIdentifier.getIdentifier().equals(iFeatureReference.getVersionedIdentifier().getIdentifier()) && versionedIdentifier.getVersion().isGreaterThan(iFeatureReference.getVersionedIdentifier().getVersion())) {
                                iUnconfigureAndUninstallFeatureOperation = operationFactory.createUnconfigureAndUninstallFeatureOperation(iFeatureReference.getSite().getCurrentConfiguredSite(), iFeatureReference.getFeature(null));
                                iUnconfigureAndUninstallFeatureOperation.execute(null, null);
                                this.isAnythingReplaced = true;
                                objectArray[n2] = null;
                                break;
                            }
                            ++n2;
                        }
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                    ++n;
                }
                SiteManager.getLocalSite().save();
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
                return;
            }
        }

        public String getCurrentFeatureName() {
            return this.currentFeatureName;
        }

        public int getDoneWorksCount() {
            return this.count;
        }

        public boolean isFinished() {
            return this.isThreadFinished;
        }

        public boolean isJvmInUpdateList() {
            return this.isJvmInList;
        }

        public boolean isOldVersionReplaced() {
            return this.isAnythingReplaced;
        }
    }
}

