/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.ercp.update.views.ScrolledText;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;

public class ManageScreen
extends AbsScreen {
    private List featureList;
    private ScrolledText description;
    private Command propCommand;
    private Command updateCommand;
    private Command uninsCommand;
    private Command restartCommand;
    private Composite pane;
    private FormData fdFeatureList;
    private FormData fdDescription;
    private Vector allImportedPlugins = new Vector();
    private boolean isRequiredFeature;
    private IConfiguredSite[] allSites;
    private IFeature beingSelected;
    public static String JVM_CORE_FEATURE_NAME = "com.ibm.pvc.wece.device.";
    public static String JVM_LIB_FEATURE_NAME = "com.ibm.pvc.wece.";

    public ManageScreen(NormalView normalView) {
        super(normalView);
    }

    protected void createScreen() {
        this.init(UIMessages.AppsFeatures);
        if (4097 != this.view.inputType) {
            this.featureList = new List(this.screen, 768);
            this.featureList.setLayoutData((Object)new GridData(1808));
            this.featureList.addSelectionListener((SelectionListener)this);
            this.separator();
            this.description = 65 == this.view.wmType ? new ScrolledText(this.screen, 0, 0, 2) : new ScrolledText(this.screen, 0, 0, 3);
            this.description.setLayoutData(new GridData(768));
        } else {
            this.pane = new Composite(this.screen, 0);
            this.pane.setLayout((Layout)new FormLayout());
            this.pane.setLayoutData((Object)new GridData(1808));
            this.fdFeatureList = new FormData();
            this.fdFeatureList.top = new FormAttachment(0, 0);
            this.fdFeatureList.bottom = new FormAttachment(75, 0);
            this.fdFeatureList.left = new FormAttachment(0, 0);
            this.fdFeatureList.right = new FormAttachment(100, 0);
            this.fdDescription = new FormData();
            this.fdDescription.top = new FormAttachment(75, 5);
            this.fdDescription.bottom = new FormAttachment(100, 0);
            this.fdDescription.left = new FormAttachment(0, 0);
            this.fdDescription.right = new FormAttachment(100, 0);
            this.featureList = new List(this.pane, 768);
            this.featureList.setLayoutData((Object)this.fdFeatureList);
            this.featureList.addSelectionListener((SelectionListener)this);
            this.description = new ScrolledText(this.pane, 0, 0, -1);
            this.description.setLayoutData(this.fdDescription);
        }
        this.setButtons(1, 0, 0);
        this.propCommand = new Command((Control)this.screen, 1, 10);
        this.propCommand.setText(UIMessages.Properties);
        this.propCommand.setLongLabel(UIMessages.ShowProperties);
        this.propCommand.addSelectionListener((SelectionListener)this);
        this.updateCommand = new Command((Control)this.screen, 1, 9);
        this.updateCommand.setText(UIMessages.Update);
        this.updateCommand.setLongLabel(UIMessages.UpdateFeature);
        this.updateCommand.addSelectionListener((SelectionListener)this);
        this.uninsCommand = new Command((Control)this.screen, 1, 8);
        this.uninsCommand.setText(UIMessages.Uninstall);
        this.uninsCommand.setLongLabel(UIMessages.UninstallFeature);
        this.uninsCommand.addSelectionListener((SelectionListener)this);
        this.restartCommand = new Command((Control)this.screen, 1, 7);
        this.restartCommand.setText(NLS.bind((String)UIMessages.RestartWED, (Object[])this.view.RuntimeName));
        this.restartCommand.addSelectionListener((SelectionListener)this);
        if (3 == this.view.osType) {
            this.featureList.setFont(this.view.fontOnS60);
            this.description.setFont(this.view.fontOnS60);
        }
        this.screen.layout();
    }

    protected void refresh() {
        this.featureList.removeAll();
        this.propCommand.setEnabled(false);
        this.updateCommand.setEnabled(false);
        this.uninsCommand.setEnabled(false);
        if (9 == this.view.runtimeType) {
            this.restartCommand.setEnabled(false);
        } else {
            this.restartCommand.setEnabled(this.view.enableRestartCommand);
        }
        if (3 == this.view.osType) {
            this.restartCommand.setEnabled(true);
        }
        this.description.setText("");
        try {
            this.allSites = SiteManager.getLocalSite().getCurrentConfiguration().getConfiguredSites();
            if (this.allSites.length < 1) {
                return;
            }
            IFeature iFeature = null;
            int n = 0;
            while (n < this.allSites.length) {
                IFeatureReference[] iFeatureReferenceArray = this.allSites[n].getFeatureReferences();
                int n2 = 0;
                while (n2 < iFeatureReferenceArray.length) {
                    try {
                        VersionedIdentifier versionedIdentifier = iFeatureReferenceArray[n2].getVersionedIdentifier();
                        boolean bl = false;
                        int n3 = 0;
                        while (n3 < this.view.deletedFeatures.size()) {
                            if (versionedIdentifier.equals((Object)((VersionedIdentifier)this.view.deletedFeatures.elementAt(n3)))) {
                                bl = true;
                                break;
                            }
                            ++n3;
                        }
                        if (bl) break;
                        this.featureList.add(String.valueOf(iFeatureReferenceArray[n2].getName()) + " (" + versionedIdentifier.getVersion() + ")");
                        iFeature = iFeatureReferenceArray[n2].getFeature(null);
                        if (SiteManager.getLocalSite().getFeatureStatus(iFeature).getCode() != -1) {
                            IImport[] iImportArray = iFeature.getImports();
                            int n4 = 0;
                            while (n4 < iImportArray.length) {
                                String string = iImportArray[n4].getVersionedIdentifier().getIdentifier();
                                if (!this.allImportedPlugins.contains(string)) {
                                    this.allImportedPlugins.add(string);
                                }
                                ++n4;
                            }
                        }
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                    ++n2;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            return;
        }
    }

    protected void action() {
        this.setDefaultFocus();
        this.screen.pack();
        this.screen.layout();
    }

    protected void setDefaultFocus() {
        this.featureList.setFocus();
        if (this.featureList.getItemCount() > 0) {
            if (this.featureList.getSelectionIndex() < 0) {
                this.featureList.select(0);
            } else {
                this.featureList.select(this.featureList.getSelectionIndex());
            }
            Event event = new Event();
            event.widget = this.featureList;
            this.featureList.notifyListeners(13, event);
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.featureList) {
            String[] stringArray = this.featureList.getSelection();
            this.propCommand.setEnabled(stringArray.length == 1);
            this.updateCommand.setEnabled(stringArray.length == 1);
            this.uninsCommand.setEnabled(stringArray.length == 1);
            this.isRequiredFeature = false;
            if (stringArray.length == 1) {
                IURLEntry iURLEntry;
                VersionedIdentifier versionedIdentifier;
                block38: {
                    int n;
                    versionedIdentifier = null;
                    this.beingSelected = null;
                    int n2 = 0;
                    while (n2 < this.allSites.length) {
                        IFeatureReference[] iFeatureReferenceArray = this.allSites[n2].getFeatureReferences();
                        n = 0;
                        while (n < iFeatureReferenceArray.length) {
                            String string;
                            try {
                                versionedIdentifier = iFeatureReferenceArray[n].getVersionedIdentifier();
                                string = " (" + versionedIdentifier.getVersion().toString() + ")";
                            }
                            catch (Exception exception) {
                                string = " (?.?.?)";
                            }
                            if (stringArray[0].equals(String.valueOf(iFeatureReferenceArray[n].getName()) + string)) {
                                try {
                                    this.beingSelected = iFeatureReferenceArray[n].getFeature(null);
                                }
                                catch (CoreException coreException) {
                                    coreException.printStackTrace();
                                }
                                break;
                            }
                            ++n;
                        }
                        if (this.beingSelected != null) break;
                        ++n2;
                    }
                    if (this.beingSelected == null) {
                        this.propCommand.setEnabled(false);
                        this.updateCommand.setEnabled(false);
                        this.uninsCommand.setEnabled(false);
                        return;
                    }
                    try {
                        if (SiteManager.getLocalSite().getFeatureStatus(this.beingSelected).getCode() == -1) break block38;
                        IPluginEntry[] iPluginEntryArray = this.beingSelected.getPluginEntries();
                        n = 0;
                        while (n < iPluginEntryArray.length) {
                            int n3 = 0;
                            while (n3 < this.allImportedPlugins.size()) {
                                if (((String)this.allImportedPlugins.elementAt(n3)).equals(iPluginEntryArray[n].getVersionedIdentifier().getIdentifier())) {
                                    this.isRequiredFeature = true;
                                    break;
                                }
                                ++n3;
                            }
                            if (!this.isRequiredFeature) {
                                ++n;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                }
                if (versionedIdentifier != null) {
                    if (this.isEssentialFeature(versionedIdentifier)) {
                        this.uninsCommand.setEnabled(false);
                    } else if (versionedIdentifier.getIdentifier().startsWith("com.ibm.pvc.wed.core.")) {
                        this.uninsCommand.setEnabled(false);
                    }
                }
                try {
                    if (SiteManager.getLocalSite().getFeatureStatus(this.beingSelected).getCode() == -1) {
                        this.updateCommand.setEnabled(false);
                        this.uninsCommand.setEnabled(true);
                    }
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
                if ((iURLEntry = this.beingSelected.getDescription()) != null) {
                    this.description.setText(iURLEntry.getAnnotation());
                    this.description.setSelection(0, 0);
                } else {
                    this.description.setText("");
                }
                this.screen.layout();
                this.featureList.showSelection();
            }
        } else if (selectionEvent.widget == this.backButton.widget) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(0, false);
        } else if (selectionEvent.widget == this.propCommand) {
            this.view.availableFeatures.removeAllElements();
            this.view.availableFeatures.add(this.beingSelected);
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(11, true);
        } else if (selectionEvent.widget == this.updateCommand) {
            this.view.availableFeatures.removeAllElements();
            this.view.availableFeatures.add(this.beingSelected);
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(9, true);
        } else if (selectionEvent.widget == this.uninsCommand) {
            if (this.isRequiredFeature) {
                MessageBox messageBox = new MessageBox(this.screen.getShell(), 34);
                messageBox.setText(UIMessages.Notice);
                messageBox.setMessage(UIMessages.FeatureIsRequired);
                messageBox.open();
                return;
            }
            MessageBox messageBox = new MessageBox(this.screen.getShell(), 194);
            messageBox.setText(UIMessages.ConfirmUninstall);
            messageBox.setMessage(UIMessages.UninstallQuery);
            if (messageBox.open() == 64) {
                this.view.availableFeatures.removeAllElements();
                this.view.availableFeatures.add(this.beingSelected);
                this.setVisible(false);
                ((Object)((Object)this.view)).getClass();
                ((Object)((Object)this.view)).getClass();
                this.view.showScreen(12, true);
            }
        } else if (selectionEvent.widget == this.restartCommand) {
            MessageBox messageBox = new MessageBox(this.screen.getShell(), 194);
            messageBox.setText(UIMessages.ConfirmExit);
            messageBox.setMessage(NLS.bind((String)UIMessages.ExitWEDQuery, (Object[])this.view.RuntimeName));
            if (messageBox.open() == 64) {
                System.getProperties().put("eworkbench.returnCode", new Integer(1));
                PlatformUI.getWorkbench().close();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.featureList) {
            this.widgetSelected(selectionEvent);
            if ("win32".equals(Platform.getOS()) && "x86".equals(Platform.getOSArch())) {
                this.view.availableFeatures.removeAllElements();
                this.view.availableFeatures.add(this.beingSelected);
                this.setVisible(false);
                ((Object)((Object)this.view)).getClass();
                ((Object)((Object)this.view)).getClass();
                this.view.showScreen(11, true);
            }
        }
    }

    public boolean isEssentialFeature(VersionedIdentifier versionedIdentifier) {
        if (versionedIdentifier.getIdentifier().startsWith("com.ibm.pvc.wece.device.")) {
            return true;
        }
        if (versionedIdentifier.getIdentifier().equals("com.ibm.pvc.core.ercp.feature")) {
            return true;
        }
        if (versionedIdentifier.getIdentifier().startsWith("com.ibm.pvc.ercp.ui.")) {
            return true;
        }
        if (versionedIdentifier.getIdentifier().equals("org.eclipse.ercp.update.feature")) {
            return true;
        }
        if (versionedIdentifier.getIdentifier().equals("com.ibm.rcp.logredirector.feature")) {
            return true;
        }
        return versionedIdentifier.getIdentifier().equals("com.ibm.pvc.wct.deviceagent.feature");
    }
}

