/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ICountable;
import org.eclipse.core.expressions.IIterable;
import org.eclipse.core.internal.expressions.ExpressionMessages;
import org.eclipse.core.internal.expressions.ExpressionPlugin;
import org.eclipse.core.internal.expressions.ExpressionStatus;
import org.eclipse.core.internal.expressions.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.w3c.dom.Element;

public class Expressions {
    private static WeakHashMap fgKnownClasses;
    public static final boolean TRACING;
    public static final Object[] EMPTY_ARGS;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        TRACING = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.expressions/tracePropertyResolving"));
        EMPTY_ARGS = new Object[0];
    }

    private Expressions() {
    }

    public static boolean isInstanceOf(Object object, String string) {
        if (object == null) {
            return false;
        }
        return Expressions.isSubtype(object.getClass(), string);
    }

    private static synchronized boolean isSubtype(Class clazz, String string) {
        boolean bl;
        Object v;
        WeakHashMap weakHashMap = Expressions.getKnownClasses();
        HashMap<String, Boolean> hashMap = (HashMap<String, Boolean>)weakHashMap.get(clazz);
        if (hashMap != null && (v = hashMap.get(string)) != null) {
            return (Boolean)v;
        }
        if (hashMap == null) {
            hashMap = new HashMap<String, Boolean>();
            weakHashMap.put(clazz, hashMap);
        }
        hashMap.put(string, (bl = Expressions.uncachedIsSubtype(clazz, string)) ? Boolean.TRUE : Boolean.FALSE);
        return bl;
    }

    private static WeakHashMap getKnownClasses() {
        if (fgKnownClasses == null) {
            BundleListener bundleListener;
            fgKnownClasses = new WeakHashMap();
            BundleContext bundleContext = ExpressionPlugin.getDefault().getBundleContext();
            ExpressionPlugin.fgBundleListener = bundleListener = new BundleListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void bundleChanged(BundleEvent bundleEvent) {
                    if (bundleEvent.getType() != 4) return;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.core.internal.expressions.Expressions");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Class<?> clazz2 = clazz;
                    synchronized (clazz) {
                        fgKnownClasses.clear();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            };
            bundleContext.addBundleListener(bundleListener);
        }
        return fgKnownClasses;
    }

    public static boolean uncachedIsSubtype(Class clazz, String string) {
        if (clazz.getName().equals(string)) {
            return true;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null && Expressions.uncachedIsSubtype(clazz2, string)) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            if (Expressions.uncachedIsSubtype(classArray[n], string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static void checkAttribute(String string, String string2) throws CoreException {
        if (string2 == null) {
            throw new CoreException((IStatus)new ExpressionStatus(50, Messages.format(ExpressionMessages.Expression_attribute_missing, string)));
        }
    }

    public static void checkAttribute(String string, String string2, String[] stringArray) throws CoreException {
        Expressions.checkAttribute(string, string2);
        int n = 0;
        while (n < stringArray.length) {
            if (string2.equals(stringArray[n])) {
                return;
            }
            ++n;
        }
        throw new CoreException((IStatus)new ExpressionStatus(51, Messages.format(ExpressionMessages.Expression_attribute_invalid_value, string2)));
    }

    public static void checkCollection(Object object, Expression expression) throws CoreException {
        if (object instanceof Collection) {
            return;
        }
        throw new CoreException((IStatus)new ExpressionStatus(3, Messages.format(ExpressionMessages.Expression_variable_not_a_collection, expression.toString())));
    }

    public static void checkList(Object object, Expression expression) throws CoreException {
        if (object instanceof List) {
            return;
        }
        throw new CoreException((IStatus)new ExpressionStatus(4, Messages.format(ExpressionMessages.Expression_variable_not_a_list, expression.toString())));
    }

    public static IIterable getAsIIterable(Object object, Expression expression) throws CoreException {
        IIterable iIterable;
        if (object instanceof IIterable) {
            return (IIterable)object;
        }
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.expressions.IIterable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iIterable = (IIterable)iAdapterManager.getAdapter(object, (Class)clazz)) != null) {
            return iIterable;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.expressions.IIterable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (iAdapterManager.queryAdapter(object, clazz2.getName()) == 1) {
            return null;
        }
        throw new CoreException((IStatus)new ExpressionStatus(3, Messages.format(ExpressionMessages.Expression_variable_not_iterable, expression.toString())));
    }

    public static ICountable getAsICountable(Object object, Expression expression) throws CoreException {
        ICountable iCountable;
        if (object instanceof ICountable) {
            return (ICountable)object;
        }
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.core.expressions.ICountable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iCountable = (ICountable)iAdapterManager.getAdapter(object, (Class)clazz)) != null) {
            return iCountable;
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.core.expressions.ICountable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (iAdapterManager.queryAdapter(object, clazz2.getName()) == 1) {
            return null;
        }
        throw new CoreException((IStatus)new ExpressionStatus(3, Messages.format(ExpressionMessages.Expression_variable_not_countable, expression.toString())));
    }

    public static boolean getOptionalBooleanAttribute(IConfigurationElement iConfigurationElement, String string) {
        String string2 = iConfigurationElement.getAttribute(string);
        if (string2 == null) {
            return false;
        }
        return Boolean.valueOf(string2);
    }

    public static boolean getOptionalBooleanAttribute(Element element, String string) {
        String string2 = element.getAttribute(string);
        if (string2.length() == 0) {
            return false;
        }
        return Boolean.valueOf(string2);
    }

    public static Object[] getArguments(IConfigurationElement iConfigurationElement, String string) throws CoreException {
        String string2 = iConfigurationElement.getAttribute(string);
        if (string2 != null) {
            return Expressions.parseArguments(string2);
        }
        return EMPTY_ARGS;
    }

    public static Object[] getArguments(Element element, String string) throws CoreException {
        String string2 = element.getAttribute(string);
        if (string2.length() > 0) {
            return Expressions.parseArguments(string2);
        }
        return EMPTY_ARGS;
    }

    public static Object[] parseArguments(String string) throws CoreException {
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 0;
        while ((n = Expressions.findNextComma(string, n2)) != -1) {
            arrayList.add(Expressions.convertArgument(string.substring(n2, n).trim()));
            n2 = n + 1;
        }
        arrayList.add(Expressions.convertArgument(string.substring(n2).trim()));
        return arrayList.toArray();
    }

    private static int findNextComma(String string, int n) throws CoreException {
        boolean bl = false;
        int n2 = n;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == ',' && !bl) {
                return n2;
            }
            if (c == '\'') {
                if (!bl) {
                    bl = true;
                } else if (n2 + 1 < string.length() && string.charAt(n2 + 1) == '\'') {
                    ++n2;
                } else {
                    bl = false;
                }
            } else if (c == ',' && !bl) {
                return n2;
            }
            ++n2;
        }
        if (bl) {
            throw new CoreException((IStatus)new ExpressionStatus(303, Messages.format(ExpressionMessages.Expression_string_not_terminated, string)));
        }
        return -1;
    }

    public static Object convertArgument(String string) throws CoreException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        if (string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            return Expressions.unEscapeString(string.substring(1, string.length() - 1));
        }
        if ("true".equals(string)) {
            return Boolean.TRUE;
        }
        if ("false".equals(string)) {
            return Boolean.FALSE;
        }
        if (string.indexOf(46) != -1) {
            try {
                return Float.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                return string;
            }
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
    }

    public static String unEscapeString(String string) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\'') {
                if (n == string.length() - 1 || string.charAt(n + 1) != '\'') {
                    throw new CoreException((IStatus)new ExpressionStatus(302, Messages.format(ExpressionMessages.Expression_string_not_correctly_escaped, string)));
                }
                stringBuffer.append('\'');
                ++n;
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

