/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Composite;

import org.eclipse.ercp.swt.mobile.CaptionedControl;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.ConstrainedText;
import org.eclipse.ercp.swt.mobile.MobileShell;
import org.eclipse.ercp.swt.samples.eswtdemo.Composite.CompositeShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class CompositeShowCaseComplexLayout
extends ShowCase
implements SelectionListener,
ControlListener,
KeyListener {
    MobileShell mobileShell;
    Canvas coordinatedCanvas;
    ScrollBar vSrollBarCoordinatedCanvas;
    int lastScrollBarSelection = 0;
    FormData coordinatedCanvasFormdata;
    int coordinatedCanvasAttachementLeft = 5;
    int coordinatedCanvasAttachementTop = 5;
    CaptionedControl lastNameCptCtrl;
    Text textLastName;
    CaptionedControl firstNameCptCtrl;
    Text textFirstName;
    CaptionedControl telephoneCptCtrl;
    ConstrainedText textTelephone;
    CaptionedControl mobileCptCtrl;
    ConstrainedText textMobile;
    Canvas pictureCanvas;
    Command commandSelectedPicture;
    Command commandRemoveSelectedPicture;
    Label separatorLabel;
    Label skillsLabel;
    Text skillsText;
    Command commandGrow;
    Command commandShrink;
    Command commandExit;
    static int MOBILESHELL_STATE_SMALL = 0;
    static int MOBILESHELL_STATE_NORMAL = 1;
    static int MOBILESHELL_STATE_FULLSCREEN = 2;
    int mobileshellstate = MOBILESHELL_STATE_SMALL;
    Image defaultPicture;
    Image selectedPicture;
    FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.widget == CompositeShowCaseComplexLayout.this.textLastName || focusEvent.widget == CompositeShowCaseComplexLayout.this.textFirstName) {
                CompositeShowCaseComplexLayout.this.vSrollBarCoordinatedCanvas.setSelection(CompositeShowCaseComplexLayout.this.vSrollBarCoordinatedCanvas.getMinimum());
                CompositeShowCaseComplexLayout.this.updateCanvasWithScrolBar();
            } else if (focusEvent.widget == CompositeShowCaseComplexLayout.this.textTelephone || focusEvent.widget == CompositeShowCaseComplexLayout.this.textMobile) {
                CompositeShowCaseComplexLayout.this.vSrollBarCoordinatedCanvas.setSelection(CompositeShowCaseComplexLayout.this.vSrollBarCoordinatedCanvas.getMaximum());
                CompositeShowCaseComplexLayout.this.updateCanvasWithScrolBar();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    };
    SelectionListener scrollBarListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.widget == CompositeShowCaseComplexLayout.this.vSrollBarCoordinatedCanvas) {
                CompositeShowCaseComplexLayout.this.updateCanvasWithScrolBar();
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    PaintListener paintPicture = new PaintListener(){

        public void paintControl(PaintEvent paintEvent) {
            Image image = CompositeShowCaseComplexLayout.this.selectedPicture != null ? CompositeShowCaseComplexLayout.this.selectedPicture : CompositeShowCaseComplexLayout.this.defaultPicture;
            Rectangle rectangle = image.getBounds();
            Rectangle rectangle2 = ((Canvas)paintEvent.widget).getBounds();
            float f = (float)rectangle.width / (float)rectangle.height;
            int n = (int)((float)rectangle2.height * f);
            int n2 = rectangle2.height;
            int n3 = (rectangle2.width - n) / 2;
            int n4 = 0;
            if (n > rectangle2.width) {
                n = rectangle2.width;
                n2 = (int)((float)rectangle2.width * f);
                n3 = 0;
                n4 = (rectangle2.height - n2) / 2;
            }
            paintEvent.gc.drawImage(image, 0, 0, rectangle.width, rectangle.height, n3, n4, n, n2);
            paintEvent.gc.setForeground(CompositeShowCaseComplexLayout.this.getComposite().getDisplay().getSystemColor(23));
            if (((Canvas)paintEvent.widget).isFocusControl()) {
                paintEvent.gc.drawRectangle(0, 0, rectangle2.width - 1, rectangle2.height - 1);
            }
        }
    };

    CompositeShowCaseComplexLayout(MobileShell mobileShell) {
        this.mobileShell = mobileShell;
    }

    public String getName() {
        return Messages.getString("CompositeShowCaseComplexLayout.0");
    }

    private void createControls() {
        this.coordinatedCanvas = new Canvas(this.getComposite(), 526848);
        this.coordinatedCanvas.addControlListener((ControlListener)this);
        this.lastNameCptCtrl = new CaptionedControl((Composite)this.coordinatedCanvas, 0x2000000);
        this.lastNameCptCtrl.setText(Messages.getString("CompositeShowCaseComplexLayout.1"));
        this.textLastName = new Text((Composite)this.lastNameCptCtrl, 4);
        this.textLastName.setText(Messages.getString("CompositeShowCaseComplexLayout.2"));
        this.textLastName.setSize(200, 20);
        this.firstNameCptCtrl = new CaptionedControl((Composite)this.coordinatedCanvas, 0x2000000);
        this.firstNameCptCtrl.setText(Messages.getString("CompositeShowCaseComplexLayout.3"));
        this.textFirstName = new Text((Composite)this.firstNameCptCtrl, 4);
        this.textFirstName.setText(Messages.getString("CompositeShowCaseComplexLayout.4"));
        this.textFirstName.setSize(200, 20);
        this.telephoneCptCtrl = new CaptionedControl((Composite)this.coordinatedCanvas, 0x2000000);
        this.telephoneCptCtrl.setText(Messages.getString("CompositeShowCaseComplexLayout.5"));
        this.textTelephone = new ConstrainedText((Composite)this.telephoneCptCtrl, 4, 4);
        this.textTelephone.setText(Messages.getString("CompositeShowCaseComplexLayout.6"));
        this.textTelephone.setSize(200, 20);
        this.mobileCptCtrl = new CaptionedControl((Composite)this.coordinatedCanvas, 0x2000000);
        this.mobileCptCtrl.setText(Messages.getString("CompositeShowCaseComplexLayout.7"));
        this.textMobile = new ConstrainedText((Composite)this.mobileCptCtrl, 4, 4);
        this.textMobile.setSize(200, 20);
        this.defaultPicture = new Image((Device)this.getComposite().getDisplay(), this.getClass().getResourceAsStream("/res/smith.png"));
        this.selectedPicture = null;
        this.pictureCanvas = new Canvas(this.getComposite(), 524288);
        this.pictureCanvas.setSize(this.defaultPicture.getBounds().width, this.defaultPicture.getBounds().height);
        this.pictureCanvas.addPaintListener(this.paintPicture);
        this.pictureCanvas.addControlListener((ControlListener)this);
        this.pictureCanvas.addKeyListener((KeyListener)this);
        this.separatorLabel = new Label(this.getComposite(), 258);
        this.separatorLabel.setSize(-1, 1);
        this.skillsLabel = new Label(this.getComposite(), 0);
        this.skillsLabel.setText(Messages.getString("CompositeShowCaseComplexLayout.9"));
        this.skillsLabel.setSize(200, 10);
        this.skillsText = new Text(this.getComposite(), 2562);
        this.skillsText.setText(Messages.getString("CompositeShowCaseComplexLayout.10"));
    }

    private void applyLayoutOnControls() {
        FormLayout formLayout = new FormLayout();
        this.getComposite().setLayout((Layout)formLayout);
        FormLayout formLayout2 = new FormLayout();
        this.coordinatedCanvasFormdata = new FormData();
        this.coordinatedCanvasFormdata.left = new FormAttachment(0, this.coordinatedCanvasAttachementLeft);
        this.coordinatedCanvasFormdata.top = new FormAttachment(0, this.coordinatedCanvasAttachementTop);
        this.coordinatedCanvasFormdata.bottom = new FormAttachment((Control)this.separatorLabel, -5);
        this.coordinatedCanvas.setLayout((Layout)formLayout2);
        this.coordinatedCanvas.setLayoutData((Object)this.coordinatedCanvasFormdata);
        int n = 5;
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        this.lastNameCptCtrl.setLayoutData((Object)formData);
        FormData formData2 = new FormData();
        formData2.left = new FormAttachment(0, n);
        formData2.top = new FormAttachment((Control)this.lastNameCptCtrl, n);
        this.firstNameCptCtrl.setLayoutData((Object)formData2);
        FormData formData3 = new FormData();
        formData3.left = new FormAttachment(0, n);
        formData3.top = new FormAttachment((Control)this.firstNameCptCtrl, n);
        this.telephoneCptCtrl.setLayoutData((Object)formData3);
        FormData formData4 = new FormData();
        formData4.left = new FormAttachment(0, n);
        formData4.top = new FormAttachment((Control)this.telephoneCptCtrl, n);
        this.mobileCptCtrl.setLayoutData((Object)formData4);
        FormData formData5 = new FormData();
        formData5.right = new FormAttachment(100, -5);
        formData5.top = new FormAttachment(0, 5);
        formData5.bottom = new FormAttachment((Control)this.separatorLabel, -5);
        formData5.left = new FormAttachment((Control)this.coordinatedCanvas, 5);
        this.pictureCanvas.setLayoutData((Object)formData5);
        FormData formData6 = new FormData();
        formData6.top = new FormAttachment(50, 0);
        formData6.left = new FormAttachment(0, 5);
        formData6.right = new FormAttachment(100, -5);
        this.separatorLabel.setLayoutData((Object)formData6);
        FormData formData7 = new FormData();
        formData7.left = new FormAttachment(0, n);
        formData7.top = new FormAttachment((Control)this.separatorLabel, n);
        this.skillsLabel.setLayoutData((Object)formData7);
        FormData formData8 = new FormData();
        formData8.left = new FormAttachment(0, 5);
        formData8.right = new FormAttachment(100, -5);
        formData8.top = new FormAttachment((Control)this.skillsLabel, 5);
        formData8.bottom = new FormAttachment(100, -5);
        this.skillsText.setLayoutData((Object)formData8);
        this.getComposite().layout();
        this.getComposite().setFocus();
    }

    public void show() {
        this.mobileShell.setText(Messages.getString("CompositeShowCaseComplexLayout.11"));
        this.createControls();
        this.applyLayoutOnControls();
        this.createCommands();
        this.vSrollBarCoordinatedCanvas = this.coordinatedCanvas.getVerticalBar();
        this.vSrollBarCoordinatedCanvas.addSelectionListener(this.scrollBarListener);
        this.updateScrollBarSize();
        this.textLastName.addFocusListener(this.focusListener);
        this.textFirstName.addFocusListener(this.focusListener);
        this.textTelephone.addFocusListener(this.focusListener);
        this.textMobile.addFocusListener(this.focusListener);
        this.changeMobileShellSize();
        this.getComposite().setFocus();
    }

    private void createCommands() {
        this.commandGrow = new Command((Control)this.getComposite(), 1, 3);
        this.commandGrow.setText(Messages.getString("CompositeShowCaseComplexLayout.12"));
        this.commandGrow.addSelectionListener((SelectionListener)this);
        this.commandShrink = new Command((Control)this.getComposite(), 1, 1);
        this.commandShrink.setText(Messages.getString("CompositeShowCaseComplexLayout.13"));
        this.commandShrink.addSelectionListener((SelectionListener)this);
        this.commandExit = new Command((Control)this.getComposite(), 7, 0);
        this.commandExit.setText(Messages.getString("CompositeShowCaseComplexLayout.14"));
        this.commandExit.setLongLabel(Messages.getString("CompositeShowCaseComplexLayout.15"));
        this.commandExit.addSelectionListener((SelectionListener)this);
        CompositeShowCase.getInstance().enableExit(false);
        this.commandSelectedPicture = new Command((Control)this.pictureCanvas, 1, 3);
        this.commandSelectedPicture.setText(Messages.getString("CompositeShowCaseComplexLayout.16"));
        this.commandSelectedPicture.setLongLabel(Messages.getString("CompositeShowCaseComplexLayout.17"));
        this.commandSelectedPicture.addSelectionListener((SelectionListener)this);
        this.commandRemoveSelectedPicture = new Command((Control)this.pictureCanvas, 1, 1);
        this.commandRemoveSelectedPicture.setText(Messages.getString("CompositeShowCaseComplexLayout.18"));
        this.commandRemoveSelectedPicture.setLongLabel(Messages.getString("CompositeShowCaseComplexLayout.19"));
        this.commandRemoveSelectedPicture.addSelectionListener((SelectionListener)this);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.commandGrow) {
            this.grow();
        } else if (selectionEvent.widget == this.commandShrink) {
            this.shrink();
        } else if (selectionEvent.widget == this.commandExit) {
            this.quit();
        } else if (selectionEvent.widget == this.commandSelectedPicture) {
            this.chooseAPicture();
        } else if (selectionEvent.widget == this.commandRemoveSelectedPicture && this.selectedPicture != null) {
            this.selectedPicture.dispose();
            this.selectedPicture = null;
            this.pictureCanvas.redraw();
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    private void quit() {
        this.mobileShell.setFullScreenMode(false);
        this.mobileShell.changeTrim(32, 2);
        this.vSrollBarCoordinatedCanvas.removeSelectionListener(this.scrollBarListener);
        this.vSrollBarCoordinatedCanvas = null;
        this.commandSelectedPicture.dispose();
        this.commandRemoveSelectedPicture.dispose();
        this.commandGrow.dispose();
        this.commandShrink.dispose();
        this.commandExit.dispose();
        CompositeShowCase.getInstance().enableExit(true);
        if (this.selectedPicture != null) {
            this.selectedPicture.dispose();
        }
        if (this.defaultPicture != null) {
            this.defaultPicture.dispose();
        }
        this.dispose();
    }

    private void grow() {
        if (this.mobileshellstate == MOBILESHELL_STATE_FULLSCREEN) {
            return;
        }
        ++this.mobileshellstate;
        this.commandShrink.setEnabled(true);
        this.changeMobileShellSize();
    }

    private void shrink() {
        if (this.mobileshellstate == MOBILESHELL_STATE_SMALL) {
            return;
        }
        --this.mobileshellstate;
        this.commandGrow.setEnabled(true);
        this.changeMobileShellSize();
    }

    private void changeMobileShellSize() {
        this.vSrollBarCoordinatedCanvas.setSelection(this.vSrollBarCoordinatedCanvas.getMinimum());
        this.updateCanvasWithScrolBar();
        this.updateScrollBarSize();
        if (this.mobileshellstate == MOBILESHELL_STATE_SMALL) {
            this.mobileShell.setFullScreenMode(false);
            this.mobileShell.changeTrim(32, 3);
            this.commandShrink.setEnabled(false);
        }
        if (this.mobileshellstate == MOBILESHELL_STATE_NORMAL) {
            this.mobileShell.setFullScreenMode(false);
            this.mobileShell.changeTrim(32, 2);
        }
        if (this.mobileshellstate == MOBILESHELL_STATE_FULLSCREEN) {
            this.mobileShell.setFullScreenMode(true);
            this.mobileShell.changeTrim(8, 1);
            this.commandGrow.setEnabled(false);
            Display.getCurrent().timerExec(10000, new Runnable(){

                public void run() {
                    CompositeShowCaseComplexLayout.this.shrink();
                }
            });
        }
    }

    private void chooseAPicture() {
        if (this.selectedPicture != null) {
            this.selectedPicture.dispose();
            this.selectedPicture = null;
        }
        try {
            FileDialog fileDialog = new FileDialog((Shell)this.mobileShell, 4096);
            fileDialog.setFilterExtensions(new String[]{"*.gif", "*.png", "*.jpg"});
            fileDialog.open();
            String string = fileDialog.getFileName();
            String string2 = fileDialog.getFilterPath();
            String string3 = String.valueOf(string2) + string;
            string3 = string3.replace('\\', '/');
            this.selectedPicture = new Image((Device)this.getComposite().getDisplay(), string3);
        }
        catch (Exception exception) {
            this.selectedPicture = new Image((Device)this.getComposite().getDisplay(), this.getClass().getResourceAsStream("/res/smith.jpg"));
        }
        this.pictureCanvas.redraw();
    }

    private Rectangle getChildrenBounds(Composite composite) {
        Rectangle rectangle = null;
        Control[] controlArray = this.coordinatedCanvas.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (rectangle == null) {
                rectangle = new Rectangle(controlArray[n].getBounds().x, controlArray[n].getBounds().y, controlArray[n].getBounds().width, controlArray[n].getBounds().height);
            } else {
                rectangle.add(controlArray[n].getBounds());
            }
            ++n;
        }
        return rectangle;
    }

    private void updateScrollBarSize() {
        if (this.vSrollBarCoordinatedCanvas != null) {
            int n = this.vSrollBarCoordinatedCanvas.getSelection();
            Rectangle rectangle = this.getChildrenBounds((Composite)this.coordinatedCanvas);
            Rectangle rectangle2 = this.coordinatedCanvas.getClientArea();
            this.vSrollBarCoordinatedCanvas.setMaximum(rectangle.height);
            this.vSrollBarCoordinatedCanvas.setMinimum(0);
            this.vSrollBarCoordinatedCanvas.setThumb(rectangle2.height);
            this.vSrollBarCoordinatedCanvas.setPageIncrement(rectangle2.height);
            this.vSrollBarCoordinatedCanvas.setIncrement(rectangle2.height / 10);
            this.vSrollBarCoordinatedCanvas.setSelection(n);
        }
    }

    private void updateCanvasWithScrolBar() {
        int n = this.vSrollBarCoordinatedCanvas.getSelection();
        Rectangle rectangle = this.getChildrenBounds((Composite)this.coordinatedCanvas);
        this.coordinatedCanvas.scroll(rectangle.x, rectangle.y + (this.lastScrollBarSelection - n), rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        this.lastScrollBarSelection = n;
    }

    public void controlMoved(ControlEvent controlEvent) {
    }

    public void controlResized(ControlEvent controlEvent) {
        if (controlEvent.widget == this.coordinatedCanvas) {
            this.updateScrollBarSize();
        } else {
            Widget cfr_ignored_0 = controlEvent.widget;
        }
    }

    protected void setFocus() {
        this.mobileShell.forceActive();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.widget == this.pictureCanvas && keyEvent.keyCode != 0x1000004 && keyEvent.keyCode != 0x1000003) {
            if (keyEvent.keyCode == 0x1000002) {
                this.skillsText.setFocus();
            } else if (keyEvent.keyCode == 0x1000001) {
                this.mobileCptCtrl.setFocus();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

