/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.internal.preferences.legacy.InitLegacyPreferences;
import org.eclipse.core.internal.preferences.legacy.ProductPreferencesService;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.internal.runtime.DataArea;
import org.eclipse.core.internal.runtime.Log;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.internal.runtime.MetaDataKeeper;
import org.eclipse.core.internal.runtime.PlatformActivator;
import org.eclipse.core.internal.runtime.PlatformLogWriter;
import org.eclipse.core.internal.runtime.Product;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.internal.runtime.auth.AuthorizationHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.app.Activator;
import org.eclipse.equinox.internal.app.CommandLineArgs;
import org.eclipse.equinox.internal.app.EclipseAppContainer;
import org.eclipse.equinox.internal.app.IBranding;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public final class InternalPlatform {
    private static final String[] ARCH_LIST = new String[]{"PA_RISC", "ppc", "sparc", "x86", "x86_64", "ia64", "ia64_32"};
    public static boolean DEBUG = false;
    public static boolean DEBUG_PLUGIN_PREFERENCES = false;
    static boolean splashEnded = false;
    private static boolean initialized;
    private static final String KEYRING = "-keyring";
    private static String keyringFile;
    private static Map logs;
    private static final String[] OS_LIST;
    private static String password;
    private static final String PASSWORD = "-password";
    private static PlatformLogWriter platformLog;
    private static final String PLUGIN_PATH = ".plugin-path";
    public static final String PROP_APPLICATION = "eclipse.application";
    public static final String PROP_ARCH = "osgi.arch";
    public static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    public static final String PROP_CONSOLE_LOG = "eclipse.consoleLog";
    public static final String PROP_DEBUG = "osgi.debug";
    public static final String PROP_DEV = "osgi.dev";
    public static final String PROP_INSTALL_AREA = "osgi.install.area";
    public static final String PROP_NL = "osgi.nl";
    public static final String PROP_OS = "osgi.os";
    public static final String PROP_PRODUCT = "eclipse.product";
    public static final String PROP_WS = "osgi.ws";
    public static final String PROP_ACTIVATE_PLUGINS = "eclipse.activateRuntimePlugins";
    private static final InternalPlatform singleton;
    private static final String[] WS_LIST;
    private Path cachedInstanceLocation;
    private ServiceTracker configurationLocation = null;
    private BundleContext context;
    private Map groupProviders = new HashMap(3);
    private ServiceTracker installLocation = null;
    private ServiceTracker instanceLocation = null;
    private Plugin runtimeInstance;
    private ServiceRegistration legacyPreferencesService = null;
    private ServiceRegistration customPreferencesService = null;
    private ServiceTracker environmentTracker = null;
    private ServiceTracker logTracker = null;
    private ServiceTracker bundleTracker = null;
    private ServiceTracker debugTracker = null;
    private ServiceTracker contentTracker = null;
    private ServiceTracker preferencesTracker = null;
    private ServiceTracker userLocation = null;
    private ServiceTracker groupProviderTracker = null;
    private IProduct product;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    static {
        logs = new HashMap(5);
        OS_LIST = new String[]{"aix", "hpux", "linux", "macosx", "qnx", "solaris", "win32"};
        password = "";
        platformLog = null;
        singleton = new InternalPlatform();
        WS_LIST = new String[]{"carbon", "cocoa", "gtk", "motif", "photon", "win32", "wpf"};
    }

    public static InternalPlatform getDefault() {
        return singleton;
    }

    private InternalPlatform() {
    }

    public void addLogListener(ILogListener iLogListener) {
        this.assertInitialized();
        RuntimeLog.addLogListener((ILogListener)iLogListener);
    }

    private void assertInitialized() {
        if (!initialized) {
            Assert.isTrue((boolean)false, (String)Messages.meta_appNotInit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSplash() {
        InternalPlatform internalPlatform = this;
        synchronized (internalPlatform) {
            if (splashEnded) {
                return;
            }
            splashEnded = true;
        }
        internalPlatform = this.getApplicationContext();
        if (internalPlatform != null) {
            internalPlatform.applicationRunning();
        }
    }

    public IAdapterManager getAdapterManager() {
        this.assertInitialized();
        return AdapterManager.getDefault();
    }

    public String[] getApplicationArgs() {
        return CommandLineArgs.getApplicationArgs();
    }

    public boolean getBooleanOption(String string, boolean bl) {
        String string2 = this.getOption(string);
        if (string2 == null) {
            return bl;
        }
        return string2.equalsIgnoreCase("true");
    }

    public Bundle getBundle(String string) {
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundleArray = packageAdmin.getBundles(string, null);
        if (bundleArray == null) {
            return null;
        }
        int n = 0;
        while (n < bundleArray.length) {
            if ((bundleArray[n].getState() & 3) == 0) {
                return bundleArray[n];
            }
            ++n;
        }
        return null;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public String getBundleId(Object object) {
        if (object == null) {
            return null;
        }
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return null;
        }
        Bundle bundle = packageAdmin.getBundle(object.getClass());
        if (bundle != null && bundle.getSymbolicName() != null) {
            return bundle.getSymbolicName();
        }
        return null;
    }

    public IBundleGroupProvider[] getBundleGroupProviders() {
        Filter filter;
        if (this.groupProviderTracker == null) {
            filter = null;
            try {
                BundleContext bundleContext = this.getBundleContext();
                StringBuffer stringBuffer = new StringBuffer("(objectClass=");
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.runtime.IBundleGroupProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                filter = bundleContext.createFilter(stringBuffer.append(clazz.getName()).append(")").toString());
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            this.groupProviderTracker = new ServiceTracker(this.getBundleContext(), filter, null);
            this.groupProviderTracker.open();
        }
        if ((filter = this.groupProviderTracker.getServices()) == null) {
            return new IBundleGroupProvider[0];
        }
        IBundleGroupProvider[] iBundleGroupProviderArray = new IBundleGroupProvider[((Object[])filter).length];
        System.arraycopy(filter, 0, iBundleGroupProviderArray, 0, ((Object[])filter).length);
        return iBundleGroupProviderArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBundleGroupProvider(IBundleGroupProvider iBundleGroupProvider) {
        BundleContext bundleContext = this.getBundleContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.IBundleGroupProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceRegistration serviceRegistration = bundleContext.registerService(clazz.getName(), (Object)iBundleGroupProvider, null);
        Map map = this.groupProviders;
        synchronized (map) {
            this.groupProviders.put(iBundleGroupProvider, serviceRegistration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBundleGroupProvider(IBundleGroupProvider iBundleGroupProvider) {
        ServiceRegistration serviceRegistration;
        Map map = this.groupProviders;
        synchronized (map) {
            serviceRegistration = (ServiceRegistration)this.groupProviders.remove(iBundleGroupProvider);
        }
        if (serviceRegistration == null) {
            return;
        }
        serviceRegistration.unregister();
    }

    public Bundle[] getBundles(String string, String string2) {
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundleArray = packageAdmin.getBundles(string, string2);
        if (bundleArray == null) {
            return null;
        }
        if (bundleArray.length == 1 && (bundleArray[0].getState() & 3) == 0) {
            return bundleArray;
        }
        Bundle[] bundleArray2 = new Bundle[bundleArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < bundleArray.length) {
            if ((bundleArray[n2].getState() & 3) == 0) {
                bundleArray2[n++] = bundleArray[n2];
            }
            ++n2;
        }
        if (n == 0) {
            return null;
        }
        Bundle[] bundleArray3 = new Bundle[n];
        System.arraycopy(bundleArray2, 0, bundleArray3, 0, n);
        return bundleArray3;
    }

    public String[] getCommandLineArgs() {
        return CommandLineArgs.getAllArgs();
    }

    public Location getConfigurationLocation() {
        this.assertInitialized();
        if (this.configurationLocation == null) {
            Filter filter = null;
            try {
                filter = this.context.createFilter(Location.CONFIGURATION_FILTER);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            this.configurationLocation = new ServiceTracker(this.context, filter, null);
            this.configurationLocation.open();
        }
        return (Location)this.configurationLocation.getService();
    }

    public IContentTypeManager getContentTypeManager() {
        if (this.contentTracker == null) {
            if (this.context == null) {
                return null;
            }
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.runtime.content.IContentTypeManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.contentTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.contentTracker.open();
        }
        return (IContentTypeManager)this.contentTracker.getService();
    }

    public EnvironmentInfo getEnvironmentInfoService() {
        if (this.environmentTracker == null) {
            if (this.context == null) {
                return null;
            }
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.environmentTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.environmentTracker.open();
        }
        return (EnvironmentInfo)this.environmentTracker.getService();
    }

    public Bundle[] getFragments(Bundle bundle) {
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return null;
        }
        return packageAdmin.getFragments(bundle);
    }

    public FrameworkLog getFrameworkLog() {
        if (this.logTracker == null) {
            if (this.context == null) {
                return null;
            }
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.logTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.logTracker.open();
        }
        return (FrameworkLog)this.logTracker.getService();
    }

    public Bundle[] getHosts(Bundle bundle) {
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return null;
        }
        return packageAdmin.getHosts(bundle);
    }

    public Location getInstallLocation() {
        this.assertInitialized();
        Filter filter = null;
        if (this.installLocation == null) {
            try {
                filter = this.context.createFilter(Location.INSTALL_FILTER);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            this.installLocation = new ServiceTracker(this.context, filter, null);
            this.installLocation.open();
        }
        return (Location)this.installLocation.getService();
    }

    public URL getInstallURL() {
        Location location = this.getInstallLocation();
        if (location == null) {
            throw new IllegalStateException("The installation location must not be null");
        }
        return location.getURL();
    }

    public Location getInstanceLocation() {
        this.assertInitialized();
        if (this.instanceLocation == null) {
            Filter filter = null;
            try {
                filter = this.context.createFilter(Location.INSTANCE_FILTER);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            this.instanceLocation = new ServiceTracker(this.context, filter, null);
            this.instanceLocation.open();
        }
        return (Location)this.instanceLocation.getService();
    }

    public IPath getLocation() throws IllegalStateException {
        if (this.cachedInstanceLocation == null) {
            Location location = this.getInstanceLocation();
            if (location == null) {
                return null;
            }
            File file = new File(location.getURL().getFile());
            this.cachedInstanceLocation = new Path(file.toString());
        }
        return this.cachedInstanceLocation;
    }

    public ILog getLog(Bundle bundle) {
        ILog iLog = (ILog)logs.get(bundle);
        if (iLog != null) {
            return iLog;
        }
        iLog = new Log(bundle);
        logs.put(bundle, iLog);
        return iLog;
    }

    public DataArea getMetaArea() {
        return MetaDataKeeper.getMetaArea();
    }

    public String getNL() {
        return this.getBundleContext().getProperty(PROP_NL);
    }

    public String getNLExtensions() {
        String string = PlatformActivator.getContext().getProperty("osgi.nl.extensions");
        if (string == null) {
            return "";
        }
        if (!string.startsWith("@")) {
            string = String.valueOf('@') + string;
        }
        return string;
    }

    public String getOption(String string) {
        DebugOptions debugOptions = this.getDebugOptions();
        if (debugOptions != null) {
            return debugOptions.getOption(string);
        }
        return null;
    }

    public String getOS() {
        return this.getBundleContext().getProperty(PROP_OS);
    }

    public String getOSArch() {
        return this.getBundleContext().getProperty(PROP_ARCH);
    }

    public PlatformAdmin getPlatformAdmin() {
        ServiceReference serviceReference;
        if (this.context == null) {
            return null;
        }
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((serviceReference = this.context.getServiceReference(clazz.getName())) == null) {
            return null;
        }
        return (PlatformAdmin)this.context.getService(serviceReference);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL[] getPluginPath(URL uRL) {
        Object object;
        InputStream inputStream = null;
        if (uRL == null) {
            return null;
        }
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {}
        if (inputStream == null) {
            try {
                object = new URL("platform:/base/.plugin-path");
                inputStream = ((URL)object).openStream();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
        }
        if (inputStream == null) {
            return null;
        }
        object = null;
        try {
            try {
                object = this.readPluginPath(inputStream);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                inputStream.close();
                throw throwable;
            }
            {
                Object var4_6 = null;
                inputStream.close();
                return object;
            }
        }
        catch (IOException iOException) {}
        return object;
    }

    public IPreferencesService getPreferencesService() {
        if (this.preferencesTracker == null) {
            if (this.context == null) {
                return null;
            }
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("org.eclipse.core.runtime.preferences.IPreferencesService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.preferencesTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.preferencesTracker.open();
        }
        return (IPreferencesService)this.preferencesTracker.getService();
    }

    public IProduct getProduct() {
        IBranding iBranding;
        if (this.product != null) {
            return this.product;
        }
        EclipseAppContainer eclipseAppContainer = Activator.getContainer();
        IBranding iBranding2 = iBranding = eclipseAppContainer == null ? null : eclipseAppContainer.getBranding();
        if (iBranding == null) {
            return null;
        }
        Object object = iBranding.getProduct();
        if (!(object instanceof IProduct)) {
            object = new Product(iBranding);
        }
        this.product = (IProduct)object;
        return this.product;
    }

    public IExtensionRegistry getRegistry() {
        return RegistryFactory.getRegistry();
    }

    public ResourceBundle getResourceBundle(Bundle bundle) {
        return ResourceTranslator.getResourceBundle((Bundle)bundle);
    }

    public String getResourceString(Bundle bundle, String string) {
        return ResourceTranslator.getResourceString((Bundle)bundle, (String)string);
    }

    public String getResourceString(Bundle bundle, String string, ResourceBundle resourceBundle) {
        return ResourceTranslator.getResourceString((Bundle)bundle, (String)string, (ResourceBundle)resourceBundle);
    }

    public Plugin getRuntimeInstance() {
        return this.runtimeInstance;
    }

    private IApplicationContext getApplicationContext() {
        ServiceReference[] serviceReferenceArray;
        try {
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("org.eclipse.equinox.app.IApplicationContext");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            serviceReferenceArray = this.context.getServiceReferences(clazz.getName(), "(eclipse.application.type=main.thread)");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
        if (serviceReferenceArray == null || serviceReferenceArray.length == 0) {
            return null;
        }
        IApplicationContext iApplicationContext = (IApplicationContext)this.context.getService(serviceReferenceArray[0]);
        if (iApplicationContext != null) {
            this.context.ungetService(serviceReferenceArray[0]);
            return iApplicationContext;
        }
        return null;
    }

    public IPath getStateLocation(Bundle bundle) {
        return this.getStateLocation(bundle, true);
    }

    public IPath getStateLocation(Bundle bundle, boolean bl) throws IllegalStateException {
        this.assertInitialized();
        IPath iPath = this.getMetaArea().getStateLocation(bundle);
        if (bl) {
            iPath.toFile().mkdirs();
        }
        return iPath;
    }

    public long getStateTimeStamp() {
        PlatformAdmin platformAdmin = this.getPlatformAdmin();
        return platformAdmin == null ? -1L : platformAdmin.getState(false).getTimeStamp();
    }

    public Location getUserLocation() {
        this.assertInitialized();
        if (this.userLocation == null) {
            Filter filter = null;
            try {
                filter = this.context.createFilter(Location.USER_FILTER);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            this.userLocation = new ServiceTracker(this.context, filter, null);
            this.userLocation.open();
        }
        return (Location)this.userLocation.getService();
    }

    public String getWS() {
        return this.getBundleContext().getProperty(PROP_WS);
    }

    private void initializeAuthorizationHandler() {
        try {
            AuthorizationHandler.setKeyringFile((String)keyringFile);
            AuthorizationHandler.setPassword((String)password);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
    }

    void initializeDebugFlags() {
        DEBUG = this.getBooleanOption("org.eclipse.core.runtime/debug", false);
        if (DEBUG) {
            DEBUG_PLUGIN_PREFERENCES = this.getBooleanOption("org.eclipse.core.runtime/preferences/plugin", false);
        }
    }

    public boolean isFragment(Bundle bundle) {
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return false;
        }
        return (packageAdmin.getBundleType(bundle) & 1) > 0;
    }

    public boolean isRunning() {
        try {
            return initialized && this.context != null && this.context.getBundle().getState() == 32;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    public String[] knownOSArchValues() {
        return ARCH_LIST;
    }

    public String[] knownOSValues() {
        return OS_LIST;
    }

    public String[] knownWSValues() {
        return WS_LIST;
    }

    public void log(IStatus iStatus) {
        RuntimeLog.log((IStatus)iStatus);
    }

    private void processCommandLine(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (n != stringArray.length - 1 && !stringArray[n + 1].startsWith("-")) {
                String string = stringArray[++n];
                if (stringArray[n - 1].equalsIgnoreCase(KEYRING)) {
                    keyringFile = string;
                }
                if (stringArray[n - 1].equalsIgnoreCase(PASSWORD)) {
                    password = string;
                }
            }
            ++n;
        }
    }

    private URL[] readPluginPath(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            return null;
        }
        Vector<URL> vector = new Vector<URL>(5);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            StringTokenizer stringTokenizer = new StringTokenizer(properties.getProperty(string), ";");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                if (string2.equals("")) continue;
                try {
                    vector.addElement(new URL(string2));
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("Ignoring plugin: " + string2);
                }
            }
        }
        return vector.toArray(new URL[vector.size()]);
    }

    public void removeLogListener(ILogListener iLogListener) {
        this.assertInitialized();
        RuntimeLog.removeLogListener((ILogListener)iLogListener);
    }

    public void setRuntimeInstance(Plugin plugin) {
        this.runtimeInstance = plugin;
    }

    public void start(BundleContext bundleContext) {
        boolean bl;
        this.context = bundleContext;
        splashEnded = false;
        this.processCommandLine(this.getEnvironmentInfoService().getNonFrameworkArgs());
        this.initializeDebugFlags();
        initialized = true;
        this.getMetaArea();
        this.initializeAuthorizationHandler();
        FrameworkLog frameworkLog = this.getFrameworkLog();
        if (frameworkLog != null) {
            platformLog = new PlatformLogWriter(this.getFrameworkLog());
            this.addLogListener(platformLog);
        } else {
            platformLog = null;
        }
        this.startServices();
        boolean bl2 = bl = !"false".equalsIgnoreCase(this.context.getProperty(PROP_ACTIVATE_PLUGINS));
        if (bl) {
            new DefaultScope();
            Job.getJobManager();
        }
    }

    public void stop(BundleContext bundleContext) {
        this.assertInitialized();
        this.stopServices();
        if (platformLog != null) {
            RuntimeLog.removeLogListener((ILogListener)platformLog);
        }
        initialized = false;
        this.closeOSGITrackers();
        this.context = null;
    }

    private void startServices() {
        BundleContext bundleContext = this.getBundleContext();
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("org.eclipse.core.internal.preferences.exchange.IProductPreferencesService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.customPreferencesService = bundleContext.registerService(clazz.getName(), (Object)new ProductPreferencesService(), new Hashtable());
        if (this.getBundle("org.eclipse.core.runtime.compatibility") != null) {
            BundleContext bundleContext2 = this.getBundleContext();
            Class<?> clazz2 = class$8;
            if (clazz2 == null) {
                try {
                    clazz2 = class$8 = Class.forName("org.eclipse.core.internal.preferences.exchange.ILegacyPreferences");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.legacyPreferencesService = bundleContext2.registerService(clazz2.getName(), (Object)new InitLegacyPreferences(), new Hashtable());
        }
    }

    private void stopServices() {
        if (this.legacyPreferencesService != null) {
            this.legacyPreferencesService.unregister();
            this.legacyPreferencesService = null;
        }
        if (this.customPreferencesService != null) {
            this.customPreferencesService.unregister();
            this.customPreferencesService = null;
        }
    }

    private PackageAdmin getBundleAdmin() {
        if (this.bundleTracker == null) {
            if (this.context == null) {
                return null;
            }
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.bundleTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.bundleTracker.open();
        }
        return (PackageAdmin)this.bundleTracker.getService();
    }

    private DebugOptions getDebugOptions() {
        if (this.debugTracker == null) {
            if (this.context == null) {
                return null;
            }
            Class<?> clazz = class$10;
            if (clazz == null) {
                try {
                    clazz = class$10 = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.debugTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.debugTracker.open();
        }
        return (DebugOptions)this.debugTracker.getService();
    }

    private void closeOSGITrackers() {
        if (this.preferencesTracker != null) {
            this.preferencesTracker.close();
            this.preferencesTracker = null;
        }
        if (this.contentTracker != null) {
            this.contentTracker.close();
            this.contentTracker = null;
        }
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
        if (this.groupProviderTracker != null) {
            this.groupProviderTracker.close();
            this.groupProviderTracker = null;
        }
        if (this.environmentTracker != null) {
            this.environmentTracker.close();
            this.environmentTracker = null;
        }
    }

    public static void message(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new Date(System.currentTimeMillis()));
        stringBuffer.append(" - [");
        stringBuffer.append(Thread.currentThread().getName());
        stringBuffer.append("] ");
        stringBuffer.append(string);
        System.out.println(stringBuffer.toString());
    }

    public static void start(Bundle bundle) throws BundleException {
        int n = bundle.getState();
        if ((n & 0x20) != 0) {
            return;
        }
        try {
            bundle.start(1);
        }
        catch (BundleException bundleException) {
            if ((n & 8) != 0 && (bundle.getState() & 8) != 0) {
                return;
            }
            throw bundleException;
        }
    }
}

