/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    Image image;
    int alignment = -1;
    boolean selection = false;
    String text;
    boolean isDefault = false;

    public Button(Composite parent, int style) {
        super(parent, Button.checkStyle(style));
        OS.Button_SetAlignment(this.internal_handle, this.getAlignmentStyle(this.internal_style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Button.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        if (((style = Button.checkBits(style, 8, 32, 16, 2, 0, 0)) & 8) != 0) {
            return Button.checkBits(style, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((style & 0x32) != 0) {
            return Button.checkBits(style, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        return style;
    }

    private int getAlignmentStyle(int style) {
        int nativeStyle = 0;
        if ((style & 0x4000) == 16384) {
            nativeStyle = 1;
        } else if ((style & 0x1000000) == 0x1000000) {
            nativeStyle = 2;
        } else if ((style & 0x20000) == 131072) {
            nativeStyle = 4;
        }
        return nativeStyle;
    }

    private void buttonCallback() {
        if ((this.internal_style & 8) == 0) {
            if ((this.internal_style & 0x10) != 0 && (this.internal_parent.getStyle() & 0x400000) == 0) {
                this.selectRadio();
            } else {
                this.selection = !this.selection;
            }
        }
        this.postEvent(13);
    }

    void click() {
        this.internal_sendEvent(13);
    }

    protected void internal_createHandle(int index) {
        if ((this.internal_style & 0x20) != 0) {
            this.internal_handle = OS.Checkbox_New(this.internal_parent.internal_handle, this.internal_getNativeStyle());
            if (this.internal_handle == 0) {
                Button.error(2);
            }
            return;
        }
        if ((this.internal_style & 0x10) != 0) {
            this.internal_handle = OS.RadioButton_New(this.internal_parent.internal_handle, this.internal_getNativeStyle());
            if (this.internal_handle == 0) {
                Button.error(2);
            }
            return;
        }
        if ((this.internal_style & 8) != 0) {
            this.internal_handle = OS.PushButton_New(this.internal_parent.internal_handle, this.internal_getNativeStyle());
            if (this.internal_handle == 0) {
                Button.error(2);
            }
            return;
        }
        if ((this.internal_style & 2) != 0) {
            this.internal_handle = OS.ToggleButton_New(this.internal_parent.internal_handle, this.internal_getNativeStyle());
            if (this.internal_handle == 0) {
                Button.error(2);
            }
            return;
        }
        OS.Button_SetAlignment(this.internal_handle, this.getAlignmentStyle(this.internal_style));
    }

    protected int internal_getNativeStyle() {
        int nativeStyle = super.internal_getNativeStyle();
        if ((this.internal_style & 0x800000) == 0x800000) {
            nativeStyle |= 0x1000;
        }
        return nativeStyle;
    }

    public int getAlignment() {
        this.checkWidget();
        if (this.alignment != -1) {
            return this.alignment;
        }
        if ((this.internal_style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.internal_style & 0x1000000) != 0) {
            return 0x1000000;
        }
        return 131072;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public boolean getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    protected void releaseWidget() {
        if (this.isDefault) {
            this.getShell().setDefaultButton(null);
        }
        super.releaseWidget();
        this.image = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Button.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void selectRadio() {
        Control[] children = this.internal_parent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            if (this == child) continue;
            child.setRadioSelection(false);
        }
        this.setSelection(true);
    }

    boolean setRadioSelection(boolean value) {
        if ((this.internal_style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.postEvent(13);
        }
        return true;
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        if (this.alignment == alignment) {
            return;
        }
        this.alignment = alignment;
        OS.Button_SetAlignment(this.internal_handle, this.getAlignmentStyle(alignment));
    }

    void setDefault(boolean value) {
        this.isDefault = value;
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.image = image;
        if (image == null) {
            OS.Button_SetImage(this.internal_handle, 0);
        } else {
            if (image.isDisposed()) {
                Button.error(5);
            }
            OS.Button_SetImage(this.internal_handle, image.internal_handle);
        }
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.internal_style & 0x20) != 0 || (this.internal_style & 0x10) != 0 || (this.internal_style & 2) != 0) {
            this.selection = selected;
            OS.Button_SetSelection(this.internal_handle, selected);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            Button.error(4);
        }
        this.text = string;
        OS.Button_SetLabel(this.internal_handle, string);
        OS.Button_SetImage(this.internal_handle, 0);
    }

    public boolean allowTraverseByArrowKey(Event event) {
        switch (event.keyCode) {
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000003: 
            case 0x1000004: {
                return true;
            }
        }
        return false;
    }

    protected boolean traverse(Event event) {
        if (this.isDisposed()) {
            return false;
        }
        if (this.allowTraverseByArrowKey(event)) {
            return this.traverseByArrowKey(event);
        }
        return super.traverse(event);
    }
}

