/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    int accelerator;
    boolean enabled = true;
    boolean selected = false;

    public MenuItem(Menu parent, int style) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        this.createWidget(parent.getItemCount());
    }

    public MenuItem(Menu parent, int style, int index) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        this.createWidget(index);
    }

    void selectionCallback(int modifiers) {
        if (!this.isEnabled()) {
            return;
        }
        if ((this.internal_style & 0x20) == 32) {
            this.selected = !this.selected;
        } else if ((this.internal_style & 0x10) == 16) {
            if ((this.parent.getStyle() & 0x400000) == 0x400000) {
                this.selected = !this.selected;
            } else {
                this.selectRadio();
            }
        }
        Event event = new Event();
        this.setInputState(event, 13, modifiers);
        this.postEvent(13, event);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            MenuItem.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return MenuItem.checkBits(style, 8, 32, 16, 2, 64, 0);
    }

    protected void internal_createHandle(int index) {
        int count = this.parent.getItemCount();
        if (0 > index || index > count) {
            MenuItem.error(6);
        }
        int parentHandle = this.parent.internal_handle;
        if ((this.internal_style & 2) == 2) {
            this.internal_handle = OS.SeparatorItem_New(parentHandle, index);
        } else if ((this.internal_style & 0x10) == 16) {
            this.internal_handle = OS.StateMenuItem_New(parentHandle, index, 16);
        } else if ((this.internal_style & 0x20) == 32) {
            this.internal_handle = OS.StateMenuItem_New(parentHandle, index, 32);
        } else if ((this.internal_style & 8) == 8) {
            this.internal_handle = OS.PushMenuItem_New(parentHandle, index);
        } else if ((this.internal_style & 0x40) == 64) {
            this.internal_handle = OS.CascadeMenuItem_New(parentHandle, index);
        }
        if (this.internal_handle == 0) {
            MenuItem.error(2);
        }
        this.parent.insertItem(this, index);
    }

    public void dispose() {
        Menu parent = this.parent;
        super.dispose();
        if (parent != null) {
            parent.removeItem(this);
        }
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return this.enabled;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.internal_style & 0x30) == 0) {
            return false;
        }
        return this.selected;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    protected void releaseWidget() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.releaseResources();
        }
        this.menu = null;
        super.releaseWidget();
        this.accelerator = 0;
        this.parent = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            MenuItem.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAccelerator(int accelerator) {
        this.checkWidget();
        this.accelerator = accelerator;
        if ((this.internal_style & 2) == 0) {
            int keyMods = 0;
            if ((accelerator & SWT.MOD3) != 0) {
                keyMods |= 1;
            }
            if ((accelerator & SWT.MOD2) != 0) {
                keyMods |= 2;
            }
            if ((accelerator & SWT.MOD1) != 0) {
                keyMods |= 4;
            }
            int key = accelerator & ~(SWT.MOD3 | SWT.MOD2 | SWT.MOD1);
            key = Display.convertToUglKeyCode(key);
            int value = keyMods << 16 | key;
            OS.LabeledMenuItem_SetAccelerator(this.internal_handle, value);
        }
    }

    public void setImage(Image image) {
        super.setImage(image);
        if ((this.internal_style & 2) == 0) {
            int imageHandle = 0;
            if (image != null) {
                imageHandle = image.internal_handle;
                OS.LabeledMenuItem_SetImage(this.internal_handle, imageHandle);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (enabled == this.enabled) {
            return;
        }
        this.enabled = enabled;
        if (this.parent.getEnabled()) {
            this.updateEnabledStatus(true);
        }
    }

    public void setMenu(Menu menu) {
        int menuHandle;
        this.checkWidget();
        if ((this.internal_style & 0x40) == 0) {
            MenuItem.error(27);
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                MenuItem.error(5);
            }
            if ((menu.internal_style & 4) == 0) {
                MenuItem.error(21);
            }
            if (menu.parent != this.parent.parent) {
                MenuItem.error(32);
            }
            menuHandle = menu.internal_handle;
            this.menu = menu;
            this.menu.cascade = this;
        } else {
            menuHandle = 0;
            if (this.menu != null) {
                this.menu.cascade = null;
                this.menu = null;
            }
        }
        OS.CascadeMenuItem_SetMenu(this.internal_handle, menuHandle);
    }

    void selectRadio() {
        MenuItem[] items = this.parent.getItems();
        for (int index = 0; index < items.length && items[index] != this; ++index) {
        }
        for (int i = index - 1; i >= 0 && items[i].setRadioSelection(false); --i) {
        }
        for (int j = index + 1; j < items.length && items[j].setRadioSelection(false); ++j) {
        }
        this.setSelection(true);
    }

    boolean setRadioSelection(boolean value) {
        if ((this.internal_style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.internal_style & 0x30) == 0) {
            return;
        }
        this.selected = selected;
        OS.StateMenuItem_SetSelection(this.internal_handle, selected);
    }

    public void setText(String string) {
        super.setText(string);
        if ((this.internal_style & 2) == 0) {
            String itemText = string;
            String accelText = "";
            int tab = string.indexOf(9);
            if (tab > -1) {
                itemText = tab == 0 ? "" : string.substring(0, tab);
                int length = string.length();
                if (tab < length - 1) {
                    accelText = string.substring(tab + 1, length);
                }
            }
            OS.LabeledMenuItem_SetText(this.internal_handle, itemText, accelText);
        }
    }

    void updateEnabledStatus(boolean parentEnabled) {
        if (this.internal_handle != 0) {
            OS.AbstractMenuItem_SetEnabled(this.internal_handle, parentEnabled && this.enabled);
        }
    }

    void fixMenus(Decorations newParent) {
        if (this.menu != null) {
            this.menu.fixMenus(newParent);
        }
    }
}

