/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite parent, int style) {
        super(parent, style);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int[] insets = OS.Scrollable_GetInsets(this.internal_handle);
        return new Rectangle(x - insets[0], y - insets[1], width + insets[0] + insets[2], height + insets[1] + insets[3]);
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.createScrollBars();
    }

    void createScrollBars() {
        int peerHandle;
        if ((this.internal_style & 0x100) != 0 && (peerHandle = OS.Scrollable_GetHorizontalBar(this.internal_handle)) != 0) {
            this.horizontalBar = new ScrollBar(this, 256, peerHandle);
        }
        if ((this.internal_style & 0x200) != 0 && (peerHandle = OS.Scrollable_GetVerticalBar(this.internal_handle)) != 0) {
            this.verticalBar = new ScrollBar(this, 512, peerHandle);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        int[] bounds = OS.Control_GetBounds(this.internal_handle);
        int[] insets = OS.Scrollable_GetInsets(this.internal_handle);
        return new Rectangle(0, 0, bounds[2] - insets[0] - insets[2], bounds[3] - insets[1] - insets[3]);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = super.computeSize(wHint, hHint, changed);
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        size.x = trim.width;
        size.y = trim.height;
        return size;
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    protected int internal_getNativeStyle() {
        int nativeStyle = super.internal_getNativeStyle();
        if ((this.internal_style & 0x100) == 256) {
            nativeStyle |= 0x10000;
        }
        if ((this.internal_style & 0x200) == 512) {
            nativeStyle |= 0x20000;
        }
        return nativeStyle;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    protected void releaseWidget() {
        if (this.horizontalBar != null) {
            this.horizontalBar.releaseResources();
        }
        if (this.verticalBar != null) {
            this.verticalBar.releaseResources();
        }
        this.verticalBar = null;
        this.horizontalBar = null;
        super.releaseWidget();
    }

    void clientAreaResized() {
    }
}

