/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.debug;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.framework.debug.FrameworkDebugTraceEntry;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugTrace;

public class EclipseDebugTrace
implements DebugTrace {
    public static final String PROP_TRACE_SIZE_MAX = "eclipse.trace.size.max";
    public static final String PROP_TRACE_FILE_MAX = "eclipse.trace.backup.max";
    protected static final String MESSAGE_THREAD_DUMP = "Thread Stack dump: ";
    protected static final String MESSAGE_EXIT_METHOD_WITH_RESULTS = "Exiting method with result: ";
    protected static final String MESSAGE_EXIT_METHOD_NO_RESULTS = "Exiting method with a void return";
    protected static final String MESSAGE_ENTER_METHOD_WITH_PARAMS = "Entering method with parameters: (";
    protected static final String MESSAGE_ENTER_METHOD_NO_PARAMS = "Entering method with no parameters";
    protected static final String TRACE_FILE_VERSION_COMMENT = "version: ";
    protected static final String TRACE_FILE_VERSION = "1.0";
    protected static final String TRACE_NEW_SESSION = "!SESSION ";
    protected static final String TRACE_FILE_DATE = "Time of creation: ";
    protected static final SimpleDateFormat TRACE_FILE_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected static final String TRACE_COMMENT = "#";
    protected static final String TRACE_ELEMENT_DELIMITER = "|";
    protected static final String LINE_SEPARATOR;
    public static final String NULL_VALUE = "<null>";
    private static final SecureAction secureAction;
    protected static final Object writeLock;
    public static final int DEFAULT_TRACE_FILE_SIZE = 1000;
    public static final int DEFAULT_TRACE_FILES = 10;
    public static final int DEFAULT_TRACE_FILE_MIN_SIZE = 10;
    public static final String TRACE_FILE_EXTENSION = ".trace";
    public static final String BACKUP_MARK = ".bak_";
    protected int maxTraceFileSize = 1000;
    protected int maxTraceFiles = 10;
    protected int backupTraceFileIndex = 0;
    protected Class traceClass = null;
    protected String bundleSymbolicName = null;
    protected static boolean newSession;
    protected DebugOptions debugOptions = null;

    static {
        String string = System.getProperty("line.separator");
        LINE_SEPARATOR = string == null ? "\n" : string;
        secureAction = (SecureAction)AccessController.doPrivileged(SecureAction.createSecureAction());
        writeLock = new Object();
        newSession = true;
    }

    public EclipseDebugTrace(String string, DebugOptions debugOptions) {
        this(string, debugOptions, null);
    }

    public EclipseDebugTrace(String string, DebugOptions debugOptions, Class clazz) {
        this.traceClass = clazz;
        this.debugOptions = debugOptions;
        this.bundleSymbolicName = string;
        this.readLogProperties();
    }

    protected final boolean isDebuggingEnabled(String string) {
        if (string == null) {
            return true;
        }
        boolean bl = false;
        if (this.debugOptions.isDebugEnabled()) {
            String string2 = String.valueOf(this.bundleSymbolicName) + string;
            bl = this.debugOptions.getBooleanOption(string2, false);
        }
        return bl;
    }

    public void trace(String string, String string2) {
        if (this.isDebuggingEnabled(string)) {
            FrameworkDebugTraceEntry frameworkDebugTraceEntry = new FrameworkDebugTraceEntry(this.bundleSymbolicName, string, string2, this.traceClass);
            this.writeRecord(frameworkDebugTraceEntry);
        }
    }

    public void trace(String string, String string2, Throwable throwable) {
        if (this.isDebuggingEnabled(string)) {
            FrameworkDebugTraceEntry frameworkDebugTraceEntry = new FrameworkDebugTraceEntry(this.bundleSymbolicName, string, string2, throwable, this.traceClass);
            this.writeRecord(frameworkDebugTraceEntry);
        }
    }

    public void traceEntry(String string) {
        if (this.isDebuggingEnabled(string)) {
            FrameworkDebugTraceEntry frameworkDebugTraceEntry = new FrameworkDebugTraceEntry(this.bundleSymbolicName, string, MESSAGE_ENTER_METHOD_NO_PARAMS, this.traceClass);
            this.writeRecord(frameworkDebugTraceEntry);
        }
    }

    public void traceEntry(String string, Object object) {
        if (this.isDebuggingEnabled(string)) {
            this.traceEntry(string, new Object[]{object});
        }
    }

    public void traceEntry(String string, Object[] objectArray) {
        if (this.isDebuggingEnabled(string)) {
            StringBuffer stringBuffer = new StringBuffer(MESSAGE_ENTER_METHOD_WITH_PARAMS);
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] != null) {
                        stringBuffer.append(objectArray[n].toString());
                    } else {
                        stringBuffer.append(NULL_VALUE);
                    }
                    stringBuffer.append(" ");
                    ++n;
                }
                stringBuffer.append(")");
            }
            FrameworkDebugTraceEntry frameworkDebugTraceEntry = new FrameworkDebugTraceEntry(this.bundleSymbolicName, string, stringBuffer.toString(), this.traceClass);
            this.writeRecord(frameworkDebugTraceEntry);
        }
    }

    public void traceExit(String string) {
        if (this.isDebuggingEnabled(string)) {
            FrameworkDebugTraceEntry frameworkDebugTraceEntry = new FrameworkDebugTraceEntry(this.bundleSymbolicName, string, MESSAGE_EXIT_METHOD_NO_RESULTS, this.traceClass);
            this.writeRecord(frameworkDebugTraceEntry);
        }
    }

    public void traceExit(String string, Object object) {
        if (this.isDebuggingEnabled(string)) {
            StringBuffer stringBuffer = new StringBuffer(MESSAGE_EXIT_METHOD_WITH_RESULTS);
            if (object == null) {
                stringBuffer.append(NULL_VALUE);
            } else {
                stringBuffer.append(object.toString());
            }
            FrameworkDebugTraceEntry frameworkDebugTraceEntry = new FrameworkDebugTraceEntry(this.bundleSymbolicName, string, stringBuffer.toString(), this.traceClass);
            this.writeRecord(frameworkDebugTraceEntry);
        }
    }

    public void traceDumpStack(String string) {
        if (this.isDebuggingEnabled(string)) {
            StringBuffer stringBuffer = new StringBuffer(MESSAGE_THREAD_DUMP);
            StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
            int n = this.traceClass == null ? 1 : 2;
            int n2 = stackTraceElementArray.length - n;
            StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[n2];
            int n3 = 0;
            while (n3 < n2) {
                stackTraceElementArray2[n3] = stackTraceElementArray[n];
                ++n3;
                ++n;
            }
            stringBuffer.append(this.convertStackTraceElementsToString(stackTraceElementArray2));
            FrameworkDebugTraceEntry frameworkDebugTraceEntry = new FrameworkDebugTraceEntry(this.bundleSymbolicName, string, stringBuffer.toString(), this.traceClass);
            this.writeRecord(frameworkDebugTraceEntry);
        }
    }

    protected final String convertStackTraceElementsToString(StackTraceElement[] stackTraceElementArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stackTraceElementArray != null) {
            stringBuffer.append("java.lang.Throwable: ");
            stringBuffer.append(LINE_SEPARATOR);
            int n = 0;
            while (n < stackTraceElementArray.length) {
                if (stackTraceElementArray[n] != null) {
                    stringBuffer.append("\tat ");
                    stringBuffer.append(stackTraceElementArray[n].toString());
                    stringBuffer.append(LINE_SEPARATOR);
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeRecord(FrameworkDebugTraceEntry frameworkDebugTraceEntry) {
        if (frameworkDebugTraceEntry == null) return;
        Object object = writeLock;
        synchronized (object) {
            File file = this.debugOptions.getFile();
            Writer writer = null;
            try {
                try {
                    this.checkTraceFileSize(file);
                    writer = this.openWriter(file);
                    if (newSession) {
                        this.writeSession(writer);
                        newSession = false;
                    }
                    this.writeMessage(writer, frameworkDebugTraceEntry);
                    writer.flush();
                }
                catch (Exception exception) {
                    System.err.println("An exception occurred while writing to the platform trace file: ");
                    exception.printStackTrace(System.err);
                }
                Object var6_8 = null;
                if (file == null) return;
                this.closeWriter(writer);
                return;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (file == null) throw throwable;
                this.closeWriter(writer);
                throw throwable;
            }
        }
    }

    protected void readLogProperties() {
        String string;
        String string2 = secureAction.getProperty(PROP_TRACE_SIZE_MAX);
        if (string2 != null) {
            this.maxTraceFileSize = Integer.parseInt(string2);
            if (this.maxTraceFileSize != 0 && this.maxTraceFileSize < 10) {
                this.maxTraceFileSize = 10;
            }
        }
        if ((string = secureAction.getProperty(PROP_TRACE_FILE_MAX)) != null) {
            this.maxTraceFiles = Integer.parseInt(string);
            if (this.maxTraceFiles < 1) {
                this.maxTraceFiles = 10;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkTraceFileSize(File file) {
        boolean bl = true;
        if (this.maxTraceFileSize > 0 && file != null && file.exists() && file.length() >> 10 > (long)this.maxTraceFileSize) {
            boolean bl2;
            String string = file.getAbsolutePath();
            String string2 = "";
            string2 = string.toLowerCase().endsWith(TRACE_FILE_EXTENSION) ? String.valueOf(string.substring(0, string.length() - TRACE_FILE_EXTENSION.length())) + BACKUP_MARK + this.backupTraceFileIndex + TRACE_FILE_EXTENSION : String.valueOf(string) + BACKUP_MARK + this.backupTraceFileIndex;
            File file2 = new File(string2);
            if (file2.exists() && !file2.delete()) {
                System.err.println("Error when trying to delete old trace file: " + file2.getName());
                if (file2.renameTo(new File(String.valueOf(file2.getAbsolutePath()) + System.currentTimeMillis()))) {
                    System.err.println("So we rename it to filename: " + file2.getName());
                } else {
                    System.err.println("And we also cannot rename it!");
                    bl = false;
                }
            }
            if (!(bl2 = file.renameTo(file2))) {
                System.err.println("Error when trying to rename trace file to backup one.");
                bl = false;
            }
            Writer writer = null;
            try {
                try {
                    writer = this.openWriter(file);
                    this.writeComment(writer, "This is a continuation of trace file " + file2.getAbsolutePath());
                    this.writeComment(writer, TRACE_FILE_DATE + TRACE_FILE_DATE_FORMATTER.format(new Date(System.currentTimeMillis())));
                    writer.flush();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (file != null) {
                    this.closeWriter(writer);
                }
                throw throwable;
            }
            {
                Object var9_11 = null;
                if (file != null) {
                    this.closeWriter(writer);
                }
                ++this.backupTraceFileIndex;
                this.backupTraceFileIndex %= this.maxTraceFiles;
            }
        }
        return bl;
    }

    protected void writeComment(Writer writer, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(TRACE_COMMENT);
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append(LINE_SEPARATOR);
        writer.write(stringBuffer.toString());
    }

    protected final String getFormattedDate() {
        return this.getFormattedDate(System.currentTimeMillis());
    }

    protected final String getFormattedDate(long l) {
        return TRACE_FILE_DATE_FORMATTER.format(new Date(l));
    }

    protected void writeSession(Writer writer) throws IOException {
        this.writeComment(writer, TRACE_NEW_SESSION + this.getFormattedDate());
        this.writeComment(writer, "version: 1.0");
        this.writeComment(writer, "The following option strings are specified for this debug session:");
        String[] stringArray = FrameworkDebugOptions.getDefault().getAllOptions();
        int n = 0;
        while (n < stringArray.length) {
            this.writeComment(writer, "\t" + stringArray[n]);
            ++n;
        }
    }

    protected void writeMessage(Writer writer, FrameworkDebugTraceEntry frameworkDebugTraceEntry) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(frameworkDebugTraceEntry.getThreadName());
        stringBuffer.append(" ");
        stringBuffer.append(TRACE_ELEMENT_DELIMITER);
        stringBuffer.append(" ");
        stringBuffer.append(this.getFormattedDate(frameworkDebugTraceEntry.getTimestamp()));
        stringBuffer.append(" ");
        stringBuffer.append(TRACE_ELEMENT_DELIMITER);
        stringBuffer.append(" ");
        stringBuffer.append(frameworkDebugTraceEntry.getBundleSymbolicName());
        stringBuffer.append(" ");
        stringBuffer.append(TRACE_ELEMENT_DELIMITER);
        stringBuffer.append(" ");
        stringBuffer.append(frameworkDebugTraceEntry.getOptionPath());
        stringBuffer.append(" ");
        stringBuffer.append(TRACE_ELEMENT_DELIMITER);
        stringBuffer.append(" ");
        stringBuffer.append(frameworkDebugTraceEntry.getClassName());
        stringBuffer.append(" ");
        stringBuffer.append(TRACE_ELEMENT_DELIMITER);
        stringBuffer.append(" ");
        stringBuffer.append(frameworkDebugTraceEntry.getMethodName());
        stringBuffer.append(" ");
        stringBuffer.append(TRACE_ELEMENT_DELIMITER);
        stringBuffer.append(" ");
        stringBuffer.append(frameworkDebugTraceEntry.getLineNumber());
        stringBuffer.append(" ");
        stringBuffer.append(TRACE_ELEMENT_DELIMITER);
        stringBuffer.append(" ");
        stringBuffer.append(frameworkDebugTraceEntry.getMessage());
        if (frameworkDebugTraceEntry.getThrowable() != null) {
            stringBuffer.append(TRACE_ELEMENT_DELIMITER);
            stringBuffer.append(" ");
            stringBuffer.append(frameworkDebugTraceEntry.getThrowable());
        }
        stringBuffer.append(LINE_SEPARATOR);
        if (writer != null && stringBuffer != null) {
            writer.write(stringBuffer.toString());
        }
    }

    protected Writer logForStream(OutputStream outputStream) {
        try {
            return new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new BufferedWriter(new OutputStreamWriter(outputStream));
        }
    }

    protected Writer openWriter(File file) {
        Writer writer = null;
        if (file != null) {
            try {
                writer = this.logForStream(secureAction.getFileOutputStream(file, true));
            }
            catch (IOException iOException) {
                writer = this.logForStream(System.out);
            }
        } else {
            writer = this.logForStream(System.out);
        }
        return writer;
    }

    protected void closeWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            writer = null;
        }
    }
}

