/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class CopyOnWriteIdentityMap
implements Map {
    private static final Entry[] emptyArray = new Entry[0];
    private volatile Entry[] entries;

    public CopyOnWriteIdentityMap() {
        this.entries = emptyArray;
    }

    public CopyOnWriteIdentityMap(CopyOnWriteIdentityMap copyOnWriteIdentityMap) {
        this.entries = copyOnWriteIdentityMap.entries();
    }

    public synchronized Object put(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        int n = this.entries.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.entries[n2].key == object) {
                Object object3 = this.entries[n2].value;
                if (object3 == object2) {
                    return object3;
                }
                Entry[] entryArray = new Entry[n];
                System.arraycopy(this.entries, 0, entryArray, 0, n);
                entryArray[n2] = new Entry(object, object2);
                this.entries = entryArray;
                return object3;
            }
            ++n2;
        }
        Entry[] entryArray = new Entry[n + 1];
        if (n > 0) {
            System.arraycopy(this.entries, 0, entryArray, 0, n);
        }
        entryArray[n] = new Entry(object, object2);
        this.entries = entryArray;
        return null;
    }

    public void putAll(Map map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (map instanceof CopyOnWriteIdentityMap) {
            this.putAll(((CopyOnWriteIdentityMap)map).entries());
            return;
        }
        Entry[] entryArray = new Entry[n];
        Iterator iterator = map.entrySet().iterator();
        int n2 = 0;
        while (n2 < n) {
            Map.Entry entry = iterator.next();
            entryArray[n2] = new Entry(entry.getKey(), entry.getValue());
            ++n2;
        }
        this.putAll(entryArray);
    }

    public void putAll(Object[] objectArray) {
        int n = objectArray.length;
        if (n == 0) {
            return;
        }
        Entry[] entryArray = new Entry[n];
        int n2 = 0;
        while (n2 < n) {
            entryArray[n2] = new Entry(objectArray[n2], null);
            ++n2;
        }
        this.putAll(entryArray);
    }

    private synchronized void putAll(Entry[] entryArray) {
        int n = entryArray.length;
        int n2 = this.entries.length;
        Entry[] entryArray2 = new Entry[n2 + n];
        System.arraycopy(this.entries, 0, entryArray2, 0, n2);
        int n3 = 0;
        while (n3 < n) {
            block4: {
                Entry entry = entryArray[n3];
                int n4 = 0;
                while (n4 < n2) {
                    if (entryArray2[n4].key == entry.key) {
                        entryArray2[n4] = entry;
                        break block4;
                    }
                    ++n4;
                }
                entryArray2[n2] = entry;
                ++n2;
            }
            ++n3;
        }
        if (n2 == entryArray2.length) {
            this.entries = entryArray2;
            return;
        }
        Entry[] entryArray3 = new Entry[n2];
        System.arraycopy(entryArray2, 0, entryArray3, 0, n2);
        this.entries = entryArray3;
    }

    public synchronized Object remove(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        int n = this.entries.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.entries[n2].key == object) {
                int n3;
                Object object2 = this.entries[n2].value;
                if (n == 1) {
                    this.entries = emptyArray;
                    return object2;
                }
                Entry[] entryArray = new Entry[n - 1];
                if (n2 > 0) {
                    System.arraycopy(this.entries, 0, entryArray, 0, n2);
                }
                if ((n3 = n - 1 - n2) > 0) {
                    System.arraycopy(this.entries, n2 + 1, entryArray, n2, n3);
                }
                this.entries = entryArray;
                return object2;
            }
            ++n2;
        }
        return null;
    }

    public synchronized void clear() {
        this.entries = emptyArray;
    }

    private Entry[] entries() {
        return this.entries;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.entries().length;
    }

    public Object get(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Entry[] entryArray = this.entries();
        int n = 0;
        while (n < entryArray.length) {
            if (entryArray[n].key == object) {
                return entryArray[n].value;
            }
            ++n;
        }
        return null;
    }

    public boolean containsKey(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Entry[] entryArray = this.entries();
        int n = 0;
        while (n < entryArray.length) {
            if (entryArray[n].key == object) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean containsValue(Object object) {
        Entry[] entryArray = this.entries();
        int n = 0;
        while (n < entryArray.length) {
            if (entryArray[n].value == object) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Set entrySet() {
        return new EntrySet(this.entries(), 1);
    }

    public Set keySet() {
        return new EntrySet(this.entries(), 2);
    }

    public Collection values() {
        return new EntrySet(this.entries(), 3);
    }

    private static class Entry
    implements Map.Entry {
        final Object key;
        final Object value;

        Entry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    private static class EntryIterator
    implements Iterator {
        private final Entry[] entries;
        private final int returnType;
        private int cursor = 0;

        EntryIterator(Entry[] entryArray, int n) {
            this.entries = entryArray;
            this.returnType = n;
        }

        public boolean hasNext() {
            return this.cursor < this.entries.length;
        }

        public Object next() {
            if (this.cursor == this.entries.length) {
                throw new NoSuchElementException();
            }
            switch (this.returnType) {
                case 1: {
                    return this.entries[this.cursor++];
                }
                case 2: {
                    return this.entries[this.cursor++].key;
                }
                case 3: {
                    return this.entries[this.cursor++].value;
                }
            }
            throw new InternalError();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class EntrySet
    extends AbstractSet {
        private final Entry[] entries;
        private final int returnType;
        static final int ENTRY = 1;
        static final int KEY = 2;
        static final int VALUE = 3;

        EntrySet(Entry[] entryArray, int n) {
            this.entries = entryArray;
            this.returnType = n;
        }

        public Iterator iterator() {
            return new EntryIterator(this.entries, this.returnType);
        }

        public int size() {
            return this.entries.length;
        }
    }
}

